/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.IncrementalScanEvent;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.SnapshotUtil;

class IncrementalDataTableScan
extends DataTableScan {
    IncrementalDataTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context.useSnapshotId(null));
        IncrementalDataTableScan.validateSnapshotIds(table, context.fromSnapshotId(), context.toSnapshotId());
    }

    @Override
    public TableScan asOfTime(long timestampMillis) {
        throw new UnsupportedOperationException(String.format("Cannot scan table as of time %s: configured for incremental data in snapshots (%s, %s]", timestampMillis, this.context().fromSnapshotId(), this.context().toSnapshotId()));
    }

    @Override
    public TableScan useRef(String ref) {
        throw new UnsupportedOperationException(String.format("Cannot scan table using ref %s: configured for incremental data in snapshots (%s, %s]", ref, this.context().fromSnapshotId(), this.context().toSnapshotId()));
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        throw new UnsupportedOperationException(String.format("Cannot scan table using scan snapshot id %s: configured for incremental data in snapshots (%s, %s]", scanSnapshotId, this.context().fromSnapshotId(), this.context().toSnapshotId()));
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        this.validateSnapshotIdsRefinement(fromSnapshotId, toSnapshotId);
        return new IncrementalDataTableScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotIdExclusive(fromSnapshotId).toSnapshotId(toSnapshotId));
    }

    @Override
    public TableScan appendsAfter(long newFromSnapshotId) {
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkState((currentSnapshot != null ? 1 : 0) != 0, (String)"Cannot scan appends after %s, there is no current snapshot", (long)newFromSnapshotId);
        return this.appendsBetween(newFromSnapshotId, currentSnapshot.snapshotId());
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        Long fromSnapshotId = this.context().fromSnapshotId();
        Long toSnapshotId = this.context().toSnapshotId();
        List<Snapshot> snapshots = IncrementalDataTableScan.snapshotsWithin(this.table(), fromSnapshotId, toSnapshotId);
        HashSet snapshotIds = Sets.newHashSet((Iterable)Iterables.transform(snapshots, Snapshot::snapshotId));
        ImmutableSet manifests = FluentIterable.from(snapshots).transformAndConcat(snapshot -> snapshot.dataManifests(this.tableOps().io())).filter(manifestFile -> snapshotIds.contains(manifestFile.snapshotId())).toSet();
        ManifestGroup manifestGroup = new ManifestGroup(this.table().io(), (Iterable<ManifestFile>)manifests).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterData(this.filter()).filterManifestEntries(manifestEntry -> snapshotIds.contains(manifestEntry.snapshotId()) && manifestEntry.status() == ManifestEntry.Status.ADDED).specsById(this.table().specs()).ignoreDeleted();
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        Listeners.notifyAll((Object)new IncrementalScanEvent(this.table().name(), fromSnapshotId.longValue(), toSnapshotId.longValue(), this.filter(), this.schema(), false));
        if (manifests.size() > 1 && this.shouldPlanWithExecutor()) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.planFiles();
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        return new IncrementalDataTableScan(ops, table, schema, context);
    }

    private static List<Snapshot> snapshotsWithin(Table table, long fromSnapshotId, long toSnapshotId) {
        ArrayList snapshots = Lists.newArrayList();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween(toSnapshotId, (Long)fromSnapshotId, arg_0 -> ((Table)table).snapshot(arg_0))) {
            if (snapshot.operation().equals("append")) {
                snapshots.add(snapshot);
                continue;
            }
            if (!snapshot.operation().equals("overwrite")) continue;
            throw new UnsupportedOperationException(String.format("Found %s operation, cannot support incremental data in snapshots (%s, %s]", "overwrite", fromSnapshotId, toSnapshotId));
        }
        return snapshots;
    }

    private void validateSnapshotIdsRefinement(long newFromSnapshotId, long newToSnapshotId) {
        HashSet snapshotIdsRange = Sets.newHashSet(SnapshotUtil.ancestorIdsBetween(this.context().toSnapshotId(), this.context().fromSnapshotId(), arg_0 -> ((Table)this.table()).snapshot(arg_0)));
        snapshotIdsRange.add(this.context().fromSnapshotId());
        Preconditions.checkArgument((boolean)snapshotIdsRange.contains(newFromSnapshotId), (String)"from snapshot id %s not in existing snapshot ids range (%s, %s]", (Object)newFromSnapshotId, (Object)this.context().fromSnapshotId(), (Object)newToSnapshotId);
        Preconditions.checkArgument((boolean)snapshotIdsRange.contains(newToSnapshotId), (String)"to snapshot id %s not in existing snapshot ids range (%s, %s]", (Object)newToSnapshotId, (Object)this.context().fromSnapshotId(), (Object)this.context().toSnapshotId());
    }

    private static void validateSnapshotIds(Table table, long fromSnapshotId, long toSnapshotId) {
        Preconditions.checkArgument((fromSnapshotId != toSnapshotId ? 1 : 0) != 0, (Object)"from and to snapshot ids cannot be the same");
        Preconditions.checkArgument((table.snapshot(fromSnapshotId) != null ? 1 : 0) != 0, (String)"from snapshot %s does not exist", (long)fromSnapshotId);
        Preconditions.checkArgument((table.snapshot(toSnapshotId) != null ? 1 : 0) != 0, (String)"to snapshot %s does not exist", (long)toSnapshotId);
        Preconditions.checkArgument((boolean)SnapshotUtil.isAncestorOf(table, toSnapshotId, fromSnapshotId), (String)"from snapshot %s is not an ancestor of to snapshot  %s", (long)fromSnapshotId, (long)toSnapshotId);
    }
}

