/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.controllers;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.util.file.FileUtil;
import org.ini4j.Ini;

public class CCConfig
extends ControllerConfig {
    private static final long serialVersionUID = 4118822454622201176L;
    private List<String> appArgs = new ArrayList<String>();

    public CCConfig() {
        this(new ConfigManager());
    }

    public CCConfig(ConfigManager configManager) {
        super(configManager);
        configManager.register(Option.class);
        configManager.register(ControllerConfig.Option.class);
        configManager.registerArgsListener(this.appArgs::addAll);
    }

    public List<String> getAppArgs() {
        return this.appArgs;
    }

    public String[] getAppArgsArray() {
        return this.appArgs.toArray(new String[this.appArgs.size()]);
    }

    public Ini getIni() {
        return this.configManager.toIni(false);
    }

    public String getClusterListenAddress() {
        return this.getAppConfig().getString((IOption)Option.CLUSTER_LISTEN_ADDRESS);
    }

    public void setClusterListenAddress(String clusterListenAddress) {
        this.configManager.set(Option.CLUSTER_LISTEN_ADDRESS, clusterListenAddress);
    }

    public int getClusterListenPort() {
        return this.getAppConfig().getInt((IOption)Option.CLUSTER_LISTEN_PORT);
    }

    public void setClusterListenPort(int clusterListenPort) {
        this.configManager.set(Option.CLUSTER_LISTEN_PORT, clusterListenPort);
    }

    public String getClusterPublicAddress() {
        return this.getAppConfig().getString((IOption)Option.CLUSTER_PUBLIC_ADDRESS);
    }

    public void setClusterPublicAddress(String clusterPublicAddress) {
        this.configManager.set(Option.CLUSTER_PUBLIC_ADDRESS, clusterPublicAddress);
    }

    public int getClusterPublicPort() {
        return this.getAppConfig().getInt((IOption)Option.CLUSTER_PUBLIC_PORT);
    }

    public void setClusterPublicPort(int clusterPublicPort) {
        this.configManager.set(Option.CLUSTER_PUBLIC_PORT, clusterPublicPort);
    }

    public String getClientListenAddress() {
        return this.getAppConfig().getString((IOption)Option.CLIENT_LISTEN_ADDRESS);
    }

    public void setClientListenAddress(String clientListenAddress) {
        this.configManager.set(Option.CLIENT_LISTEN_ADDRESS, clientListenAddress);
    }

    public int getClientListenPort() {
        return this.getAppConfig().getInt((IOption)Option.CLIENT_LISTEN_PORT);
    }

    public void setClientListenPort(int clientListenPort) {
        this.configManager.set(Option.CLIENT_LISTEN_PORT, clientListenPort);
    }

    public String getClientPublicAddress() {
        return this.getAppConfig().getString((IOption)Option.CLIENT_PUBLIC_ADDRESS);
    }

    public void setClientPublicAddress(String clientPublicAddress) {
        this.configManager.set(Option.CLIENT_PUBLIC_ADDRESS, clientPublicAddress);
    }

    public int getClientPublicPort() {
        return this.getAppConfig().getInt((IOption)Option.CLIENT_PUBLIC_PORT);
    }

    public void setClientPublicPort(int clientPublicPort) {
        this.configManager.set(Option.CLIENT_PUBLIC_PORT, clientPublicPort);
    }

    public int getConsoleListenPort() {
        return this.getAppConfig().getInt((IOption)Option.CONSOLE_LISTEN_PORT);
    }

    public void setConsoleListenPort(int consoleListenPort) {
        this.configManager.set(Option.CONSOLE_LISTEN_PORT, consoleListenPort);
    }

    public int getConsolePublicPort() {
        return this.getAppConfig().getInt((IOption)Option.CONSOLE_PUBLIC_PORT);
    }

    public void setConsolePublicPort(int consolePublicPort) {
        this.configManager.set(Option.CONSOLE_PUBLIC_PORT, consolePublicPort);
    }

    public long getHeartbeatPeriodMillis() {
        return this.getAppConfig().getLong((IOption)Option.HEARTBEAT_PERIOD);
    }

    public void setHeartbeatPeriodMillis(long heartbeatPeriod) {
        this.configManager.set(Option.HEARTBEAT_PERIOD, heartbeatPeriod);
    }

    public int getHeartbeatMaxMisses() {
        return this.getAppConfig().getInt((IOption)Option.HEARTBEAT_MAX_MISSES);
    }

    public void setHeartbeatMaxMisses(int heartbeatMaxMisses) {
        this.configManager.set(Option.HEARTBEAT_MAX_MISSES, heartbeatMaxMisses);
    }

    public long getDeadNodeSweepThreshold() {
        return this.getAppConfig().getLong((IOption)Option.DEAD_NODE_SWEEP_THRESHOLD);
    }

    public void setDeadNodeSweepThreshold(long deadNodeSweepThreshold) {
        this.configManager.set(Option.DEAD_NODE_SWEEP_THRESHOLD, deadNodeSweepThreshold);
    }

    public int getProfileDumpPeriod() {
        return this.getAppConfig().getInt((IOption)Option.PROFILE_DUMP_PERIOD);
    }

    public void setProfileDumpPeriod(int profileDumpPeriod) {
        this.configManager.set(Option.PROFILE_DUMP_PERIOD, profileDumpPeriod);
    }

    public int getJobHistorySize() {
        return this.getAppConfig().getInt((IOption)Option.JOB_HISTORY_SIZE);
    }

    public void setJobHistorySize(int jobHistorySize) {
        this.configManager.set(Option.JOB_HISTORY_SIZE, jobHistorySize);
    }

    public long getResultTTL() {
        return this.getAppConfig().getLong((IOption)Option.RESULT_TTL);
    }

    public void setResultTTL(long resultTTL) {
        this.configManager.set(Option.RESULT_TTL, resultTTL);
    }

    public long getResultSweepThreshold() {
        return this.getAppConfig().getLong((IOption)Option.RESULT_SWEEP_THRESHOLD);
    }

    public void setResultSweepThreshold(long resultSweepThreshold) {
        this.configManager.set(Option.RESULT_SWEEP_THRESHOLD, resultSweepThreshold);
    }

    public String getRootDir() {
        return this.getAppConfig().getString((IOption)Option.ROOT_DIR);
    }

    public void setRootDir(String rootDir) {
        this.configManager.set(Option.ROOT_DIR, rootDir);
    }

    public File getClusterTopology() {
        return this.getAppConfig().getString((IOption)Option.CLUSTER_TOPOLOGY) == null ? null : new File(this.getAppConfig().getString((IOption)Option.CLUSTER_TOPOLOGY));
    }

    public void setClusterTopology(File clusterTopology) {
        this.configManager.set(Option.CLUSTER_TOPOLOGY, clusterTopology);
    }

    public String getAppClass() {
        return this.getAppConfig().getString((IOption)Option.APP_CLASS);
    }

    public void setAppClass(String appClass) {
        this.configManager.set(Option.APP_CLASS, appClass);
    }

    public String getJobQueueClass() {
        return this.getAppConfig().getString((IOption)Option.JOB_QUEUE_CLASS);
    }

    public void setJobQueueClass(String jobQueueClass) {
        this.configManager.set(Option.JOB_QUEUE_CLASS, jobQueueClass);
    }

    public String getJobManagerClass() {
        return this.getAppConfig().getString((IOption)Option.JOB_MANAGER_CLASS);
    }

    public void setJobManagerClass(String jobManagerClass) {
        this.configManager.set(Option.JOB_MANAGER_CLASS, jobManagerClass);
    }

    public int getJobQueueCapacity() {
        return this.getAppConfig().getInt((IOption)Option.JOB_QUEUE_CAPACITY);
    }

    public boolean getEnforceFrameWriterProtocol() {
        return this.getAppConfig().getBoolean((IOption)Option.ENFORCE_FRAME_WRITER_PROTOCOL);
    }

    public void setEnforceFrameWriterProtocol(boolean enforce) {
        this.configManager.set(Option.ENFORCE_FRAME_WRITER_PROTOCOL, enforce);
    }

    public void setCoresMultiplier(int coresMultiplier) {
        this.configManager.set(Option.CORES_MULTIPLIER, coresMultiplier);
    }

    public int getCoresMultiplier() {
        return this.getAppConfig().getInt((IOption)Option.CORES_MULTIPLIER);
    }

    public CcId getCcId() {
        return CcId.valueOf((int)this.getAppConfig().getShort((IOption)Option.CONTROLLER_ID));
    }

    public String getKeyStorePath() {
        return this.getAppConfig().getString((IOption)Option.KEY_STORE_PATH);
    }

    public String getKeyStorePassword() {
        return this.getAppConfig().getString((IOption)Option.KEY_STORE_PASSWORD);
    }

    public void setKeyStorePath(String keyStorePath) {
        this.configManager.set(Option.KEY_STORE_PATH, keyStorePath);
    }

    public String getTrustStorePath() {
        return this.getAppConfig().getString((IOption)Option.TRUST_STORE_PATH);
    }

    public void setTrustStorePath(String trustStorePath) {
        this.configManager.set(Option.TRUST_STORE_PATH, trustStorePath);
    }

    public String getCredentialFilePath() {
        return this.getAppConfig().getString((IOption)Option.CREDENTIAL_FILE);
    }

    public String getGlobalTxLogDir() {
        return this.getAppConfig().getString((IOption)Option.GLOBAL_TXN_LOG_DIR);
    }

    public long getGlobalTxCommitTimeout() {
        return this.getAppConfig().getLong((IOption)Option.GLOBAL_TXN_COMMIT_TIMEOUT);
    }

    public long getGlobalTxRollbackTimeout() {
        return this.getAppConfig().getLong((IOption)Option.GLOBAL_TXN_ROLLBACK_TIMEOUT);
    }

    public static enum Option implements IOption
    {
        APP_CLASS(OptionTypes.STRING, (String)null),
        ADDRESS(OptionTypes.STRING, InetAddress.getLoopbackAddress().getHostAddress()),
        PUBLIC_ADDRESS(OptionTypes.STRING, ADDRESS),
        CLUSTER_LISTEN_ADDRESS(OptionTypes.STRING, ADDRESS),
        CLUSTER_LISTEN_PORT(OptionTypes.NONNEGATIVE_INTEGER, 1099),
        CLUSTER_PUBLIC_ADDRESS(OptionTypes.STRING, PUBLIC_ADDRESS),
        CLUSTER_PUBLIC_PORT(OptionTypes.NONNEGATIVE_INTEGER, CLUSTER_LISTEN_PORT),
        CLIENT_LISTEN_ADDRESS(OptionTypes.STRING, ADDRESS),
        CLIENT_LISTEN_PORT(OptionTypes.NONNEGATIVE_INTEGER, 1098),
        CLIENT_PUBLIC_ADDRESS(OptionTypes.STRING, PUBLIC_ADDRESS),
        CLIENT_PUBLIC_PORT(OptionTypes.NONNEGATIVE_INTEGER, CLIENT_LISTEN_PORT),
        CONSOLE_LISTEN_ADDRESS(OptionTypes.STRING, ADDRESS),
        CONSOLE_LISTEN_PORT(OptionTypes.NONNEGATIVE_INTEGER, 16001),
        CONSOLE_PUBLIC_ADDRESS(OptionTypes.STRING, PUBLIC_ADDRESS),
        CONSOLE_PUBLIC_PORT(OptionTypes.NONNEGATIVE_INTEGER, CONSOLE_LISTEN_PORT),
        HEARTBEAT_PERIOD(OptionTypes.LONG, 10000L),
        HEARTBEAT_MAX_MISSES(OptionTypes.NONNEGATIVE_INTEGER, 5),
        DEAD_NODE_SWEEP_THRESHOLD(OptionTypes.LONG, HEARTBEAT_PERIOD),
        PROFILE_DUMP_PERIOD(OptionTypes.NONNEGATIVE_INTEGER, 0),
        JOB_HISTORY_SIZE(OptionTypes.NONNEGATIVE_INTEGER, 10),
        RESULT_TTL(OptionTypes.LONG, 86400000L),
        RESULT_SWEEP_THRESHOLD(OptionTypes.LONG, 60000L),
        ROOT_DIR(OptionTypes.STRING, appConfig -> FileUtil.joinPath((String[])new String[]{appConfig.getString((IOption)ControllerConfig.Option.DEFAULT_DIR), "ClusterControllerService"}), "<value of " + ControllerConfig.Option.DEFAULT_DIR.cmdline() + ">/ClusterControllerService"),
        CLUSTER_TOPOLOGY(OptionTypes.STRING),
        JOB_QUEUE_CLASS(OptionTypes.STRING, "org.apache.hyracks.control.cc.scheduler.FIFOJobQueue"),
        JOB_QUEUE_CAPACITY(OptionTypes.POSITIVE_INTEGER, 4096),
        JOB_MANAGER_CLASS(OptionTypes.STRING, "org.apache.hyracks.control.cc.job.JobManager"),
        ENFORCE_FRAME_WRITER_PROTOCOL(OptionTypes.BOOLEAN, false),
        CORES_MULTIPLIER(OptionTypes.POSITIVE_INTEGER, 3),
        CONTROLLER_ID(OptionTypes.SHORT, (short)0),
        KEY_STORE_PATH(OptionTypes.STRING),
        TRUST_STORE_PATH(OptionTypes.STRING),
        KEY_STORE_PASSWORD(OptionTypes.STRING),
        CREDENTIAL_FILE(OptionTypes.STRING, appConfig -> FileUtil.joinPath((String[])new String[]{appConfig.getString((IOption)ControllerConfig.Option.DEFAULT_DIR), "passwd"}), ControllerConfig.Option.DEFAULT_DIR.cmdline() + "/passwd"),
        GLOBAL_TXN_LOG_DIR(OptionTypes.STRING, appConfig -> FileUtil.joinPath((String[])new String[]{appConfig.getString((IOption)ControllerConfig.Option.DEFAULT_DIR), "global-txn-log"}), ControllerConfig.Option.DEFAULT_DIR.cmdline() + "/global-txn-log"),
        GLOBAL_TXN_COMMIT_TIMEOUT(OptionTypes.LONG, 600000L),
        GLOBAL_TXN_ROLLBACK_TIMEOUT(OptionTypes.LONG, 600000L);

        private final IOptionType parser;
        private Object defaultValue;
        private final String defaultValueDescription;

        private <T> Option(IOptionType<T> parser) {
            this(parser, (T)null);
        }

        private <T> Option(IOptionType<T> parser, Option defaultOption) {
            this.parser = parser;
            this.defaultValue = defaultOption;
            this.defaultValueDescription = null;
        }

        private <T> Option(IOptionType<T> parser, T defaultValue) {
            this.parser = parser;
            this.defaultValue = defaultValue;
            this.defaultValueDescription = null;
        }

        private <T> Option(IOptionType<T> parser, Function<IApplicationConfig, T> defaultValue, String defaultValueDescription) {
            this.parser = parser;
            this.defaultValue = defaultValue;
            this.defaultValueDescription = defaultValueDescription;
        }

        public Section section() {
            return Section.CC;
        }

        public IOptionType type() {
            return this.parser;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public String description() {
            switch (this) {
                case APP_CLASS: {
                    return "Application CC main class";
                }
                case ADDRESS: {
                    return "Default bind address for all services on this cluster controller";
                }
                case PUBLIC_ADDRESS: {
                    return "Default public address that other processes should use to contact this cluster controller. All services will advertise this address unless a service-specific public address is supplied.";
                }
                case CLUSTER_LISTEN_ADDRESS: {
                    return "Sets the IP Address to listen for connections from NCs";
                }
                case CLUSTER_LISTEN_PORT: {
                    return "Sets the port to listen for connections from node controllers";
                }
                case CLUSTER_PUBLIC_ADDRESS: {
                    return "Address that NCs should use to contact this CC";
                }
                case CLUSTER_PUBLIC_PORT: {
                    return "Port that NCs should use to contact this CC";
                }
                case CLIENT_LISTEN_ADDRESS: {
                    return "Sets the IP Address to listen for connections from clients";
                }
                case CLIENT_LISTEN_PORT: {
                    return "Sets the port to listen for connections from clients";
                }
                case CLIENT_PUBLIC_ADDRESS: {
                    return "The IP Address which clients should use to connect";
                }
                case CLIENT_PUBLIC_PORT: {
                    return "The port which clients should use to connect";
                }
                case CONSOLE_LISTEN_ADDRESS: {
                    return "Sets the listen address for the Cluster Controller";
                }
                case CONSOLE_LISTEN_PORT: {
                    return "Sets the http port for the Cluster Controller)";
                }
                case CONSOLE_PUBLIC_ADDRESS: {
                    return "Sets the address on which to contact the http console for the Cluster Controller";
                }
                case CONSOLE_PUBLIC_PORT: {
                    return "Sets the port on which to contact the http console for the Cluster Controller)";
                }
                case HEARTBEAT_PERIOD: {
                    return "Sets the time duration between two heartbeats from each node controller in milliseconds";
                }
                case HEARTBEAT_MAX_MISSES: {
                    return "Sets the maximum number of missed heartbeats before a node can be considered dead";
                }
                case DEAD_NODE_SWEEP_THRESHOLD: {
                    return "Sets the frequency (in milliseconds) to process nodes that can be considered dead";
                }
                case PROFILE_DUMP_PERIOD: {
                    return "Sets the time duration between two profile dumps from each node controller in milliseconds; 0 to disable";
                }
                case JOB_HISTORY_SIZE: {
                    return "Limits the number of historical jobs remembered by the system to the specified value";
                }
                case RESULT_TTL: {
                    return "Limits the amount of time results for asynchronous jobs should be retained by the system in milliseconds";
                }
                case RESULT_SWEEP_THRESHOLD: {
                    return "The duration within which an instance of the result cleanup should be invoked in milliseconds";
                }
                case ROOT_DIR: {
                    return "Sets the root folder used for file operations";
                }
                case CLUSTER_TOPOLOGY: {
                    return "Sets the XML file that defines the cluster topology";
                }
                case JOB_QUEUE_CLASS: {
                    return "Specify the implementation class name for the job queue";
                }
                case JOB_QUEUE_CAPACITY: {
                    return "The maximum number of jobs to queue before rejecting new jobs";
                }
                case JOB_MANAGER_CLASS: {
                    return "Specify the implementation class name for the job manager";
                }
                case ENFORCE_FRAME_WRITER_PROTOCOL: {
                    return "A flag indicating if runtime should enforce frame writer protocol and detect bad behaving operators";
                }
                case CORES_MULTIPLIER: {
                    return "the factor to multiply by the number of cores to determine maximum query concurrent execution level";
                }
                case CONTROLLER_ID: {
                    return "The 16-bit (0-65535) id of this Cluster Controller";
                }
                case KEY_STORE_PATH: {
                    return "A fully-qualified path to a key store file that will be used for secured connections";
                }
                case TRUST_STORE_PATH: {
                    return "A fully-qualified path to a trust store file that will be used for secured connections";
                }
                case KEY_STORE_PASSWORD: {
                    return "The password to the provided key store";
                }
                case CREDENTIAL_FILE: {
                    return "Path to HTTP basic credentials";
                }
                case GLOBAL_TXN_LOG_DIR: {
                    return "Directory to store global transaction logs";
                }
                case GLOBAL_TXN_COMMIT_TIMEOUT: {
                    return "Timeout for Commit";
                }
                case GLOBAL_TXN_ROLLBACK_TIMEOUT: {
                    return "Timeout for Rollback";
                }
            }
            throw new IllegalStateException("NYI: " + this);
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            return this.defaultValueDescription;
        }

        public boolean hidden() {
            return this == KEY_STORE_PASSWORD;
        }
    }
}

