/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema.visitor;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PathExtractorVisitor
implements ISchemaNodeVisitor<AbstractSchemaNode, Void> {
    private final IColumnValuesReaderFactory readerFactory;
    private final IntList delimiters;
    private final Int2ObjectMap<IColumnValuesReader> cachedReaders;
    private int level;

    public PathExtractorVisitor(IColumnValuesReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
        this.cachedReaders = new Int2ObjectOpenHashMap();
        this.delimiters = new IntArrayList();
    }

    public List<IColumnValuesReader> getOrCreateReaders(ObjectSchemaNode path, List<IColumnValuesReader> readers) throws HyracksDataException {
        this.level = 0;
        this.delimiters.clear();
        AbstractSchemaNode node = path.accept(this, null);
        ATypeTag typeTag = node.getTypeTag();
        if (typeTag == ATypeTag.UNION) {
            UnionSchemaNode unionNode = (UnionSchemaNode)node;
            Collection<AbstractSchemaNode> children = unionNode.getChildren().values();
            ArrayList<IColumnValuesReader> unionReaders = new ArrayList<IColumnValuesReader>();
            for (AbstractSchemaNode child : children) {
                if (child.isNested()) continue;
                IColumnValuesReader reader = this.getOrCreate(child, readers);
                unionReaders.add(reader);
            }
            return unionReaders;
        }
        return Collections.singletonList(this.getOrCreate(node, readers));
    }

    @Override
    public AbstractSchemaNode visit(ObjectSchemaNode objectNode, Void arg) throws HyracksDataException {
        int fieldNameIndex;
        IntList fieldNameIndexes = objectNode.getChildrenFieldNameIndexes();
        int n = fieldNameIndex = fieldNameIndexes.isEmpty() ? -1 : objectNode.getChildrenFieldNameIndexes().getInt(0);
        if (fieldNameIndex < 0) {
            return MissingFieldSchemaNode.INSTANCE;
        }
        ++this.level;
        return objectNode.getChild(fieldNameIndex).accept(this, null);
    }

    @Override
    public AbstractSchemaNode visit(AbstractCollectionSchemaNode collectionNode, Void arg) throws HyracksDataException {
        AbstractSchemaNode itemNode = collectionNode.getItemNode();
        if (itemNode == null) {
            return MissingFieldSchemaNode.INSTANCE;
        }
        this.delimiters.add(this.level - 1);
        ++this.level;
        return collectionNode.getItemNode().accept(this, null);
    }

    @Override
    public AbstractSchemaNode visit(UnionSchemaNode unionNode, Void arg) throws HyracksDataException {
        Iterator<AbstractSchemaNode> iterator;
        Collection<AbstractSchemaNode> children = unionNode.getChildren().values();
        if (children.size() == 1 && (iterator = children.iterator()).hasNext()) {
            AbstractSchemaNode node = iterator.next();
            return node.accept(this, null);
        }
        return unionNode;
    }

    @Override
    public AbstractSchemaNode visit(PrimitiveSchemaNode primitiveNode, Void arg) throws HyracksDataException {
        return primitiveNode;
    }

    private IColumnValuesReader getOrCreate(AbstractSchemaNode node, List<IColumnValuesReader> readers) {
        PrimitiveSchemaNode primitiveNode = (PrimitiveSchemaNode)node;
        int columnIndex = primitiveNode.getColumnIndex();
        return (IColumnValuesReader)this.cachedReaders.computeIfAbsent(columnIndex, k -> this.createReader(primitiveNode, readers));
    }

    private IColumnValuesReader createReader(PrimitiveSchemaNode primitiveNode, List<IColumnValuesReader> readers) {
        IColumnValuesReader reader;
        if (this.delimiters.isEmpty()) {
            int nodeLevel = primitiveNode.isPrimaryKey() ? 1 : this.level;
            reader = this.readerFactory.createValueReader(primitiveNode.getTypeTag(), primitiveNode.getColumnIndex(), nodeLevel, primitiveNode.isPrimaryKey());
        } else {
            reader = this.readerFactory.createValueReader(primitiveNode.getTypeTag(), primitiveNode.getColumnIndex(), this.level, this.getReversedDelimiters());
        }
        readers.add(reader);
        return reader;
    }

    private int[] getReversedDelimiters() {
        Collections.reverse(this.delimiters);
        return this.delimiters.toIntArray();
    }
}

