/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.asterix.column.metadata.PathInfoSerializer;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.util.ColumnValuesUtil;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class UnionSchemaNode
extends AbstractSchemaNestedNode {
    private final AbstractSchemaNode originalType;
    private final Map<ATypeTag, AbstractSchemaNode> children;

    public UnionSchemaNode(AbstractSchemaNode child1, AbstractSchemaNode child2) {
        this.children = new EnumMap<ATypeTag, AbstractSchemaNode>(ATypeTag.class);
        this.originalType = child1;
        this.putChild(child1);
        this.putChild(child2);
    }

    UnionSchemaNode(DataInput input, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels) throws IOException {
        if (definitionLevels != null) {
            definitionLevels.put(this, new RunLengthIntArray());
        }
        ATypeTag originalTypeTag = ATypeTag.VALUE_TYPE_MAPPING[input.readByte()];
        int numberOfChildren = input.readInt();
        this.children = new EnumMap<ATypeTag, AbstractSchemaNode>(ATypeTag.class);
        for (int i = 0; i < numberOfChildren; ++i) {
            AbstractSchemaNode child = AbstractSchemaNode.deserialize(input, definitionLevels);
            this.children.put(child.getTypeTag(), child);
        }
        this.originalType = this.children.get(originalTypeTag);
    }

    private void putChild(AbstractSchemaNode child) {
        this.children.put(child.getTypeTag(), child);
    }

    public AbstractSchemaNode getOriginalType() {
        return this.originalType;
    }

    public AbstractSchemaNode getOrCreateChild(ATypeTag childTypeTag, FlushColumnMetadata columnMetadata) throws HyracksDataException {
        AbstractSchemaNode newChild;
        ATypeTag normalizedTypeTag = ColumnValuesUtil.getNormalizedTypeTag(childTypeTag);
        AbstractSchemaNode currentChild = this.children.get(normalizedTypeTag);
        if (currentChild != (newChild = columnMetadata.getOrCreateChild(currentChild, normalizedTypeTag))) {
            this.putChild(newChild);
        }
        return newChild;
    }

    public AbstractSchemaNode getChild(ATypeTag typeTag) {
        return this.children.getOrDefault(typeTag, MissingFieldSchemaNode.INSTANCE);
    }

    public Map<ATypeTag, AbstractSchemaNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean isObjectOrCollection() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.UNION;
    }

    @Override
    public <R, T> R accept(ISchemaNodeVisitor<R, T> visitor, T arg) throws HyracksDataException {
        return visitor.visit(this, arg);
    }

    @Override
    public void serialize(DataOutput output, PathInfoSerializer pathInfoSerializer) throws IOException {
        output.write(ATypeTag.UNION.serialize());
        output.writeByte(this.originalType.getTypeTag().serialize());
        output.writeInt(this.children.size());
        pathInfoSerializer.enter(this);
        for (AbstractSchemaNode child : this.children.values()) {
            child.serialize(output, pathInfoSerializer);
        }
        pathInfoSerializer.exit(this);
    }

    public AbstractSchemaNode getNumericChildOrMissing(ATypeTag excludeTypeTag) {
        for (AbstractSchemaNode child : this.children.values()) {
            ATypeTag childTypeTag = child.getTypeTag();
            boolean numeric = ATypeHierarchy.getTypeDomain((ATypeTag)childTypeTag) == ATypeHierarchy.Domain.NUMERIC;
            if (!numeric || childTypeTag == excludeTypeTag) continue;
            return child;
        }
        return MissingFieldSchemaNode.INSTANCE;
    }

    public int getNumberOfNumericChildren() {
        int counter = 0;
        for (AbstractSchemaNode node : this.children.values()) {
            if (ATypeHierarchy.getTypeDomain((ATypeTag)node.getTypeTag()) != ATypeHierarchy.Domain.NUMERIC) continue;
            ++counter;
        }
        return counter;
    }
}

