/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.decoder;

import java.io.IOException;
import java.io.InputStream;
import org.apache.asterix.column.bytes.decoder.AbstractParquetValuesReader;
import org.apache.asterix.column.bytes.decoder.ParquetDeltaBinaryPackingValuesReader;
import org.apache.asterix.column.bytes.decoder.ParquetDeltaLengthByteArrayValuesReader;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.io.ParquetDecodingException;

public class ParquetDeltaByteArrayReader
extends AbstractParquetValuesReader {
    private final AbstractParquetValuesReader prefixLengthReader = new ParquetDeltaBinaryPackingValuesReader();
    private final ParquetDeltaLengthByteArrayValuesReader suffixReader = new ParquetDeltaLengthByteArrayValuesReader();
    private final byte[] lengthBytes;
    private final ArrayBackedValueStorage temp = new ArrayBackedValueStorage();
    private final ArrayBackedValueStorage previous = new ArrayBackedValueStorage();
    boolean newPage;

    public ParquetDeltaByteArrayReader(boolean containsLength) {
        this.lengthBytes = containsLength ? new byte[4] : new byte[]{};
    }

    @Override
    public void initFromPage(AbstractBytesInputStream stream) throws IOException {
        AbstractBytesInputStream prefixStream = stream.sliceStream(BytesUtils.readUnsignedVarInt((InputStream)stream));
        this.prefixLengthReader.initFromPage(prefixStream);
        this.suffixReader.initFromPage(stream);
        this.previous.reset();
        this.temp.reset();
        this.newPage = true;
    }

    @Override
    public void skip() {
        this.readBytes();
    }

    @Override
    public IValueReference readBytes() {
        int prefixLength = this.prefixLengthReader.readInteger();
        IValueReference suffix = this.suffixReader.readBytes();
        try {
            int lengthSize;
            if (prefixLength != 0) {
                lengthSize = this.appendLength(prefixLength + suffix.getLength());
                this.temp.append(this.previous.getByteArray(), this.previous.getStartOffset(), prefixLength);
            } else {
                lengthSize = this.appendLength(suffix.getLength());
            }
            this.temp.append(suffix);
            System.arraycopy(this.lengthBytes, 0, this.temp.getByteArray(), 0, lengthSize);
            this.previous.set(this.temp.getByteArray(), this.temp.getStartOffset() + lengthSize, this.temp.getLength() - lengthSize);
        }
        catch (IOException e) {
            throw new ParquetDecodingException((Throwable)e);
        }
        this.newPage = false;
        return this.temp;
    }

    private int appendLength(int length) {
        if (this.lengthBytes.length > 0) {
            int numOfBytes = UTF8StringUtil.encodeUTF8Length((int)length, (byte[])this.lengthBytes, (int)0);
            this.temp.setSize(numOfBytes);
            return numOfBytes;
        }
        this.temp.setSize(0);
        return 0;
    }
}

