/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import org.apache.asterix.app.function.DumpIndexDatasource;
import org.apache.asterix.app.function.FunctionRewriter;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;

public class DumpIndexRewriter
extends FunctionRewriter {
    public static final FunctionIdentifier DUMP_INDEX = new FunctionIdentifier("asterix", "dump-index", 3);
    public static final DumpIndexRewriter INSTANCE = new DumpIndexRewriter(DUMP_INDEX);

    private DumpIndexRewriter(FunctionIdentifier functionId) {
        super(functionId);
    }

    @Override
    public DumpIndexDatasource toDatasource(IOptimizationContext context, AbstractFunctionCallExpression f) throws AlgebricksException {
        SourceLocation loc = f.getSourceLocation();
        DataverseName dataverseName = this.getDataverseName(loc, f.getArguments(), 0);
        String datasetName = this.getString(loc, f.getArguments(), 1);
        String indexName = this.getString(loc, f.getArguments(), 2);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, loc, new Serializable[]{datasetName, dataverseName});
        }
        Index index = metadataProvider.getIndex(dataverseName, datasetName, indexName);
        if (index == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_INDEX, loc, new Serializable[]{indexName});
        }
        if (index.isPrimaryIndex()) {
            throw new CompilationException(ErrorCode.OPERATION_NOT_SUPPORTED_ON_PRIMARY_INDEX, loc, new Serializable[]{indexName});
        }
        SecondaryIndexOperationsHelper secondaryIndexHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper((Dataset)dataset, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)loc);
        IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), secondaryIndexHelper.getSecondaryFileSplitProvider());
        AlgebricksAbsolutePartitionConstraint secondaryPartitionConstraint = (AlgebricksAbsolutePartitionConstraint)secondaryIndexHelper.getSecondaryPartitionConstraint();
        return new DumpIndexDatasource(context.getComputationNodeDomain(), indexDataflowHelperFactory, secondaryIndexHelper.getSecondaryRecDesc(), secondaryIndexHelper.getSecondaryComparatorFactories(), secondaryPartitionConstraint);
    }
}

