/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.InputStream;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleInputStream;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STMBREnlargeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STMBREnlargeDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_MBR_ENLARGE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg0 = new VoidPointable();
                    private IPointable inputArg1 = new VoidPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private ByteArrayAccessibleInputStream inStream;
                    private DataInputStream dataIn;
                    Envelope env;
                    private final ISerializerDeserializer<ARectangle> rectangleSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.inStream = new ByteArrayAccessibleInputStream(new byte[0], 0, 0);
                        this.dataIn = new DataInputStream((InputStream)this.inStream);
                        this.env = new Envelope();
                        this.rectangleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.inputArg0);
                        this.eval1.evaluate(tuple, this.inputArg1);
                        if (PointableHelper.checkAndSetMissingOrNull((IPointable)result, (IPointable)this.inputArg0, (IPointable)this.inputArg1)) {
                            return;
                        }
                        byte[] data0 = this.inputArg0.getByteArray();
                        int offset0 = this.inputArg0.getStartOffset();
                        int len = this.inputArg0.getLength();
                        byte[] data1 = this.inputArg1.getByteArray();
                        int offset1 = this.inputArg1.getStartOffset();
                        if (data0[offset0] != ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG) {
                            throw new TypeMismatchException(STMBREnlargeDescriptor.this.sourceLoc, STMBREnlargeDescriptor.this.getIdentifier(), 0, data0[offset0], new byte[]{ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG});
                        }
                        this.inStream.setContent(data0, offset0 + 1, len - 1);
                        OGCGeometry geometry = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)this.dataIn).getGeometry();
                        geometry.getEsriGeometry().queryEnvelope(this.env);
                        double expandValue = ATypeHierarchy.getDoubleValue((String)STMBREnlargeDescriptor.this.getIdentifier().getName(), (int)0, (byte[])data1, (int)offset1);
                        AMutableRectangle expandedMBR = new AMutableRectangle((APoint)new AMutablePoint(this.env.getXMin() - expandValue, this.env.getYMin() - expandValue), (APoint)new AMutablePoint(this.env.getXMax() + expandValue, this.env.getYMax() + expandValue));
                        this.rectangleSerde.serialize((Object)expandedMBR, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

