/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorMessageUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NONE = "";
    private static final String COMMA = ",";

    private ErrorMessageUtil() {
    }

    public static Map<Integer, String> loadErrorMap(InputStream resourceStream) throws IOException {
        Properties prop = new Properties();
        HashMap<Integer, String> errorMessageMap = new HashMap<Integer, String>();
        prop.load(resourceStream);
        prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key1, value) -> {
            String key = (String)key1;
            String msg = (String)value;
            if (key.contains(COMMA)) {
                String[] codes;
                for (String code : codes = key.split(COMMA)) {
                    errorMessageMap.put(Integer.parseInt(code), msg);
                }
            } else {
                errorMessageMap.put(Integer.parseInt(key), msg);
            }
        }));
        return errorMessageMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String formatMessage(String component, int errorCode, String message, SourceLocation sourceLoc, Serializable ... params) {
        try (Formatter fmt = new Formatter();){
            if (!NONE.equals(component)) {
                fmt.format("%1$s%2$04d: ", component, errorCode);
                if (message.startsWith(fmt.toString())) {
                    String string = message;
                    return string;
                }
            }
            if (message != null) {
                fmt.format(message, params);
            }
            if (sourceLoc != null) {
                fmt.out().append(" (in line ").append(String.valueOf(sourceLoc.getLine())).append(", at column ").append(String.valueOf(sourceLoc.getColumn())).append(')');
            }
            String string = fmt.out().toString();
            return string;
        }
        catch (Exception e) {
            String paramsString = Arrays.toString(params);
            LOGGER.log(Level.WARN, "error formatting {}{}: message {} params {}", (Object)component, (Object)errorCode, (Object)message, (Object)paramsString, (Object)e);
            return message + "; " + paramsString;
        }
    }

    public static String getMessageNoCode(String component, String message) {
        if (NONE.equals(component)) {
            return message;
        }
        return message.substring(message.indexOf(":") + 2);
    }

    public static String getCauseMessage(Throwable t) {
        if (t instanceof IFormattedException) {
            return t.getMessage();
        }
        return String.valueOf(t);
    }

    public static String[] defineMessageEnumOrdinalMap(IError[] values, String resourcePath) {
        String[] enumMessages = new String[values.length];
        try (InputStream resourceStream = values[0].getClass().getClassLoader().getResourceAsStream(resourcePath);){
            Map<Integer, String> errorMessageMap = ErrorMessageUtil.loadErrorMap(resourceStream);
            for (IError error : values) {
                enumMessages[((Enum)((Object)error)).ordinal()] = errorMessageMap.computeIfAbsent(error.intValue(), intValue -> {
                    throw new IllegalStateException("error message missing for " + error + " (" + intValue + ")");
                });
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return enumMessages;
    }

    public static void writeObjectWithError(IError error, ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(error);
    }

    public static Optional<IError> readObjectWithError(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            return Optional.ofNullable((IError)in.readObject());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("unable to deserialize error object due to {}, the error reference will be empty", (Object)String.valueOf(e));
            return Optional.empty();
        }
    }
}

