/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveUnusedOneToOneEquiJoinRule
implements IAlgebraicRewriteRule {
    private final Set<LogicalVariable> parentsUsedVars = new HashSet<LogicalVariable>();
    private final List<LogicalVariable> usedVars = new ArrayList<LogicalVariable>();
    private final List<LogicalVariable> liveVars = new ArrayList<LogicalVariable>();
    private final List<LogicalVariable> pkVars = new ArrayList<LogicalVariable>();
    private final List<DataSourceScanOperator> dataScans = new ArrayList<DataSourceScanOperator>();
    private boolean hasRun = false;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        this.hasRun = true;
        return this.removeUnusedJoin(opRef);
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    private boolean removeUnusedJoin(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean modified = false;
        this.usedVars.clear();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, this.usedVars);
        this.parentsUsedVars.addAll(this.usedVars);
        int numInputs = op.getInputs().size();
        for (int i = 0; i < numInputs; ++i) {
            Mutable childOpRef = (Mutable)op.getInputs().get(i);
            int unusedJoinBranchIndex = this.removeJoinFromInputBranch((Mutable<ILogicalOperator>)childOpRef);
            if (unusedJoinBranchIndex >= 0) {
                int usedBranchIndex = unusedJoinBranchIndex == 0 ? 1 : 0;
                AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)childOpRef.getValue();
                op.getInputs().set(i, (Mutable)joinOp.getInputs().get(usedBranchIndex));
                modified = true;
            }
            if (!this.removeUnusedJoin((Mutable<ILogicalOperator>)childOpRef)) continue;
            modified = true;
        }
        return modified;
    }

    private int removeJoinFromInputBranch(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        int i;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return -1;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        if (!this.isEquiJoin((Mutable<ILogicalExpression>)joinOp.getCondition())) {
            return -1;
        }
        int unusedJoinBranchIndex = -1;
        for (i = 0; i < joinOp.getInputs().size(); ++i) {
            this.liveVars.clear();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)joinOp.getInputs().get(i)).getValue()), this.liveVars);
            if (this.liveVars.isEmpty()) {
                return i;
            }
            this.liveVars.retainAll(this.parentsUsedVars);
            if (!this.liveVars.isEmpty()) continue;
            unusedJoinBranchIndex = i;
            break;
        }
        if (unusedJoinBranchIndex < 0) {
            return -1;
        }
        this.usedVars.clear();
        VariableUtilities.getUsedVariables((ILogicalOperator)joinOp, this.usedVars);
        this.gatherProducingDataScans(opRef, this.usedVars, this.dataScans);
        if (this.dataScans.size() < 2) {
            return -1;
        }
        for (i = 0; i < this.dataScans.size(); ++i) {
            DatasetDataSource previousDataSource;
            DatasetDataSource currentDataSource = (DatasetDataSource)this.dataScans.get(i).getDataSource();
            if (currentDataSource.getDataset().getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
                return -1;
            }
            if (i > 0 && !(previousDataSource = (DatasetDataSource)this.dataScans.get(i - 1).getDataSource()).getDataset().equals((Object)currentDataSource.getDataset())) {
                return -1;
            }
            this.fillPKVars(this.dataScans.get(i), this.pkVars);
            this.usedVars.removeAll(this.pkVars);
        }
        if (!this.usedVars.isEmpty()) {
            return -1;
        }
        if (unusedJoinBranchIndex >= 0 && this.isSelectionAboveDataScan((Mutable<ILogicalOperator>)((Mutable)((ILogicalOperator)opRef.getValue()).getInputs().get(unusedJoinBranchIndex)))) {
            unusedJoinBranchIndex = -1;
        }
        return unusedJoinBranchIndex;
    }

    private boolean isSelectionAboveDataScan(Mutable<ILogicalOperator> opRef) {
        boolean hasSelection = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        LogicalOperatorTag tag = op.getOperatorTag();
        switch (tag) {
            case DATASOURCESCAN: {
                return false;
            }
            case UNNEST_MAP: 
            case LEFT_OUTER_UNNEST_MAP: 
            case LIMIT: 
            case SELECT: {
                return true;
            }
        }
        for (Mutable inputOp : op.getInputs()) {
            hasSelection |= this.isSelectionAboveDataScan((Mutable<ILogicalOperator>)inputOp);
        }
        return hasSelection;
    }

    private void gatherProducingDataScans(Mutable<ILogicalOperator> opRef, List<LogicalVariable> joinUsedVars, List<DataSourceScanOperator> dataScans) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            for (Mutable inputOp : op.getInputs()) {
                this.gatherProducingDataScans((Mutable<ILogicalOperator>)inputOp, joinUsedVars, dataScans);
            }
            return;
        }
        DataSourceScanOperator dataScan = (DataSourceScanOperator)op;
        this.fillPKVars(dataScan, this.pkVars);
        if (joinUsedVars.containsAll(this.pkVars)) {
            dataScans.add(dataScan);
        }
    }

    private void fillPKVars(DataSourceScanOperator dataScan, List<LogicalVariable> pkVars) {
        Dataset dataset;
        pkVars.clear();
        DataSource dataSource = (DataSource)dataScan.getDataSource();
        if (dataSource.getDatasourceType() == 0 && (dataset = ((DatasetDataSource)dataSource).getDataset()).getDatasetDetails() instanceof InternalDatasetDetails) {
            int numPKs = dataset.getPrimaryKeys().size();
            for (int i = 0; i < numPKs; ++i) {
                pkVars.add((LogicalVariable)dataScan.getVariables().get(i));
            }
        }
    }

    private boolean isEquiJoin(Mutable<ILogicalExpression> conditionExpr) {
        AbstractFunctionCallExpression funcExpr;
        FunctionIdentifier funcIdent;
        AbstractLogicalExpression expr = (AbstractLogicalExpression)conditionExpr.getValue();
        return expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (funcIdent = (funcExpr = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()) == AlgebricksBuiltinFunctions.AND || funcIdent == AlgebricksBuiltinFunctions.EQ;
    }
}

