/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveOrReplaceDefaultNullCastRule
implements IAlgebraicRewriteRule {
    private static final Map<FunctionIdentifier, FunctionIdentifier> CAST_MAP = new HashMap<FunctionIdentifier, FunctionIdentifier>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            return this.processExpressions(context, (ILogicalOperator)assignOp, assignOp.getExpressions());
        }
        if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
            SelectOperator selectOp = (SelectOperator)op;
            return this.processExpression(context, (ILogicalOperator)selectOp, (Mutable<ILogicalExpression>)selectOp.getCondition());
        }
        return false;
    }

    private boolean processExpressions(IOptimizationContext context, ILogicalOperator op, List<Mutable<ILogicalExpression>> expressions) throws AlgebricksException {
        boolean changed = false;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            changed |= this.processExpression(context, op, exprRef);
        }
        return changed;
    }

    private boolean processExpression(IOptimizationContext context, ILogicalOperator op, Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        boolean changed = this.processExpressions(context, op, funcExpr.getArguments());
        if (!CAST_MAP.containsKey(fid)) {
            return changed;
        }
        ILogicalExpression castArgExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        IVariableTypeEnvironment env = context.getOutputTypeEnvironment(op);
        IAType outputType = ((AUnionType)env.getType((ILogicalExpression)funcExpr)).getActualType();
        IAType argType = (IAType)env.getType(castArgExpr);
        if (this.isDerivedOrAny(argType) || !outputType.equals(argType) && !this.isConvertableType(fid, outputType, argType)) {
            return changed;
        }
        if (outputType.equals(argType)) {
            exprRef.setValue((Object)castArgExpr);
        } else {
            MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
            IFunctionInfo functionInfo = metadataProvider.lookupFunction(CAST_MAP.get(fid));
            funcExpr.setFunctionInfo(functionInfo);
            context.computeAndSetTypeEnvironmentForOperator(op);
        }
        return true;
    }

    private boolean isDerivedOrAny(IAType argType) {
        ATypeTag argTypeTag = argType.getTypeTag();
        return argTypeTag.isDerivedType() || argTypeTag == ATypeTag.ANY;
    }

    private boolean isConvertableType(FunctionIdentifier fid, IAType outputType, IAType argType) {
        ATypeTag outputTypeTag = outputType.getTypeTag();
        ATypeTag argTypeTag = argType.getTypeTag();
        boolean convertableNumeric = ATypeHierarchy.getTypeDomain((ATypeTag)outputTypeTag) == ATypeHierarchy.Domain.NUMERIC && ATypeHierarchy.getTypeDomain((ATypeTag)argTypeTag) == ATypeHierarchy.Domain.NUMERIC && (ATypeHierarchy.canPromote((ATypeTag)argTypeTag, (ATypeTag)outputTypeTag) || ATypeHierarchy.canDemote((ATypeTag)argTypeTag, (ATypeTag)outputTypeTag));
        return BuiltinFunctions.STRING_DEFAULT_NULL_CONSTRUCTOR.equals((Object)fid) || convertableNumeric;
    }

    static {
        CAST_MAP.put(BuiltinFunctions.BOOLEAN_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.BOOLEAN_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.INT8_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.INT8_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.INT16_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.INT16_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.INT32_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.INT32_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.INT64_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.INT64_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.FLOAT_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.FLOAT_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.DOUBLE_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DOUBLE_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.DATE_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DATE_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.TIME_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.TIME_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.DATETIME_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DATETIME_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.DURATION_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DURATION_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.DAY_TIME_DURATION_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DAY_TIME_DURATION_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.YEAR_MONTH_DURATION_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.YEAR_MONTH_DURATION_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.STRING_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.STRING_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.BINARY_BASE64_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.BINARY_BASE64_CONSTRUCTOR);
        CAST_MAP.put(BuiltinFunctions.UUID_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.UUID_CONSTRUCTOR);
    }
}

