/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.common.annotations.SpatialJoinAnnotation;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FilterRefineSpatialJoinRuleForSTFunctions
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        Mutable joinConditionRef = joinOp.getCondition();
        ILogicalExpression joinCondition = (ILogicalExpression)joinConditionRef.getValue();
        if (joinCondition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression stFuncExpr = (AbstractFunctionCallExpression)joinCondition;
        if (!BuiltinFunctions.isSTFilterRefineFunction((FunctionIdentifier)stFuncExpr.getFunctionIdentifier())) {
            return false;
        }
        List stFuncArgs = stFuncExpr.getArguments();
        Mutable stFuncLeftArg = (Mutable)stFuncArgs.get(0);
        Mutable stFuncRightArg = (Mutable)stFuncArgs.get(1);
        if (((ILogicalExpression)stFuncLeftArg.getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT || ((ILogicalExpression)stFuncRightArg.getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            return false;
        }
        ScalarFunctionCallExpression left = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.ST_MBR), new Mutable[]{stFuncLeftArg});
        left.setSourceLocation(((ILogicalExpression)stFuncLeftArg.getValue()).getSourceLocation());
        ScalarFunctionCallExpression right = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.ST_MBR), new Mutable[]{stFuncRightArg});
        right.setSourceLocation(((ILogicalExpression)stFuncRightArg.getValue()).getSourceLocation());
        ScalarFunctionCallExpression spatialIntersect = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SPATIAL_INTERSECT), new Mutable[]{new MutableObject((Object)left.cloneExpression()), new MutableObject((Object)right.cloneExpression())});
        spatialIntersect.setSourceLocation(op.getSourceLocation());
        if (stFuncExpr.getAnnotation(SpatialJoinAnnotation.class) != null) {
            spatialIntersect.putAnnotation(stFuncExpr.getAnnotation(SpatialJoinAnnotation.class));
        }
        ScalarFunctionCallExpression updatedJoinCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), new Mutable[]{new MutableObject((Object)spatialIntersect), new MutableObject((Object)stFuncExpr)});
        updatedJoinCondition.setSourceLocation(op.getSourceLocation());
        joinConditionRef.setValue((Object)updatedJoinCondition);
        return true;
    }
}

