/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayMoveSwapEval;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.asterix.runtime.utils.DescriptorFactoryUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ArrayMoveDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType inputListType;
    private String funcIDString = String.valueOf(BuiltinFunctions.ARRAY_MOVE);
    public static final IFunctionDescriptorFactory FACTORY = DescriptorFactoryUtil.createFactory(ArrayMoveDescriptor::new, FunctionTypeInferers.SET_ARGUMENTS_TYPE);

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_MOVE;
    }

    public void setImmutableStates(Object ... states) {
        this.inputListType = (IAType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayMoveEval(args, ctx);
            }
        };
    }

    public class ArrayMoveEval
    extends AbstractArrayMoveSwapEval {
        private final ArrayBackedValueStorage storage;

        ArrayMoveEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            super(args, ctx, ArrayMoveDescriptor.this.funcIDString, ArrayMoveDescriptor.this.inputListType);
            this.storage = new ArrayBackedValueStorage();
        }

        @Override
        protected void buildList(int oldIndexInt, int newIndexInt, int listLen, ListAccessor listAccessor, IAsterixListBuilder listBuilder) throws IOException {
            for (int i = 0; i < listLen; ++i) {
                if (oldIndexInt < newIndexInt) {
                    if (i < oldIndexInt || i > newIndexInt) {
                        this.storage.reset();
                        listAccessor.writeItem(i, this.storage.getDataOutput());
                        listBuilder.addItem((IValueReference)this.storage);
                        continue;
                    }
                    if (i >= oldIndexInt && i < newIndexInt) {
                        this.storage.reset();
                        listAccessor.writeItem(i + 1, this.storage.getDataOutput());
                        listBuilder.addItem((IValueReference)this.storage);
                        continue;
                    }
                    this.storage.reset();
                    listAccessor.writeItem(oldIndexInt, this.storage.getDataOutput());
                    listBuilder.addItem((IValueReference)this.storage);
                    continue;
                }
                if (i < newIndexInt || i > oldIndexInt) {
                    this.storage.reset();
                    listAccessor.writeItem(i, this.storage.getDataOutput());
                    listBuilder.addItem((IValueReference)this.storage);
                    continue;
                }
                if (i > newIndexInt && i <= oldIndexInt) {
                    this.storage.reset();
                    listAccessor.writeItem(i - 1, this.storage.getDataOutput());
                    listBuilder.addItem((IValueReference)this.storage);
                    continue;
                }
                this.storage.reset();
                listAccessor.writeItem(oldIndexInt, this.storage.getDataOutput());
                listBuilder.addItem((IValueReference)this.storage);
            }
        }
    }
}

