/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.IQueryWebServerRegistrant;
import org.apache.asterix.api.http.server.ActiveStatsApiServlet;
import org.apache.asterix.api.http.server.ApiServlet;
import org.apache.asterix.api.http.server.CcQueryCancellationServlet;
import org.apache.asterix.api.http.server.ClusterApiServlet;
import org.apache.asterix.api.http.server.ClusterControllerDetailsApiServlet;
import org.apache.asterix.api.http.server.ConnectorApiServlet;
import org.apache.asterix.api.http.server.DiagnosticsApiServlet;
import org.apache.asterix.api.http.server.NodeControllerDetailsApiServlet;
import org.apache.asterix.api.http.server.QueryResultApiServlet;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.api.http.server.QueryStatusApiServlet;
import org.apache.asterix.api.http.server.RebalanceApiServlet;
import org.apache.asterix.api.http.server.ShutdownApiServlet;
import org.apache.asterix.api.http.server.VersionApiServlet;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.cc.CCExtensionManager;
import org.apache.asterix.app.cc.CcApplicationContext;
import org.apache.asterix.app.config.ConfigValidator;
import org.apache.asterix.app.io.PersistedResourceRegistry;
import org.apache.asterix.app.replication.NcLifecycleCoordinator;
import org.apache.asterix.app.result.JobResultCallback;
import org.apache.asterix.common.api.AsterixThreadFactory;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IConfigValidatorFactory;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.api.INodeJobTracker;
import org.apache.asterix.common.api.IReceptionistFactory;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.ExtensionProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.external.IAdapterFactoryService;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.IMetadataLockUtil;
import org.apache.asterix.common.replication.INcLifecycleCoordinator;
import org.apache.asterix.external.adapter.factory.AdapterFactoryService;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.asterix.hyracks.bootstrap.ApplicationConfigurator;
import org.apache.asterix.hyracks.bootstrap.ClusterLifecycleListener;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.bootstrap.AsterixStateProxy;
import org.apache.asterix.metadata.lock.MetadataLockManager;
import org.apache.asterix.metadata.utils.MetadataLockUtil;
import org.apache.asterix.runtime.job.resource.JobCapacityController;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.Receptionist;
import org.apache.asterix.util.MetadataBuiltinFunctions;
import org.apache.asterix.utils.RedactionUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.control.IGatekeeper;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.lifecycle.LifeCycleComponentManager;
import org.apache.hyracks.api.messages.IMessageBroker;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.result.IJobResultCallback;
import org.apache.hyracks.control.cc.BaseCCApplication;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.HttpServerConfig;
import org.apache.hyracks.http.server.HttpServerConfigBuilder;
import org.apache.hyracks.http.server.WebManager;
import org.apache.hyracks.ipc.impl.HyracksConnection;
import org.apache.hyracks.util.ILogRedactor;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.LoggingConfigUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCApplication
extends BaseCCApplication {
    private static final Logger LOGGER = LogManager.getLogger();
    private IAsterixStateProxy proxy;
    protected CCExtensionManager ccExtensionManager;
    protected IStorageComponentProvider componentProvider;
    protected WebManager webManager;
    protected ICcApplicationContext appCtx;
    private IJobCapacityController jobCapacityController;
    private HyracksConnection hcc;

    public void init(IServiceContext serviceCtx) throws Exception {
        super.init(serviceCtx);
        this.ccServiceCtx.setThreadFactory((ThreadFactory)new AsterixThreadFactory(this.ccServiceCtx.getThreadFactory(), (ILifeCycleComponentManager)new LifeCycleComponentManager()));
        this.validateEnvironment();
    }

    public void start(String[] args) throws Exception {
        if (args.length > 0) {
            throw new IllegalArgumentException("Unrecognized argument(s): " + Arrays.toString(args));
        }
        ClusterControllerService controllerService = (ClusterControllerService)this.ccServiceCtx.getControllerService();
        this.ccServiceCtx.setMessageBroker((IMessageBroker)new CCMessageBroker(controllerService));
        this.ccServiceCtx.setPersistedResourceRegistry((IPersistedResourceRegistry)new PersistedResourceRegistry());
        this.configureLoggingLevel(this.ccServiceCtx.getAppConfig().getLoggingLevel((IOption)ExternalProperties.Option.LOG_LEVEL));
        LOGGER.info("Starting Asterix cluster controller");
        String strIP = this.ccServiceCtx.getCCContext().getClusterControllerInfo().getClientNetAddress();
        int port = this.ccServiceCtx.getCCContext().getClusterControllerInfo().getClientNetPort();
        this.hcc = new HyracksConnection(strIP, port, this.ccServiceCtx.getControllerService().getNetworkSecurityManager().getSocketChannelFactory());
        MetadataBuiltinFunctions.init();
        ReplicationProperties repProp = new ReplicationProperties(PropertiesAccessor.getInstance((IApplicationConfig)this.ccServiceCtx.getAppConfig()));
        INcLifecycleCoordinator lifecycleCoordinator = this.createNcLifeCycleCoordinator(repProp.isReplicationEnabled());
        this.componentProvider = new StorageComponentProvider();
        this.ccExtensionManager = new CCExtensionManager(new ArrayList<AsterixExtension>(this.getExtensions()));
        IGlobalRecoveryManager globalRecoveryManager = this.createGlobalRecoveryManager();
        this.appCtx = this.createApplicationContext(null, globalRecoveryManager, lifecycleCoordinator, Receptionist::new, ConfigValidator::new, this.ccExtensionManager, (IAdapterFactoryService)new AdapterFactoryService());
        CCConfig ccConfig = controllerService.getCCConfig();
        if (System.getProperty("java.rmi.server.hostname") == null) {
            System.setProperty("java.rmi.server.hostname", ccConfig.getClusterPublicAddress());
        }
        MetadataProperties metadataProperties = this.appCtx.getMetadataProperties();
        this.proxy = this.getAsterixStateProxy(controllerService, metadataProperties);
        this.ccServiceCtx.setDistributedState((Serializable)this.proxy);
        MetadataManager.initialize((IAsterixStateProxy)this.proxy, (MetadataProperties)metadataProperties, (ICcApplicationContext)this.appCtx);
        this.ccServiceCtx.addJobLifecycleListener(this.appCtx.getActiveNotificationHandler());
        this.webManager = new WebManager();
        this.configureServers();
        this.webManager.start();
        this.ccServiceCtx.addClusterLifecycleListener((IClusterLifecycleListener)new ClusterLifecycleListener(this.appCtx));
        INodeJobTracker nodeJobTracker = this.appCtx.getNodeJobTracker();
        this.ccServiceCtx.addJobLifecycleListener((IJobLifecycleListener)nodeJobTracker);
        this.ccServiceCtx.addClusterLifecycleListener((IClusterLifecycleListener)nodeJobTracker);
        this.jobCapacityController = new JobCapacityController(controllerService.getResourceManager());
    }

    private Map<String, String> parseCredentialMap(String credPath) {
        File credentialFile = new File(credPath);
        HashMap<String, String> storedCredentials = new HashMap<String, String>();
        if (credentialFile.exists()) {
            try (CSVParser p = CSVParser.parse((File)credentialFile, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT.withDelimiter(':'));){
                List recs = p.getRecords();
                for (CSVRecord r : recs) {
                    if (r.size() != 2) {
                        throw new IOException("Passwd file must have exactly two fields.");
                    }
                    storedCredentials.put(r.get(0), r.get(1));
                }
            }
            catch (IOException e) {
                LOGGER.error("Malformed credential file", (Throwable)e);
            }
        }
        return storedCredentials;
    }

    protected ICcApplicationContext createApplicationContext(ILibraryManager libraryManager, IGlobalRecoveryManager globalRecoveryManager, INcLifecycleCoordinator lifecycleCoordinator, IReceptionistFactory receptionistFactory, IConfigValidatorFactory configValidatorFactory, CCExtensionManager ccExtensionManager, IAdapterFactoryService adapterFactoryService) throws AlgebricksException, IOException {
        return new CcApplicationContext(this.ccServiceCtx, this.hcc, () -> MetadataManager.INSTANCE, globalRecoveryManager, lifecycleCoordinator, new ActiveNotificationHandler(), this.componentProvider, (IMetadataLockManager)new MetadataLockManager(), this.createMetadataLockUtil(), receptionistFactory, configValidatorFactory, ccExtensionManager, adapterFactoryService);
    }

    protected IGlobalRecoveryManager createGlobalRecoveryManager() throws Exception {
        return this.ccExtensionManager.getGlobalRecoveryManager(this.ccServiceCtx, this.getHcc(), this.componentProvider);
    }

    protected INcLifecycleCoordinator createNcLifeCycleCoordinator(boolean replicationEnabled) {
        return new NcLifecycleCoordinator(this.ccServiceCtx, replicationEnabled);
    }

    protected IMetadataLockUtil createMetadataLockUtil() {
        return new MetadataLockUtil();
    }

    public void configureLoggingLevel(Level level) {
        super.configureLoggingLevel(level);
        LoggingConfigUtil.defaultIfMissing((String)"org.apache.asterix", (Level)level);
        LogRedactionUtil.setRedactor((ILogRedactor)RedactionUtil.LOG_REDACTOR);
    }

    protected List<AsterixExtension> getExtensions() throws Exception {
        return new ExtensionProperties(PropertiesAccessor.getInstance((IApplicationConfig)this.ccServiceCtx.getAppConfig())).getExtensions();
    }

    protected void configureServers() throws Exception {
        this.webManager.add(this.setupWebServer(this.appCtx.getExternalProperties()));
        this.webManager.add(this.setupJSONAPIServer(this.appCtx.getExternalProperties()));
        this.webManager.add(this.setupQueryWebServer(this.appCtx.getExternalProperties()));
    }

    public void stop() throws Exception {
        LOGGER.info("Stopping Asterix cluster controller");
        this.appCtx.getClusterStateManager().setState(IClusterManagementWork.ClusterState.SHUTTING_DOWN);
        ((ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler()).stop();
        AsterixStateProxy.unregisterRemoteObject();
        this.webManager.stop();
    }

    protected HttpServer setupWebServer(ExternalProperties externalProperties) throws Exception {
        HttpServerConfig config = HttpServerConfigBuilder.custom().setMaxRequestSize(externalProperties.getMaxWebRequestSize()).build();
        HttpServer webServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getWebInterfacePort(), config);
        webServer.setAttribute("org.apache.asterix.HYRACKS_CONNECTION", (Object)this.hcc);
        webServer.addServlet((IServlet)new ApiServlet(webServer.ctx(), new String[]{"/*"}, this.appCtx, this.ccExtensionManager.getCompilationProvider(ILangExtension.Language.SQLPP), this.getStatementExecutorFactory(), this.componentProvider));
        return webServer;
    }

    protected HttpServer setupJSONAPIServer(ExternalProperties externalProperties) throws Exception {
        HttpServerConfig config = HttpServerConfigBuilder.custom().setMaxRequestSize(externalProperties.getMaxWebRequestSize()).build();
        HttpServer jsonAPIServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getAPIServerPort(), config);
        jsonAPIServer.setAttribute("org.apache.asterix.HYRACKS_CONNECTION", (Object)this.hcc);
        jsonAPIServer.setAttribute("org.apache.asterix.APP_CONTEXT_INFO", (Object)this.appCtx);
        jsonAPIServer.setAttribute("org.apache.asterix.EXECUTOR_SERVICE", (Object)this.ccServiceCtx.getControllerService().getExecutor());
        jsonAPIServer.setAttribute("org.apache.asterix.SERVICE_CONTEXT", (Object)this.ccServiceCtx);
        jsonAPIServer.setAttribute("org.apache.asterix.CREDENTIAL_MAP", this.parseCredentialMap(((ClusterControllerService)this.appCtx.getServiceContext().getControllerService()).getCCConfig().getCredentialFilePath()));
        this.addServlet(jsonAPIServer, "/query/service/status/*");
        this.addServlet(jsonAPIServer, "/query/service/result/*");
        this.addServlet(jsonAPIServer, "/query/service");
        this.addServlet(jsonAPIServer, "/admin/requests/running/*");
        this.addServlet(jsonAPIServer, "/connector");
        this.addServlet(jsonAPIServer, "/admin/shutdown");
        this.addServlet(jsonAPIServer, "/admin/version");
        this.addServlet(jsonAPIServer, "/admin/cluster/*");
        this.addServlet(jsonAPIServer, "/admin/rebalance");
        this.addServlet(jsonAPIServer, "/admin/cluster/node/*");
        this.addServlet(jsonAPIServer, "/admin/cluster/cc/*");
        this.addServlet(jsonAPIServer, "/admin/diagnostics");
        this.addServlet(jsonAPIServer, "/admin/active/*");
        return jsonAPIServer;
    }

    protected void addServlet(HttpServer server, String path) {
        server.addServlet(this.createServlet(server, path, path));
    }

    protected HttpServer setupQueryWebServer(ExternalProperties externalProperties) throws Exception {
        HttpServerConfig config = HttpServerConfigBuilder.custom().setMaxRequestSize(externalProperties.getMaxWebRequestSize()).build();
        HttpServer queryWebServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getQueryWebInterfacePort(), config);
        queryWebServer.setAttribute("org.apache.asterix.HYRACKS_CONNECTION", (Object)this.hcc);
        ServiceLoader.load(IQueryWebServerRegistrant.class).iterator().forEachRemaining(c -> c.register(this.appCtx, queryWebServer));
        return queryWebServer;
    }

    protected IServlet createServlet(HttpServer server, String key, String ... paths) {
        ConcurrentMap ctx = server.ctx();
        switch (key) {
            case "/admin/requests/running/*": {
                return new CcQueryCancellationServlet(ctx, this.appCtx, paths);
            }
            case "/query/service/status/*": {
                return new QueryStatusApiServlet(ctx, (IApplicationContext)this.appCtx, paths);
            }
            case "/query/service/result/*": {
                return new QueryResultApiServlet(ctx, (IApplicationContext)this.appCtx, paths);
            }
            case "/query/service": {
                return new QueryServiceServlet(ctx, paths, (IApplicationContext)this.appCtx, ILangExtension.Language.SQLPP, this.ccExtensionManager.getCompilationProvider(ILangExtension.Language.SQLPP), this.getStatementExecutorFactory(), this.componentProvider, null);
            }
            case "/connector": {
                return new ConnectorApiServlet(ctx, paths, this.appCtx);
            }
            case "/admin/rebalance": {
                return new RebalanceApiServlet(ctx, paths, this.appCtx);
            }
            case "/admin/shutdown": {
                return new ShutdownApiServlet(this.appCtx, ctx, paths);
            }
            case "/admin/version": {
                return new VersionApiServlet(ctx, paths);
            }
            case "/admin/cluster/*": {
                return new ClusterApiServlet(this.appCtx, ctx, paths);
            }
            case "/admin/cluster/node/*": {
                return new NodeControllerDetailsApiServlet(this.appCtx, ctx, paths);
            }
            case "/admin/cluster/cc/*": {
                return new ClusterControllerDetailsApiServlet(this.appCtx, ctx, paths);
            }
            case "/admin/diagnostics": {
                return new DiagnosticsApiServlet(this.appCtx, ctx, paths);
            }
            case "/admin/active/*": {
                return new ActiveStatsApiServlet(this.appCtx, ctx, paths);
            }
        }
        throw new IllegalStateException(key);
    }

    public IStatementExecutorFactory getStatementExecutorFactory() {
        return this.ccExtensionManager.getStatementExecutorFactory(this.ccServiceCtx.getControllerService().getExecutor());
    }

    public IJobCapacityController getJobCapacityController() {
        return this.jobCapacityController;
    }

    public void registerConfig(IConfigManager configManager) {
        super.registerConfig(configManager);
        ApplicationConfigurator.registerConfigOptions(configManager);
    }

    protected IAsterixStateProxy getAsterixStateProxy(ClusterControllerService controllerService, MetadataProperties metadataProperties) throws RemoteException {
        return AsterixStateProxy.registerRemoteObject((INetworkSecurityManager)controllerService.getNetworkSecurityManager(), (int)metadataProperties.getMetadataCallbackPort());
    }

    public ICcApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public IHyracksClientConnection getHcc() {
        return this.hcc;
    }

    protected void validateEnvironment() throws HyracksDataException {
        this.validateJavaVersion();
    }

    protected void validateJavaVersion() throws HyracksDataException {
        ApplicationConfigurator.validateJavaRuntime();
    }

    public IGatekeeper getGatekeeper() {
        return this.getConfigManager().getAppConfig().getNCNames()::contains;
    }

    public IJobResultCallback getJobResultCallback() {
        return new JobResultCallback(this.appCtx);
    }
}

