/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.clause;

import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class OrderbyClause
extends AbstractClause {
    private List<Expression> orderbyList;
    private List<OrderModifier> modifierList;
    private List<NullOrderModifier> nullModifierList;
    private RangeMap rangeMap;
    private int numFrames = -1;
    private int numTuples = -1;

    public OrderbyClause() {
    }

    public OrderbyClause(List<Expression> orderbyList, List<OrderModifier> modifierList, List<NullOrderModifier> nullModifierList) {
        this.orderbyList = orderbyList;
        this.modifierList = modifierList;
        this.nullModifierList = nullModifierList;
    }

    public List<Expression> getOrderbyList() {
        return this.orderbyList;
    }

    public void setOrderbyList(List<Expression> orderbyList) {
        this.orderbyList = orderbyList;
    }

    public List<OrderModifier> getModifierList() {
        return this.modifierList;
    }

    public void setModifierList(List<OrderModifier> modifierList) {
        this.modifierList = modifierList;
    }

    public List<NullOrderModifier> getNullModifierList() {
        return this.nullModifierList;
    }

    public void setNullModifierList(List<NullOrderModifier> nullModifierList) {
        this.nullModifierList = nullModifierList;
    }

    @Override
    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.ORDER_BY_CLAUSE;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(int numFrames) {
        this.numFrames = numFrames;
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public void setNumTuples(int numTuples) {
        this.numTuples = numTuples;
    }

    public RangeMap getRangeMap() {
        return this.rangeMap;
    }

    public void setRangeMap(RangeMap rangeMap) {
        this.rangeMap = rangeMap;
    }

    public int hashCode() {
        return Objects.hash(this.modifierList, this.numFrames, this.numTuples, this.orderbyList, this.rangeMap);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OrderbyClause)) {
            return false;
        }
        OrderbyClause target = (OrderbyClause)object;
        return Objects.equals(this.modifierList, target.modifierList) && this.numFrames == target.numFrames && this.numTuples == target.numTuples && this.orderbyList.equals(target.orderbyList) && Objects.equals(this.rangeMap, target.rangeMap);
    }

    public static enum NullOrderModifier {
        FIRST,
        LAST;

    }

    public static enum OrderModifier {
        ASC,
        DESC;

    }
}

