/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.Sql92AggregateFunctionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppWindowAggregationSugarVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private final Deque<SelectBlock> stack = new ArrayDeque<SelectBlock>();

    public SqlppWindowAggregationSugarVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        this.stack.push(selectBlock);
        Expression expr = super.visit(selectBlock, arg);
        this.stack.pop();
        return expr;
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature signature;
        FunctionIdentifier winfi;
        if (!winExpr.hasWindowFieldList()) {
            SelectBlock selectBlock = this.stack.peek();
            List<Pair<Expression, Identifier>> winFieldList = this.createWindowFieldList(selectBlock);
            winExpr.setWindowFieldList(winFieldList);
        }
        if ((winfi = FunctionMapUtil.getInternalWindowFunction(signature = winExpr.getFunctionSignature())) != null) {
            winExpr.setFunctionSignature(new FunctionSignature(winfi));
            if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)winfi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.HAS_LIST_ARG)) {
                if (winExpr.hasAggregateFilterExpr()) {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_USE_OF_FILTER_CLAUSE, winExpr.getSourceLocation(), new Serializable[0]);
                }
                this.wrapAggregationArgument(winExpr, null);
            }
        } else if (FunctionMapUtil.isSql92AggregateFunction(signature)) {
            if (winExpr.getExprList().size() != 1) {
                throw new CompilationException(ErrorCode.COMPILATION_INVALID_PARAMETER_NUMBER, winExpr.getSourceLocation(), new Serializable[]{signature.getName(), Integer.valueOf(winExpr.getExprList().size())});
            }
            this.wrapAggregationArgument(winExpr, winExpr.getAggregateFilterExpr());
            winExpr.setAggregateFilterExpr(null);
            winExpr.setFunctionSignature(FunctionMapUtil.sql92ToCoreAggregateFunction(signature));
        }
        return super.visit(winExpr, arg);
    }

    private void wrapAggregationArgument(WindowExpression winExpr, Expression aggFilterExpr) throws CompilationException {
        VariableExpr winVar = winExpr.getWindowVar();
        Map liveAnnotatedVars = this.scopeChecker.getCurrentScope().getLiveVariables();
        Set<VariableExpr> liveVars = liveAnnotatedVars.keySet();
        Map localAnnotatedVars = this.scopeChecker.getCurrentScope().getLiveVariables(this.scopeChecker.getPrecedingScope());
        Set liveContextVars = Scope.findVariablesAnnotatedBy(localAnnotatedVars.keySet(), (Scope.SymbolAnnotation)AbstractSqlppExpressionScopingVisitor.SqlppVariableAnnotation.CONTEXT_VARIABLE, (Map)localAnnotatedVars, (SourceLocation)winExpr.getSourceLocation());
        List<Pair<Expression, Identifier>> winFieldList = winExpr.getWindowFieldList();
        Map<VariableExpr, Identifier> winVarFieldMap = SqlppGroupByAggregationSugarVisitor.createGroupVarFieldMap(winFieldList);
        List exprList = winExpr.getExprList();
        Expression aggArgExpr = (Expression)exprList.get(0);
        Expression newAggArgExpr = Sql92AggregateFunctionVisitor.wrapAggregationArgument(aggArgExpr, aggFilterExpr, (Expression)winVar, winVarFieldMap, liveContextVars, null, liveVars, this.context);
        ArrayList<Expression> newExprList = new ArrayList<Expression>(exprList);
        newExprList.set(0, newAggArgExpr);
        winExpr.setExprList(newExprList);
    }

    private List<Pair<Expression, Identifier>> createWindowFieldList(SelectBlock selectBlock) throws CompilationException {
        ArrayList<Pair<Expression, Identifier>> fieldList = new ArrayList<Pair<Expression, Identifier>>();
        if (selectBlock != null) {
            this.addToFieldList(fieldList, SqlppVariableUtil.getBindingVariables((ILangExpression)selectBlock.getFromClause()));
            this.addToFieldList(fieldList, SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetWhereList()));
            this.addToFieldList(fieldList, SqlppVariableUtil.getBindingVariables((ILangExpression)selectBlock.getGroupbyClause()));
            this.addToFieldList(fieldList, SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetHavingListAfterGroupby()));
        }
        return fieldList;
    }

    private void addToFieldList(List<Pair<Expression, Identifier>> outFieldList, List<VariableExpr> varList) {
        for (VariableExpr varExpr : varList) {
            if (this.scopeChecker.lookupSymbol(varExpr.getVar().getValue()) == null) continue;
            SqlppVariableUtil.addToFieldVariableList(varExpr, outFieldList);
        }
    }
}

