/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.transform.PutRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, AttributeValue> item;

    public PutRequest() {
    }

    public PutRequest(Map<String, AttributeValue> item) {
        this.setItem(item);
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> item) {
        this.item = item;
    }

    public PutRequest withItem(Map<String, AttributeValue> item) {
        this.setItem(item);
        return this;
    }

    public PutRequest addItemEntry(String key, AttributeValue value) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.item.put(key, value);
        return this;
    }

    public PutRequest clearItemEntries() {
        this.item = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItem() != null) {
            sb.append("Item: ").append(this.getItem());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRequest)) {
            return false;
        }
        PutRequest other = (PutRequest)obj;
        if (other.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        return other.getItem() == null || other.getItem().equals(this.getItem());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItem() == null ? 0 : this.getItem().hashCode());
        return hashCode;
    }

    public PutRequest clone() {
        try {
            return (PutRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

