/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.result.ResultSetId;

public interface IStatementExecutor {
    public void compileAndExecute(IHyracksClientConnection var1, IRequestParameters var2) throws Exception;

    public JobSpecification rewriteCompileQuery(IClusterInfoCollector var1, MetadataProvider var2, Query var3, CompiledStatements.ICompiledDmlStatement var4, Map<String, IAObject> var5, IRequestParameters var6) throws RemoteException, AlgebricksException, ACIDException;

    public DataverseName getActiveDataverseName(DataverseName var1);

    public ExecutionPlans getExecutionPlans();

    public IResponsePrinter getResponsePrinter();

    public void getWarnings(Collection<? super Warning> var1, long var2);

    public static class StatementProperties
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private Statement.Kind kind;
        private String name;

        public Statement.Kind getKind() {
            return this.kind;
        }

        public void setKind(Statement.Kind kind) {
            this.kind = kind;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isValid() {
            return this.kind != null && (this.kind != Statement.Kind.EXTENSION || this.name != null);
        }

        public String toString() {
            return Statement.Kind.EXTENSION == this.kind ? String.valueOf(this.name) : String.valueOf(this.kind);
        }
    }

    public static class Profile
    implements Serializable {
        private static final long serialVersionUID = 4813321148252768375L;
        private transient ObjectNode profile;

        public Profile(ObjectNode profile) {
            this.profile = profile;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            ObjectMapper om = new ObjectMapper();
            out.writeUTF(om.writeValueAsString((Object)this.profile));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            ObjectMapper om = new ObjectMapper();
            JsonNode inNode = om.readTree(in.readUTF());
            if (!inNode.isObject()) {
                throw new IOException("Deserialization error");
            }
            this.profile = (ObjectNode)inNode;
        }

        public ObjectNode getProfile() {
            return this.profile;
        }
    }

    public static class Stats
    implements Serializable {
        private static final long serialVersionUID = 5885273238208454611L;
        private long count;
        private long size;
        private long processedObjects;
        private Profile profile;
        private ProfileType profileType;
        private long totalWarningsCount;

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getProcessedObjects() {
            return this.processedObjects;
        }

        public void setProcessedObjects(long processedObjects) {
            this.processedObjects = processedObjects;
        }

        public long getTotalWarningsCount() {
            return this.totalWarningsCount;
        }

        public void updateTotalWarningsCount(long delta) {
            if (delta <= Long.MAX_VALUE - this.totalWarningsCount) {
                this.totalWarningsCount += delta;
            }
        }

        public void setJobProfile(ObjectNode profile) {
            this.profile = new Profile(profile);
        }

        public ObjectNode getJobProfile() {
            return this.profile != null ? this.profile.getProfile() : null;
        }

        public ProfileType getProfileType() {
            return this.profileType;
        }

        public void setProfileType(ProfileType profileType) {
            this.profileType = profileType;
        }

        public static enum ProfileType {
            COUNTS("counts"),
            FULL("timings"),
            NONE("off");

            private static final Map<String, ProfileType> profileNames;
            private final String name;

            private ProfileType(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public static ProfileType fromName(String name) {
                return profileNames.get(name);
            }

            static {
                profileNames = Collections.unmodifiableMap(Arrays.stream(ProfileType.values()).collect(Collectors.toMap(ProfileType::getName, Function.identity())));
            }
        }
    }

    public static class ResultMetadata
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Triple<JobId, ResultSetId, ARecordType>> resultSets = new ArrayList<Triple<JobId, ResultSetId, ARecordType>>();

        public List<Triple<JobId, ResultSetId, ARecordType>> getResultSets() {
            return this.resultSets;
        }
    }

    public static enum ResultDelivery {
        IMMEDIATE("immediate"),
        DEFERRED("deferred"),
        ASYNC("async");

        private static final Map<String, ResultDelivery> deliveryNames;
        private final String name;

        private ResultDelivery(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ResultDelivery fromName(String name) {
            return deliveryNames.get(name);
        }

        static {
            deliveryNames = Collections.unmodifiableMap(Arrays.stream(ResultDelivery.values()).collect(Collectors.toMap(ResultDelivery::getName, Function.identity())));
        }
    }
}

