/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.pushdown.ExpectedSchemaBuilder;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

class ExpressionValueAccessPushdownVisitor
implements ILogicalExpressionReferenceTransform {
    static final Set<FunctionIdentifier> TYPE_CHECK_FUNCTIONS = ExpressionValueAccessPushdownVisitor.createSupportedTypeCheckFunctions();
    static final Set<FunctionIdentifier> ARRAY_FUNCTIONS = ExpressionValueAccessPushdownVisitor.createSupportedArrayFunctions();
    static final Set<FunctionIdentifier> SUPPORTED_FUNCTIONS = ExpressionValueAccessPushdownVisitor.createSupportedFunctions();
    private final ExpectedSchemaBuilder builder;
    private List<LogicalVariable> producedVariables;
    private int producedVariableIndex;

    public ExpressionValueAccessPushdownVisitor(ExpectedSchemaBuilder builder) {
        this.builder = builder;
        this.end();
    }

    public void init(List<LogicalVariable> producedVariables) {
        this.producedVariables = producedVariables;
        this.producedVariableIndex = 0;
    }

    public boolean transform(Mutable<ILogicalExpression> expression) throws AlgebricksException {
        if (this.producedVariableIndex == -1) {
            throw new IllegalStateException("init must be called first");
        }
        this.pushValueAccessExpression(expression, this.getNextProducedVariable());
        return false;
    }

    public void end() {
        this.producedVariables = null;
        this.producedVariableIndex = -1;
    }

    private LogicalVariable getNextProducedVariable() {
        LogicalVariable variable = this.producedVariables != null ? this.producedVariables.get(this.producedVariableIndex) : null;
        ++this.producedVariableIndex;
        return variable;
    }

    private void pushValueAccessExpression(Mutable<ILogicalExpression> exprRef, LogicalVariable producedVar) {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (this.skipPushdown(expr)) {
            return;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (this.isSuccessfullyPushedDown(funcExpr, producedVar)) {
            return;
        }
        this.pushValueAccessExpressionArg(funcExpr.getArguments());
    }

    private boolean skipPushdown(ILogicalExpression expr) {
        if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            LogicalVariable variable = VariableUtilities.getVariable((ILogicalExpression)expr);
            this.unregisterVariableIfNeeded(variable);
            return true;
        }
        return expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || !this.builder.containsRegisteredDatasets() || this.isTypeCheckOnVariable(expr);
    }

    private boolean isTypeCheckOnVariable(ILogicalExpression expression) {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        return TYPE_CHECK_FUNCTIONS.contains(funcExpr.getFunctionIdentifier()) && ((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }

    private void pushValueAccessExpressionArg(List<Mutable<ILogicalExpression>> exprList) {
        for (Mutable<ILogicalExpression> exprRef : exprList) {
            this.pushValueAccessExpression(exprRef, null);
        }
    }

    private boolean isSuccessfullyPushedDown(AbstractFunctionCallExpression funcExpr, LogicalVariable producedVar) {
        return SUPPORTED_FUNCTIONS.contains(funcExpr.getFunctionIdentifier()) && this.builder.setSchemaFromExpression(funcExpr, producedVar);
    }

    private void unregisterVariableIfNeeded(LogicalVariable variable) {
        if (this.builder.isVariableRegistered(variable)) {
            this.builder.unregisterVariable(variable);
        }
    }

    private static Set<FunctionIdentifier> createSupportedArrayFunctions() {
        return Set.of(BuiltinFunctions.GET_ITEM, BuiltinFunctions.ARRAY_STAR, BuiltinFunctions.SCAN_COLLECTION);
    }

    private static Set<FunctionIdentifier> createSupportedFunctions() {
        HashSet<FunctionIdentifier> supportedFunctions = new HashSet<FunctionIdentifier>();
        supportedFunctions.add(BuiltinFunctions.FIELD_ACCESS_BY_NAME);
        supportedFunctions.addAll(ARRAY_FUNCTIONS);
        return supportedFunctions;
    }

    private static Set<FunctionIdentifier> createSupportedTypeCheckFunctions() {
        return Set.of(BuiltinFunctions.IS_ARRAY, BuiltinFunctions.IS_OBJECT, BuiltinFunctions.IS_ATOMIC, BuiltinFunctions.IS_NUMBER, BuiltinFunctions.IS_BOOLEAN, BuiltinFunctions.IS_STRING, AlgebricksBuiltinFunctions.IS_MISSING, AlgebricksBuiltinFunctions.IS_NULL, BuiltinFunctions.IS_UNKNOWN);
    }
}

