/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.projection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;

public class FunctionCallInformation
implements Serializable {
    private static final long serialVersionUID = -7884346933746232736L;
    private final String functionName;
    private final SourceLocation sourceLocation;
    private Set<ATypeTag> typeMismatches;

    public FunctionCallInformation(String functionName, SourceLocation sourceLocation) {
        this(functionName, sourceLocation, Collections.emptySet());
    }

    private FunctionCallInformation(String functionName, SourceLocation sourceLocation, Set<ATypeTag> typeMismatches) {
        this.functionName = functionName;
        this.sourceLocation = sourceLocation;
        this.typeMismatches = typeMismatches;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public Warning createTypeMismatchWarning(ATypeTag expectedType, ATypeTag actualType) {
        if (this.typeMismatches == null) {
            this.typeMismatches = EnumSet.noneOf(ATypeTag.class);
        } else if (this.typeMismatches.contains(actualType)) {
            return null;
        }
        this.typeMismatches.add(actualType);
        return Warning.of((SourceLocation)this.getSourceLocation(), (IError)ErrorCode.TYPE_MISMATCH_FUNCTION, (Serializable[])new Serializable[]{this.getFunctionName(), ExceptionUtil.indexToPosition((int)0), expectedType, actualType});
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.functionName);
        SourceLocation.writeFields((SourceLocation)this.sourceLocation, (DataOutput)output);
        output.writeInt(this.typeMismatches.size());
        for (ATypeTag typeTag : this.typeMismatches) {
            output.write(typeTag.serialize());
        }
    }

    public static FunctionCallInformation create(DataInput in) throws IOException {
        String functionName = in.readUTF();
        SourceLocation sourceLocation = SourceLocation.create((DataInput)in);
        int typeMismatchesLength = in.readInt();
        EnumSet<ATypeTag> typeMismatches = EnumSet.noneOf(ATypeTag.class);
        for (int i = 0; i < typeMismatchesLength; ++i) {
            typeMismatches.add(ATypeTag.VALUE_TYPE_MAPPING[in.readByte()]);
        }
        return new FunctionCallInformation(functionName, sourceLocation, typeMismatches);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.sourceLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCallInformation that = (FunctionCallInformation)o;
        return Objects.equals(this.functionName, that.functionName) && Objects.equals(this.sourceLocation, that.sourceLocation);
    }
}

