/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.asterix.common.annotations.AutoDataGen;
import org.apache.asterix.common.annotations.DateBetweenYearsDataGen;
import org.apache.asterix.common.annotations.DatetimeAddRandHoursDataGen;
import org.apache.asterix.common.annotations.DatetimeBetweenYearsDataGen;
import org.apache.asterix.common.annotations.ExternalSubpathAnnotation;
import org.apache.asterix.common.annotations.FieldIntervalDataGen;
import org.apache.asterix.common.annotations.FieldValFileDataGen;
import org.apache.asterix.common.annotations.FieldValFileSameIndexDataGen;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.InsertRandIntDataGen;
import org.apache.asterix.common.annotations.ListDataGen;
import org.apache.asterix.common.annotations.ListValFileDataGen;
import org.apache.asterix.common.annotations.RangeAnnotation;
import org.apache.asterix.common.annotations.SecondaryIndexSearchPreferenceAnnotation;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.annotations.SpatialJoinAnnotation;
import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.WarningCollector;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.AbstractLangExpression;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.context.RootScopeFactory;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.AbstractAccessor;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FalseLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.MissingLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.statement.AdapterDropStatement;
import org.apache.asterix.lang.common.statement.AnalyzeDropStatement;
import org.apache.asterix.lang.common.statement.AnalyzeStatement;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFullTextConfigStatement;
import org.apache.asterix.lang.common.statement.CreateFullTextFilterStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.CreateViewStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FullTextConfigDropStatement;
import org.apache.asterix.lang.common.statement.FullTextFilterDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.SynonymDropStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.statement.ViewDropStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.DatasetDeclParametersUtil;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.util.RangeMapBuilder;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.optype.UnnestType;
import org.apache.asterix.lang.sqlpp.parser.JavaCharStream;
import org.apache.asterix.lang.sqlpp.parser.ParseException;
import org.apache.asterix.lang.sqlpp.parser.SQLPPParserConstants;
import org.apache.asterix.lang.sqlpp.parser.SQLPPParserTokenManager;
import org.apache.asterix.lang.sqlpp.parser.SqlppGroupingSetsParser;
import org.apache.asterix.lang.sqlpp.parser.SqlppHint;
import org.apache.asterix.lang.sqlpp.parser.SqlppParseException;
import org.apache.asterix.lang.sqlpp.parser.Token;
import org.apache.asterix.lang.sqlpp.parser.TokenMgrError;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.ExpressionToVariableUtil;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.JoinProductivityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.StringUtil;

class SQLPPParser
extends ScopeChecker
implements IParser,
SQLPPParserConstants {
    private static final String CUBE = "CUBE";
    private static final String CURRENT = "CURRENT";
    private static final String DEFAULT = "DEFAULT";
    private static final String EXCLUDE = "EXCLUDE";
    private static final String INCLUDE = "INCLUDE";
    private static final String FIRST = "FIRST";
    private static final String FOLLOWING = "FOLLOWING";
    private static final String FOREIGN = "FOREIGN";
    private static final String GROUPING = "GROUPING";
    private static final String GROUPS = "GROUPS";
    private static final String IGNORE = "IGNORE";
    private static final String LAST = "LAST";
    private static final String META = "META";
    private static final String NO = "NO";
    private static final String NULLS = "NULLS";
    private static final String OTHERS = "OTHERS";
    private static final String PARTITION = "PARTITION";
    private static final String PRECEDING = "PRECEDING";
    private static final String RANGE = "RANGE";
    private static final String REFERENCES = "REFERENCES";
    private static final String RESPECT = "RESPECT";
    private static final String ROLLUP = "ROLLUP";
    private static final String ROW = "ROW";
    private static final String ROWS = "ROWS";
    private static final String SETS = "SETS";
    private static final String TIES = "TIES";
    private static final String UNBOUNDED = "UNBOUNDED";
    private static final String REPLACE = "REPLACE";
    private static final String RETURNS = "RETURNS";
    private static final String CONFIG = "CONFIG";
    private static final String STATISTICS = "STATISTICS";
    private static final String INT_TYPE_NAME = "int";
    private static final String UDF_VARARGS_PARAM_NAME = "args";
    protected static final boolean REPORT_EXPECTED_TOKENS = false;
    private int externalVarCounter;
    private DataverseName defaultDataverse;
    private SqlppGroupingSetsParser groupingSetsParser;
    private final WarningCollector warningCollector = new WarningCollector();
    private final Map<SourceLocation, String> hintCollector = new HashMap<SourceLocation, String>();
    public SQLPPParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[235];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private final JJCalls[] jj_2_rtns = new JJCalls[25];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private IRecordFieldDataGen parseFieldDataGen(Token hintToken) throws ParseException {
        String[] splits = hintToken.hintParams != null ? hintToken.hintParams.split("\\s+") : null;
        switch (hintToken.hint) {
            case VAL_FILE_HINT: {
                File[] valFiles = new File[splits.length];
                for (int k = 0; k < splits.length; ++k) {
                    valFiles[k] = new File(splits[k]);
                }
                return new FieldValFileDataGen(valFiles);
            }
            case VAL_FILE_SAME_INDEX_HINT: {
                return new FieldValFileSameIndexDataGen(new File(splits[0]), splits[1]);
            }
            case LIST_VAL_FILE_HINT: {
                return new ListValFileDataGen(new File(splits[0]), Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
            }
            case LIST_HINT: {
                return new ListDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
            }
            case INTERVAL_HINT: {
                FieldIntervalDataGen.ValueType vt;
                switch (splits[0]) {
                    case "int": {
                        vt = FieldIntervalDataGen.ValueType.INT;
                        break;
                    }
                    case "long": {
                        vt = FieldIntervalDataGen.ValueType.LONG;
                        break;
                    }
                    case "float": {
                        vt = FieldIntervalDataGen.ValueType.FLOAT;
                        break;
                    }
                    case "double": {
                        vt = FieldIntervalDataGen.ValueType.DOUBLE;
                        break;
                    }
                    default: {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Unknown type for interval data gen: " + splits[0]);
                    }
                }
                return new FieldIntervalDataGen(vt, splits[1], splits[2]);
            }
            case INSERT_RAND_INT_HINT: {
                return new InsertRandIntDataGen(splits[0], splits[1]);
            }
            case DATE_BETWEEN_YEARS_HINT: {
                return new DateBetweenYearsDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
            }
            case DATETIME_BETWEEN_YEARS_HINT: {
                return new DatetimeBetweenYearsDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
            }
            case DATETIME_ADD_RAND_HOURS_HINT: {
                return new DatetimeAddRandHoursDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]), splits[2]);
            }
            case AUTO_HINT: {
                return new AutoDataGen(splits[0]);
            }
        }
        return null;
    }

    public SQLPPParser(String s) {
        this(new StringReader(s));
        super.setInput(s);
    }

    public static void main(String[] args) throws ParseException, TokenMgrError, IOException, FileNotFoundException, CompilationException {
        File file = new File(args[0]);
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        SQLPPParser parser = new SQLPPParser(fis);
        List<Statement> st = parser.parse();
    }

    public List<Statement> parse() throws CompilationException {
        return this.parseImpl(new ParseFunction<List<Statement>>(){

            @Override
            public List<Statement> parse() throws ParseException {
                return SQLPPParser.this.Statement();
            }
        });
    }

    public Expression parseExpression() throws CompilationException {
        return this.parseImpl(new ParseFunction<Expression>(){

            @Override
            public Expression parse() throws ParseException {
                return SQLPPParser.this.Expression();
            }
        });
    }

    private static Expression parseExpression(String text) throws CompilationException {
        return new SQLPPParser(text).parseExpression();
    }

    public List<String> parseMultipartIdentifier() throws CompilationException {
        return this.parseImpl(new ParseFunction<List<String>>(){

            @Override
            public List<String> parse() throws ParseException {
                return (List)SQLPPParser.this.MultipartIdentifier().first;
            }
        });
    }

    private List<String> parseParenthesizedIdentifierList() throws CompilationException {
        return this.parseImpl(new ParseFunction<List<String>>(){

            @Override
            public List<String> parse() throws ParseException {
                return SQLPPParser.this.ParenthesizedIdentifierList();
            }
        });
    }

    private static List<String> parseParenthesizedIdentifierList(String text) throws CompilationException {
        return new SQLPPParser(text).parseParenthesizedIdentifierList();
    }

    private Pair<HashJoinExpressionAnnotation.BuildOrProbe, String> parseHashJoinParams() throws CompilationException {
        return this.parseImpl(new ParseFunction<Pair<HashJoinExpressionAnnotation.BuildOrProbe, String>>(){

            @Override
            public Pair<HashJoinExpressionAnnotation.BuildOrProbe, String> parse() throws ParseException {
                return SQLPPParser.this.buildOrProbeParenthesizedIdentifier();
            }
        });
    }

    private static Pair<HashJoinExpressionAnnotation.BuildOrProbe, String> parseHashJoinParams(String text) throws CompilationException {
        return new SQLPPParser(text).parseHashJoinParams();
    }

    private String parseBroadcastJoinParams() throws CompilationException {
        return this.parseImpl(new ParseFunction<String>(){

            @Override
            public String parse() throws ParseException {
                return SQLPPParser.this.parenthesizedIdentifier();
            }
        });
    }

    private static String parseBroadcastJoinParams(String text) throws CompilationException {
        return new SQLPPParser(text).parseBroadcastJoinParams();
    }

    private List<Literal> parseParenthesizedLiteralList() throws CompilationException {
        return this.parseImpl(new ParseFunction<List<Literal>>(){

            @Override
            public List<Literal> parse() throws ParseException {
                return SQLPPParser.this.ParenthesizedLiteralList();
            }
        });
    }

    private static List<Literal> parseParenthesizedLiteralList(String text) throws CompilationException {
        return new SQLPPParser(text).parseParenthesizedLiteralList();
    }

    public FunctionDecl parseFunctionBody(final FunctionSignature signature, final List<String> paramNames, final boolean isStored) throws CompilationException {
        return this.parseImpl(new ParseFunction<FunctionDecl>(){

            @Override
            public FunctionDecl parse() throws ParseException {
                DataverseName dataverse = SQLPPParser.this.defaultDataverse;
                SQLPPParser.this.defaultDataverse = signature.getDataverseName();
                SQLPPParser.this.createNewScope();
                ArrayList<VarIdentifier> paramVars = new ArrayList<VarIdentifier>(paramNames.size());
                for (String paramName : paramNames) {
                    paramVars.add(SqlppVariableUtil.toInternalVariableIdentifier(paramName));
                }
                Expression functionBodyExpr = SQLPPParser.this.FunctionBody();
                SQLPPParser.this.removeCurrentScope();
                SQLPPParser.this.defaultDataverse = dataverse;
                return new FunctionDecl(signature, paramVars, functionBodyExpr, isStored);
            }
        });
    }

    public ViewDecl parseViewBody(final DatasetFullyQualifiedName viewName) throws CompilationException {
        return this.parseImpl(new ParseFunction<ViewDecl>(){

            @Override
            public ViewDecl parse() throws ParseException {
                DataverseName dataverse = SQLPPParser.this.defaultDataverse;
                SQLPPParser.this.defaultDataverse = viewName.getDataverseName();
                SQLPPParser.this.createNewScope();
                Expression viewBodyExpr = SQLPPParser.this.ViewBody();
                SQLPPParser.this.removeCurrentScope();
                SQLPPParser.this.defaultDataverse = dataverse;
                return new ViewDecl(viewName, viewBodyExpr);
            }
        });
    }

    private <T> T parseImpl(ParseFunction<T> parseFunction) throws CompilationException {
        this.warningCollector.clear();
        this.hintCollector.clear();
        this.token_source.hintCollector = this.hintCollector;
        try {
            T t = parseFunction.parse();
            return t;
        }
        catch (SqlppParseException e) {
            AlgebricksException cause;
            if (e.getCause() instanceof AlgebricksException && (cause = (AlgebricksException)e.getCause()).getError().isPresent() && cause.getError().get() instanceof ErrorCode) {
                throw new CompilationException((ErrorCode)cause.getError().get(), e.getSourceLocation(), cause.getParams());
            }
            throw new CompilationException(ErrorCode.PARSE_ERROR, e.getSourceLocation(), new Serializable[]{LogRedactionUtil.userData((String)this.getMessage(e))});
        }
        catch (ParseException e) {
            throw new CompilationException(ErrorCode.PARSE_ERROR, new Serializable[]{LogRedactionUtil.userData((String)this.getMessage(e))});
        }
        catch (Error e) {
            String msg = e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "");
            throw new CompilationException(ErrorCode.PARSE_ERROR, new Serializable[]{LogRedactionUtil.userData((String)msg)});
        }
        finally {
            this.reportUnclaimedHints();
        }
    }

    public void getWarnings(IWarningCollector outWarningCollector) {
        this.warningCollector.getWarnings(outWarningCollector);
    }

    public void getWarnings(Collection<? super Warning> outWarnings, long maxWarnings) {
        this.warningCollector.getWarnings(outWarnings, maxWarnings);
    }

    public long getTotalWarningsCount() {
        return this.warningCollector.getTotalWarningsCount();
    }

    protected String getMessage(ParseException pe) {
        Token currentToken = pe.currentToken;
        if (currentToken == null) {
            return pe.getMessage();
        }
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String[] tokenImage = pe.tokenImage;
        String sep = " ";
        StringBuilder expected = null;
        int maxSize = this.appendExpected(expected, expectedTokenSequences, tokenImage);
        Token tok = currentToken.next;
        int line = tok.beginLine;
        StringBuilder message = new StringBuilder(128);
        message.append("In line ").append(line).append(" >>").append(this.getLine(line)).append("<<").append(sep).append("Encountered ");
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                message.append(' ');
            }
            if (tok.kind == 0) {
                message.append(SQLPPParser.fixQuotes((String)tokenImage[0]));
                break;
            }
            String fixedTokenImage = tokenImage[tok.kind];
            if (!tok.image.equalsIgnoreCase(SQLPPParser.stripQuotes((String)fixedTokenImage))) {
                message.append(SQLPPParser.fixQuotes((String)fixedTokenImage)).append(' ');
            }
            message.append(quot).append(SQLPPParser.addEscapes((String)tok.image)).append(quot);
            tok = tok.next;
        }
        message.append(" at column ").append(currentToken.next.beginColumn).append('.').append(sep);
        return message.toString();
    }

    protected static SourceLocation getSourceLocation(Token token) {
        return token == null ? null : (token.sourceLocation != null ? token.sourceLocation : new SourceLocation(token.beginLine, token.beginColumn));
    }

    protected static <T extends AbstractLangExpression> T addSourceLocation(T expr, Token token) {
        expr.setSourceLocation(SQLPPParser.getSourceLocation(token));
        return expr;
    }

    private boolean isToken(String image) {
        return SQLPPParser.isToken(this.token, image);
    }

    private static boolean isToken(Token token, String image) {
        return token.image.equalsIgnoreCase(image);
    }

    private void expectToken(String image) throws SqlppParseException {
        SQLPPParser.expectToken(this.token, image);
    }

    private static void expectToken(Token token, String image) throws SqlppParseException {
        if (!SQLPPParser.isToken(token, image)) {
            throw SQLPPParser.createUnexpectedTokenError(token);
        }
    }

    private SqlppParseException createUnexpectedTokenError() {
        return SQLPPParser.createUnexpectedTokenError(this.token, null);
    }

    private static SqlppParseException createUnexpectedTokenError(Token t) {
        return SQLPPParser.createUnexpectedTokenError(t, null);
    }

    private SqlppParseException createUnexpectedTokenError(String expected) {
        return SQLPPParser.createUnexpectedTokenError(this.token, expected);
    }

    private static SqlppParseException createUnexpectedTokenError(Token t, String expected) {
        String message = "Unexpected token: " + LogRedactionUtil.userData((String)t.image) + (String)(expected == null ? "" : ". Expected: " + LogRedactionUtil.userData((String)expected));
        return new SqlppParseException(SQLPPParser.getSourceLocation(t), message);
    }

    private boolean laToken(int idx, int kind) {
        Token t = this.getToken(idx);
        return t.kind == kind;
    }

    private boolean laToken(int idx, int kind, String image) {
        Token t = this.getToken(idx);
        return t.kind == kind && t.image.equalsIgnoreCase(image);
    }

    private boolean laIdentifier(int idx, String image) {
        return this.laToken(idx, 167, image);
    }

    private boolean laIdentifier(String image) {
        return this.laIdentifier(1, image);
    }

    private Token fetchHint(Token token, SqlppHint ... expectedHints) {
        Token hintToken = token.specialToken;
        if (hintToken == null) {
            return null;
        }
        SourceLocation sourceLoc = SQLPPParser.getSourceLocation(hintToken);
        this.hintCollector.remove(sourceLoc);
        if (hintToken.hint == null) {
            this.warnUnexpectedHint(hintToken.hintParams, sourceLoc, expectedHints);
            return null;
        }
        if (!ArrayUtils.contains((Object[])expectedHints, (Object)((Object)hintToken.hint))) {
            this.warnUnexpectedHint(hintToken.hint.getIdentifier(), sourceLoc, expectedHints);
            return null;
        }
        return hintToken;
    }

    private void reportUnclaimedHints() {
        for (Map.Entry<SourceLocation, String> me : this.hintCollector.entrySet()) {
            this.warnUnexpectedHint(me.getValue(), me.getKey(), "None");
        }
    }

    private void warnUnexpectedHint(String actualHint, SourceLocation sourceLoc, SqlppHint ... expectedHints) {
        this.warnUnexpectedHint(actualHint, sourceLoc, StringUtil.join((Object[])expectedHints, (String)", ", (String)"\""));
    }

    private void warnUnexpectedHint(String actualHint, SourceLocation sourceLoc, String expectedHints) {
        if (this.warningCollector.shouldWarn()) {
            this.warningCollector.warn(Warning.of((SourceLocation)sourceLoc, (IError)ErrorCode.UNEXPECTED_HINT, (Serializable[])new Serializable[]{actualHint, expectedHints}));
        }
    }

    private IExpressionAnnotation parseExpressionAnnotation(Token hintToken) {
        IndexedNLJoinExpressionAnnotation onParseErrorReturn = null;
        Pattern number = Pattern.compile("\\d+\\.\\d+");
        Pattern stringNumber = Pattern.compile("\\w+\\s+\\d+\\.\\d+");
        Pattern lessThanOnePat = Pattern.compile("0\\.\\d+");
        try {
            switch (hintToken.hint) {
                case SINGLE_DATASET_PREDICATE_SELECTIVITY_HINT: {
                    if (hintToken.hintParams == null) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expected selectivity value");
                    }
                    double selectivity = 1.0;
                    Matcher mat = lessThanOnePat.matcher(hintToken.hintParams);
                    if (!mat.find()) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Selectivity has to be a decimal value greater than 0 and less than 1");
                    }
                    selectivity = Double.parseDouble(mat.group());
                    return new PredicateCardinalityAnnotation(selectivity);
                }
                case JOIN_PREDICATE_PRODUCTIVITY_HINT: {
                    Matcher numMat;
                    if (hintToken.hintParams == null) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expected productivity collection name and value");
                    }
                    double productivity = 1.0;
                    String leftSideDataSet = null;
                    Matcher StringNum = stringNumber.matcher(hintToken.hintParams);
                    if (StringNum.find()) {
                        String matchedGroup = StringNum.group();
                        Pattern var = Pattern.compile("[a-zA-Z]\\w*");
                        Matcher matVar = var.matcher(matchedGroup);
                        if (!matVar.find()) {
                            throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expected productivity collection name");
                        }
                        leftSideDataSet = matVar.group();
                        numMat = number.matcher(matchedGroup);
                        if (!numMat.find()) {
                            throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Productivity has to be a decimal value greater than 0");
                        }
                    } else {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Invalid format for productivity values");
                    }
                    productivity = Double.parseDouble(numMat.group());
                    return new JoinProductivityAnnotation(productivity, leftSideDataSet);
                }
                case HASH_BROADCAST_JOIN_HINT: {
                    if (hintToken.hintParams == null) {
                        return new BroadcastExpressionAnnotation(BroadcastExpressionAnnotation.BroadcastSide.RIGHT);
                    }
                    String name = SQLPPParser.parseBroadcastJoinParams(hintToken.hintParams);
                    return new BroadcastExpressionAnnotation(name);
                }
                case HASH_JOIN_HINT: {
                    if (hintToken.hintParams == null) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expected hash join build/probe collection name");
                    }
                    Pair<HashJoinExpressionAnnotation.BuildOrProbe, String> pair = SQLPPParser.parseHashJoinParams(hintToken.hintParams);
                    return new HashJoinExpressionAnnotation(pair);
                }
                case INDEXED_NESTED_LOOP_JOIN_HINT: {
                    if (hintToken.hintParams == null) {
                        return IndexedNLJoinExpressionAnnotation.INSTANCE_ANY_INDEX;
                    }
                    onParseErrorReturn = IndexedNLJoinExpressionAnnotation.INSTANCE_ANY_INDEX;
                    List<String> indexNames = SQLPPParser.parseParenthesizedIdentifierList(hintToken.hintParams);
                    return IndexedNLJoinExpressionAnnotation.newInstance(indexNames);
                }
                case RANGE_HINT: {
                    Expression rangeExpr = SQLPPParser.parseExpression(hintToken.hintParams);
                    RangeMap rangeMap = RangeMapBuilder.parseHint((Expression)rangeExpr);
                    return new RangeAnnotation(rangeMap);
                }
                case SKIP_SECONDARY_INDEX_SEARCH_HINT: {
                    if (hintToken.hintParams == null) {
                        return SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE_ANY_INDEX;
                    }
                    List<String> indexNames = SQLPPParser.parseParenthesizedIdentifierList(hintToken.hintParams);
                    return SkipSecondaryIndexSearchExpressionAnnotation.newInstance(indexNames);
                }
                case SPATIAL_JOIN_HINT: {
                    Literal lit;
                    int i;
                    List<Literal> hintValues = SQLPPParser.parseParenthesizedLiteralList(hintToken.hintParams);
                    if (hintValues.size() != 6) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), String.format("Unexpected hint: %s. 6 arguments are required.", hintToken.hint.toString()));
                    }
                    for (i = 0; i < 4; ++i) {
                        lit = hintValues.get(i);
                        if (lit.getLiteralType() == Literal.Type.DOUBLE || lit.getLiteralType() == Literal.Type.FLOAT || lit.getLiteralType() == Literal.Type.LONG || lit.getLiteralType() == Literal.Type.INTEGER) continue;
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), String.format("Unexpected hint: %s. Numeric value is required for first 4 arguments.", hintToken.hint.toString()));
                    }
                    for (i = 4; i < 6; ++i) {
                        lit = hintValues.get(i);
                        if (lit.getLiteralType() == Literal.Type.LONG || lit.getLiteralType() == Literal.Type.INTEGER) continue;
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), String.format("Unexpected hint: %s. Long/int is required for last 2 arguments.", hintToken.hint.toString()));
                    }
                    try {
                        double minX = ExpressionUtils.getDoubleValue((Literal)hintValues.get(0));
                        double minY = ExpressionUtils.getDoubleValue((Literal)hintValues.get(1));
                        double maxX = ExpressionUtils.getDoubleValue((Literal)hintValues.get(2));
                        double maxY = ExpressionUtils.getDoubleValue((Literal)hintValues.get(3));
                        int numRows = (int)ExpressionUtils.getLongValue((Literal)hintValues.get(4));
                        int numColumns = (int)ExpressionUtils.getLongValue((Literal)hintValues.get(5));
                        SpatialJoinAnnotation spatialJoinAnn = new SpatialJoinAnnotation(minX, minY, maxX, maxY, numRows, numColumns);
                        return spatialJoinAnn;
                    }
                    catch (TypeMismatchException e) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), e.getMessage());
                    }
                }
                case USE_SECONDARY_INDEX_SEARCH_HINT: {
                    if (hintToken.hintParams == null) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expected index name(s)");
                    }
                    List<String> indexNames = SQLPPParser.parseParenthesizedIdentifierList(hintToken.hintParams);
                    return SecondaryIndexSearchPreferenceAnnotation.newInstance(indexNames);
                }
            }
            throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Unexpected hint");
        }
        catch (SqlppParseException e) {
            if (this.warningCollector.shouldWarn()) {
                this.warningCollector.warn(Warning.of((SourceLocation)SQLPPParser.getSourceLocation(hintToken), (IError)ErrorCode.INVALID_HINT, (Serializable[])new Serializable[]{hintToken.hint.toString(), e.getMessage()}));
            }
            return onParseErrorReturn;
        }
        catch (CompilationException e) {
            if (this.warningCollector.shouldWarn()) {
                this.warningCollector.warn(Warning.of((SourceLocation)SQLPPParser.getSourceLocation(hintToken), (IError)ErrorCode.INVALID_HINT, (Serializable[])new Serializable[]{hintToken.hint.toString(), e.getMessage()}));
            }
            return onParseErrorReturn;
        }
    }

    private void ensureNoTypeDeclsInFunction(String fnName, List<Pair<VarIdentifier, TypeExpression>> paramList, TypeExpression returnType, Token startToken) throws SqlppParseException {
        for (Pair<VarIdentifier, TypeExpression> p : paramList) {
            if (p.second == null) continue;
            String paramName = SqlppVariableUtil.toUserDefinedName(((VarIdentifier)p.first).getValue());
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startToken), "Unexpected type declaration for parameter " + paramName + " in function " + fnName);
        }
        if (returnType != null) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startToken), "Unexpected return type declaration for function " + fnName);
        }
    }

    private void ensureIntegerLiteral(LiteralExpr expr, String errorPrefix) throws SqlppParseException {
        Literal lit = expr.getValue();
        if (lit.getLiteralType() != Literal.Type.INTEGER && lit.getLiteralType() != Literal.Type.LONG) {
            throw new SqlppParseException(expr.getSourceLocation(), errorPrefix + " should be an INTEGER");
        }
    }

    private DataverseName createDataverseName(List<String> parts, int fromIndex, int toIndex, Token startToken) throws SqlppParseException {
        try {
            return DataverseName.create(parts, (int)fromIndex, (int)toIndex);
        }
        catch (AsterixException e) {
            SqlppParseException pe = new SqlppParseException(SQLPPParser.getSourceLocation(startToken), e.getMessage());
            pe.initCause(e);
            throw pe;
        }
    }

    public final List<Statement> Statement() throws ParseException, ParseException {
        this.scopeStack.push(RootScopeFactory.createRootScope((ScopeChecker)this));
        ArrayList<Statement> decls = new ArrayList<Statement>();
        Statement stmt = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 5: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 26: 
                case 28: 
                case 30: 
                case 33: 
                case 35: 
                case 39: 
                case 41: 
                case 43: 
                case 48: 
                case 61: 
                case 70: 
                case 71: 
                case 74: 
                case 75: 
                case 79: 
                case 80: 
                case 94: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 111: 
                case 116: 
                case 117: 
                case 118: 
                case 125: 
                case 126: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 142: 
                case 143: 
                case 153: 
                case 155: 
                case 158: 
                case 159: 
                case 160: 
                case 167: 
                case 168: 
                case 169: 
                case 179: 
                case 180: 
                case 181: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 5: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 26: 
                case 28: 
                case 30: 
                case 33: 
                case 35: 
                case 39: 
                case 41: 
                case 43: 
                case 48: 
                case 61: 
                case 70: 
                case 71: 
                case 74: 
                case 75: 
                case 79: 
                case 80: 
                case 94: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 111: 
                case 116: 
                case 117: 
                case 118: 
                case 125: 
                case 126: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 142: 
                case 153: 
                case 155: 
                case 158: 
                case 159: 
                case 160: 
                case 167: 
                case 168: 
                case 169: 
                case 179: 
                case 180: 
                case 181: {
                    stmt = this.ExplainStatement();
                    decls.add(stmt);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            block10: while (true) {
                this.jj_consume_token(143);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 143: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
        }
        this.jj_consume_token(0);
        return decls;
    }

    public final Statement ExplainStatement() throws ParseException, ParseException {
        Statement stmt = null;
        Token explainToken = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                explainToken = this.token;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        stmt = this.SingleStatement();
        if (explainToken != null) {
            if (stmt.getKind() == Statement.Kind.QUERY) {
                ((Query)stmt).setExplain(true);
            } else {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(explainToken), "EXPLAIN is not supported for this kind of statement");
            }
        }
        return stmt;
    }

    public final Statement SingleStatement() throws ParseException, ParseException {
        DataverseDecl stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 118: {
                stmt = this.DataverseDeclaration();
                break;
            }
            case 26: {
                stmt = this.FunctionDeclaration();
                break;
            }
            case 17: {
                stmt = this.CreateStatement();
                break;
            }
            case 74: {
                stmt = this.LoadStatement();
                break;
            }
            case 33: {
                stmt = this.DropStatement();
                break;
            }
            case 126: {
                stmt = this.WriteStatement();
                break;
            }
            case 103: {
                stmt = this.SetStatement();
                break;
            }
            case 61: {
                stmt = this.InsertStatement();
                break;
            }
            case 28: {
                stmt = this.DeleteStatement();
                break;
            }
            case 116: {
                stmt = this.UpdateStatement();
                break;
            }
            case 117: {
                stmt = this.UpsertStatement();
                break;
            }
            case 21: 
            case 30: 
            case 105: 
            case 106: {
                stmt = this.ConnectionStatement();
                break;
            }
            case 20: {
                stmt = this.CompactStatement();
                break;
            }
            case 3: {
                stmt = this.AnalyzeStatement();
                break;
            }
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 48: 
            case 70: 
            case 71: 
            case 75: 
            case 79: 
            case 80: 
            case 102: 
            case 104: 
            case 111: 
            case 125: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                stmt = this.Query();
                break;
            }
            case 94: {
                stmt = this.RefreshExternalDatasetStatement();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final DataverseDecl DataverseDeclaration() throws ParseException, ParseException {
        Token startToken = null;
        DataverseName dvName = null;
        this.jj_consume_token(118);
        startToken = this.token;
        this.defaultDataverse = dvName = this.DataverseName();
        DataverseDecl dvDecl = new DataverseDecl(this.defaultDataverse);
        return SQLPPParser.addSourceLocation(dvDecl, startToken);
    }

    public final Statement CreateStatement() throws ParseException, ParseException {
        Token startToken = null;
        Statement stmt = null;
        this.jj_consume_token(17);
        startToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 84: {
                stmt = this.CreateOrReplaceStatement(startToken);
                break;
            }
            case 112: {
                stmt = this.CreateTypeStatement(startToken);
                break;
            }
            case 77: {
                stmt = this.CreateNodegroupStatement(startToken);
                break;
            }
            case 23: 
            case 24: 
            case 42: 
            case 62: {
                stmt = this.CreateDatasetStatement(startToken);
                break;
            }
            case 58: 
            case 92: {
                stmt = this.CreateIndexStatement(startToken);
                break;
            }
            case 25: {
                stmt = this.CreateDataverseStatement(startToken);
                break;
            }
            case 51: {
                stmt = this.CreateFunctionStatement(startToken, false);
                break;
            }
            case 1: {
                stmt = this.CreateAdapterStatement(startToken);
                break;
            }
            case 107: {
                stmt = this.CreateSynonymStatement(startToken);
                break;
            }
            case 44: {
                stmt = this.CreateFeedStatement(startToken);
                break;
            }
            case 59: {
                stmt = this.CreateFeedPolicyStatement(startToken);
                break;
            }
            case 50: {
                stmt = this.CreateFullTextStatement(startToken);
                break;
            }
            case 122: {
                stmt = this.CreateViewStatement(startToken, false);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final Statement CreateOrReplaceStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFunctionStatement stmt = null;
        Token replaceToken = null;
        this.jj_consume_token(84);
        this.jj_consume_token(167);
        replaceToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                stmt = this.CreateFunctionStatement(startStmtToken, true);
                break;
            }
            case 122: {
                stmt = this.CreateViewStatement(startStmtToken, true);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SQLPPParser.expectToken(replaceToken, REPLACE);
        return stmt;
    }

    public final TypeDecl CreateTypeStatement(Token startStmtToken) throws ParseException, ParseException {
        TypeDecl stmt = null;
        this.jj_consume_token(112);
        stmt = this.TypeSpecification(startStmtToken);
        return stmt;
    }

    public final TypeDecl TypeSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        RecordTypeDefinition typeExpr = null;
        nameComponents = this.TypeName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(7);
        typeExpr = this.RecordTypeDef();
        boolean dgen = false;
        long numValues = -1L;
        String filename = null;
        Token hintToken = this.fetchHint(startStmtToken, SqlppHint.DGEN_HINT);
        if (hintToken != null) {
            String[] splits;
            String hintParams = hintToken.hintParams;
            String[] stringArray = splits = hintParams != null ? hintParams.split("\\s+") : null;
            if (splits == null || splits.length != 2) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expecting /*+ dgen <filename> <numberOfItems> */");
            }
            dgen = true;
            filename = splits[0];
            numValues = Long.parseLong(splits[1]);
        }
        TypeDataGen tddg = new TypeDataGen(dgen, filename, numValues);
        TypeDecl stmt = new TypeDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, (TypeExpression)typeExpr, tddg, ifNotExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final NodegroupDecl CreateNodegroupStatement(Token startStmtToken) throws ParseException, ParseException {
        NodegroupDecl stmt = null;
        this.jj_consume_token(77);
        stmt = this.NodegroupSpecification(startStmtToken);
        return stmt;
    }

    public final NodegroupDecl NodegroupSpecification(Token startStmtToken) throws ParseException, ParseException {
        String name = null;
        String tmp = null;
        boolean ifNotExists = false;
        ArrayList<Identifier> ncNames = new ArrayList<Identifier>();
        name = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(82);
        tmp = this.Identifier();
        ncNames.add(new Identifier(tmp));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            tmp = this.Identifier();
            ncNames.add(new Identifier(tmp));
        }
        NodegroupDecl stmt = new NodegroupDecl(new Identifier(name), ncNames, ifNotExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final void Dataset() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DatasetToken() throws ParseException, ParseException {
        this.Dataset();
    }

    public final DatasetDecl CreateDatasetStatement(Token startStmtToken) throws ParseException, ParseException {
        DatasetDecl stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: 
            case 24: 
            case 62: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 62: {
                        this.jj_consume_token(62);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                this.Dataset();
                stmt = this.DatasetSpecification(startStmtToken);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                this.Dataset();
                stmt = this.ExternalDatasetSpecification(startStmtToken);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final DatasetDecl DatasetSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        TypeExpression typeExpr = null;
        TypeExpression metaTypeExpr = null;
        Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
        Map<Object, Object> hints = new HashMap();
        DatasetDecl stmt = null;
        boolean autogenerated = false;
        Pair<Integer, List<String>> filterField = null;
        RecordConstructor withRecord = null;
        nameComponents = this.QualifiedName();
        typeExpr = this.DatasetTypeSpecification();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 125: {
                this.jj_consume_token(125);
                String name = this.Identifier();
                if (!name.equalsIgnoreCase("meta")) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), "We can only support one additional associated field called \"meta\".");
                }
                metaTypeExpr = this.DatasetTypeSpecification();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        ifNotExists = this.IfNotExists();
        primaryKeyFields = this.PrimaryKey();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                autogenerated = true;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                hints = this.Properties();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (this.jj_2_1(2)) {
            this.jj_consume_token(125);
            this.jj_consume_token(45);
            this.jj_consume_token(82);
            filterField = this.NestedField();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 125: {
                this.jj_consume_token(125);
                withRecord = this.RecordConstructor();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        try {
            InternalDetailsDecl idd = new InternalDetailsDecl((List)primaryKeyFields.second, (List)primaryKeyFields.first, autogenerated, filterField == null ? null : (Integer)filterField.first, filterField == null ? null : (List)filterField.second);
            DatasetDeclParametersUtil.adjustInlineTypeDecl((TypeExpression)typeExpr, (List)((List)primaryKeyFields.second), (List)((List)primaryKeyFields.first), (boolean)false);
            if (metaTypeExpr != null) {
                DatasetDeclParametersUtil.adjustInlineTypeDecl((TypeExpression)metaTypeExpr, (List)((List)primaryKeyFields.second), (List)((List)primaryKeyFields.first), (boolean)true);
            }
            stmt = new DatasetDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, typeExpr, metaTypeExpr, hints, DatasetConfig.DatasetType.INTERNAL, (IDatasetDetailsDecl)idd, withRecord, ifNotExists);
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
    }

    public final DatasetDecl ExternalDatasetSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        TypeExpression typeExpr = null;
        boolean ifNotExists = false;
        String adapterName = null;
        Map<String, String> properties = null;
        Map<Object, Object> hints = new HashMap();
        DatasetDecl stmt = null;
        RecordConstructor withRecord = null;
        nameComponents = this.QualifiedName();
        typeExpr = this.DatasetTypeSpecification();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(119);
        adapterName = this.AdapterName();
        properties = this.Configuration();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                hints = this.Properties();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 125: {
                this.jj_consume_token(125);
                withRecord = this.RecordConstructor();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        ExternalDetailsDecl edd = new ExternalDetailsDecl();
        edd.setAdapter(adapterName);
        edd.setProperties(properties);
        try {
            stmt = new DatasetDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, typeExpr, null, hints, DatasetConfig.DatasetType.EXTERNAL, (IDatasetDetailsDecl)edd, withRecord, ifNotExists);
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
    }

    public final TypeExpression DatasetTypeSpecification() throws ParseException, ParseException {
        RecordTypeDefinition typeExpr = null;
        if (this.jj_2_2(3)) {
            typeExpr = this.DatasetRecordTypeSpecification(true);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: {
                    typeExpr = this.DatasetReferenceTypeSpecification();
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeExpr;
    }

    public final TypeExpression DatasetReferenceTypeSpecification() throws ParseException, ParseException {
        TypeReferenceExpression typeExpr = null;
        this.jj_consume_token(133);
        typeExpr = this.TypeReference();
        this.jj_consume_token(134);
        return typeExpr;
    }

    public final RecordTypeDefinition DatasetRecordTypeSpecification(boolean allowRecordKindModifier) throws ParseException, ParseException {
        RecordTypeDefinition recordTypeDef = null;
        RecordTypeDefinition.RecordKind recordKind = null;
        Token startToken = null;
        Token recordKindToken = null;
        this.jj_consume_token(133);
        startToken = this.token;
        recordTypeDef = this.DatasetRecordTypeDef();
        this.jj_consume_token(134);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 83: {
                recordKind = this.RecordTypeKind();
                recordKindToken = this.token;
                this.jj_consume_token(112);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        if (recordKind == null) {
            recordKind = RecordTypeDefinition.RecordKind.CLOSED;
        } else if (!allowRecordKindModifier) {
            throw SQLPPParser.createUnexpectedTokenError(recordKindToken);
        }
        recordTypeDef.setRecordKind(recordKind);
        return SQLPPParser.addSourceLocation(recordTypeDef, startToken);
    }

    public final RecordTypeDefinition DatasetRecordTypeDef() throws ParseException, ParseException {
        RecordTypeDefinition recType = new RecordTypeDefinition();
        this.DatasetRecordField(recType);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            this.DatasetRecordField(recType);
        }
        return recType;
    }

    public final void DatasetRecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
        TypeReferenceExpression type = null;
        boolean nullable = true;
        boolean missable = true;
        String fieldName = this.Identifier();
        type = this.TypeReference();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                this.jj_consume_token(114);
                nullable = false;
                missable = false;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        recType.addField(fieldName, (TypeExpression)type, nullable, missable);
    }

    public final RefreshExternalDatasetStatement RefreshExternalDatasetStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        Object datasetName = null;
        this.jj_consume_token(94);
        startToken = this.token;
        this.jj_consume_token(42);
        this.Dataset();
        nameComponents = this.QualifiedName();
        RefreshExternalDatasetStatement stmt = new RefreshExternalDatasetStatement();
        stmt.setDataverseName((DataverseName)nameComponents.first);
        stmt.setDatasetName((Identifier)nameComponents.second);
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final CreateIndexStatement CreateIndexStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateIndexStatement stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                stmt = this.IndexSpecification(startStmtToken);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                this.jj_consume_token(58);
                stmt = this.PrimaryIndexSpecification(startStmtToken);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final CreateIndexStatement IndexSpecification(Token startStmtToken) throws ParseException, ParseException {
        int gramLength;
        DatasetConfig.IndexType indexType;
        Pair<DataverseName, Identifier> nameComponents = null;
        String indexName = null;
        IndexParams indexParams = null;
        CreateIndexStatement.IndexedElement indexedElement = null;
        ArrayList<CreateIndexStatement.IndexedElement> indexedElementList = new ArrayList<CreateIndexStatement.IndexedElement>();
        boolean enforced = false;
        boolean ifNotExists = false;
        boolean hasUnnest = false;
        String fullTextConfigName = null;
        Token startElementToken = null;
        Boolean excludeUnknown = null;
        Boolean castDefaultNull = null;
        Map castConfig = null;
        indexName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(82);
        nameComponents = this.QualifiedName();
        this.jj_consume_token(133);
        startElementToken = this.token;
        indexedElement = this.IndexedElement(startElementToken);
        indexedElementList.add(indexedElement);
        hasUnnest |= indexedElement.hasUnnest();
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(139);
            startElementToken = this.token;
            indexedElement = this.IndexedElement(startElementToken);
            indexedElementList.add(indexedElement);
            hasUnnest |= indexedElement.hasUnnest();
        }
        this.jj_consume_token(134);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 112: {
                this.jj_consume_token(112);
                indexParams = this.IndexType();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                enforced = true;
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (this.laIdentifier(EXCLUDE) || this.laIdentifier(INCLUDE)) {
            this.jj_consume_token(167);
            if (this.isToken(EXCLUDE)) {
                excludeUnknown = true;
            } else if (this.isToken(INCLUDE)) {
                excludeUnknown = false;
            } else {
                throw this.createUnexpectedTokenError();
            }
            this.jj_consume_token(114);
            this.jj_consume_token(67);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.jj_consume_token(133);
                Pair<Map<String, String>, Boolean> castConfigDefaultNull = this.CastDefaultNull();
                this.jj_consume_token(134);
                castConfig = (Map)castConfigDefaultNull.first;
                castDefaultNull = (Boolean)castConfigDefaultNull.second;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        if (indexParams != null) {
            indexType = indexParams.type;
            gramLength = indexParams.gramLength;
            fullTextConfigName = indexParams.fullTextConfig;
        } else {
            indexType = hasUnnest ? DatasetConfig.IndexType.ARRAY : DatasetConfig.IndexType.BTREE;
            gramLength = -1;
            fullTextConfigName = null;
        }
        CreateIndexStatement stmt = new CreateIndexStatement((DataverseName)nameComponents.first, (Identifier)nameComponents.second, new Identifier(indexName), indexType, indexedElementList, enforced, gramLength, fullTextConfigName, ifNotExists, excludeUnknown, castDefaultNull, castConfig);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final CreateIndexStatement.IndexedElement IndexedElement(Token startElementToken) throws ParseException, ParseException {
        List projectList;
        List unnestList;
        int source;
        Triple<Integer, List<List<String>>, List<Pair<List<String>, IndexedTypeExpression>>> element = null;
        Pair<List<String>, IndexedTypeExpression> elementSimple = null;
        int elementSimpleSource = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 115: {
                element = this.IndexedElementUnnestSelect();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                if (this.jj_2_3(1)) {
                    if (!(this.laIdentifier(META) && this.laToken(2, 133) && this.laToken(3, 134))) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    this.jj_consume_token(167);
                    this.expectToken(META);
                    this.jj_consume_token(133);
                    this.jj_consume_token(134);
                    this.jj_consume_token(140);
                    elementSimple = this.IndexedField();
                    elementSimpleSource = 1;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 167: 
                    case 168: {
                        elementSimple = this.IndexedField();
                        break block0;
                    }
                    case 133: {
                        this.jj_consume_token(133);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 115: {
                                element = this.IndexedElementUnnestSelect();
                                break;
                            }
                            case 167: 
                            case 168: {
                                elementSimple = this.IndexedField();
                                break;
                            }
                            default: {
                                this.jj_la1[26] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(134);
                        break block0;
                    }
                }
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (elementSimple != null) {
            source = elementSimpleSource;
            unnestList = null;
            projectList = Collections.singletonList(elementSimple);
        } else {
            source = (Integer)element.first;
            unnestList = (List)element.second;
            projectList = (List)element.third;
        }
        CreateIndexStatement.IndexedElement ie = new CreateIndexStatement.IndexedElement(source, unnestList, projectList);
        ie.setSourceLocation(SQLPPParser.getSourceLocation(startElementToken));
        return ie;
    }

    public final Triple<Integer, List<List<String>>, List<Pair<List<String>, IndexedTypeExpression>>> IndexedElementUnnestSelect() throws ParseException, ParseException {
        int source = 0;
        Pair<List<List<String>>, List<Pair<List<String>, IndexedTypeExpression>>> element = null;
        this.jj_consume_token(115);
        if (this.jj_2_4(1)) {
            if (!(this.laIdentifier(META) && this.laToken(2, 133) && this.laToken(3, 134))) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(167);
            this.expectToken(META);
            this.jj_consume_token(133);
            this.jj_consume_token(134);
            this.jj_consume_token(140);
            element = this.IndexedElementUnnestSelectBody();
            source = 1;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 167: 
                case 168: {
                    element = this.IndexedElementUnnestSelectBody();
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return new Triple((Object)source, (Object)((List)element.first), (Object)((List)element.second));
    }

    public final Pair<List<List<String>>, List<Pair<List<String>, IndexedTypeExpression>>> IndexedElementUnnestSelectBody() throws ParseException, ParseException {
        Triple<List<String>, Token, Token> path = null;
        IndexedTypeExpression type = null;
        ArrayList<List> unnestList = new ArrayList<List>();
        ArrayList<Pair> projectList = new ArrayList<Pair>();
        path = this.MultipartIdentifier();
        unnestList.add((List)path.first);
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 115: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(115);
            path = this.MultipartIdentifier();
            unnestList.add((List)path.first);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 102: 
            case 138: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 138: {
                        this.jj_consume_token(138);
                        type = this.IndexedTypeExpr(false);
                        projectList.add(new Pair(null, (Object)type));
                        break block3;
                    }
                    case 102: {
                        this.jj_consume_token(102);
                        path = this.MultipartIdentifier();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                type = this.IndexedTypeExpr(false);
                                break;
                            }
                            default: {
                                this.jj_la1[31] = this.jj_gen;
                            }
                        }
                        projectList.add(new Pair((Object)((List)path.first), (Object)type));
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 139: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[32] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(139);
                            path = this.MultipartIdentifier();
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 138: {
                                    this.jj_consume_token(138);
                                    type = this.IndexedTypeExpr(false);
                                    break;
                                }
                                default: {
                                    this.jj_la1[33] = this.jj_gen;
                                }
                            }
                            projectList.add(new Pair((Object)((List)path.first), (Object)type));
                        }
                    }
                }
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        if (projectList.isEmpty()) {
            projectList.add(new Pair(null, null));
        }
        return new Pair(unnestList, projectList);
    }

    public final Pair<List<String>, IndexedTypeExpression> IndexedField() throws ParseException, ParseException {
        Triple<List<String>, Token, Token> path = null;
        IndexedTypeExpression type = null;
        path = this.MultipartIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                type = this.IndexedTypeExpr(true);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        return new Pair((Object)((List)path.first), (Object)type);
    }

    public final CreateIndexStatement PrimaryIndexSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        Object indexName = null;
        boolean ifNotExists = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: 
            case 168: {
                indexName = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(82);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 112: {
                this.jj_consume_token(112);
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        if (indexName == null) {
            indexName = "primary_idx_" + nameComponents.second;
        }
        CreateIndexStatement stmt = new CreateIndexStatement((DataverseName)nameComponents.first, (Identifier)nameComponents.second, new Identifier((String)indexName), DatasetConfig.IndexType.BTREE, Collections.emptyList(), false, -1, null, ifNotExists, null, null, Collections.emptyMap());
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final String FilterField() throws ParseException, ParseException {
        String filterField = null;
        filterField = this.Identifier();
        return filterField;
    }

    public final IndexParams IndexType() throws ParseException, ParseException {
        DatasetConfig.IndexType type = null;
        int gramLength = 0;
        String fullTextConfig = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                type = DatasetConfig.IndexType.BTREE;
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                type = DatasetConfig.IndexType.RTREE;
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX;
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                type = DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 119: {
                        this.jj_consume_token(119);
                        this.Identifier();
                        fullTextConfig = this.token.image;
                        break block0;
                    }
                }
                this.jj_la1[39] = this.jj_gen;
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                this.jj_consume_token(133);
                this.jj_consume_token(158);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                gramLength = Integer.valueOf(this.token.image);
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new IndexParams(type, gramLength, fullTextConfig);
    }

    public final CreateDataverseStatement CreateDataverseStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateDataverseStatement stmt = null;
        this.jj_consume_token(25);
        stmt = this.DataverseSpecification(startStmtToken);
        return stmt;
    }

    public final CreateDataverseStatement DataverseSpecification(Token startStmtToken) throws ParseException, ParseException {
        DataverseName dvName = null;
        boolean ifNotExists = false;
        dvName = this.DataverseName();
        ifNotExists = this.IfNotExists();
        CreateDataverseStatement stmt = new CreateDataverseStatement(dvName, null, ifNotExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final CreateAdapterStatement CreateAdapterStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateAdapterStatement stmt = null;
        this.jj_consume_token(1);
        stmt = this.AdapterSpecification(startStmtToken);
        return stmt;
    }

    public final CreateAdapterStatement AdapterSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> adapterName = null;
        Pair<DataverseName, Identifier> libraryName = null;
        List<String> externalIdentifier = null;
        boolean ifNotExists = false;
        adapterName = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(7);
        externalIdentifier = this.FunctionExternalIdentifier();
        this.jj_consume_token(9);
        libraryName = this.QualifiedName();
        CreateAdapterStatement stmt = new CreateAdapterStatement((DataverseName)adapterName.first, ((Identifier)adapterName.second).getValue(), (DataverseName)libraryName.first, ((Identifier)libraryName.second).getValue(), externalIdentifier, ifNotExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final CreateViewStatement CreateViewStatement(Token startStmtToken, boolean orReplace) throws ParseException, ParseException {
        CreateViewStatement stmt = null;
        this.jj_consume_token(122);
        stmt = this.ViewSpecification(startStmtToken, orReplace);
        return stmt;
    }

    public final CreateViewStatement ViewSpecification(Token startStmtToken, boolean orReplace) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        TypeExpression typeExpr = null;
        boolean ifNotExists = false;
        Token beginPos = null;
        Token endPos = null;
        Expression viewBodyExpr = null;
        Boolean defaultNull = null;
        Map viewConfig = null;
        Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
        Pair<List<Integer>, List<List<String>>> foreignKeyFields = null;
        Pair<DataverseName, Identifier> refNameComponents = null;
        ArrayList<CreateViewStatement.ForeignKeyDecl> foreignKeyDecls = null;
        DataverseName currentDataverse = this.defaultDataverse;
        nameComponents = this.QualifiedName();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                typeExpr = this.DatasetTypeSpecification();
                ifNotExists = this.IfNotExists();
                Pair<Map<String, String>, Boolean> viewConfigDefaultNull = this.CastDefaultNull();
                viewConfig = (Map)viewConfigDefaultNull.first;
                defaultNull = (Boolean)viewConfigDefaultNull.second;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 92: {
                        this.jj_consume_token(92);
                        this.jj_consume_token(67);
                        this.jj_consume_token(133);
                        primaryKeyFields = this.PrimaryKeyFields();
                        this.jj_consume_token(134);
                        this.jj_consume_token(79);
                        this.jj_consume_token(37);
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 167: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(167);
                    this.expectToken(FOREIGN);
                    this.jj_consume_token(67);
                    this.jj_consume_token(133);
                    foreignKeyFields = this.PrimaryKeyFields();
                    this.jj_consume_token(134);
                    this.jj_consume_token(167);
                    this.expectToken(REFERENCES);
                    refNameComponents = this.QualifiedName();
                    this.jj_consume_token(79);
                    this.jj_consume_token(37);
                    if (foreignKeyDecls == null) {
                        foreignKeyDecls = new ArrayList<CreateViewStatement.ForeignKeyDecl>();
                    }
                    foreignKeyDecls.add(new CreateViewStatement.ForeignKeyDecl((List)foreignKeyFields.second, (List)foreignKeyFields.first, (DataverseName)refNameComponents.first, (Identifier)refNameComponents.second));
                }
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                ifNotExists = this.IfNotExists();
            }
        }
        if (orReplace && ifNotExists) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), "Unexpected IF NOT EXISTS");
        }
        this.jj_consume_token(7);
        beginPos = this.token;
        this.createNewScope();
        if (nameComponents.first != null) {
            this.defaultDataverse = (DataverseName)nameComponents.first;
        }
        viewBodyExpr = this.ViewBody();
        endPos = this.token;
        String viewBody = this.extractFragment(beginPos.beginLine, beginPos.beginColumn + 1, endPos.endLine, endPos.endColumn + 1);
        this.removeCurrentScope();
        this.defaultDataverse = currentDataverse;
        if (typeExpr != null && primaryKeyFields != null) {
            DatasetDeclParametersUtil.adjustInlineTypeDecl((TypeExpression)typeExpr, (List)((List)primaryKeyFields.second), (List)((List)primaryKeyFields.first), (boolean)false);
        }
        CreateViewStatement.KeyDecl primaryKeyDecl = primaryKeyFields != null ? new CreateViewStatement.KeyDecl((List)primaryKeyFields.second, (List)primaryKeyFields.first) : null;
        CreateViewStatement stmt = new CreateViewStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), typeExpr, viewBody, viewBodyExpr, defaultNull, viewConfig, primaryKeyDecl, foreignKeyDecls, orReplace, ifNotExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final Expression ViewBody() throws ParseException, ParseException {
        Object viewBodyExpr = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: 
            case 168: {
                viewBodyExpr = this.VariableRef();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 140: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block0;
                        }
                    }
                    viewBodyExpr = this.FieldAccessor((Expression)viewBodyExpr);
                }
            }
            case 48: 
            case 70: 
            case 71: 
            case 102: 
            case 125: {
                viewBodyExpr = this.SelectExpression(true);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return viewBodyExpr;
    }

    public final Pair<Map<String, String>, Boolean> CastDefaultNull() throws ParseException, ParseException {
        HashMap<String, String> castConfig = null;
        Boolean defaultNull = null;
        String propertyName = null;
        String propertyValue = null;
        this.jj_consume_token(167);
        this.expectToken(DEFAULT);
        this.jj_consume_token(80);
        defaultNull = true;
        while (this.jj_2_5(2)) {
            this.jj_consume_token(167);
            propertyName = this.token.image.toLowerCase();
            propertyValue = this.StringLiteral();
            if (castConfig == null) {
                castConfig = new HashMap<String, String>();
            }
            castConfig.put(propertyName, propertyValue);
        }
        return new Pair(castConfig, (Object)defaultNull);
    }

    public final CreateFunctionStatement CreateFunctionStatement(Token startStmtToken, boolean orReplace) throws ParseException, ParseException {
        CreateFunctionStatement stmt = null;
        this.jj_consume_token(51);
        stmt = this.FunctionSpecification(startStmtToken, orReplace);
        return stmt;
    }

    public final CreateFunctionStatement FunctionSpecification(Token startStmtToken, boolean orReplace) throws ParseException, ParseException {
        FunctionSignature signature = null;
        FunctionName fctName = null;
        Pair<Integer, List<Pair<VarIdentifier, TypeExpression>>> paramsWithArity = null;
        List params = null;
        int arity = 0;
        TypeExpression returnType = null;
        Token beginPos = null;
        Token endPos = null;
        Expression functionBodyExpr = null;
        Pair<DataverseName, Identifier> libraryName = null;
        List<String> externalIdentifier = null;
        RecordConstructor withOptions = null;
        boolean ifNotExists = false;
        CreateFunctionStatement stmt = null;
        DataverseName currentDataverse = this.defaultDataverse;
        fctName = this.FunctionName();
        this.defaultDataverse = fctName.dataverse;
        paramsWithArity = this.FunctionParameters();
        arity = (Integer)paramsWithArity.first;
        params = (List)paramsWithArity.second;
        signature = new FunctionSignature(fctName.dataverse, fctName.function, arity);
        ifNotExists = this.IfNotExists();
        if (orReplace && ifNotExists) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Unexpected IF NOT EXISTS");
        }
        returnType = this.FunctionReturnType();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 153: {
                this.jj_consume_token(153);
                beginPos = this.token;
                this.createNewScope();
                functionBodyExpr = this.FunctionBody();
                this.jj_consume_token(154);
                endPos = this.token;
                String functionBody = this.extractFragment(beginPos.beginLine, beginPos.beginColumn, endPos.beginLine, endPos.beginColumn);
                this.getCurrentScope().addFunctionDescriptor(signature, false);
                this.removeCurrentScope();
                this.ensureNoTypeDeclsInFunction(fctName.function, params, returnType, startStmtToken);
                stmt = new CreateFunctionStatement(signature, params, functionBody, functionBodyExpr, orReplace, ifNotExists);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                externalIdentifier = this.FunctionExternalIdentifier();
                this.jj_consume_token(9);
                libraryName = this.QualifiedName();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 125: {
                        this.jj_consume_token(125);
                        withOptions = this.RecordConstructor();
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                try {
                    stmt = new CreateFunctionStatement(signature, params, returnType, (DataverseName)libraryName.first, ((Identifier)libraryName.second).getValue(), externalIdentifier, withOptions, orReplace, ifNotExists);
                    break;
                }
                catch (AlgebricksException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
                }
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.defaultDataverse = currentDataverse;
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final Pair<Integer, List<Pair<VarIdentifier, TypeExpression>>> FunctionParameters() throws ParseException {
        Pair params = null;
        this.jj_consume_token(133);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 140: 
            case 167: 
            case 168: {
                params = this.FunctionParameterList();
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
        if (params == null) {
            params = new Pair((Object)0, Collections.emptyList());
        }
        return params;
    }

    public final Pair<Integer, List<Pair<VarIdentifier, TypeExpression>>> FunctionParameterList() throws ParseException {
        List<Object> paramList = null;
        Pair<VarIdentifier, TypeExpression> param = null;
        int arity = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 140: {
                this.jj_consume_token(140);
                this.jj_consume_token(140);
                this.jj_consume_token(140);
                param = new Pair<VarIdentifier, TypeExpression>((Object)SqlppVariableUtil.toInternalVariableIdentifier(UDF_VARARGS_PARAM_NAME), null);
                paramList = Collections.singletonList(param);
                arity = -1;
                break;
            }
            case 167: 
            case 168: {
                param = this.FunctionParameter();
                paramList = new ArrayList<Pair<VarIdentifier, TypeExpression>>();
                paramList.add(param);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(139);
                    param = this.FunctionParameter();
                    paramList.add(param);
                }
                arity = paramList.size();
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Pair((Object)arity, paramList);
    }

    public final Pair<VarIdentifier, TypeExpression> FunctionParameter() throws ParseException, ParseException {
        String name = null;
        TypeExpression type = null;
        name = this.VariableIdentifier();
        if (this.jj_2_6(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 138: {
                    this.jj_consume_token(138);
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                }
            }
            type = this.TypeExpr(false);
        }
        return new Pair((Object)new VarIdentifier(name), type);
    }

    public final TypeExpression FunctionReturnType() throws ParseException, ParseException {
        TypeExpression returnType = null;
        if (this.laIdentifier(RETURNS)) {
            this.jj_consume_token(167);
            returnType = this.TypeExpr(false);
        }
        return returnType;
    }

    public final Expression FunctionBody() throws ParseException, ParseException {
        Object functionBodyExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: 
            case 70: 
            case 71: 
            case 102: 
            case 125: {
                functionBodyExpr = this.SelectExpression(true);
                break;
            }
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                functionBodyExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return functionBodyExpr;
    }

    public final List<String> FunctionExternalIdentifier() throws ParseException, ParseException {
        String ident = null;
        ArrayList<String> identList = new ArrayList<String>(2);
        ident = this.StringLiteral();
        identList.add(ident.trim());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            ident = this.StringLiteral();
            identList.add(ident.trim());
        }
        return identList;
    }

    public final CreateFeedStatement CreateFeedStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFeedStatement stmt = null;
        this.jj_consume_token(44);
        stmt = this.FeedSpecification(startStmtToken);
        return stmt;
    }

    public final CreateFeedStatement FeedSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        Object adapterName = null;
        Object properties = null;
        CreateFeedStatement stmt = null;
        Object sourceNameComponents = null;
        RecordConstructor withRecord = null;
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(125);
        withRecord = this.RecordConstructor();
        try {
            stmt = new CreateFeedStatement(nameComponents, withRecord, ifNotExists);
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        catch (AlgebricksException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
    }

    public final CreateFeedPolicyStatement CreateFeedPolicyStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFeedPolicyStatement stmt = null;
        this.jj_consume_token(59);
        this.jj_consume_token(90);
        stmt = this.FeedPolicySpecification(startStmtToken);
        return stmt;
    }

    public final CreateFeedPolicyStatement FeedPolicySpecification(Token startStmtToken) throws ParseException, ParseException {
        String policyName = null;
        String basePolicyName = null;
        String sourcePolicyFile = null;
        String definition = null;
        boolean ifNotExists = false;
        Map<String, String> properties = null;
        CreateFeedPolicyStatement stmt = null;
        policyName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(48);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                basePolicyName = this.Identifier();
                properties = this.Configuration();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        definition = this.ConstantString();
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                    }
                }
                stmt = new CreateFeedPolicyStatement(policyName, basePolicyName, properties, definition, ifNotExists);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                sourcePolicyFile = this.ConstantString();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        definition = this.ConstantString();
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                    }
                }
                stmt = new CreateFeedPolicyStatement(policyName, sourcePolicyFile, definition, ifNotExists);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final Statement CreateFullTextStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFullTextFilterStatement stmt = null;
        this.jj_consume_token(50);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                stmt = this.CreateFullTextFilterSpec(startStmtToken);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                this.expectToken(CONFIG);
                stmt = this.CreateFullTextConfigSpec(startStmtToken);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final CreateFullTextFilterStatement CreateFullTextFilterSpec(Token startStmtToken) throws ParseException, ParseException {
        CreateFullTextFilterStatement stmt = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        RecordConstructor expr = null;
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(7);
        expr = this.RecordConstructor();
        try {
            stmt = new CreateFullTextFilterStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), ifNotExists, expr);
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
    }

    public final CreateFullTextConfigStatement CreateFullTextConfigSpec(Token startStmtToken) throws ParseException, ParseException {
        CreateFullTextConfigStatement stmt = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        RecordConstructor expr = null;
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(7);
        expr = this.RecordConstructor();
        try {
            stmt = new CreateFullTextConfigStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), ifNotExists, expr);
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
    }

    public final CreateSynonymStatement CreateSynonymStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateSynonymStatement stmt = null;
        this.jj_consume_token(107);
        stmt = this.SynonymSpecification(startStmtToken);
        return stmt;
    }

    public final CreateSynonymStatement SynonymSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        Pair<DataverseName, Identifier> objectNameComponents = null;
        boolean ifNotExists = false;
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(47);
        objectNameComponents = this.QualifiedName();
        CreateSynonymStatement stmt = new CreateSynonymStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), (DataverseName)objectNameComponents.first, ((Identifier)objectNameComponents.second).getValue(), ifNotExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final boolean IfNotExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(79);
                this.jj_consume_token(41);
                return true;
            }
        }
        this.jj_la1[58] = this.jj_gen;
        return false;
    }

    public final void ApplyFunction(List<FunctionSignature> funcSigs) throws ParseException, ParseException {
        FunctionName functionName = null;
        String fqFunctionName = null;
        this.jj_consume_token(6);
        this.jj_consume_token(51);
        functionName = this.FunctionName();
        fqFunctionName = functionName.library == null ? functionName.function : functionName.library + "#" + functionName.function;
        funcSigs.add(new FunctionSignature(functionName.dataverse, fqFunctionName, 1));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            functionName = this.FunctionName();
            fqFunctionName = functionName.library == null ? functionName.function : functionName.library + "#" + functionName.function;
            funcSigs.add(new FunctionSignature(functionName.dataverse, fqFunctionName, 1));
        }
    }

    public final String GetPolicy() throws ParseException, ParseException {
        String policy = null;
        this.jj_consume_token(119);
        this.jj_consume_token(90);
        policy = this.Identifier();
        return policy;
    }

    public final FunctionSignature FunctionSignature() throws ParseException, ParseException {
        FunctionName fctName = null;
        Pair<Integer, List<Pair<VarIdentifier, TypeExpression>>> params = null;
        int arity = 0;
        fctName = this.FunctionName();
        if (this.jj_2_7(2)) {
            params = this.FunctionParameters();
            arity = (Integer)params.first;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: {
                    this.jj_consume_token(133);
                    arity = this.FunctionArity();
                    this.jj_consume_token(134);
                    break;
                }
                case 137: {
                    this.jj_consume_token(137);
                    arity = this.FunctionArity();
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return new FunctionSignature(fctName.dataverse, fctName.function, arity);
    }

    public final int FunctionArity() throws ParseException, ParseException {
        int arity;
        this.jj_consume_token(158);
        try {
            arity = Integer.parseInt(this.token.image);
        }
        catch (NumberFormatException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Invalid arity: " + this.token.image);
        }
        if (arity < 0 && arity != -1) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Invalid arity: " + arity);
        }
        return arity;
    }

    public final Pair<List<Integer>, List<List<String>>> PrimaryKey() throws ParseException, ParseException {
        Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
        this.jj_consume_token(92);
        this.jj_consume_token(67);
        primaryKeyFields = this.PrimaryKeyFields();
        return primaryKeyFields;
    }

    public final Pair<List<Integer>, List<List<String>>> PrimaryKeyFields() throws ParseException, ParseException {
        Pair<Integer, List<String>> tmp = null;
        ArrayList<Integer> keyFieldSourceIndicators = new ArrayList<Integer>();
        ArrayList<List> primaryKeyFields = new ArrayList<List>();
        tmp = this.NestedField();
        keyFieldSourceIndicators.add((Integer)tmp.first);
        primaryKeyFields.add((List)tmp.second);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            tmp = this.NestedField();
            keyFieldSourceIndicators.add((Integer)tmp.first);
            primaryKeyFields.add((List)tmp.second);
        }
        return new Pair(keyFieldSourceIndicators, primaryKeyFields);
    }

    public final Statement DropStatement() throws ParseException, ParseException {
        Token startToken = null;
        DropDatasetStatement stmt = null;
        this.jj_consume_token(33);
        startToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: 
            case 24: {
                stmt = this.DropDatasetStatement(startToken);
                break;
            }
            case 58: {
                stmt = this.DropIndexStatement(startToken);
                break;
            }
            case 77: {
                stmt = this.DropNodeGroupStatement(startToken);
                break;
            }
            case 112: {
                stmt = this.DropTypeStatement(startToken);
                break;
            }
            case 25: {
                stmt = this.DropDataverseStatement(startToken);
                break;
            }
            case 1: {
                stmt = this.DropAdapterStatement(startToken);
                break;
            }
            case 51: {
                stmt = this.DropFunctionStatement(startToken);
                break;
            }
            case 44: {
                stmt = this.DropFeedStatement(startToken);
                break;
            }
            case 59: {
                stmt = this.DropFeedPolicyStatement(startToken);
                break;
            }
            case 107: {
                stmt = this.DropSynonymStatement(startToken);
                break;
            }
            case 50: {
                stmt = this.DropFullTextStatement(startToken);
                break;
            }
            case 122: {
                stmt = this.DropViewStatement(startToken);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final DropDatasetStatement DropDatasetStatement(Token startStmtToken) throws ParseException, ParseException {
        DropDatasetStatement stmt = null;
        this.Dataset();
        stmt = this.DropDatasetSpecification(startStmtToken);
        return stmt;
    }

    public final DropDatasetStatement DropDatasetSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        DropDatasetStatement stmt = new DropDatasetStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final ViewDropStatement DropViewStatement(Token startStmtToken) throws ParseException, ParseException {
        ViewDropStatement stmt = null;
        this.jj_consume_token(122);
        stmt = this.DropViewSpecification(startStmtToken);
        return stmt;
    }

    public final ViewDropStatement DropViewSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        ViewDropStatement stmt = new ViewDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final IndexDropStatement DropIndexStatement(Token startStmtToken) throws ParseException, ParseException {
        IndexDropStatement stmt = null;
        this.jj_consume_token(58);
        stmt = this.DropIndexSpecification(startStmtToken);
        return stmt;
    }

    public final IndexDropStatement DropIndexSpecification(Token startStmtToken) throws ParseException, ParseException {
        Triple<DataverseName, Identifier, Identifier> tripleId = null;
        boolean ifExists = false;
        tripleId = this.DoubleQualifiedName();
        ifExists = this.IfExists();
        IndexDropStatement stmt = new IndexDropStatement((DataverseName)tripleId.first, (Identifier)tripleId.second, (Identifier)tripleId.third, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final Statement DropFullTextStatement(Token startStmtToken) throws ParseException, ParseException {
        FullTextFilterDropStatement stmt = null;
        this.jj_consume_token(50);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                stmt = this.DropFullTextFilterSpec(startStmtToken);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                this.expectToken(CONFIG);
                stmt = this.DropFullTextConfigSpec(startStmtToken);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final FullTextFilterDropStatement DropFullTextFilterSpec(Token startStmtToken) throws ParseException, ParseException {
        FullTextFilterDropStatement stmt = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifExists = false;
        nameComponents = this.QualifiedName();
        ifExists = this.IfExists();
        stmt = new FullTextFilterDropStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final FullTextConfigDropStatement DropFullTextConfigSpec(Token startStmtToken) throws ParseException, ParseException {
        FullTextConfigDropStatement stmt = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifExists = false;
        nameComponents = this.QualifiedName();
        ifExists = this.IfExists();
        stmt = new FullTextConfigDropStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final NodeGroupDropStatement DropNodeGroupStatement(Token startStmtToken) throws ParseException, ParseException {
        NodeGroupDropStatement stmt = null;
        this.jj_consume_token(77);
        stmt = this.DropNodeGroupSpecification(startStmtToken);
        return stmt;
    }

    public final NodeGroupDropStatement DropNodeGroupSpecification(Token startStmtToken) throws ParseException, ParseException {
        String id = null;
        boolean ifExists = false;
        id = this.Identifier();
        ifExists = this.IfExists();
        NodeGroupDropStatement stmt = new NodeGroupDropStatement(new Identifier(id), ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final TypeDropStatement DropTypeStatement(Token startStmtToken) throws ParseException, ParseException {
        TypeDropStatement stmt = null;
        this.jj_consume_token(112);
        stmt = this.DropTypeSpecification(startStmtToken);
        return stmt;
    }

    public final TypeDropStatement DropTypeSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.TypeName();
        ifExists = this.IfExists();
        TypeDropStatement stmt = new TypeDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final DataverseDropStatement DropDataverseStatement(Token startStmtToken) throws ParseException, ParseException {
        DataverseDropStatement stmt = null;
        this.jj_consume_token(25);
        stmt = this.DropDataverseSpecification(startStmtToken);
        return stmt;
    }

    public final DataverseDropStatement DropDataverseSpecification(Token startStmtToken) throws ParseException, ParseException {
        DataverseName dvName = null;
        boolean ifExists = false;
        dvName = this.DataverseName();
        ifExists = this.IfExists();
        DataverseDropStatement stmt = new DataverseDropStatement(dvName, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final AdapterDropStatement DropAdapterStatement(Token startStmtToken) throws ParseException, ParseException {
        AdapterDropStatement stmt = null;
        this.jj_consume_token(1);
        stmt = this.DropAdapterSpecification(startStmtToken);
        return stmt;
    }

    public final AdapterDropStatement DropAdapterSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> adapterName = null;
        boolean ifExists = false;
        adapterName = this.QualifiedName();
        ifExists = this.IfExists();
        AdapterDropStatement stmt = new AdapterDropStatement((DataverseName)adapterName.first, ((Identifier)adapterName.second).getValue(), ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final FunctionDropStatement DropFunctionStatement(Token startStmtToken) throws ParseException, ParseException {
        FunctionDropStatement stmt = null;
        this.jj_consume_token(51);
        stmt = this.DropFunctionSpecification(startStmtToken);
        return stmt;
    }

    public final FunctionDropStatement DropFunctionSpecification(Token startStmtToken) throws ParseException, ParseException {
        FunctionSignature funcSig = null;
        boolean ifExists = false;
        funcSig = this.FunctionSignature();
        ifExists = this.IfExists();
        FunctionDropStatement stmt = new FunctionDropStatement(funcSig, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final FeedDropStatement DropFeedStatement(Token startStmtToken) throws ParseException, ParseException {
        FeedDropStatement stmt = null;
        this.jj_consume_token(44);
        stmt = this.DropFeedSpecification(startStmtToken);
        return stmt;
    }

    public final FeedDropStatement DropFeedSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        FeedDropStatement stmt = new FeedDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final FeedPolicyDropStatement DropFeedPolicyStatement(Token startStmtToken) throws ParseException, ParseException {
        FeedPolicyDropStatement stmt = null;
        this.jj_consume_token(59);
        this.jj_consume_token(90);
        stmt = this.DropFeedPolicySpecification(startStmtToken);
        return stmt;
    }

    public final FeedPolicyDropStatement DropFeedPolicySpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        FeedPolicyDropStatement stmt = new FeedPolicyDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final SynonymDropStatement DropSynonymStatement(Token startStmtToken) throws ParseException, ParseException {
        SynonymDropStatement stmt = null;
        this.jj_consume_token(107);
        stmt = this.DropSynonymSpecification(startStmtToken);
        return stmt;
    }

    public final SynonymDropStatement DropSynonymSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        SynonymDropStatement stmt = new SynonymDropStatement((DataverseName)pairId.first, ((Identifier)pairId.second).getValue(), ifExists);
        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final boolean IfExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(41);
                return true;
            }
        }
        this.jj_la1[64] = this.jj_gen;
        return false;
    }

    public final InsertStatement InsertStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        VariableExpr var = null;
        Query query = null;
        Expression returnExpression = null;
        this.jj_consume_token(61);
        startToken = this.token;
        this.jj_consume_token(56);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        query = this.Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        if (var == null && returnExpression != null) {
            var = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue()));
            SQLPPParser.addSourceLocation(var, startToken);
        }
        query.setTopLevel(true);
        InsertStatement stmt = new InsertStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), query, this.getVarCounter(), var, returnExpression);
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final UpsertStatement UpsertStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        VariableExpr var = null;
        Query query = null;
        Expression returnExpression = null;
        this.jj_consume_token(117);
        startToken = this.token;
        this.jj_consume_token(56);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        query = this.Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        if (var == null && returnExpression != null) {
            var = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue()));
            SQLPPParser.addSourceLocation(var, startToken);
        }
        query.setTopLevel(true);
        UpsertStatement stmt = new UpsertStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), query, this.getVarCounter(), var, returnExpression);
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final DeleteStatement DeleteStatement() throws ParseException, ParseException {
        Token startToken = null;
        VariableExpr var = null;
        Expression condition = null;
        this.jj_consume_token(28);
        startToken = this.token;
        this.jj_consume_token(48);
        Pair<DataverseName, Identifier> nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 167: 
            case 168: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[69] = this.jj_gen;
                    }
                }
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                condition = this.Expression();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
            }
        }
        if (var == null) {
            var = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue()));
            SQLPPParser.addSourceLocation(var, startToken);
        }
        DeleteStatement stmt = new DeleteStatement(var, (DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), condition, this.getVarCounter());
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final UpdateStatement UpdateStatement() throws ParseException, ParseException {
        Token startToken = null;
        ArrayList<UpdateClause> ucs = new ArrayList<UpdateClause>();
        this.jj_consume_token(116);
        startToken = this.token;
        VariableExpr vars = this.Variable();
        this.jj_consume_token(57);
        Expression target = this.Expression();
        this.jj_consume_token(124);
        Expression condition = this.Expression();
        this.jj_consume_token(133);
        UpdateClause uc = this.UpdateClause();
        ucs.add(uc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            uc = this.UpdateClause();
            ucs.add(uc);
        }
        this.jj_consume_token(134);
        UpdateStatement stmt = new UpdateStatement(vars, target, condition, ucs);
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final UpdateClause UpdateClause() throws ParseException, ParseException {
        Expression target = null;
        Expression value = null;
        InsertStatement is = null;
        DeleteStatement ds = null;
        UpdateStatement us = null;
        Expression condition = null;
        UpdateClause ifbranch = null;
        UpdateClause elsebranch = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                target = this.Expression();
                this.jj_consume_token(149);
                value = this.Expression();
                break;
            }
            case 61: {
                is = this.InsertStatement();
                break;
            }
            case 28: {
                ds = this.DeleteStatement();
                break;
            }
            case 116: {
                us = this.UpdateStatement();
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(133);
                condition = this.Expression();
                this.jj_consume_token(134);
                this.jj_consume_token(109);
                ifbranch = this.UpdateClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        elsebranch = this.UpdateClause();
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                    }
                }
                return new UpdateClause(target, value, is, ds, us, condition, ifbranch, elsebranch);
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement SetStatement() throws ParseException, ParseException {
        Token startToken = null;
        String pn = null;
        String pv = null;
        this.jj_consume_token(103);
        startToken = this.token;
        pn = this.Identifier();
        pv = this.ConstantString();
        SetStatement stmt = new SetStatement(pn, pv);
        return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final Statement WriteStatement() throws ParseException, ParseException {
        Token startToken = null;
        String nodeName = null;
        String fileName = null;
        String writerClass = null;
        Object nameComponents = null;
        this.jj_consume_token(126);
        startToken = this.token;
        this.jj_consume_token(87);
        this.jj_consume_token(110);
        nodeName = this.Identifier();
        this.jj_consume_token(138);
        fileName = this.ConstantString();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 119: {
                this.jj_consume_token(119);
                writerClass = this.ConstantString();
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
            }
        }
        WriteStatement stmt = new WriteStatement(new Identifier(nodeName), fileName, writerClass);
        return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final LoadStatement LoadStatement() throws ParseException, ParseException {
        Token startToken = null;
        DataverseName dataverseName = null;
        Identifier datasetName = null;
        boolean alreadySorted = false;
        Pair<DataverseName, Identifier> nameComponents = null;
        this.jj_consume_token(74);
        startToken = this.token;
        this.Dataset();
        nameComponents = this.QualifiedName();
        dataverseName = (DataverseName)nameComponents.first;
        datasetName = (Identifier)nameComponents.second;
        this.jj_consume_token(119);
        String adapterName = this.AdapterName();
        Map<String, String> properties = this.Configuration();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                alreadySorted = true;
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        LoadStatement stmt = new LoadStatement(dataverseName, datasetName.getValue(), adapterName, properties, alreadySorted);
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final String AdapterName() throws ParseException, ParseException {
        String adapterName = null;
        adapterName = this.Identifier();
        return adapterName;
    }

    public final Statement AnalyzeStatement() throws ParseException, ParseException {
        Token startToken = null;
        Statement stmt = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        this.jj_consume_token(3);
        startToken = this.token;
        this.DatasetToken();
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                stmt = this.AnalyzeDatasetDropStatement(startToken, (DataverseName)nameComponents.first, (Identifier)nameComponents.second);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
                stmt = this.AnalyzeDatasetStatement(startToken, (DataverseName)nameComponents.first, (Identifier)nameComponents.second);
            }
        }
        return stmt;
    }

    public final Statement AnalyzeDatasetStatement(Token startToken, DataverseName dvName, Identifier identifier) throws ParseException, ParseException {
        RecordConstructor withRecord = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 125: {
                this.jj_consume_token(125);
                withRecord = this.RecordConstructor();
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        try {
            AnalyzeStatement stmt = new AnalyzeStatement(dvName, identifier.getValue(), withRecord);
            return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startToken), e.getMessage());
        }
    }

    public final Statement AnalyzeDatasetDropStatement(Token startToken, DataverseName dvName, Identifier identifier) throws ParseException, ParseException {
        this.jj_consume_token(33);
        this.jj_consume_token(167);
        this.expectToken(STATISTICS);
        AnalyzeDropStatement stmt = new AnalyzeDropStatement(dvName, identifier.getValue());
        return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final Statement CompactStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        this.jj_consume_token(20);
        startToken = this.token;
        this.Dataset();
        nameComponents = this.QualifiedName();
        CompactStatement stmt = new CompactStatement((DataverseName)nameComponents.first, (Identifier)nameComponents.second);
        return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final Statement ConnectionStatement() throws ParseException, ParseException {
        Token startToken = null;
        AbstractStatement stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                startToken = this.token;
                stmt = this.ConnectStatement(startToken);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                startToken = this.token;
                stmt = this.DisconnectStatement(startToken);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                startToken = this.token;
                stmt = this.StartStatement(startToken);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                startToken = this.token;
                stmt = this.StopStatement(startToken);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final Statement StartStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        StartFeedStatement stmt = null;
        this.jj_consume_token(44);
        feedNameComponents = this.QualifiedName();
        stmt = new StartFeedStatement(feedNameComponents);
        return (Statement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final AbstractStatement StopStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        StopFeedStatement stmt = null;
        this.jj_consume_token(44);
        feedNameComponents = this.QualifiedName();
        stmt = new StopFeedStatement(feedNameComponents);
        return (AbstractStatement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final AbstractStatement DisconnectStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        Pair<DataverseName, Identifier> datasetNameComponents = null;
        DisconnectFeedStatement stmt = null;
        this.jj_consume_token(44);
        feedNameComponents = this.QualifiedName();
        this.jj_consume_token(48);
        this.Dataset();
        datasetNameComponents = this.QualifiedName();
        stmt = new DisconnectFeedStatement(feedNameComponents, datasetNameComponents);
        return (AbstractStatement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final AbstractStatement ConnectStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        Pair<DataverseName, Identifier> datasetNameComponents = null;
        Object configuration = null;
        ArrayList<FunctionSignature> appliedFunctions = new ArrayList<FunctionSignature>();
        ConnectFeedStatement stmt = null;
        String policy = null;
        String whereClauseBody = null;
        WhereClause whereClause = null;
        Token beginPos = null;
        Token endPos = null;
        this.jj_consume_token(44);
        feedNameComponents = this.QualifiedName();
        this.jj_consume_token(110);
        this.Dataset();
        datasetNameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.ApplyFunction(appliedFunctions);
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 119: {
                policy = this.GetPolicy();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                beginPos = this.token;
                whereClause = new WhereClause();
                Expression whereExpr = this.Expression();
                whereClause.setWhereExpr(whereExpr);
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
            }
        }
        if (whereClause != null) {
            endPos = this.token;
            whereClauseBody = this.extractFragment(beginPos.endLine, beginPos.endColumn, endPos.endLine, endPos.endColumn + 1);
        }
        stmt = new ConnectFeedStatement(feedNameComponents, datasetNameComponents, appliedFunctions, policy, whereClauseBody, this.getVarCounter());
        return (AbstractStatement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
    }

    public final Map<String, String> Configuration() throws ParseException, ParseException {
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        Pair<String, String> keyValuePair = null;
        this.jj_consume_token(133);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                keyValuePair = this.KeyValuePair();
                configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[83] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(139);
                    keyValuePair = this.KeyValuePair();
                    configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                }
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
        return configuration;
    }

    public final Pair<String, String> KeyValuePair() throws ParseException, ParseException {
        String value;
        this.jj_consume_token(133);
        String key = this.ConstantString();
        this.jj_consume_token(149);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 168: 
            case 169: {
                value = this.ConstantString();
                break;
            }
            case 43: 
            case 111: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 111: {
                        this.jj_consume_token(111);
                        break;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                value = this.token.image.toLowerCase();
                break;
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(134);
        return new Pair((Object)key, (Object)value);
    }

    public final Map<String, String> Properties() throws ParseException, ParseException {
        HashMap<String, String> properties = new HashMap<String, String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                this.jj_consume_token(133);
                Pair<String, String> property = this.Property();
                properties.put((String)property.first, (String)property.second);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(139);
                    property = this.Property();
                    properties.put((String)property.first, (String)property.second);
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        return properties;
    }

    public final Pair<String, String> Property() throws ParseException, ParseException {
        String key = null;
        String value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: 
            case 168: {
                key = this.Identifier();
                break;
            }
            case 169: {
                key = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(149);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 168: 
            case 169: {
                value = this.ConstantString();
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                try {
                    value = String.valueOf(Long.parseLong(this.token.image));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "inapproriate value: " + this.token.image);
                }
            }
            default: {
                this.jj_la1[90] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Pair((Object)key.toUpperCase(), (Object)value);
    }

    public final IndexedTypeExpression IndexedTypeExpr(boolean allowQues) throws ParseException, ParseException {
        TypeExpression typeExpr = null;
        boolean isUnknownable = !allowQues;
        typeExpr = this.TypeExpr(false);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 142: {
                this.jj_consume_token(142);
                if (!allowQues) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "'?' quantifier is illegal for the type expression.");
                }
                isUnknownable = true;
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
            }
        }
        return new IndexedTypeExpression(typeExpr, isUnknownable);
    }

    public final TypeExpression TypeExpr(boolean allowRecordTypeDef) throws ParseException, ParseException {
        TypeReferenceExpression typeExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: 
            case 168: {
                typeExpr = this.TypeReference();
                break;
            }
            case 135: {
                typeExpr = this.OrderedListTypeDef(allowRecordTypeDef);
                break;
            }
            case 155: {
                typeExpr = this.UnorderedListTypeDef(allowRecordTypeDef);
                break;
            }
            case 16: 
            case 83: 
            case 153: {
                typeExpr = this.RecordTypeDef();
                if (allowRecordTypeDef) break;
                throw new SqlppParseException(typeExpr.getSourceLocation(), "Unexpected record type declaration");
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return typeExpr;
    }

    public final RecordTypeDefinition.RecordKind RecordTypeKind() throws ParseException, ParseException {
        RecordTypeDefinition.RecordKind recordKind = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                recordKind = RecordTypeDefinition.RecordKind.CLOSED;
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                recordKind = RecordTypeDefinition.RecordKind.OPEN;
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return recordKind;
    }

    public final RecordTypeDefinition RecordTypeDef() throws ParseException, ParseException {
        Token startToken = null;
        RecordTypeDefinition recType = new RecordTypeDefinition();
        RecordTypeDefinition.RecordKind recordKind = RecordTypeDefinition.RecordKind.OPEN;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 83: {
                recordKind = this.RecordTypeKind();
                break;
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
            }
        }
        this.jj_consume_token(153);
        startToken = this.token;
        Token hintToken = this.fetchHint(this.token, SqlppHint.GEN_FIELDS_HINT);
        if (hintToken != null) {
            String[] splits;
            String hintParams = hintToken.hintParams;
            String[] stringArray = splits = hintParams != null ? hintParams.split("\\s+") : null;
            if (splits == null || splits.length != 4) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expecting: /*+ gen-fields <type> <min> <max> <prefix>*/");
            }
            if (!splits[0].equals(INT_TYPE_NAME)) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "The only supported type for gen-fields is int.");
            }
            UndeclaredFieldsDataGen ufdg = new UndeclaredFieldsDataGen(UndeclaredFieldsDataGen.Type.INT, Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), splits[3]);
            recType.setUndeclaredFieldsDataGen(ufdg);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: 
            case 168: {
                this.RecordField(recType);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[95] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(139);
                    this.RecordField(recType);
                }
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
            }
        }
        this.jj_consume_token(154);
        recType.setRecordKind(recordKind);
        return SQLPPParser.addSourceLocation(recType, startToken);
    }

    public final void RecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
        TypeExpression type = null;
        boolean nullable = false;
        boolean missable = false;
        String fieldName = this.Identifier();
        Token hintToken = this.fetchHint(this.token, SqlppHint.VAL_FILE_HINT, SqlppHint.VAL_FILE_SAME_INDEX_HINT, SqlppHint.LIST_VAL_FILE_HINT, SqlppHint.LIST_HINT, SqlppHint.INTERVAL_HINT, SqlppHint.INSERT_RAND_INT_HINT, SqlppHint.DATE_BETWEEN_YEARS_HINT, SqlppHint.DATETIME_ADD_RAND_HOURS_HINT, SqlppHint.AUTO_HINT);
        IRecordFieldDataGen rfdg = hintToken != null ? this.parseFieldDataGen(hintToken) : null;
        this.jj_consume_token(138);
        type = this.TypeExpr(true);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 142: {
                this.jj_consume_token(142);
                nullable = true;
                missable = true;
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        recType.addField(fieldName, type, nullable, missable, rfdg);
    }

    public final TypeReferenceExpression TypeReference() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> id = null;
        id = this.QualifiedName();
        if (id.first == null && ((Identifier)id.second).getValue().equalsIgnoreCase(INT_TYPE_NAME)) {
            id.second = new Identifier(BuiltinType.AINT64.getTypeName());
        }
        TypeReferenceExpression typeRef = new TypeReferenceExpression(id);
        return SQLPPParser.addSourceLocation(typeRef, this.token);
    }

    public final OrderedListTypeDefinition OrderedListTypeDef(boolean allowRecordTypeDef) throws ParseException, ParseException {
        Token startToken = null;
        TypeExpression type = null;
        this.jj_consume_token(135);
        startToken = this.token;
        type = this.TypeExpr(allowRecordTypeDef);
        this.jj_consume_token(136);
        OrderedListTypeDefinition typeDef = new OrderedListTypeDefinition(type);
        return SQLPPParser.addSourceLocation(typeDef, startToken);
    }

    public final UnorderedListTypeDefinition UnorderedListTypeDef(boolean allowRecordTypeDef) throws ParseException, ParseException {
        Token startToken = null;
        TypeExpression type = null;
        this.jj_consume_token(155);
        startToken = this.token;
        type = this.TypeExpr(allowRecordTypeDef);
        this.jj_consume_token(156);
        UnorderedListTypeDefinition typeDef = new UnorderedListTypeDefinition(type);
        return SQLPPParser.addSourceLocation(typeDef, startToken);
    }

    public final FunctionName FunctionName() throws ParseException, ParseException {
        Triple<List<String>, Token, Token> prefix = null;
        String suffix = null;
        prefix = this.MultipartIdentifierWithHints(SqlppHint.INDEXED_NESTED_LOOP_JOIN_HINT, SqlppHint.RANGE_HINT, SqlppHint.HASH_JOIN_HINT, SqlppHint.SKIP_SECONDARY_INDEX_SEARCH_HINT, SqlppHint.SPATIAL_JOIN_HINT, SqlppHint.USE_SECONDARY_INDEX_SEARCH_HINT);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 144: {
                this.jj_consume_token(144);
                suffix = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
            }
        }
        Token startToken = (Token)prefix.second;
        FunctionName result = new FunctionName();
        result.sourceLoc = SQLPPParser.getSourceLocation(startToken);
        result.hintToken = (Token)prefix.third;
        List list = (List)prefix.first;
        int ln = list.size();
        String last = (String)list.get(ln - 1);
        if (suffix == null) {
            result.function = last;
        } else {
            result.library = last;
            result.function = suffix;
        }
        result.dataverse = ln > 1 ? this.createDataverseName(list, 0, ln - 1, startToken) : this.defaultDataverse;
        if (result.function.equalsIgnoreCase(INT_TYPE_NAME)) {
            result.function = BuiltinType.AINT64.getTypeName();
        }
        return result;
    }

    public final Pair<DataverseName, Identifier> TypeName() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> name = null;
        name = this.QualifiedName();
        if (name.first == null) {
            name.first = this.defaultDataverse;
        }
        return name;
    }

    public final String Identifier() throws ParseException, ParseException {
        String lit = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: {
                this.jj_consume_token(167);
                return this.token.image;
            }
            case 168: {
                lit = this.QuotedString();
                return lit;
            }
        }
        this.jj_la1[99] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<String> ParenthesizedIdentifierList() throws ParseException, ParseException {
        ArrayList<String> list = new ArrayList<String>();
        String ident = null;
        this.jj_consume_token(133);
        ident = this.Identifier();
        list.add(ident);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            ident = this.Identifier();
            list.add(ident);
        }
        this.jj_consume_token(134);
        return list;
    }

    public final Pair<HashJoinExpressionAnnotation.BuildOrProbe, String> buildOrProbeParenthesizedIdentifier() throws ParseException, ParseException {
        String ident1 = null;
        String ident2 = null;
        ident1 = this.Identifier();
        this.jj_consume_token(133);
        ident2 = this.Identifier();
        this.jj_consume_token(134);
        if (ident1.equals("build")) {
            return new Pair((Object)HashJoinExpressionAnnotation.BuildOrProbe.BUILD, (Object)ident2);
        }
        if (ident1.equals("probe")) {
            return new Pair((Object)HashJoinExpressionAnnotation.BuildOrProbe.PROBE, (Object)ident2);
        }
        throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "The string after hashjoin has to be \"build\" or \"probe\".");
    }

    public final String parenthesizedIdentifier() throws ParseException, ParseException {
        String ident = null;
        this.jj_consume_token(133);
        ident = this.Identifier();
        this.jj_consume_token(134);
        return ident;
    }

    public final List<Literal> ParenthesizedLiteralList() throws ParseException, ParseException {
        ArrayList<Literal> list = new ArrayList<Literal>();
        boolean minus = false;
        Expression litExpr = null;
        Literal lit = null;
        this.jj_consume_token(133);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                minus = true;
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
            }
        }
        litExpr = this.Literal();
        lit = ((LiteralExpr)litExpr).getValue();
        if (minus) {
            try {
                lit = ExpressionUtils.reverseSign((Literal)lit);
            }
            catch (TypeMismatchException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            minus = false;
        }
        list.add(lit);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(139);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    this.jj_consume_token(130);
                    minus = true;
                    break;
                }
                default: {
                    this.jj_la1[103] = this.jj_gen;
                }
            }
            litExpr = this.Literal();
            lit = ((LiteralExpr)litExpr).getValue();
            if (minus) {
                try {
                    lit = ExpressionUtils.reverseSign((Literal)lit);
                }
                catch (TypeMismatchException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
                }
                minus = false;
            }
            list.add(lit);
        }
        this.jj_consume_token(134);
        return list;
    }

    public final Pair<Integer, Pair<List<String>, IndexedTypeExpression>> OpenField() throws ParseException, ParseException {
        IndexedTypeExpression fieldType = null;
        Pair<Integer, List<String>> fieldList = null;
        fieldList = this.NestedField();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                fieldType = this.IndexedTypeExpr(true);
                break;
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
            }
        }
        return new Pair((Object)((Integer)fieldList.first), (Object)new Pair((Object)((List)fieldList.second), (Object)fieldType));
    }

    public final Pair<Integer, List<String>> NestedField() throws ParseException, ParseException {
        ArrayList<String> exprList = new ArrayList<String>();
        String lit = null;
        Token litToken = null;
        int source = 0;
        lit = this.Identifier();
        boolean meetParens = false;
        litToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                this.jj_consume_token(133);
                this.jj_consume_token(134);
                if (!lit.equalsIgnoreCase("meta")) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(litToken), "The string before () has to be \"meta\".");
                }
                meetParens = true;
                source = 1;
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        if (!meetParens) {
            exprList.add(lit);
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 140: {
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(140);
            lit = this.Identifier();
            exprList.add(lit);
        }
        return new Pair((Object)source, exprList);
    }

    public final String ConstantString() throws ParseException, ParseException {
        String value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 168: {
                value = this.QuotedString();
                break;
            }
            case 169: {
                value = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String QuotedString() throws ParseException, ParseException {
        this.jj_consume_token(168);
        return SQLPPParser.removeQuotesAndEscapes((String)this.token.image);
    }

    public final String StringLiteral() throws ParseException, ParseException {
        StringBuilder str = null;
        char quote = '\u0000';
        boolean ext = false;
        Token litToken = null;
        String lit = null;
        block3: while (true) {
            boolean e;
            this.jj_consume_token(169);
            String quoted = this.token.image;
            char q = quoted.charAt(0);
            boolean bl = e = q == 'E';
            if (e) {
                q = quoted.charAt(1);
                quoted = quoted.substring(1);
            }
            if (lit == null) {
                quote = q;
                ext = e;
            } else {
                boolean isAdjacent;
                boolean bl2 = isAdjacent = litToken.endLine == this.token.beginLine && litToken.endColumn + 1 == this.token.beginColumn;
                if (!isAdjacent || ext || e || q != quote) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Invalid string literal");
                }
                if (str == null) {
                    str = new StringBuilder();
                }
                str.append(lit);
                str.append(quote);
            }
            lit = SQLPPParser.removeQuotesAndEscapes((String)quoted);
            litToken = this.token;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 169: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[108] = this.jj_gen;
        if (str == null) {
            return lit;
        }
        str.append(lit);
        return str.toString();
    }

    public final Triple<List<String>, Token, Token> MultipartIdentifier() throws ParseException, ParseException {
        Triple<List<String>, Token, Token> result = null;
        result = this.MultipartIdentifierWithHints(null);
        return result;
    }

    public final Triple<List<String>, Token, Token> MultipartIdentifierWithHints(SqlppHint ... expectedHints) throws ParseException, ParseException {
        ArrayList<String> list = new ArrayList<String>();
        Object sourceLoc = null;
        Token hintToken = null;
        String item = null;
        item = this.Identifier();
        list.add(item);
        Token startToken = this.token;
        if (expectedHints != null && expectedHints.length > 0) {
            hintToken = this.fetchHint(this.token, expectedHints);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 140: {
                    break;
                }
                default: {
                    this.jj_la1[109] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(140);
            item = this.Identifier();
            list.add(item);
        }
        return new Triple(list, (Object)startToken, (Object)hintToken);
    }

    public final DataverseName DataverseName() throws ParseException, ParseException {
        Triple<List<String>, Token, Token> ident = null;
        ident = this.MultipartIdentifier();
        List list = (List)ident.first;
        Token startToken = (Token)ident.second;
        return this.createDataverseName(list, 0, list.size(), startToken);
    }

    public final Pair<DataverseName, Identifier> QualifiedName() throws ParseException, ParseException {
        Triple<List<String>, Token, Token> ident = null;
        ident = this.MultipartIdentifier();
        List list = (List)ident.first;
        Token startToken = (Token)ident.second;
        int len = list.size();
        DataverseName id1 = len > 1 ? this.createDataverseName(list, 0, len - 1, startToken) : null;
        Identifier id2 = new Identifier((String)list.get(len - 1));
        return new Pair((Object)id1, (Object)id2);
    }

    public final Triple<DataverseName, Identifier, Identifier> DoubleQualifiedName() throws ParseException, ParseException {
        ArrayList<String> list = new ArrayList<String>();
        String item = null;
        Token startToken = null;
        item = this.Identifier();
        list.add(item);
        startToken = this.token;
        block3: while (true) {
            this.jj_consume_token(140);
            item = this.Identifier();
            list.add(item);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 140: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[110] = this.jj_gen;
        int len = list.size();
        DataverseName id1 = len > 2 ? this.createDataverseName(list, 0, len - 2, startToken) : null;
        Identifier id2 = new Identifier((String)list.get(len - 2));
        Identifier id3 = new Identifier((String)list.get(len - 1));
        return new Triple((Object)id1, (Object)id2, (Object)id3);
    }

    public final FunctionDecl FunctionDeclaration() throws ParseException, ParseException {
        Token startToken = null;
        Pair<Integer, List<Pair<VarIdentifier, TypeExpression>>> paramsWithArity = null;
        this.createNewScope();
        this.jj_consume_token(26);
        startToken = this.token;
        this.jj_consume_token(51);
        String functionName = this.Identifier();
        paramsWithArity = this.FunctionParameters();
        this.jj_consume_token(153);
        Expression funcBody = this.FunctionBody();
        this.jj_consume_token(154);
        int arity = (Integer)paramsWithArity.first;
        List paramList = (List)paramsWithArity.second;
        FunctionSignature signature = new FunctionSignature(this.defaultDataverse, functionName, arity);
        this.getCurrentScope().addFunctionDescriptor(signature, false);
        this.ensureNoTypeDeclsInFunction(functionName, paramList, null, startToken);
        ArrayList<VarIdentifier> params = new ArrayList<VarIdentifier>(paramList.size());
        for (Pair p : paramList) {
            params.add((VarIdentifier)p.getFirst());
        }
        FunctionDecl stmt = new FunctionDecl(signature, params, funcBody, false);
        this.removeCurrentScope();
        return SQLPPParser.addSourceLocation(stmt, startToken);
    }

    public final Query Query() throws ParseException, ParseException {
        Object expr;
        Query query = new Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                expr = this.Expression();
                break;
            }
            case 48: 
            case 70: 
            case 71: 
            case 102: 
            case 125: {
                expr = this.SelectExpression(false);
                break;
            }
            default: {
                this.jj_la1[111] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        query.setBody(expr);
        query.setSourceLocation(expr.getSourceLocation());
        return query;
    }

    public final Expression Expression() throws ParseException {
        Expression expr = null;
        Object exprP = null;
        if (this.jj_2_8(2)) {
            expr = this.OperatorExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 39: 
                case 104: {
                    expr = this.QuantifiedExpression();
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return exprP == null ? expr : exprP;
    }

    public final Expression OperatorExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AndExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(84);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator(this.token.image.toLowerCase());
            }
            catch (Exception e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.AndExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression AndExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.NotExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[114] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(4);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator(this.token.image.toLowerCase());
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.NotExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression NotExpr() throws ParseException, ParseException {
        boolean not = false;
        Token startToken = null;
        if (this.jj_2_9(2)) {
            this.jj_consume_token(79);
            not = true;
            startToken = this.token;
        }
        Expression inputExpr = this.RelExpr();
        if (not) {
            FunctionSignature signature = new FunctionSignature(BuiltinFunctions.NOT);
            CallExpr callExpr = new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(inputExpr)));
            return (Expression)SQLPPParser.addSourceLocation(callExpr, startToken);
        }
        return inputExpr;
    }

    public final Expression RelExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Token opToken = null;
        Expression operand = null;
        IExpressionAnnotation annotation = null;
        ArrayList<IExpressionAnnotation> annotationList = new ArrayList<IExpressionAnnotation>();
        operand = this.BetweenExpr();
        if (this.jj_2_10(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 145: {
                    this.jj_consume_token(145);
                    break;
                }
                case 146: {
                    this.jj_consume_token(146);
                    break;
                }
                case 147: {
                    this.jj_consume_token(147);
                    break;
                }
                case 148: {
                    this.jj_consume_token(148);
                    break;
                }
                case 149: {
                    this.jj_consume_token(149);
                    break;
                }
                case 150: {
                    this.jj_consume_token(150);
                    break;
                }
                case 151: {
                    this.jj_consume_token(151);
                    break;
                }
                case 152: {
                    this.jj_consume_token(152);
                    break;
                }
                case 57: 
                case 79: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 79: {
                            this.jj_consume_token(79);
                            not = true;
                            break;
                        }
                        default: {
                            this.jj_la1[115] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(57);
                    break;
                }
                case 64: {
                    this.jj_consume_token(64);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 79: {
                            this.jj_consume_token(79);
                            not = true;
                            break;
                        }
                        default: {
                            this.jj_la1[116] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(31);
                    opToken = this.token;
                    this.jj_consume_token(48);
                    break;
                }
                default: {
                    this.jj_la1[117] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (opToken == null) {
                opToken = this.token;
            }
            Token hintToken = this.fetchHint(this.token, SqlppHint.HASH_BROADCAST_JOIN_HINT, SqlppHint.INDEXED_NESTED_LOOP_JOIN_HINT, SqlppHint.HASH_JOIN_HINT, SqlppHint.SKIP_SECONDARY_INDEX_SEARCH_HINT, SqlppHint.USE_SECONDARY_INDEX_SEARCH_HINT, SqlppHint.SINGLE_DATASET_PREDICATE_SELECTIVITY_HINT, SqlppHint.JOIN_PREDICATE_PRODUCTIVITY_HINT);
            while (hintToken != null) {
                annotation = this.parseExpressionAnnotation(hintToken);
                if (annotation != null) {
                    annotationList.add(annotation);
                }
                if ((hintToken = hintToken.specialToken) == null) continue;
                SourceLocation sourceLoc = SQLPPParser.getSourceLocation(hintToken);
                this.hintCollector.remove(sourceLoc);
            }
            Object operator = opToken.image.toLowerCase();
            if (((String)operator).equals("<>")) {
                operator = "!=";
            }
            if (not) {
                operator = "not_" + (String)operator;
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator((String)operator);
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.BetweenExpr();
            op.addOperand(operand);
        }
        if (annotation != null) {
            op.addHints(annotationList);
        }
        return op == null ? operand : op;
    }

    public final Expression BetweenExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        IExpressionAnnotation annotation = null;
        operand = this.IsExpr();
        if (this.jj_2_11(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 79: {
                    this.jj_consume_token(79);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                }
            }
            this.jj_consume_token(11);
            Token hintToken = this.fetchHint(this.token, SqlppHint.INDEXED_NESTED_LOOP_JOIN_HINT, SqlppHint.SKIP_SECONDARY_INDEX_SEARCH_HINT, SqlppHint.HASH_JOIN_HINT, SqlppHint.USE_SECONDARY_INDEX_SEARCH_HINT, SqlppHint.SINGLE_DATASET_PREDICATE_SELECTIVITY_HINT);
            if (hintToken != null) {
                annotation = this.parseExpressionAnnotation(hintToken);
            }
            Object operator = this.token.image.toLowerCase();
            if (not) {
                operator = "not_" + (String)operator;
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator((String)operator);
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.IsExpr();
            op.addOperand(operand);
            this.jj_consume_token(4);
            operand = this.IsExpr();
            op.addOperator(OperatorType.AND);
            op.addOperand(operand);
        }
        if (annotation != null) {
            op.addHint(annotation);
        }
        return op == null ? operand : op;
    }

    public final Expression IsExpr() throws ParseException, ParseException {
        Token notToken = null;
        CallExpr expr = null;
        Expression operand = null;
        boolean not = false;
        FunctionIdentifier fn = null;
        operand = this.LikeExpr();
        if (this.jj_2_12(3)) {
            this.jj_consume_token(64);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 79: {
                    this.jj_consume_token(79);
                    not = true;
                    notToken = this.token;
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 80: {
                    this.jj_consume_token(80);
                    fn = BuiltinFunctions.IS_NULL;
                    break;
                }
                case 75: {
                    this.jj_consume_token(75);
                    fn = BuiltinFunctions.IS_MISSING;
                    break;
                }
                case 114: {
                    this.jj_consume_token(114);
                    fn = BuiltinFunctions.IS_UNKNOWN;
                    break;
                }
                case 68: 
                case 121: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 68: {
                            this.jj_consume_token(68);
                            break;
                        }
                        case 121: {
                            this.jj_consume_token(121);
                            break;
                        }
                        default: {
                            this.jj_la1[120] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    not = !not;
                    fn = BuiltinFunctions.IS_UNKNOWN;
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            FunctionSignature signature = new FunctionSignature(fn);
            expr = new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(operand)));
            SQLPPParser.addSourceLocation(expr, this.token);
            if (not) {
                FunctionSignature notSignature = new FunctionSignature(BuiltinFunctions.NOT);
                expr = new CallExpr(notSignature, new ArrayList<CallExpr>(Collections.singletonList(expr)));
                SQLPPParser.addSourceLocation(expr, notToken);
            }
        }
        return expr == null ? operand : expr;
    }

    public final Expression LikeExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        IExpressionAnnotation annotation = null;
        operand = this.ConcatExpr();
        if (this.jj_2_13(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 79: {
                    this.jj_consume_token(79);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[122] = this.jj_gen;
                }
            }
            this.jj_consume_token(72);
            Token hintToken = this.fetchHint(this.token, SqlppHint.SINGLE_DATASET_PREDICATE_SELECTIVITY_HINT);
            if (hintToken != null) {
                annotation = this.parseExpressionAnnotation(hintToken);
            }
            op = new OperatorExpr();
            op.addOperand(operand);
            op.setCurrentop(true);
            SQLPPParser.addSourceLocation(op, this.token);
            Object operator = this.token.image.toLowerCase();
            if (not) {
                operator = "not_" + (String)operator;
            }
            try {
                op.addOperator((String)operator);
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            if (annotation != null) {
                op.addHint(annotation);
            }
            operand = this.ConcatExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression ConcatExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AddExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[123] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(128);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            op.addOperator(OperatorType.CONCAT);
            operand = this.AddExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression AddExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        OperatorType opType = null;
        Expression operand = null;
        operand = this.MultExpr();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: 
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[124] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    this.jj_consume_token(132);
                    opType = OperatorType.PLUS;
                    break;
                }
                case 130: {
                    this.jj_consume_token(130);
                    opType = OperatorType.MINUS;
                    break;
                }
                default: {
                    this.jj_la1[125] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            op.addOperator(opType);
            operand = this.MultExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression MultExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        OperatorType opType = null;
        Expression operand = null;
        operand = this.ExponentExpr();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: 
                case 76: 
                case 129: 
                case 131: 
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[126] = this.jj_gen;
                    break block13;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 131: {
                    this.jj_consume_token(131);
                    opType = OperatorType.MUL;
                    break;
                }
                case 129: {
                    this.jj_consume_token(129);
                    opType = OperatorType.DIVIDE;
                    break;
                }
                case 32: {
                    this.jj_consume_token(32);
                    opType = OperatorType.DIV;
                    break;
                }
                case 76: 
                case 141: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 76: {
                            this.jj_consume_token(76);
                            break;
                        }
                        case 141: {
                            this.jj_consume_token(141);
                            break;
                        }
                        default: {
                            this.jj_la1[127] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    opType = OperatorType.MOD;
                    break;
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            op.addOperator(opType);
            operand = this.ExponentExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression ExponentExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.UnaryExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 127: {
                this.jj_consume_token(127);
                if (op == null) {
                    op = new OperatorExpr();
                    op.addOperand(operand);
                    op.setCurrentop(true);
                    SQLPPParser.addSourceLocation(op, this.token);
                }
                op.addOperator(OperatorType.CARET);
                operand = this.UnaryExpr();
                op.addOperand(operand);
                break;
            }
            default: {
                this.jj_la1[129] = this.jj_gen;
            }
        }
        return op == null ? operand : op;
    }

    public final Expression UnaryExpr() throws ParseException, ParseException {
        boolean not = false;
        UnaryExpr uexpr = null;
        Expression expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: 
            case 79: 
            case 130: 
            case 132: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 132: {
                        this.jj_consume_token(132);
                        break;
                    }
                    case 130: {
                        this.jj_consume_token(130);
                        break;
                    }
                    case 41: 
                    case 79: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 79: {
                                this.jj_consume_token(79);
                                not = true;
                                break;
                            }
                            default: {
                                this.jj_la1[130] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(41);
                        break;
                    }
                    default: {
                        this.jj_la1[131] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Object exprType = this.token.image.toLowerCase();
                if (not) {
                    exprType = "not_" + (String)exprType;
                }
                uexpr = new UnaryExpr();
                SQLPPParser.addSourceLocation(uexpr, this.token);
                try {
                    uexpr.setExprType((String)exprType);
                    break;
                }
                catch (CompilationException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
                }
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
            }
        }
        expr = this.ValueExpr();
        if (uexpr == null) {
            return expr;
        }
        uexpr.setExpr(expr);
        return uexpr;
    }

    public final Expression ValueExpr() throws ParseException, ParseException {
        Expression accessor;
        Expression expr;
        block8: {
            expr = null;
            accessor = null;
            expr = this.PrimaryExpr();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 135: 
                    case 140: {
                        break;
                    }
                    default: {
                        this.jj_la1[133] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 140: {
                        accessor = this.FieldAccessor(accessor != null ? accessor : expr);
                        continue block7;
                    }
                    case 135: {
                        accessor = this.IndexAccessor(accessor != null ? accessor : expr);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[134] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return accessor == null ? expr : accessor;
    }

    public final FieldAccessor FieldAccessor(Expression inputExpr) throws ParseException, ParseException {
        Token startToken = null;
        String ident = null;
        this.jj_consume_token(140);
        startToken = this.token;
        ident = this.Identifier();
        FieldAccessor fa = new FieldAccessor(inputExpr, new Identifier(ident));
        return SQLPPParser.addSourceLocation(fa, startToken);
    }

    public final AbstractAccessor IndexAccessor(Expression inputExpr) throws ParseException, ParseException {
        Token startToken = null;
        boolean star = false;
        boolean slice = false;
        Expression expr1 = null;
        Expression expr2 = null;
        this.jj_consume_token(135);
        startToken = this.token;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                this.jj_consume_token(131);
                star = true;
                break;
            }
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                expr1 = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 138: {
                        this.jj_consume_token(138);
                        slice = true;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: 
                            case 14: 
                            case 39: 
                            case 41: 
                            case 43: 
                            case 75: 
                            case 79: 
                            case 80: 
                            case 104: 
                            case 111: 
                            case 130: 
                            case 132: 
                            case 133: 
                            case 135: 
                            case 142: 
                            case 153: 
                            case 155: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 179: 
                            case 180: 
                            case 181: {
                                expr2 = this.Expression();
                                break block0;
                            }
                        }
                        this.jj_la1[135] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[136] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(136);
        if (expr1 != null && expr1.getKind() == Expression.Kind.LITERAL_EXPRESSION) {
            this.ensureIntegerLiteral((LiteralExpr)expr1, "Index");
        }
        if (expr2 != null && expr2.getKind() == Expression.Kind.LITERAL_EXPRESSION) {
            this.ensureIntegerLiteral((LiteralExpr)expr2, "Index");
        }
        Object resultAccessor = slice ? new ListSliceExpression(inputExpr, expr1, expr2) : (star ? new IndexAccessor(inputExpr, IndexAccessor.IndexKind.STAR, null) : new IndexAccessor(inputExpr, IndexAccessor.IndexKind.ELEMENT, expr1));
        return (AbstractAccessor)SQLPPParser.addSourceLocation(resultAccessor, startToken);
    }

    public final Expression PrimaryExpr() throws ParseException, ParseException {
        Expression expr = null;
        if (this.jj_2_14(Integer.MAX_VALUE)) {
            expr = this.FunctionCallExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    expr = this.CaseExpr();
                    break;
                }
                case 43: 
                case 75: 
                case 80: 
                case 111: 
                case 158: 
                case 159: 
                case 160: 
                case 169: {
                    expr = this.Literal();
                    break;
                }
                case 167: 
                case 168: {
                    expr = this.VariableRef();
                    break;
                }
                case 142: 
                case 179: 
                case 180: 
                case 181: {
                    expr = this.ExternalVariableRef();
                    break;
                }
                case 135: 
                case 155: {
                    expr = this.ListConstructor();
                    break;
                }
                case 153: {
                    expr = this.RecordConstructor();
                    break;
                }
                case 133: {
                    expr = this.ParenthesizedExpression();
                    break;
                }
                default: {
                    this.jj_la1[138] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expr;
    }

    public final Expression Literal() throws ParseException, ParseException {
        LiteralExpr lit = new LiteralExpr();
        String str = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 169: {
                str = this.StringLiteral();
                lit.setValue((Literal)new StringLiteral(str));
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                try {
                    lit.setValue((Literal)new LongIntegerLiteral(Long.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Could not parse numeric literal \"" + LogRedactionUtil.userData((String)this.token.image) + "\"");
                }
            }
            case 160: {
                this.jj_consume_token(160);
                try {
                    lit.setValue((Literal)new FloatLiteral(Float.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Could not parse numeric literal \"" + LogRedactionUtil.userData((String)this.token.image) + "\"");
                }
            }
            case 159: {
                this.jj_consume_token(159);
                try {
                    lit.setValue((Literal)new DoubleLiteral(Double.valueOf(this.token.image).doubleValue()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Could not parse numeric literal \"" + LogRedactionUtil.userData((String)this.token.image) + "\"");
                }
            }
            case 75: {
                this.jj_consume_token(75);
                lit.setValue((Literal)MissingLiteral.INSTANCE);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                lit.setValue((Literal)NullLiteral.INSTANCE);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                lit.setValue((Literal)TrueLiteral.INSTANCE);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                lit.setValue((Literal)FalseLiteral.INSTANCE);
                break;
            }
            default: {
                this.jj_la1[139] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (Expression)SQLPPParser.addSourceLocation(lit, this.token);
    }

    public final VariableExpr VariableRef() throws ParseException, ParseException {
        VariableExpr varExp;
        String id = null;
        id = this.VariableIdentifier();
        Identifier ident = this.lookupSymbol(id);
        if (this.isInForbiddenScopes(id)) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");
        }
        if (ident != null) {
            varExp = new VariableExpr((VarIdentifier)ident);
        } else {
            varExp = new VariableExpr(new VarIdentifier(id));
            varExp.setIsNewVar(false);
        }
        return SQLPPParser.addSourceLocation(varExp, this.token);
    }

    public final VariableExpr Variable() throws ParseException, ParseException {
        String id = null;
        id = this.VariableIdentifier();
        Identifier ident = this.lookupSymbol(id);
        VariableExpr varExp = new VariableExpr(new VarIdentifier(id));
        if (ident != null) {
            varExp.setIsNewVar(false);
        }
        return SQLPPParser.addSourceLocation(varExp, this.token);
    }

    public final String VariableIdentifier() throws ParseException, ParseException {
        String id = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: {
                this.jj_consume_token(167);
                id = this.token.image;
                break;
            }
            case 168: {
                id = this.QuotedString();
                break;
            }
            default: {
                this.jj_la1[140] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return SqlppVariableUtil.toInternalVariableName(id);
    }

    public final Pair<VariableExpr, List<Pair<Expression, Identifier>>> VariableWithFieldMap() throws ParseException, ParseException {
        VariableExpr var = null;
        ArrayList<Pair> fieldList = new ArrayList<Pair>();
        var = this.Variable();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                VariableExpr fieldVarExpr = null;
                String fieldIdentifierStr = null;
                this.jj_consume_token(133);
                fieldVarExpr = this.VariableRef();
                this.jj_consume_token(7);
                fieldIdentifierStr = this.Identifier();
                fieldList.add(new Pair((Object)fieldVarExpr, (Object)new Identifier(fieldIdentifierStr)));
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[141] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(139);
                    fieldVarExpr = this.VariableRef();
                    this.jj_consume_token(7);
                    fieldIdentifierStr = this.Identifier();
                    fieldList.add(new Pair((Object)fieldVarExpr, (Object)new Identifier(fieldIdentifierStr)));
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[142] = this.jj_gen;
            }
        }
        return new Pair((Object)var, fieldList);
    }

    public final VariableExpr ExternalVariableRef() throws ParseException, ParseException {
        String name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 180: {
                this.jj_consume_token(180);
                name = this.token.image.substring(1);
                break;
            }
            case 179: {
                this.jj_consume_token(179);
                name = this.token.image.substring(1);
                break;
            }
            case 181: {
                this.jj_consume_token(181);
                name = SQLPPParser.removeQuotesAndEscapes((String)this.token.image.substring(1));
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                name = String.valueOf(++this.externalVarCounter);
                break;
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String idName = SqlppVariableUtil.toExternalVariableName(name);
        VarIdentifier id = new VarIdentifier(idName);
        VariableExpr varExp = new VariableExpr(id);
        return SQLPPParser.addSourceLocation(varExp, this.token);
    }

    public final Expression ListConstructor() throws ParseException, ParseException {
        ListConstructor expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                expr = this.OrderedListConstructor();
                break;
            }
            case 155: {
                expr = this.UnorderedListConstructor();
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final ListConstructor OrderedListConstructor() throws ParseException, ParseException {
        Token startToken = null;
        List<Expression> exprList = null;
        this.jj_consume_token(135);
        startToken = this.token;
        exprList = this.ExpressionList();
        this.jj_consume_token(136);
        ListConstructor expr = new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, exprList);
        return SQLPPParser.addSourceLocation(expr, startToken);
    }

    public final ListConstructor UnorderedListConstructor() throws ParseException, ParseException {
        Token startToken = null;
        List<Expression> exprList = null;
        this.jj_consume_token(155);
        startToken = this.token;
        exprList = this.ExpressionList();
        this.jj_consume_token(156);
        ListConstructor expr = new ListConstructor(ListConstructor.Type.UNORDERED_LIST_CONSTRUCTOR, exprList);
        return SQLPPParser.addSourceLocation(expr, startToken);
    }

    public final List<Expression> ExpressionList() throws ParseException, ParseException {
        Expression expr = null;
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                expr = this.Expression();
                exprList.add(expr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[145] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(139);
                    expr = this.Expression();
                    exprList.add(expr);
                }
            }
            default: {
                this.jj_la1[146] = this.jj_gen;
            }
        }
        return exprList;
    }

    public final RecordConstructor RecordConstructor() throws ParseException, ParseException {
        Token startToken = null;
        FieldBinding fb = null;
        ArrayList<FieldBinding> fbList = new ArrayList<FieldBinding>();
        this.jj_consume_token(153);
        startToken = this.token;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                fb = this.FieldBinding();
                fbList.add(fb);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[147] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(139);
                    fb = this.FieldBinding();
                    fbList.add(fb);
                }
            }
            default: {
                this.jj_la1[148] = this.jj_gen;
            }
        }
        this.jj_consume_token(154);
        RecordConstructor expr = new RecordConstructor(fbList);
        return SQLPPParser.addSourceLocation(expr, startToken);
    }

    public final FieldBinding FieldBinding() throws ParseException, ParseException {
        Expression right = null;
        Expression left = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                right = this.Expression();
                break;
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
            }
        }
        if (right == null) {
            String generatedIdentifier = ExpressionToVariableUtil.getGeneratedIdentifier(left, false);
            if (generatedIdentifier == null) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Cannot infer field name");
            }
            String generatedName = SqlppVariableUtil.toUserDefinedName(generatedIdentifier);
            LiteralExpr generatedNameExpr = new LiteralExpr((Literal)new StringLiteral(generatedName));
            generatedNameExpr.setSourceLocation(left.getSourceLocation());
            return new FieldBinding((Expression)generatedNameExpr, left);
        }
        return new FieldBinding(left, right);
    }

    public final Expression FunctionCallExpr() throws ParseException, ParseException {
        IExpressionAnnotation annotation;
        int arity;
        Object fqFunctionName;
        FunctionSignature signature;
        ArrayList<Expression> argList = new ArrayList<Expression>();
        Expression argExpr = null;
        FunctionName funcName = null;
        boolean star = false;
        boolean distinct = false;
        Expression filterExpr = null;
        WindowExpression windowExpr = null;
        funcName = this.FunctionName();
        this.jj_consume_token(133);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 14: 
            case 31: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 31: {
                        this.jj_consume_token(31);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[150] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 14: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 104: 
                    case 111: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 142: 
                    case 153: 
                    case 155: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 179: 
                    case 180: 
                    case 181: {
                        argExpr = this.Expression();
                        break;
                    }
                    case 131: {
                        this.jj_consume_token(131);
                        star = true;
                        break;
                    }
                    default: {
                        this.jj_la1[151] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (star) {
                    if (funcName.function.equalsIgnoreCase(BuiltinFunctions.SCALAR_COUNT.getName())) {
                        argExpr = new LiteralExpr((Literal)new LongIntegerLiteral(Long.valueOf(1L)));
                    } else {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "The parameter * can only be used in " + BuiltinFunctions.SCALAR_COUNT.getName() + "().");
                    }
                }
                argList.add(argExpr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[152] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(139);
                    argExpr = this.Expression();
                    argList.add(argExpr);
                }
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
        Object name = funcName.function;
        if (distinct) {
            name = (String)name + "-distinct";
        }
        if ((signature = this.lookupFunctionSignature(funcName.dataverse, (String)(fqFunctionName = funcName.library == null ? name : funcName.library + "#" + (String)name), arity = argList.size())) == null) {
            signature = new FunctionSignature(funcName.dataverse, (String)fqFunctionName, arity);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                this.jj_consume_token(133);
                this.jj_consume_token(124);
                filterExpr = this.Expression();
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
            }
        }
        if (this.jj_2_15(5)) {
            windowExpr = this.WindowExpr(signature, argList, filterExpr);
        }
        if (windowExpr != null) {
            return windowExpr;
        }
        CallExpr callExpr = new CallExpr(signature, argList, filterExpr);
        if (funcName.hintToken != null && (annotation = this.parseExpressionAnnotation(funcName.hintToken)) != null) {
            callExpr.addHint(annotation);
        }
        FunctionMapUtil.normalizedListInputFunctions(callExpr);
        callExpr.setSourceLocation(funcName.sourceLoc);
        return callExpr;
    }

    public final WindowExpression WindowExpr(FunctionSignature signature, List<Expression> argList, Expression aggFilterExpr) throws ParseException, ParseException {
        WindowExpression windowExpr = null;
        Boolean fromLast = null;
        Boolean ignoreNulls = null;
        if (this.jj_2_16(5)) {
            this.jj_consume_token(48);
            this.jj_consume_token(167);
            if (this.isToken(FIRST)) {
                fromLast = false;
            } else if (this.isToken(LAST)) {
                fromLast = true;
            } else {
                throw this.createUnexpectedTokenError();
            }
        }
        if (this.jj_2_17(3)) {
            this.jj_consume_token(167);
            if (this.isToken(RESPECT)) {
                ignoreNulls = false;
            } else if (this.isToken(IGNORE)) {
                ignoreNulls = true;
            } else {
                throw this.createUnexpectedTokenError();
            }
            this.jj_consume_token(167);
            if (!this.isToken(NULLS)) {
                throw this.createUnexpectedTokenError();
            }
        }
        this.jj_consume_token(88);
        windowExpr = this.OverClause(signature, argList, aggFilterExpr, this.token, fromLast, ignoreNulls);
        return windowExpr;
    }

    public final WindowExpression OverClause(FunctionSignature signature, List<Expression> argList, Expression aggFilterExpr, Token startToken, Boolean fromLast, Boolean ignoreNulls) throws ParseException, ParseException {
        Expression partitionExpr = null;
        ArrayList<Expression> partitionExprs = new ArrayList<Expression>();
        OrderbyClause orderByClause = null;
        List orderbyList = null;
        List orderbyModifierList = null;
        List orderbyNullModifierList = null;
        WindowExpression.FrameMode frameMode = null;
        Pair<WindowExpression.FrameBoundaryKind, Expression> frameStart = null;
        Pair<WindowExpression.FrameBoundaryKind, Expression> frameEnd = null;
        WindowExpression.FrameBoundaryKind frameStartKind = null;
        WindowExpression.FrameBoundaryKind frameEndKind = null;
        Expression frameStartExpr = null;
        Expression frameEndExpr = null;
        WindowExpression.FrameExclusionKind frameExclusionKind = null;
        Pair<VariableExpr, List<Pair<Expression, Identifier>>> windowVarWithFieldList = null;
        VariableExpr windowVar = null;
        List windowFieldList = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: 
            case 168: {
                windowVarWithFieldList = this.VariableWithFieldMap();
                this.jj_consume_token(7);
                windowVar = (VariableExpr)windowVarWithFieldList.first;
                windowFieldList = (List)windowVarWithFieldList.second;
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
            }
        }
        this.jj_consume_token(133);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 167: {
                this.jj_consume_token(167);
                this.expectToken(PARTITION);
                this.jj_consume_token(13);
                partitionExpr = this.Expression();
                partitionExprs.add(partitionExpr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[156] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(139);
                    partitionExpr = this.Expression();
                    partitionExprs.add(partitionExpr);
                }
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
            }
        }
        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                orderByClause = this.OrderbyClause();
                orderbyList = orderByClause.getOrderbyList();
                orderbyModifierList = orderByClause.getModifierList();
                orderbyNullModifierList = orderByClause.getNullModifierList();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 167: {
                        frameMode = this.WindowFrameMode();
                        if (this.jj_2_18(1)) {
                            frameStart = this.WindowFrameBoundary();
                        } else {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 11: {
                                    this.jj_consume_token(11);
                                    frameStart = this.WindowFrameBoundary();
                                    this.jj_consume_token(4);
                                    frameEnd = this.WindowFrameBoundary();
                                    break;
                                }
                                default: {
                                    this.jj_la1[158] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 167: {
                                frameExclusionKind = this.WindowFrameExclusion();
                                break;
                            }
                            default: {
                                this.jj_la1[159] = this.jj_gen;
                            }
                        }
                        frameStartKind = (WindowExpression.FrameBoundaryKind)((Object)frameStart.first);
                        frameStartExpr = (Expression)frameStart.second;
                        if (frameEnd == null) {
                            frameEndKind = WindowExpression.FrameBoundaryKind.CURRENT_ROW;
                        } else {
                            frameEndKind = (WindowExpression.FrameBoundaryKind)((Object)frameEnd.first);
                            frameEndExpr = (Expression)frameEnd.second;
                        }
                        if (frameExclusionKind != null) break block9;
                        frameExclusionKind = WindowExpression.FrameExclusionKind.NO_OTHERS;
                        break;
                    }
                    default: {
                        this.jj_la1[160] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
        WindowExpression winExpr = new WindowExpression(signature, argList, aggFilterExpr, partitionExprs, orderbyList, orderbyModifierList, orderbyNullModifierList, frameMode, frameStartKind, frameStartExpr, frameEndKind, frameEndExpr, frameExclusionKind, windowVar, windowFieldList, ignoreNulls, fromLast);
        return SQLPPParser.addSourceLocation(winExpr, startToken);
    }

    public final WindowExpression.FrameMode WindowFrameMode() throws ParseException, ParseException {
        this.jj_consume_token(167);
        if (this.isToken(RANGE)) {
            return WindowExpression.FrameMode.RANGE;
        }
        if (this.isToken(ROWS)) {
            return WindowExpression.FrameMode.ROWS;
        }
        if (this.isToken(GROUPS)) {
            return WindowExpression.FrameMode.GROUPS;
        }
        throw this.createUnexpectedTokenError();
    }

    public final Pair<WindowExpression.FrameBoundaryKind, Expression> WindowFrameBoundary() throws ParseException, ParseException {
        WindowExpression.FrameBoundaryKind kind;
        boolean current = false;
        Expression expr = null;
        if (this.laIdentifier(CURRENT) || this.laIdentifier(UNBOUNDED)) {
            this.jj_consume_token(167);
            current = this.isToken(CURRENT);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 14: 
                case 39: 
                case 41: 
                case 43: 
                case 75: 
                case 79: 
                case 80: 
                case 104: 
                case 111: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 142: 
                case 153: 
                case 155: 
                case 158: 
                case 159: 
                case 160: 
                case 167: 
                case 168: 
                case 169: 
                case 179: 
                case 180: 
                case 181: {
                    expr = this.Expression();
                    break;
                }
                default: {
                    this.jj_la1[162] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(167);
        if (current && this.isToken(ROW)) {
            kind = WindowExpression.FrameBoundaryKind.CURRENT_ROW;
        } else if (!current && this.isToken(PRECEDING)) {
            kind = expr == null ? WindowExpression.FrameBoundaryKind.UNBOUNDED_PRECEDING : WindowExpression.FrameBoundaryKind.BOUNDED_PRECEDING;
        } else if (!current && this.isToken(FOLLOWING)) {
            kind = expr == null ? WindowExpression.FrameBoundaryKind.UNBOUNDED_FOLLOWING : WindowExpression.FrameBoundaryKind.BOUNDED_FOLLOWING;
        } else {
            throw this.createUnexpectedTokenError();
        }
        return new Pair((Object)kind, (Object)expr);
    }

    public final WindowExpression.FrameExclusionKind WindowFrameExclusion() throws ParseException, ParseException {
        boolean current = false;
        boolean no = false;
        this.jj_consume_token(167);
        this.expectToken(EXCLUDE);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                return WindowExpression.FrameExclusionKind.GROUP;
            }
            case 167: {
                this.jj_consume_token(167);
                if (this.isToken(TIES)) {
                    return WindowExpression.FrameExclusionKind.TIES;
                }
                if (this.isToken(CURRENT)) {
                    current = true;
                } else if (this.isToken(NO)) {
                    no = true;
                } else {
                    throw this.createUnexpectedTokenError();
                }
                this.jj_consume_token(167);
                if (current && this.isToken(ROW)) {
                    return WindowExpression.FrameExclusionKind.CURRENT_ROW;
                }
                if (no && this.isToken(OTHERS)) {
                    return WindowExpression.FrameExclusionKind.NO_OTHERS;
                }
                throw this.createUnexpectedTokenError();
            }
        }
        this.jj_la1[163] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expression ParenthesizedExpression() throws ParseException, ParseException {
        Token startToken = null;
        Object expr = null;
        Expression expr2 = null;
        ArrayList<Expression> exprList = null;
        if (this.jj_2_19(2)) {
            this.jj_consume_token(133);
            startToken = this.token;
            expr = this.Expression();
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 139: {
                        break;
                    }
                    default: {
                        this.jj_la1[164] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(139);
                expr2 = this.Expression();
                if (exprList == null) {
                    exprList = new ArrayList<Expression>();
                    exprList.add((Expression)expr);
                }
                exprList.add(expr2);
            }
            this.jj_consume_token(134);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: {
                    expr = this.Subquery();
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (exprList != null) {
            ListConstructor listExpr = new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, exprList);
            return (Expression)SQLPPParser.addSourceLocation(listExpr, startToken);
        }
        return expr;
    }

    public final Expression CaseExpr() throws ParseException, ParseException {
        Token startToken = null;
        Expression conditionExpr = null;
        ArrayList<Expression> whenExprs = new ArrayList<Expression>();
        ArrayList<Expression> thenExprs = new ArrayList<Expression>();
        Expression elseExpr = null;
        Expression whenExpr = null;
        Expression thenExpr = null;
        this.jj_consume_token(14);
        startToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                conditionExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[166] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[167] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(123);
            whenExpr = this.Expression();
            whenExprs.add(whenExpr);
            this.jj_consume_token(109);
            thenExpr = this.Expression();
            thenExprs.add(thenExpr);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                elseExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[168] = this.jj_gen;
            }
        }
        this.jj_consume_token(38);
        if (conditionExpr == null) {
            LiteralExpr litExpr = new LiteralExpr((Literal)TrueLiteral.INSTANCE);
            conditionExpr = (Expression)SQLPPParser.addSourceLocation(litExpr, startToken);
        }
        CaseExpression caseExpr = new CaseExpression(conditionExpr, whenExprs, thenExprs, elseExpr);
        return (Expression)SQLPPParser.addSourceLocation(caseExpr, startToken);
    }

    public final SelectExpression SelectExpression(boolean subquery) throws ParseException, ParseException {
        ArrayList<LetClause> letClauses = new ArrayList();
        OrderbyClause orderbyClause = null;
        LimitClause limitClause = null;
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 70: 
            case 71: 
            case 125: {
                letClauses = this.LetClause();
                break;
            }
            default: {
                this.jj_la1[169] = this.jj_gen;
            }
        }
        SelectSetOperation selectSetOperation = this.SelectSetOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                orderbyClause = this.OrderbyClause();
                break;
            }
            default: {
                this.jj_la1[170] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: 
            case 81: {
                limitClause = this.LimitClause();
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
            }
        }
        SelectExpression selectExpr = new SelectExpression(letClauses, selectSetOperation, orderbyClause, limitClause, subquery);
        selectExpr.setSourceLocation((!letClauses.isEmpty() ? (AbstractClause)letClauses.get(0) : selectSetOperation).getSourceLocation());
        return selectExpr;
    }

    public final SelectSetOperation SelectSetOperation() throws ParseException, ParseException {
        ArrayList<SetOperationRight> setOperationRights = new ArrayList<SetOperationRight>();
        SelectBlock selectBlockLeft = null;
        SelectExpression subqueryLeft = null;
        Object expr = null;
        selectBlockLeft = this.SelectBlock();
        SetOperationInput setOperationInputLeft = new SetOperationInput(selectBlockLeft, subqueryLeft);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: 
                case 63: 
                case 113: {
                    break;
                }
                default: {
                    this.jj_la1[172] = this.jj_gen;
                    break block15;
                }
            }
            SetOpType opType = SetOpType.UNION;
            boolean setSemantics = true;
            SelectBlock selectBlockRight = null;
            SelectExpression subqueryRight = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 113: {
                    this.jj_consume_token(113);
                    opType = SetOpType.UNION;
                    break;
                }
                case 63: {
                    this.jj_consume_token(63);
                    opType = SetOpType.INTERSECT;
                    break;
                }
                case 40: {
                    this.jj_consume_token(40);
                    opType = SetOpType.EXCEPT;
                    break;
                }
                default: {
                    this.jj_la1[173] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: {
                    this.jj_consume_token(2);
                    setSemantics = false;
                    break;
                }
                default: {
                    this.jj_la1[174] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: 
                case 102: {
                    selectBlockRight = this.SelectBlock();
                    break;
                }
                case 133: {
                    subqueryRight = this.Subquery();
                    break;
                }
                default: {
                    this.jj_la1[175] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            setOperationRights.add(new SetOperationRight(opType, setSemantics, new SetOperationInput(selectBlockRight, subqueryRight)));
        }
        SelectSetOperation selectSetOp = new SelectSetOperation(setOperationInputLeft, setOperationRights);
        selectSetOp.setSourceLocation(selectBlockLeft.getSourceLocation());
        return selectSetOp;
    }

    public final SelectExpression Subquery() throws ParseException, ParseException {
        SelectExpression selectExpr = null;
        this.jj_consume_token(133);
        selectExpr = this.SelectExpression(true);
        this.jj_consume_token(134);
        return selectExpr;
    }

    public final SelectBlock SelectBlock() throws ParseException, ParseException {
        SelectClause selectClause = null;
        FromClause fromClause = null;
        List<LetClause> fromLetClauses = null;
        WhereClause whereClause = null;
        ArrayList<AbstractClause> fromLetWhereClauses = new ArrayList<AbstractClause>();
        GroupbyClause groupbyClause = null;
        List<LetClause> gbyLetClauses = null;
        HavingClause havingClause = null;
        ArrayList<AbstractClause> gbyLetHavingClauses = new ArrayList<AbstractClause>();
        SourceLocation startSrcLoc = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 102: {
                selectClause = this.SelectClause();
                startSrcLoc = selectClause.getSourceLocation();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: 
                    case 70: 
                    case 71: 
                    case 125: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 48: {
                                fromClause = this.FromClause();
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 70: 
                                    case 71: 
                                    case 125: {
                                        fromLetClauses = this.LetClause();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[176] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 124: {
                                        whereClause = this.WhereClause();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[177] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 52: {
                                        groupbyClause = this.GroupbyClause();
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 70: 
                                            case 71: 
                                            case 125: {
                                                gbyLetClauses = this.LetClause();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[178] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 53: {
                                                havingClause = this.HavingClause();
                                                break block0;
                                            }
                                        }
                                        this.jj_la1[179] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[180] = this.jj_gen;
                                break block0;
                            }
                            case 70: 
                            case 71: 
                            case 125: {
                                fromLetClauses = this.LetClause();
                                SourceLocation sourceLoc = SQLPPParser.getSourceLocation(this.token);
                                LiteralExpr missingExpr = new LiteralExpr((Literal)MissingLiteral.INSTANCE);
                                missingExpr.setSourceLocation(sourceLoc);
                                ArrayList<LiteralExpr> list = new ArrayList<LiteralExpr>(1);
                                list.add(missingExpr);
                                ListConstructor listExpr = new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, list);
                                listExpr.setSourceLocation(sourceLoc);
                                ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>(1);
                                VariableExpr fromVar = new VariableExpr(new VarIdentifier("#0"));
                                fromVar.setSourceLocation(sourceLoc);
                                fromTerms.add(new FromTerm((Expression)listExpr, fromVar, null, new ArrayList<AbstractBinaryCorrelateClause>()));
                                fromClause = new FromClause(fromTerms);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 124: {
                                        whereClause = this.WhereClause();
                                        break block0;
                                    }
                                }
                                this.jj_la1[181] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[182] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[183] = this.jj_gen;
                break;
            }
            case 48: {
                fromClause = this.FromClause();
                startSrcLoc = fromClause.getSourceLocation();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 70: 
                    case 71: 
                    case 125: {
                        fromLetClauses = this.LetClause();
                        break;
                    }
                    default: {
                        this.jj_la1[184] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 124: {
                        whereClause = this.WhereClause();
                        break;
                    }
                    default: {
                        this.jj_la1[185] = this.jj_gen;
                    }
                }
                block35 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 52: {
                        groupbyClause = this.GroupbyClause();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 70: 
                            case 71: 
                            case 125: {
                                gbyLetClauses = this.LetClause();
                                break;
                            }
                            default: {
                                this.jj_la1[186] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 53: {
                                havingClause = this.HavingClause();
                                break block35;
                            }
                        }
                        this.jj_la1[187] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[188] = this.jj_gen;
                    }
                }
                selectClause = this.SelectClause();
                break;
            }
            default: {
                this.jj_la1[189] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (fromLetClauses != null) {
            fromLetWhereClauses.addAll(fromLetClauses);
        }
        if (whereClause != null) {
            fromLetWhereClauses.add((AbstractClause)whereClause);
        }
        if (gbyLetClauses != null) {
            gbyLetHavingClauses.addAll(gbyLetClauses);
        }
        if (havingClause != null) {
            gbyLetHavingClauses.add(havingClause);
        }
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, fromLetWhereClauses, groupbyClause, gbyLetHavingClauses);
        selectBlock.setSourceLocation(startSrcLoc);
        return selectBlock;
    }

    public final SelectClause SelectClause() throws ParseException, ParseException {
        Token startToken = null;
        SelectRegular selectRegular = null;
        SelectElement selectElement = null;
        boolean distinct = false;
        this.jj_consume_token(102);
        startToken = this.token;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 31: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        distinct = true;
                        break block0;
                    }
                }
                this.jj_la1[190] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[191] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 14: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 93: 
            case 104: 
            case 111: 
            case 120: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 14: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 104: 
                    case 111: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 142: 
                    case 153: 
                    case 155: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 179: 
                    case 180: 
                    case 181: {
                        selectRegular = this.SelectRegular();
                        break block7;
                    }
                    case 34: 
                    case 93: 
                    case 120: {
                        selectElement = this.SelectElement();
                        break block7;
                    }
                }
                this.jj_la1[192] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[193] = this.jj_gen;
            }
        }
        SourceLocation sourceLoc = SQLPPParser.getSourceLocation(startToken);
        if (selectRegular == null && selectElement == null) {
            Projection projection = new Projection(Projection.Kind.STAR, null, null);
            projection.setSourceLocation(sourceLoc);
            ArrayList<Projection> projections = new ArrayList<Projection>();
            projections.add(projection);
            selectRegular = new SelectRegular(projections);
            selectRegular.setSourceLocation(sourceLoc);
        }
        SelectClause selectClause = new SelectClause(selectElement, selectRegular, distinct);
        selectClause.setSourceLocation(sourceLoc);
        return selectClause;
    }

    public final SelectRegular SelectRegular() throws ParseException, ParseException {
        SourceLocation startSrcLoc = null;
        ArrayList<Projection> projections = new ArrayList<Projection>();
        Projection projection = null;
        projection = this.Projection();
        projections.add(projection);
        startSrcLoc = projection.getSourceLocation();
        while (this.jj_2_20(2)) {
            this.jj_consume_token(139);
            projection = this.Projection();
            projections.add(projection);
        }
        SelectRegular selectRegular = new SelectRegular(projections);
        selectRegular.setSourceLocation(startSrcLoc);
        return selectRegular;
    }

    public final SelectElement SelectElement() throws ParseException, ParseException {
        Token startToken = null;
        Expression expr = null;
        Object name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            default: {
                this.jj_la1[194] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        startToken = this.token;
        expr = this.Expression();
        SelectElement selectElement = new SelectElement(expr);
        return SQLPPParser.addSourceLocation(selectElement, startToken);
    }

    public final Projection Projection() throws ParseException, ParseException {
        SourceLocation startSrcLoc = null;
        VariableExpr expr = null;
        Object identifier = null;
        String name = null;
        Projection.Kind kind = null;
        boolean star = false;
        boolean varStar = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                this.jj_consume_token(131);
                kind = Projection.Kind.STAR;
                startSrcLoc = SQLPPParser.getSourceLocation(this.token);
                break;
            }
            default: {
                this.jj_la1[197] = this.jj_gen;
                if (this.jj_2_21(3)) {
                    expr = this.VariableRef();
                    this.jj_consume_token(140);
                    this.jj_consume_token(131);
                    kind = Projection.Kind.VAR_STAR;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 14: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 104: 
                    case 111: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 142: 
                    case 153: 
                    case 155: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 179: 
                    case 180: 
                    case 181: {
                        String generatedColumnIdentifier;
                        expr = this.Expression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 7: 
                            case 167: 
                            case 168: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 7: {
                                        this.jj_consume_token(7);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[195] = this.jj_gen;
                                    }
                                }
                                name = this.Identifier();
                                break;
                            }
                            default: {
                                this.jj_la1[196] = this.jj_gen;
                            }
                        }
                        kind = Projection.Kind.NAMED_EXPR;
                        if (name != null || (generatedColumnIdentifier = ExpressionToVariableUtil.getGeneratedIdentifier((Expression)expr, false)) == null) break block0;
                        name = SqlppVariableUtil.toUserDefinedName(generatedColumnIdentifier);
                        break block0;
                    }
                    default: {
                        this.jj_la1[198] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        Projection projection = new Projection(kind, (Expression)expr, name);
        projection.setSourceLocation(expr != null ? expr.getSourceLocation() : startSrcLoc);
        return projection;
    }

    public final FromClause FromClause() throws ParseException, ParseException {
        Token startToken = null;
        ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>();
        this.extendCurrentScope();
        FromTerm fromTerm = null;
        this.jj_consume_token(48);
        startToken = this.token;
        fromTerm = this.FromTerm();
        fromTerms.add(fromTerm);
        while (this.jj_2_22(2)) {
            this.jj_consume_token(139);
            fromTerm = this.FromTerm();
            fromTerms.add(fromTerm);
        }
        FromClause fromClause = new FromClause(fromTerms);
        return SQLPPParser.addSourceLocation(fromClause, startToken);
    }

    public final FromTerm FromTerm() throws ParseException, ParseException {
        Token hintToken;
        Expression leftExpr = null;
        VariableExpr leftVar = null;
        VariableExpr posVar = null;
        AbstractBinaryCorrelateClause correlateClause = null;
        ArrayList<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        leftExpr = this.Expression();
        if (leftExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION && (hintToken = this.fetchHint(this.token, SqlppHint.SUBPATH_HINT)) != null) {
            String subPath = hintToken.hintParams;
            ((VariableExpr)leftExpr).addHint((IExpressionAnnotation)new ExternalSubpathAnnotation(subPath));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 167: 
            case 168: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[199] = this.jj_gen;
                    }
                }
                leftVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[200] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[201] = this.jj_gen;
            }
        }
        block25: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 22: 
                case 46: 
                case 60: 
                case 65: 
                case 69: 
                case 97: 
                case 115: {
                    break;
                }
                default: {
                    this.jj_la1[202] = this.jj_gen;
                    break block25;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: 
                case 46: 
                case 65: 
                case 115: {
                    correlateClause = this.JoinOrUnnestClause(JoinType.INNER, UnnestType.INNER);
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    correlateClause = this.JoinOrUnnestClause(JoinType.INNER, UnnestType.INNER);
                    break;
                }
                case 69: {
                    this.jj_consume_token(69);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 86: {
                            this.jj_consume_token(86);
                            break;
                        }
                        default: {
                            this.jj_la1[203] = this.jj_gen;
                        }
                    }
                    correlateClause = this.JoinOrUnnestClause(JoinType.LEFTOUTER, UnnestType.LEFTOUTER);
                    break;
                }
                case 97: {
                    this.jj_consume_token(97);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 86: {
                            this.jj_consume_token(86);
                            break;
                        }
                        default: {
                            this.jj_la1[204] = this.jj_gen;
                        }
                    }
                    correlateClause = this.JoinClause(JoinType.RIGHTOUTER);
                    break;
                }
                case 18: {
                    this.jj_consume_token(18);
                    correlateClause = this.CrossJoinClause();
                    break;
                }
                default: {
                    this.jj_la1[205] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            correlateClauses.add(correlateClause);
        }
        if (leftVar == null) {
            leftVar = ExpressionToVariableUtil.getGeneratedVariable(leftExpr, true);
        }
        FromTerm fromTerm = new FromTerm(leftExpr, leftVar, posVar, correlateClauses);
        fromTerm.setSourceLocation(leftExpr.getSourceLocation());
        return fromTerm;
    }

    public final AbstractBinaryCorrelateClause JoinOrUnnestClause(JoinType joinType, UnnestType unnestType) throws ParseException, ParseException {
        AbstractBinaryCorrelateClause correlateClause = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                correlateClause = this.JoinClause(joinType);
                break;
            }
            case 22: 
            case 46: 
            case 115: {
                correlateClause = this.UnnestClause(unnestType);
                break;
            }
            default: {
                this.jj_la1[206] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return correlateClause;
    }

    public final JoinClause JoinClause(JoinType joinType) throws ParseException, ParseException {
        Token startToken = null;
        Triple<Expression, VariableExpr, VariableExpr> rightInput = null;
        Expression conditionExpr = null;
        this.jj_consume_token(65);
        startToken = this.token;
        rightInput = this.JoinClauseRightInput();
        this.jj_consume_token(82);
        conditionExpr = this.Expression();
        JoinClause joinClause = new JoinClause(joinType, (Expression)rightInput.first, (VariableExpr)rightInput.second, (VariableExpr)rightInput.third, conditionExpr, joinType == JoinType.INNER ? null : Literal.Type.MISSING);
        return SQLPPParser.addSourceLocation(joinClause, startToken);
    }

    public final JoinClause CrossJoinClause() throws ParseException, ParseException {
        Token startToken = null;
        Triple<Expression, VariableExpr, VariableExpr> rightInput = null;
        Object conditionExpr = null;
        this.jj_consume_token(65);
        startToken = this.token;
        rightInput = this.JoinClauseRightInput();
        JoinClause joinClause = new JoinClause(JoinType.INNER, (Expression)rightInput.first, (VariableExpr)rightInput.second, (VariableExpr)rightInput.third, (Expression)new LiteralExpr((Literal)TrueLiteral.INSTANCE), null);
        return SQLPPParser.addSourceLocation(joinClause, startToken);
    }

    public final Triple<Expression, VariableExpr, VariableExpr> JoinClauseRightInput() throws ParseException, ParseException {
        Token hintToken;
        Expression rightExpr = null;
        VariableExpr rightVar = null;
        VariableExpr posVar = null;
        rightExpr = this.Expression();
        if (rightExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION && (hintToken = this.fetchHint(this.token, SqlppHint.SUBPATH_HINT)) != null) {
            String subPath = hintToken.hintParams;
            ((VariableExpr)rightExpr).addHint((IExpressionAnnotation)new ExternalSubpathAnnotation(subPath));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 167: 
            case 168: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[207] = this.jj_gen;
                    }
                }
                rightVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[208] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[209] = this.jj_gen;
            }
        }
        if (rightVar == null) {
            rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
        }
        return new Triple((Object)rightExpr, (Object)rightVar, (Object)posVar);
    }

    public final UnnestClause UnnestClause(UnnestType unnestType) throws ParseException, ParseException {
        Token startToken = null;
        Expression rightExpr = null;
        VariableExpr rightVar = null;
        VariableExpr posVar = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            default: {
                this.jj_la1[210] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        startToken = this.token;
        rightExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 167: 
            case 168: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[211] = this.jj_gen;
                    }
                }
                rightVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[212] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[213] = this.jj_gen;
            }
        }
        if (rightVar == null) {
            rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
        }
        UnnestClause unnestClause = new UnnestClause(unnestType, rightExpr, rightVar, posVar, unnestType == UnnestType.INNER ? null : Literal.Type.MISSING);
        return SQLPPParser.addSourceLocation(unnestClause, startToken);
    }

    public final List<LetClause> LetClause() throws ParseException, ParseException {
        ArrayList<LetClause> letList = new ArrayList<LetClause>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 70: 
            case 71: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        this.jj_consume_token(71);
                        break;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        break;
                    }
                    default: {
                        this.jj_la1[214] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                LetClause letClause = this.LetElement();
                letList.add(letClause);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[215] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(139);
                    letClause = this.LetElement();
                    letList.add(letClause);
                }
            }
            case 125: {
                this.jj_consume_token(125);
                LetClause letClause = this.WithElement();
                letList.add(letClause);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[216] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(139);
                    letClause = this.WithElement();
                    letList.add(letClause);
                }
            }
            default: {
                this.jj_la1[217] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return letList;
    }

    public final WhereClause WhereClause() throws ParseException, ParseException {
        Token startToken = null;
        this.jj_consume_token(124);
        startToken = this.token;
        Expression whereExpr = this.Expression();
        WhereClause wc = new WhereClause(whereExpr);
        return SQLPPParser.addSourceLocation(wc, startToken);
    }

    public final OrderbyClause OrderbyClause() throws ParseException, ParseException {
        Token startToken = null;
        OrderbyClause oc = new OrderbyClause();
        Triple<Expression, OrderbyClause.OrderModifier, OrderbyClause.NullOrderModifier> orderbyExpr = null;
        ArrayList<Expression> orderbyList = new ArrayList<Expression>();
        ArrayList<OrderbyClause.OrderModifier> modifierList = new ArrayList<OrderbyClause.OrderModifier>();
        ArrayList<OrderbyClause.NullOrderModifier> nullModifierList = new ArrayList<OrderbyClause.NullOrderModifier>();
        this.jj_consume_token(85);
        startToken = this.token;
        Token hintToken = this.fetchHint(this.token, SqlppHint.INMEMORY_HINT, SqlppHint.RANGE_HINT);
        if (hintToken != null) {
            switch (hintToken.hint) {
                case INMEMORY_HINT: {
                    String[] splits = hintToken.hintParams.split("\\s+");
                    int numFrames = Integer.parseInt(splits[0]);
                    int numTuples = Integer.parseInt(splits[1]);
                    oc.setNumFrames(numFrames);
                    oc.setNumTuples(numTuples);
                    break;
                }
                case RANGE_HINT: {
                    try {
                        Expression rangeExpr = SQLPPParser.parseExpression(hintToken.hintParams);
                        RangeMap rangeMap = RangeMapBuilder.parseHint((Expression)rangeExpr);
                        oc.setRangeMap(rangeMap);
                        break;
                    }
                    catch (CompilationException e) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), e.getMessage());
                    }
                }
            }
        }
        this.jj_consume_token(13);
        orderbyExpr = this.OrderByExpression();
        orderbyList.add((Expression)orderbyExpr.first);
        modifierList.add((OrderbyClause.OrderModifier)orderbyExpr.second);
        nullModifierList.add((OrderbyClause.NullOrderModifier)orderbyExpr.third);
        while (this.jj_2_23(2)) {
            this.jj_consume_token(139);
            orderbyExpr = this.OrderByExpression();
            orderbyList.add((Expression)orderbyExpr.first);
            modifierList.add((OrderbyClause.OrderModifier)orderbyExpr.second);
            nullModifierList.add((OrderbyClause.NullOrderModifier)orderbyExpr.third);
        }
        oc.setOrderbyList(orderbyList);
        oc.setModifierList(modifierList);
        oc.setNullModifierList(nullModifierList);
        return SQLPPParser.addSourceLocation(oc, startToken);
    }

    public final Triple<Expression, OrderbyClause.OrderModifier, OrderbyClause.NullOrderModifier> OrderByExpression() throws ParseException, ParseException {
        Expression orderbyExpr = null;
        OrderbyClause.OrderModifier modif = OrderbyClause.OrderModifier.ASC;
        OrderbyClause.NullOrderModifier nullModif = null;
        orderbyExpr = this.Expression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: 
            case 29: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        modif = OrderbyClause.OrderModifier.ASC;
                        break block0;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        modif = OrderbyClause.OrderModifier.DESC;
                        break block0;
                    }
                }
                this.jj_la1[218] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[219] = this.jj_gen;
            }
        }
        if (this.laIdentifier(NULLS)) {
            this.jj_consume_token(167);
            this.expectToken(NULLS);
            this.jj_consume_token(167);
            if (this.isToken(FIRST)) {
                nullModif = OrderbyClause.NullOrderModifier.FIRST;
            } else if (this.isToken(LAST)) {
                nullModif = OrderbyClause.NullOrderModifier.LAST;
            } else {
                throw this.createUnexpectedTokenError();
            }
        }
        return new Triple((Object)orderbyExpr, (Object)modif, nullModif);
    }

    public final GroupbyClause GroupbyClause() throws ParseException, ParseException {
        Token startToken = null;
        GroupbyClause gbc = new GroupbyClause();
        List<List<GbyVariableExpressionPair>> gbyList = null;
        List<SqlppGroupingSetsParser.GroupingElement> groupingElementList = null;
        Pair<VariableExpr, List<Pair<Expression, Identifier>>> groupVarWithFieldList = null;
        VariableExpr groupVar = null;
        List groupFieldList = null;
        Scope newScope = this.extendCurrentScopeNoPush(true);
        this.jj_consume_token(52);
        startToken = this.token;
        Token hintToken = this.fetchHint(this.token, SqlppHint.HASH_GROUP_BY_HINT);
        if (hintToken != null) {
            gbc.setHashGroupByHint(true);
        }
        this.jj_consume_token(13);
        groupingElementList = this.GroupingElementList();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(7);
                groupVarWithFieldList = this.VariableWithFieldMap();
                groupVar = (VariableExpr)groupVarWithFieldList.first;
                groupFieldList = (List)groupVarWithFieldList.second;
                break;
            }
            default: {
                this.jj_la1[220] = this.jj_gen;
            }
        }
        if (this.groupingSetsParser == null) {
            this.groupingSetsParser = new SqlppGroupingSetsParser();
        }
        SourceLocation sourceLoc = SQLPPParser.getSourceLocation(startToken);
        try {
            gbyList = this.groupingSetsParser.parse(groupingElementList, sourceLoc);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(sourceLoc, e.getMessage());
        }
        gbc.setGbyPairList(gbyList);
        gbc.setDecorPairList(new ArrayList());
        gbc.setWithVarMap(new HashMap());
        gbc.setGroupVar(groupVar);
        gbc.setGroupFieldList(groupFieldList);
        this.replaceCurrentScope(newScope);
        return SQLPPParser.addSourceLocation(gbc, startToken);
    }

    public final List<SqlppGroupingSetsParser.GroupingElement> GroupingElementList() throws ParseException, ParseException {
        ArrayList<SqlppGroupingSetsParser.GroupingElement> groupingElementList = new ArrayList<SqlppGroupingSetsParser.GroupingElement>();
        SqlppGroupingSetsParser.GroupingElement groupingElement = null;
        groupingElement = this.GroupingElement();
        groupingElementList.add(groupingElement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[221] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            groupingElement = this.GroupingElement();
            groupingElementList.add(groupingElement);
        }
        return groupingElementList;
    }

    public final SqlppGroupingSetsParser.GroupingElement GroupingElement() throws ParseException, ParseException {
        SqlppGroupingSetsParser.GroupingElement groupingElement = null;
        List<SqlppGroupingSetsParser.GroupingSet> groupingSets = null;
        List<SqlppGroupingSetsParser.GroupingElement> groupingElements = null;
        if (this.jj_2_24(2)) {
            this.jj_consume_token(133);
            this.jj_consume_token(134);
            groupingElement = SqlppGroupingSetsParser.GroupingSet.EMPTY;
        } else if (this.laIdentifier(ROLLUP) && this.laToken(2, 133)) {
            this.jj_consume_token(167);
            this.expectToken(ROLLUP);
            this.jj_consume_token(133);
            groupingSets = this.OrdinaryGroupingSetList();
            this.jj_consume_token(134);
            groupingElement = new SqlppGroupingSetsParser.RollupCube(groupingSets, false);
        } else if (this.laIdentifier(CUBE) && this.laToken(2, 133)) {
            this.jj_consume_token(167);
            this.expectToken(CUBE);
            this.jj_consume_token(133);
            groupingSets = this.OrdinaryGroupingSetList();
            this.jj_consume_token(134);
            groupingElement = new SqlppGroupingSetsParser.RollupCube(groupingSets, true);
        } else if (this.laIdentifier(GROUPING) && this.laIdentifier(2, SETS) && this.laToken(3, 133)) {
            this.jj_consume_token(167);
            this.expectToken(GROUPING);
            this.jj_consume_token(167);
            this.expectToken(SETS);
            this.jj_consume_token(133);
            groupingElements = this.GroupingElementList();
            this.jj_consume_token(134);
            groupingElement = new SqlppGroupingSetsParser.GroupingSets(groupingElements);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 14: 
                case 39: 
                case 41: 
                case 43: 
                case 75: 
                case 79: 
                case 80: 
                case 104: 
                case 111: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 142: 
                case 153: 
                case 155: 
                case 158: 
                case 159: 
                case 160: 
                case 167: 
                case 168: 
                case 169: 
                case 179: 
                case 180: 
                case 181: {
                    groupingElement = this.OrdinaryGroupingSet();
                    break;
                }
                default: {
                    this.jj_la1[222] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return groupingElement;
    }

    public final SqlppGroupingSetsParser.GroupingSet OrdinaryGroupingSet() throws ParseException, ParseException {
        GbyVariableExpressionPair gbyExprPair = null;
        List<GbyVariableExpressionPair> items = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                this.jj_consume_token(133);
                items = this.GbyVariableExpressionPairList();
                this.jj_consume_token(134);
                break;
            }
            case 5: 
            case 14: 
            case 39: 
            case 41: 
            case 43: 
            case 75: 
            case 79: 
            case 80: 
            case 104: 
            case 111: 
            case 130: 
            case 132: 
            case 135: 
            case 142: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 167: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: {
                gbyExprPair = this.GbyVariableExpressionPair();
                items = Collections.singletonList(gbyExprPair);
                break;
            }
            default: {
                this.jj_la1[223] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlppGroupingSetsParser.GroupingSet(items);
    }

    public final List<SqlppGroupingSetsParser.GroupingSet> OrdinaryGroupingSetList() throws ParseException, ParseException {
        SqlppGroupingSetsParser.GroupingSet groupingSet = null;
        ArrayList<SqlppGroupingSetsParser.GroupingSet> items = new ArrayList<SqlppGroupingSetsParser.GroupingSet>();
        groupingSet = this.OrdinaryGroupingSet();
        items.add(groupingSet);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[224] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            groupingSet = this.OrdinaryGroupingSet();
            items.add(groupingSet);
        }
        return items;
    }

    public final List<GbyVariableExpressionPair> GbyVariableExpressionPairList() throws ParseException, ParseException {
        GbyVariableExpressionPair gbyExprPair = null;
        ArrayList<GbyVariableExpressionPair> items = new ArrayList<GbyVariableExpressionPair>();
        gbyExprPair = this.GbyVariableExpressionPair();
        items.add(gbyExprPair);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[225] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            gbyExprPair = this.GbyVariableExpressionPair();
            items.add(gbyExprPair);
        }
        return items;
    }

    public final GbyVariableExpressionPair GbyVariableExpressionPair() throws ParseException, ParseException {
        Expression expr = null;
        VariableExpr var = null;
        expr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 167: 
            case 168: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[226] = this.jj_gen;
                    }
                }
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[227] = this.jj_gen;
            }
        }
        return new GbyVariableExpressionPair(var, expr);
    }

    public final HavingClause HavingClause() throws ParseException, ParseException {
        Token startToken = null;
        Expression filterExpr = null;
        this.jj_consume_token(53);
        startToken = this.token;
        filterExpr = this.Expression();
        HavingClause havingClause = new HavingClause(filterExpr);
        return SQLPPParser.addSourceLocation(havingClause, startToken);
    }

    public final LimitClause LimitClause() throws ParseException, ParseException {
        Token startToken = null;
        Expression limitExpr = null;
        Expression offsetExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                startToken = this.token;
                this.pushForbiddenScope(this.getCurrentScope());
                limitExpr = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 81: {
                        this.jj_consume_token(81);
                        offsetExpr = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[228] = this.jj_gen;
                    }
                }
                this.popForbiddenScope();
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                startToken = this.token;
                this.pushForbiddenScope(this.getCurrentScope());
                offsetExpr = this.Expression();
                this.popForbiddenScope();
                break;
            }
            default: {
                this.jj_la1[229] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        LimitClause lc = new LimitClause(limitExpr, offsetExpr);
        return SQLPPParser.addSourceLocation(lc, startToken);
    }

    public final QuantifiedExpression QuantifiedExpression() throws ParseException, ParseException {
        Token startToken = null;
        QuantifiedExpression qc = new QuantifiedExpression();
        ArrayList<QuantifiedPair> quantifiedList = new ArrayList<QuantifiedPair>();
        this.createNewScope();
        if (this.jj_2_25(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    break;
                }
                case 104: {
                    this.jj_consume_token(104);
                    break;
                }
                default: {
                    this.jj_la1[230] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(4);
            this.jj_consume_token(39);
            startToken = this.token;
            qc.setQuantifier(QuantifiedExpression.Quantifier.SOME_AND_EVERY);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 104: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            this.jj_consume_token(5);
                            break;
                        }
                        case 104: {
                            this.jj_consume_token(104);
                            break;
                        }
                        default: {
                            this.jj_la1[231] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    startToken = this.token;
                    qc.setQuantifier(QuantifiedExpression.Quantifier.SOME);
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    startToken = this.token;
                    qc.setQuantifier(QuantifiedExpression.Quantifier.EVERY);
                    break;
                }
                default: {
                    this.jj_la1[232] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        VariableExpr var = this.Variable();
        this.jj_consume_token(57);
        Expression inExpr = this.Expression();
        QuantifiedPair pair = new QuantifiedPair(var, inExpr);
        quantifiedList.add(pair);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[233] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(139);
            var = this.Variable();
            this.jj_consume_token(57);
            inExpr = this.Expression();
            pair = new QuantifiedPair(var, inExpr);
            quantifiedList.add(pair);
        }
        this.jj_consume_token(100);
        Expression satisfiesExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            default: {
                this.jj_la1[234] = this.jj_gen;
            }
        }
        qc.setSatisfiesExpr(satisfiesExpr);
        qc.setQuantifiedList(quantifiedList);
        this.removeCurrentScope();
        return SQLPPParser.addSourceLocation(qc, startToken);
    }

    public final LetClause LetElement() throws ParseException, ParseException {
        this.extendCurrentScope();
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(149);
        Expression beExp = this.Expression();
        LetClause lc = new LetClause(varExp, beExp);
        lc.setSourceLocation(varExp.getSourceLocation());
        return lc;
    }

    public final LetClause WithElement() throws ParseException, ParseException {
        this.extendCurrentScope();
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(7);
        Expression beExp = this.Expression();
        LetClause lc = new LetClause(varExp, beExp);
        lc.setSourceLocation(varExp.getSourceLocation());
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    private boolean jj_3R_97() {
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(68)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(121)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.laIdentifier(CURRENT) || this.laIdentifier(UNBOUNDED);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_98()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(114);
    }

    private boolean jj_3R_136() {
        return this.jj_3R_102();
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_62() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_101() {
        return this.jj_3R_74();
    }

    private boolean jj_3R_130() {
        return this.jj_3R_138();
    }

    private boolean jj_3_21() {
        if (this.jj_3R_76()) {
            return true;
        }
        if (this.jj_scan_token(140)) {
            return true;
        }
        return this.jj_scan_token(131);
    }

    private boolean jj_3R_120() {
        return this.jj_3R_131();
    }

    private boolean jj_3R_61() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_100() {
        return this.jj_scan_token(131);
    }

    private boolean jj_3R_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_120()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(153)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_121()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_75() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_101()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_65()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_60() {
        if (this.jj_3R_90()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_140() {
        return this.jj_scan_token(83);
    }

    private boolean jj_3R_139() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_76() {
        return this.jj_3R_102();
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(138)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_53();
    }

    private boolean jj_3R_131() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_140()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_133() {
        return this.jj_3R_102();
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_84() {
        return this.jj_3R_107();
    }

    private boolean jj_3R_180() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_83() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_105();
    }

    private boolean jj_3R_179() {
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_81() {
        return this.jj_3R_104();
    }

    private boolean jj_3R_80() {
        return this.jj_scan_token(169);
    }

    private boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_81()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_82()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_83()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_84()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_52() {
        Token xsp;
        if (this.jj_3R_80()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_80());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_18() {
        return this.jj_3R_73();
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_75();
    }

    private boolean jj_3R_178() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_123() {
        return this.jj_3R_133();
    }

    private boolean jj_3R_177() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_70() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_176() {
        return this.jj_scan_token(159);
    }

    private boolean jj_3R_115() {
        return this.jj_3R_127();
    }

    private boolean jj_3R_122() {
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_112() {
        return this.jj_scan_token(168);
    }

    private boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_88() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_114() {
        if (this.jj_scan_token(167)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_74();
    }

    private boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_88()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_175() {
        return this.jj_scan_token(160);
    }

    private boolean jj_3R_85() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_60();
    }

    private boolean jj_3R_113() {
        if (this.jj_3R_126()) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_174() {
        return this.jj_scan_token(158);
    }

    private boolean jj_3R_69() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(133)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_114()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_58() {
        if (this.jj_3R_60()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_173() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_54() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_166() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_174()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_175()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_176()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_177()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_178()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_179()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_180()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_212() {
        return this.jj_scan_token(102);
    }

    private boolean jj_3_14() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_69());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(133);
    }

    private boolean jj_3R_51() {
        return false;
    }

    private boolean jj_3R_163() {
        return this.jj_3R_170();
    }

    private boolean jj_3R_162() {
        return this.jj_3R_169();
    }

    private boolean jj_3R_161() {
        return this.jj_3R_168();
    }

    private boolean jj_3R_160() {
        return this.jj_3R_167();
    }

    private boolean jj_3R_72() {
        if (this.jj_scan_token(167)) {
            return true;
        }
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_159() {
        return this.jj_3R_76();
    }

    private boolean jj_3R_158() {
        return this.jj_3R_166();
    }

    private boolean jj_3R_157() {
        return this.jj_3R_165();
    }

    private boolean jj_3R_156() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_149() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_156()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_157()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_158()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_159()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_160()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_161()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_162()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_163()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(167)) {
            return true;
        }
        if (this.jj_scan_token(167)) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_4() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.laIdentifier(META) && this.laToken(2, 133) && this.laToken(3, 134);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_51()) {
            return true;
        }
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_95() {
        if (this.jj_scan_token(167)) {
            return true;
        }
        return this.jj_scan_token(167);
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_scan_token(167)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_211() {
        return this.jj_3R_213();
    }

    private boolean jj_3R_57() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_50() {
        return false;
    }

    private boolean jj_3R_94() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_194() {
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_94()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_95()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(88)) {
            return true;
        }
        return this.jj_3R_96();
    }

    private boolean jj_3R_78() {
        return this.jj_3R_74();
    }

    private boolean jj_3_3() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.laIdentifier(META) && this.laToken(2, 133) && this.laToken(3, 134);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_50()) {
            return true;
        }
        return this.jj_scan_token(167);
    }

    private boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(145)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(146)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(147)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(148)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(149)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(150)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(151)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(152)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_56()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_57()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_58();
    }

    private boolean jj_3R_124() {
        if (this.jj_3R_58()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_193() {
        return this.jj_scan_token(140);
    }

    private boolean jj_3_7() {
        return this.jj_3R_54();
    }

    private boolean jj_3_23() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_189() {
        return this.jj_3R_194();
    }

    private boolean jj_3_15() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_188() {
        return this.jj_3R_193();
    }

    private boolean jj_3R_171() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_188()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_189()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_210() {
        return this.jj_3R_212();
    }

    private boolean jj_3R_143() {
        Token xsp;
        if (this.jj_3R_149()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_171());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_207() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_210()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_211()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_124();
    }

    private boolean jj_3R_155() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_148() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_155()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(167)) {
            return true;
        }
        return this.jj_3R_52();
    }

    private boolean jj_3R_192() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_3R_202();
    }

    private boolean jj_3R_127() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_142() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(132)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(130)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_148()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_143();
    }

    private boolean jj_3R_164() {
        if (this.jj_3R_172()) {
            return true;
        }
        return this.jj_scan_token(133);
    }

    private boolean jj_3R_110() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_86() {
        Token xsp;
        if (this.jj_3R_109()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_110());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_209() {
        return this.jj_scan_token(125);
    }

    private boolean jj_3R_208() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(71)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(70)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_206() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_208()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_209()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_205() {
        return this.jj_3R_207();
    }

    private boolean jj_3R_150() {
        return this.jj_scan_token(127);
    }

    private boolean jj_3R_125() {
        if (this.jj_3R_135()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_150()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_200() {
        return this.jj_3R_74();
    }

    private boolean jj_3R_93() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_92() {
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_92()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_93()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_87() {
        return this.jj_scan_token(84);
    }

    private boolean jj_3R_204() {
        return this.jj_3R_206();
    }

    private boolean jj_3R_202() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_204()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_205();
    }

    private boolean jj_3R_55() {
        Token xsp;
        if (this.jj_3R_86()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_87());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_198() {
        return this.jj_3R_200();
    }

    private boolean jj_3R_169() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_198()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_147() {
        return this.jj_scan_token(130);
    }

    private boolean jj_3R_154() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(76)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(141)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_99() {
        return this.jj_3R_116();
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_152() {
        return this.jj_scan_token(129);
    }

    private boolean jj_3R_151() {
        return this.jj_scan_token(131);
    }

    private boolean jj_3_8() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_145() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_151()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_153()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_154()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_99()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_111() {
        Token xsp;
        if (this.jj_3R_125()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_145());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_197() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_103() {
        if (this.jj_3R_68()) {
            return true;
        }
        return this.jj_3R_104();
    }

    private boolean jj_3R_203() {
        return this.jj_3R_74();
    }

    private boolean jj_3R_201() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_203()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_196() {
        return this.jj_scan_token(123);
    }

    private boolean jj_3R_195() {
        return this.jj_3R_74();
    }

    private boolean jj_3R_165() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_195()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_196());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_197()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_129() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_79() {
        return this.jj_3R_103();
    }

    private boolean jj_3R_128() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(104)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(104)) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_191() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        if (this.jj_3R_201()) {
            return true;
        }
        return this.jj_scan_token(156);
    }

    private boolean jj_3R_199() {
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(132);
    }

    private boolean jj_3R_141() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_147()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_172() {
        if (this.jj_3R_138()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_199()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_128()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_129()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_91() {
        Token xsp;
        if (this.jj_3R_111()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_141());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_49() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_3R_79();
    }

    private boolean jj_3R_187() {
        return this.jj_3R_192();
    }

    private boolean jj_3R_190() {
        if (this.jj_scan_token(135)) {
            return true;
        }
        if (this.jj_3R_201()) {
            return true;
        }
        return this.jj_scan_token(136);
    }

    private boolean jj_3R_186() {
        return this.jj_3R_191();
    }

    private boolean jj_3R_106() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        if (this.jj_3R_53()) {
            return true;
        }
        return this.jj_scan_token(156);
    }

    private boolean jj_3R_185() {
        return this.jj_3R_190();
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_3R_74();
    }

    private boolean jj_3R_170() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_187()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_168() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_185()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_186()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_134() {
        return this.jj_scan_token(128);
    }

    private boolean jj_3R_105() {
        if (this.jj_scan_token(135)) {
            return true;
        }
        if (this.jj_3R_53()) {
            return true;
        }
        return this.jj_scan_token(136);
    }

    private boolean jj_3R_67() {
        Token xsp;
        if (this.jj_3R_91()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_134());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_184() {
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_183() {
        return this.jj_scan_token(181);
    }

    private boolean jj_3R_182() {
        return this.jj_scan_token(179);
    }

    private boolean jj_3R_181() {
        return this.jj_scan_token(180);
    }

    private boolean jj_3R_167() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_181()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_182()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_183()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_184()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_118() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_104() {
        return this.jj_3R_119();
    }

    private boolean jj_3R_119() {
        return this.jj_3R_130();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_74();
    }

    private boolean jj_3R_132() {
        if (this.jj_3R_68()) {
            return true;
        }
        return this.jj_scan_token(138);
    }

    private boolean jj_3R_137() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        if (this.jj_3R_76()) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_126() {
        if (this.jj_3R_136()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_137()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(72)) {
            return true;
        }
        return this.jj_3R_67();
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_77();
    }

    private boolean jj_3R_144() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_90() {
        if (this.jj_3R_67()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_213() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_121() {
        return this.jj_3R_132();
    }

    private boolean jj_3R_117() {
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_117()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_118()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_138() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_144());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(125)) {
            return true;
        }
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_98() {
        return this.jj_3R_74();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1412579368, 1412579368, 0, 0, 1412579368, 58720258, 0, 0, 0x1800000, 0, 0x1800000, 0, 1024, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 16416, 0, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 0, 58720258, 0, 0, 128, 0, 128, 0, 128, 128, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0x40200000, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 65536, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16416, 32, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16416, 0, 16416, 16384, 0, 0, 0, 0, 0, 0, 0, 16416, 0, 16416, 0, Integer.MIN_VALUE, 16416, 0, -2147467232, 0, 0, 0, 0, 2048, 0, 0, 0, 16416, 0, 0, 0, 16416, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2147483644, -2147483644, 16416, 16416, 0, 128, 128, 0, 16416, 128, 128, 512, 0x440000, 0, 0, 0x440000, 0x400000, 128, 128, 512, 0x400000, 128, 128, 512, 0, 0, 0, 0, 0x20000100, 0x20000100, 0, 0, 16416, 16416, 0, 0, 128, 128, 0, 0, 32, 32, 32, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{536939146, 536939146, 0, 8, 536939138, 1275859968, 524288, 0, 0, 0x40000000, 0x40000400, 0, 0, 0x400000, 0, 0x400000, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 68224, 0, 0, 0, 0, 8192, 0x800000, 0, 0, 0, 0xC0C1000, 8192, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0x20800000, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2048, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68224, 128, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 512, 512, 0, 0, 2688, 0, 2688, 2048, 2048, 0, 0, 0, 0, 0, 0, 2688, 0, 2688, 0, 0, 2688, 0, 2688, 8192, 0, 0, 0, 0, 0, 0, 0, 2688, 0x100000, 0, 0, 2688, 0, 16, 0, 0, 0, -2147483392, -2147483392, 0, 65536, 0, 0, 0, 0x200000, 0x100000, 0, 65536, 65536, 0, 0, 0, 0x200000, 0x100000, 65536, 0, 0, 2692, 2692, 4, 0, 0, 0, 2688, 0, 0, 0, 0x10004000, 0, 0, 0x10004000, 16384, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 2688, 2688, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 64};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{1073843392, 1073843392, 0, 0, 1073843392, 0x10102000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 32768, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16388, 0x10000000, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 100544, 0, 0, 0, 0x6000000, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 524288, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100544, 0, 0x100000, 0, 32768, 32768, 32769, 32768, 32768, 16, 67600, 32768, 0, 0, 0, 4096, 4096, 4096, 0, 32768, 32768, 32768, 0, 0, 100352, 0, 100352, 67584, 67584, 0, 0, 0, 0, 0, 0, 100352, 0, 100352, 0, 0, 100352, 0, 100352, 0, 0, 0, 0, 0, 0, 0, 0x200000, 100352, 0, 0, 0, 100352, 0, 0, 192, 0x200000, 131584, 0, 0, 0, 0, 192, 0, 192, 0, 0, 0, 192, 192, 192, 0, 192, 0, 0, 0, 0, 0, 536971264, 536971264, 0x20000000, 0, 0, 0, 100352, 0, 0, 0, 34, 0x400000, 0x400000, 34, 2, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 192, 0, 0, 0, 0, 100352, 100352, 0, 0, 0, 0, 131072, 131584, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{1617987520, 1617987520, 0, 0, 1617987520, 67176448, 0x4000000, 0, 0, 0, 0, 0x20000000, 0, 0, 0x20000000, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 524288, 524288, 0, 0, 524288, 0, 0, 0, 64, 64, 0, 0, 65536, 0x800000, 4, 0, 0, 0, 0, 0x20000040, 0x20000000, 0, 0, 0, 0, 0, 536904000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67176448, 0, 0, 0, 1, 0, 1, 0, 0, 0x10000000, 0, 0, 0x100080, 0x800000, 0, 0, 0x20000000, 1536, 0, 0x800000, 0x10000000, 0, 0, 32768, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 536904000, 256, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0x2040000, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 33024, 0, 33024, 32768, 32768, 0, 0, 0, 0, 0, 0, 33024, 0, 33024, 0, 0, 33024, 0, 33024, 0, 0, 0, 0, 0, 0, 0, 0, 33024, 0, 0, 0, 33024, 0x8000000, 0, 0x20000000, 0, 0, 131072, 131072, 0, 64, 0x20000000, 0x10000000, 0x20000000, 0, 0, 0x10000000, 0x20000000, 0x20000000, 0x20000000, 0x10000000, 0x20000000, 0, 0, 64, 0, 0, 0x1008100, 0x1008100, 0x1000000, 0, 0, 0, 33024, 0, 0, 0, 524290, 0, 0, 524290, 524288, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 33024, 33024, 0, 0, 0, 0, 0, 0, 256, 256, 256, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{-905920332, -905953100, 32768, 0, -905953100, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 2048, 0, 0, 2048, 0, 0, 0, 0, 0, 32, 0, 0, 1024, 2048, 1024, 1024, 1024, 1024, 0, 0, 0, 0, 0, 0, 32, 4096, 0, 0, 0x2000000, 4096, 2048, 4096, 1024, -905953100, 2048, 0, 0, 0, 0, 0, 2048, 544, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 32, 0, 0, 2048, 32, 0, 0x40000000, 16384, 0xA000080, 0, 0, 2048, 0, 16384, 65536, 0, 2048, 4, 2048, 4, 1024, 32, 4096, 0, 0, 4096, 4096, -905953100, 0, 0, 0, 0, 0, 33423360, 0, 0, 0, 0, 0, 1, 20, 20, 8202, 8192, 8202, 0, 0, 20, 20, 4224, 4224, -905953100, 1024, -905953092, -905953120, -1073741824, 0, 2048, 32, 16384, 0x8000080, 2048, -905953100, 2048, -905953100, 1024, 0, -905953092, 2048, -905953092, 0, 0, 2048, 0, 0, 0, 0, 0, -905953100, 0, 2048, 32, -905953100, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -905953092, -905953092, 0, 0, 0, 8, -905953100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 2048, 0, 0, 0, 0, 2048, -905953100, -905953100, 2048, 2048, 0, 0, 0, 0, 0, 0, 0, 2048, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{3670913, 3670913, 0, 0, 3670913, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 384, 0, 384, 384, 0, 0, 0, 0, 0, 0, 0, 384, 0, 0, 0, 0, 128, 0, 0, 384, 0, 0, 384, 0, 384, 0, 3670913, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 768, 0, 0, 896, 768, 0, 384, 0, 0, 0, 384, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0, 768, 512, 0, 0, 3670913, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3670913, 0, 3670913, 3670913, 513, 384, 0, 0, 0x380000, 0, 0, 3670913, 0, 3670913, 0, 0, 3670913, 0, 3670913, 0, 384, 0, 128, 0, 128, 128, 0, 3670913, 128, 0, 0, 3670913, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3670913, 3670913, 0, 0, 384, 0, 3670913, 0, 384, 0, 0, 0, 0, 0, 0, 0, 384, 0, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3670913, 3670913, 0, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SQLPPParser(InputStream stream) {
        this(stream, null);
    }

    public SQLPPParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 235; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 235; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLPPParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 235; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 235; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLPPParser(SQLPPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 235; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SQLPPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 235; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[195];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 235; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 195; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 25; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SQLPPParser.jj_la1_init_0();
        SQLPPParser.jj_la1_init_1();
        SQLPPParser.jj_la1_init_2();
        SQLPPParser.jj_la1_init_3();
        SQLPPParser.jj_la1_init_4();
        SQLPPParser.jj_la1_init_5();
        SQLPPParser.jj_la1_init_6();
    }

    @FunctionalInterface
    private static interface ParseFunction<T> {
        public T parse() throws ParseException;
    }

    private static class IndexParams {
        public DatasetConfig.IndexType type;
        public int gramLength;
        public String fullTextConfig;

        public IndexParams(DatasetConfig.IndexType type, int gramLength, String fullTextConfig) {
            this.type = type;
            this.gramLength = gramLength;
            this.fullTextConfig = fullTextConfig;
        }
    }

    private static class FunctionName {
        public DataverseName dataverse;
        public String library;
        public String function;
        public Token hintToken;
        public SourceLocation sourceLoc;

        private FunctionName() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

