/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractAsynchronousScheduler;

public class GreedyScheduler
extends AbstractAsynchronousScheduler {
    public static ILSMIOOperationSchedulerFactory FACTORY = new ILSMIOOperationSchedulerFactory(){

        @Override
        public ILSMIOOperationScheduler createIoScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback, int maxNumRunningFlushes, int maxNumScheduledMerges, int maxNumRunningMerges) {
            return new GreedyScheduler(threadFactory, callback, maxNumRunningFlushes, maxNumScheduledMerges, maxNumRunningMerges);
        }

        @Override
        public String getName() {
            return "greedy";
        }
    };
    private final int maxNumScheduledMerges;
    private final int maxNumRunningMerges;
    private int numScheduledMerges;
    private final Map<String, Set<ILSMIOOperation>> scheduledMergeOperations = new HashMap<String, Set<ILSMIOOperation>>();
    private final Map<String, ILSMIOOperation> runningMergeOperations = new HashMap<String, ILSMIOOperation>();

    public GreedyScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback, int maxNumRunningFlushes, int maxNumScheduledMerges, int maxNumRunningMerges) {
        super(threadFactory, callback, maxNumRunningFlushes);
        this.maxNumScheduledMerges = maxNumScheduledMerges;
        this.maxNumRunningMerges = maxNumRunningMerges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scheduleMerge(ILSMIOOperation operation) {
        operation.pause();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            if (this.numScheduledMerges >= this.maxNumScheduledMerges) {
                this.waitingMergeOperations.add(operation);
            } else {
                this.doScheduleMerge(operation);
            }
        }
    }

    private void doScheduleMerge(ILSMIOOperation operation) {
        String indexIdentier = operation.getIndexIdentifier();
        Set mergeOps = this.scheduledMergeOperations.computeIfAbsent(indexIdentier, k -> new HashSet());
        mergeOps.add(operation);
        this.executor.submit(operation);
        ++this.numScheduledMerges;
        this.dispatchMergeOperation(indexIdentier, mergeOps);
    }

    private void dispatchMergeOperation(String indexIdentier, Set<ILSMIOOperation> mergeOps) {
        if (!this.runningMergeOperations.containsKey(indexIdentier) && this.runningMergeOperations.size() >= this.maxNumRunningMerges) {
            return;
        }
        ILSMIOOperation runningOp = null;
        ILSMIOOperation smallestMergeOp = null;
        for (ILSMIOOperation op : mergeOps) {
            if (op.isActive()) {
                runningOp = op;
            }
            if (smallestMergeOp != null && op.getRemainingPages() >= smallestMergeOp.getRemainingPages()) continue;
            smallestMergeOp = op;
        }
        if (smallestMergeOp != runningOp) {
            if (runningOp != null) {
                runningOp.pause();
            }
            smallestMergeOp.resume();
            this.runningMergeOperations.put(indexIdentier, smallestMergeOp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completeMerge(ILSMIOOperation op) {
        String id = op.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            String indexWithMostScheduledMerges;
            Set<ILSMIOOperation> mergeOperations = this.scheduledMergeOperations.get(id);
            mergeOperations.remove(op);
            if (mergeOperations.isEmpty()) {
                this.scheduledMergeOperations.remove(id);
            }
            this.runningMergeOperations.remove(id);
            --this.numScheduledMerges;
            if (!this.waitingMergeOperations.isEmpty() && this.numScheduledMerges < this.maxNumScheduledMerges) {
                this.doScheduleMerge((ILSMIOOperation)this.waitingMergeOperations.poll());
            }
            if (this.runningMergeOperations.size() < this.maxNumRunningMerges && (indexWithMostScheduledMerges = this.findIndexWithMostScheduledMerges()) != null) {
                this.dispatchMergeOperation(indexWithMostScheduledMerges, this.scheduledMergeOperations.get(indexWithMostScheduledMerges));
            }
        }
    }

    private String findIndexWithMostScheduledMerges() {
        String targetIndex = null;
        int maxMerges = 0;
        for (Map.Entry<String, Set<ILSMIOOperation>> e : this.scheduledMergeOperations.entrySet()) {
            if (this.runningMergeOperations.containsKey(e.getKey()) || targetIndex != null && maxMerges >= e.getValue().size()) continue;
            targetIndex = e.getKey();
            maxMerges = e.getValue().size();
        }
        return targetIndex;
    }
}

