/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.compiler.api;

import java.util.List;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.compiler.api.AbstractCompilerFactoryBuilder;
import org.apache.hyracks.algebricks.compiler.api.ICompiler;
import org.apache.hyracks.algebricks.compiler.api.ICompilerFactory;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.IConflictingTypeResolver;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.PlanCompiler;
import org.apache.hyracks.algebricks.core.rewriter.base.AbstractRuleController;
import org.apache.hyracks.algebricks.core.rewriter.base.AlgebricksOptimizationContext;
import org.apache.hyracks.algebricks.core.rewriter.base.HeuristicOptimizer;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import org.apache.hyracks.algebricks.core.rewriter.base.IRuleSetKind;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.runtime.writers.SerializedDataWriterFactory;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobSpecification;

public class HeuristicCompilerFactoryBuilder
extends AbstractCompilerFactoryBuilder {
    private final IOptimizationContextFactory optCtxFactory;

    public HeuristicCompilerFactoryBuilder() {
        this.optCtxFactory = DefaultOptimizationContextFactory.INSTANCE;
    }

    public HeuristicCompilerFactoryBuilder(IOptimizationContextFactory optCtxFactory) {
        this.optCtxFactory = optCtxFactory;
    }

    @Override
    public ICompilerFactory create() {
        return new CompilerFactoryImpl();
    }

    public static class DefaultOptimizationContextFactory
    implements IOptimizationContextFactory {
        public static final DefaultOptimizationContextFactory INSTANCE = new DefaultOptimizationContextFactory();

        private DefaultOptimizationContextFactory() {
        }

        public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IConflictingTypeResolver conflictingTypeResolver, PhysicalOptimizationConfig physicalOptimizationConfig, AlgebricksPartitionConstraint clusterLocations, IWarningCollector warningCollector) {
            IPlanPrettyPrinter prettyPrinter = PlanPrettyPrinter.createStringPlanPrettyPrinter();
            return new AlgebricksOptimizationContext((IOptimizationContextFactory)this, varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, missableTypeComputer, conflictingTypeResolver, physicalOptimizationConfig, clusterLocations, prettyPrinter, warningCollector);
        }

        public IOptimizationContext cloneOptimizationContext(IOptimizationContext oc) {
            return new AlgebricksOptimizationContext((AlgebricksOptimizationContext)oc);
        }
    }

    private class CompilerFactoryImpl
    implements ICompilerFactory {
        private CompilerFactoryImpl() {
        }

        @Override
        public ICompiler createCompiler(ILogicalPlan plan, IMetadataProvider<?, ?> metadata, int varCounter) {
            IOptimizationContext optContext = HeuristicCompilerFactoryBuilder.this.optCtxFactory.createOptimizationContext(varCounter, HeuristicCompilerFactoryBuilder.this.expressionEvalSizeComputer, HeuristicCompilerFactoryBuilder.this.mergeAggregationExpressionFactory, HeuristicCompilerFactoryBuilder.this.expressionTypeComputer, HeuristicCompilerFactoryBuilder.this.missableTypeComputer, HeuristicCompilerFactoryBuilder.this.conflictingTypeResolver, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig, (AlgebricksPartitionConstraint)HeuristicCompilerFactoryBuilder.this.clusterLocations, HeuristicCompilerFactoryBuilder.this.warningCollector);
            optContext.setMetadataDeclarations(metadata);
            optContext.setCompilerFactory((Object)this);
            return new CompilerImpl(this, plan, optContext, (List)HeuristicCompilerFactoryBuilder.this.logicalRewrites.get(), (List)HeuristicCompilerFactoryBuilder.this.physicalRewrites.get(), HeuristicCompilerFactoryBuilder.this.writerFactory);
        }

        @Override
        public ICompiler createCompiler(ILogicalPlan plan, IOptimizationContext newOptContext, IRuleSetKind ruleSetKind) {
            if (newOptContext.getCompilerFactory() != this) {
                throw new IllegalStateException();
            }
            return new CompilerImpl(this, plan, newOptContext, (List)HeuristicCompilerFactoryBuilder.this.logicalRewritesByKind.apply(ruleSetKind), (List)HeuristicCompilerFactoryBuilder.this.physicalRewrites.get(), (IAWriterFactory)SerializedDataWriterFactory.WITHOUT_RECORD_DESCRIPTOR);
        }

        private PlanCompiler createPlanCompiler(IOptimizationContext oc, Object appContext, IAWriterFactory writerFactory) {
            JobGenContext context = new JobGenContext(null, oc.getMetadataProvider(), appContext, HeuristicCompilerFactoryBuilder.this.serializerDeserializerProvider, HeuristicCompilerFactoryBuilder.this.hashFunctionFactoryProvider, HeuristicCompilerFactoryBuilder.this.hashFunctionFamilyProvider, HeuristicCompilerFactoryBuilder.this.comparatorFactoryProvider, HeuristicCompilerFactoryBuilder.this.typeTraitProvider, HeuristicCompilerFactoryBuilder.this.binaryBooleanInspectorFactory, HeuristicCompilerFactoryBuilder.this.binaryIntegerInspectorFactory, HeuristicCompilerFactoryBuilder.this.printerProvider, writerFactory, HeuristicCompilerFactoryBuilder.this.resultSerializerFactoryProvider, HeuristicCompilerFactoryBuilder.this.missingWriterFactory, HeuristicCompilerFactoryBuilder.this.nullWriterFactory, HeuristicCompilerFactoryBuilder.this.unnestingPositionWriterFactory, HeuristicCompilerFactoryBuilder.this.normalizedKeyComputerFactoryProvider, HeuristicCompilerFactoryBuilder.this.expressionRuntimeProvider, HeuristicCompilerFactoryBuilder.this.expressionTypeComputer, (ITypingContext)oc, HeuristicCompilerFactoryBuilder.this.expressionEvalSizeComputer, HeuristicCompilerFactoryBuilder.this.partialAggregationTypeComputer, HeuristicCompilerFactoryBuilder.this.predEvaluatorFactoryProvider, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig.getFrameSize(), HeuristicCompilerFactoryBuilder.this.clusterLocations, HeuristicCompilerFactoryBuilder.this.warningCollector, HeuristicCompilerFactoryBuilder.this.maxWarnings, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig);
            return new PlanCompiler(context);
        }
    }

    private static class CompilerImpl
    implements ICompiler {
        private final CompilerFactoryImpl factory;
        private final ILogicalPlan plan;
        private final IOptimizationContext oc;
        private final List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites;
        private final List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites;
        private final IAWriterFactory writerFactory;

        private CompilerImpl(CompilerFactoryImpl factory, ILogicalPlan plan, IOptimizationContext oc, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites, IAWriterFactory writerFactory) {
            this.factory = factory;
            this.plan = plan;
            this.oc = oc;
            this.logicalRewrites = logicalRewrites;
            this.physicalRewrites = physicalRewrites;
            this.writerFactory = writerFactory;
        }

        @Override
        public void optimize() throws AlgebricksException {
            HeuristicOptimizer opt = new HeuristicOptimizer(this.plan, this.logicalRewrites, this.physicalRewrites, this.oc);
            opt.optimize();
        }

        @Override
        public JobSpecification createJob(Object appContext, IJobletEventListenerFactory jobEventListenerFactory) throws AlgebricksException {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace("Starting Job Generation.\n");
            PlanCompiler pc = this.factory.createPlanCompiler(this.oc, appContext, this.writerFactory);
            return pc.compilePlan(this.plan, jobEventListenerFactory);
        }
    }
}

