/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hyracks.storage.common.buffercache.ICachedPageInternal;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;

public class CachedPage
implements ICachedPageInternal {
    final int cpid;
    ByteBuffer buffer;
    public final AtomicInteger pinCount;
    final AtomicBoolean dirty;
    final ReentrantReadWriteLock latch;
    private final Object replacementStrategyObject;
    private final IPageReplacementStrategy pageReplacementStrategy;
    volatile long dpid;
    CachedPage next;
    volatile boolean valid;
    final AtomicBoolean confiscated;
    private int multiplier;
    private int extraBlockPageId;
    private long compressedOffset;
    private int compressedSize;
    private static final boolean DEBUG = false;
    private final StackTraceElement[] ctorStack;

    public CachedPage() {
        this.cpid = -1;
        this.buffer = null;
        this.pageReplacementStrategy = null;
        this.dirty = new AtomicBoolean(false);
        this.confiscated = new AtomicBoolean(true);
        this.pinCount = null;
        this.replacementStrategyObject = null;
        this.latch = null;
        this.ctorStack = null;
    }

    public int incrementAndGetPinCount() {
        return this.pinCount.incrementAndGet();
    }

    public CachedPage(int cpid, ByteBuffer buffer, IPageReplacementStrategy pageReplacementStrategy) {
        this.cpid = cpid;
        this.buffer = buffer;
        this.pageReplacementStrategy = pageReplacementStrategy;
        this.pinCount = new AtomicInteger();
        this.dirty = new AtomicBoolean();
        this.latch = new ReentrantReadWriteLock(true);
        this.replacementStrategyObject = pageReplacementStrategy.createPerPageStrategyObject(cpid);
        this.dpid = -1L;
        this.valid = false;
        this.confiscated = new AtomicBoolean(false);
        this.ctorStack = null;
    }

    public void reset(long dpid) {
        this.dpid = dpid;
        this.dirty.set(false);
        this.valid = false;
        this.confiscated.set(false);
        this.pageReplacementStrategy.notifyCachePageReset(this);
    }

    public void invalidate() {
        this.reset(-1L);
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public Object getReplacementStrategyObject() {
        return this.replacementStrategyObject;
    }

    @Override
    public boolean isGoodVictim() {
        return !this.confiscated.get() && this.pinCount.get() == 0;
    }

    @Override
    public int getCachedPageId() {
        return this.cpid;
    }

    @Override
    public void acquireReadLatch() {
        this.latch.readLock().lock();
    }

    @Override
    public void acquireWriteLatch() {
        this.latch.writeLock().lock();
    }

    @Override
    public void releaseReadLatch() {
        this.latch.readLock().unlock();
    }

    @Override
    public void releaseWriteLatch(boolean markDirty) {
        try {
            if (markDirty && this.dirty.compareAndSet(false, true)) {
                this.pinCount.incrementAndGet();
            }
        }
        finally {
            this.latch.writeLock().unlock();
        }
    }

    @Override
    public boolean confiscated() {
        return this.confiscated.get();
    }

    @Override
    public long getDiskPageId() {
        return this.dpid;
    }

    @Override
    public int getFrameSizeMultiplier() {
        return this.multiplier;
    }

    @Override
    public int getPageSize() {
        return this.pageReplacementStrategy.getPageSize();
    }

    @Override
    public void setFrameSizeMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public void setExtraBlockPageId(int extraBlockPageId) {
        this.extraBlockPageId = extraBlockPageId;
    }

    @Override
    public int getExtraBlockPageId() {
        return this.extraBlockPageId;
    }

    CachedPage getNext() {
        return this.next;
    }

    void setNext(CachedPage next) {
        this.next = next;
    }

    @Override
    public void setDiskPageId(long dpid) {
        this.dpid = dpid;
    }

    @Override
    public boolean isLargePage() {
        return this.multiplier > 1;
    }

    @Override
    public void setCompressedPageOffset(long offset) {
        this.compressedOffset = offset;
    }

    @Override
    public long getCompressedPageOffset() {
        return this.compressedOffset;
    }

    @Override
    public void setCompressedPageSize(int size) {
        this.compressedSize = size;
    }

    @Override
    public int getCompressedPageSize() {
        return this.compressedSize;
    }
}

