/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.s3.S3Client;
import software.amazon.awssdk.crt.s3.S3ClientOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequest;
import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandler;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtRequestBodyStreamAdapter;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtResponseHandlerAdapter;
import software.amazon.awssdk.services.s3.internal.crt.S3InternalSdkHttpExecutionAttribute;
import software.amazon.awssdk.services.s3.internal.crt.S3NativeClientConfiguration;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class S3CrtAsyncHttpClient
implements SdkAsyncHttpClient {
    private static final Logger log = Logger.loggerFor(S3CrtAsyncHttpClient.class);
    private final S3Client crtS3Client;
    private final S3NativeClientConfiguration s3NativeClientConfiguration;

    private S3CrtAsyncHttpClient(Builder builder) {
        this.s3NativeClientConfiguration = S3NativeClientConfiguration.builder().targetThroughputInGbps(builder.targetThroughputInGbps).partSizeInBytes(builder.minimalPartSizeInBytes).maxConcurrency(builder.maxConcurrency).signingRegion(builder.region == null ? null : builder.region.id()).endpointOverride(builder.endpointOverride).credentialsProvider(builder.credentialsProvider).build();
        S3ClientOptions s3ClientOptions = new S3ClientOptions().withRegion(this.s3NativeClientConfiguration.signingRegion()).withEndpoint(this.s3NativeClientConfiguration.endpointOverride() == null ? null : this.s3NativeClientConfiguration.endpointOverride().toString()).withCredentialsProvider(this.s3NativeClientConfiguration.credentialsProvider()).withClientBootstrap(this.s3NativeClientConfiguration.clientBootstrap()).withPartSize(this.s3NativeClientConfiguration.partSizeBytes()).withComputeContentMd5(Boolean.valueOf(true)).withThroughputTargetGbps(this.s3NativeClientConfiguration.targetThroughputInGbps());
        this.crtS3Client = new S3Client(s3ClientOptions);
    }

    @SdkTestInternalApi
    S3CrtAsyncHttpClient(S3Client crtS3Client, S3NativeClientConfiguration nativeClientConfiguration) {
        this.crtS3Client = crtS3Client;
        this.s3NativeClientConfiguration = nativeClientConfiguration;
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncRequest) {
        CompletableFuture<Void> executeFuture = new CompletableFuture<Void>();
        URI uri = asyncRequest.request().getUri();
        HttpRequest httpRequest = S3CrtAsyncHttpClient.toCrtRequest(uri, asyncRequest);
        S3CrtResponseHandlerAdapter responseHandler = new S3CrtResponseHandlerAdapter(executeFuture, asyncRequest.responseHandler());
        S3MetaRequestOptions.MetaRequestType requestType = S3CrtAsyncHttpClient.requestType(asyncRequest);
        S3MetaRequestOptions requestOptions = new S3MetaRequestOptions().withHttpRequest(httpRequest).withMetaRequestType(requestType).withResponseHandler((S3MetaRequestResponseHandler)responseHandler).withEndpoint(this.s3NativeClientConfiguration.endpointOverride());
        try (S3MetaRequest s3MetaRequest = this.crtS3Client.makeMetaRequest(requestOptions);){
            S3CrtAsyncHttpClient.closeResourcesWhenComplete(executeFuture, s3MetaRequest, responseHandler);
        }
        return executeFuture;
    }

    public String clientName() {
        return "s3crt";
    }

    private static S3MetaRequestOptions.MetaRequestType requestType(AsyncExecuteRequest asyncRequest) {
        String operationName = (String)asyncRequest.httpExecutionAttributes().getAttribute(S3InternalSdkHttpExecutionAttribute.OPERATION_NAME);
        if (operationName != null) {
            switch (operationName) {
                case "GetObject": {
                    return S3MetaRequestOptions.MetaRequestType.GET_OBJECT;
                }
                case "PutObject": {
                    return S3MetaRequestOptions.MetaRequestType.PUT_OBJECT;
                }
                case "CopyObject": {
                    return S3MetaRequestOptions.MetaRequestType.COPY_OBJECT;
                }
            }
            return S3MetaRequestOptions.MetaRequestType.DEFAULT;
        }
        return S3MetaRequestOptions.MetaRequestType.DEFAULT;
    }

    private static void closeResourcesWhenComplete(CompletableFuture<Void> executeFuture, S3MetaRequest s3MetaRequest, S3CrtResponseHandlerAdapter responseHandler) {
        executeFuture.whenComplete((r, t) -> {
            if (executeFuture.isCancelled()) {
                log.debug(() -> "The request is cancelled, cancelling meta request");
                responseHandler.cancelRequest();
                s3MetaRequest.cancel();
            }
            s3MetaRequest.close();
        });
    }

    private static HttpRequest toCrtRequest(URI uri, AsyncExecuteRequest asyncRequest) {
        SdkHttpRequest sdkRequest = asyncRequest.request();
        String method = sdkRequest.method().name();
        String encodedPath = sdkRequest.encodedPath();
        if (encodedPath == null || encodedPath.isEmpty()) {
            encodedPath = "/";
        }
        String encodedQueryString = sdkRequest.encodedQueryParameters().map(value -> "?" + value).orElse("");
        HttpHeader[] crtHeaderArray = S3CrtAsyncHttpClient.createHttpHeaderList(uri, asyncRequest).toArray(new HttpHeader[0]);
        S3CrtRequestBodyStreamAdapter sdkToCrtRequestPublisher = new S3CrtRequestBodyStreamAdapter((Publisher<ByteBuffer>)asyncRequest.requestContentPublisher());
        return new HttpRequest(method, encodedPath + encodedQueryString, crtHeaderArray, (HttpRequestBodyStream)sdkToCrtRequestPublisher);
    }

    public void close() {
        this.s3NativeClientConfiguration.close();
        this.crtS3Client.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static List<HttpHeader> createHttpHeaderList(URI uri, AsyncExecuteRequest asyncRequest) {
        SdkHttpRequest sdkRequest = asyncRequest.request();
        ArrayList<HttpHeader> crtHeaderList = new ArrayList<HttpHeader>();
        if (!sdkRequest.firstMatchingHeader("Host").isPresent()) {
            crtHeaderList.add(new HttpHeader("Host", uri.getHost()));
        }
        Optional contentLength = asyncRequest.requestContentPublisher().contentLength();
        if (!sdkRequest.firstMatchingHeader("Content-Length").isPresent() && contentLength.isPresent()) {
            crtHeaderList.add(new HttpHeader("Content-Length", Long.toString((Long)contentLength.get())));
        }
        sdkRequest.forEachHeader((key, value) -> value.stream().map(val -> new HttpHeader(key, val)).forEach(crtHeaderList::add));
        return crtHeaderList;
    }

    public static final class Builder
    implements SdkAsyncHttpClient.Builder<Builder> {
        private AwsCredentialsProvider credentialsProvider;
        private Region region;
        private Long minimalPartSizeInBytes;
        private Double targetThroughputInGbps;
        private Integer maxConcurrency;
        private URI endpointOverride;

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder minimumPartSizeInBytes(Long partSizeBytes) {
            this.minimalPartSizeInBytes = partSizeBytes;
            return this;
        }

        public Builder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        public Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        public SdkAsyncHttpClient build() {
            return new S3CrtAsyncHttpClient(this);
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return this.build();
        }
    }
}

