/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STRelateDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = STRelateDescriptor::new;
    private static final long serialVersionUID = 1L;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_RELATE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new STRelateEvaluator(args, ctx);
            }
        };
    }

    private class STRelateEvaluator
    implements IScalarEvaluator {
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg = new VoidPointable();
        private IScalarEvaluator eval;
        private IPointable inputArg0;
        private IScalarEvaluator eval0;
        private final IPointable inputArg1;
        private final IScalarEvaluator eval1;

        public STRelateEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval = args[2].createScalarEvaluator(ctx);
            this.inputArg0 = new VoidPointable();
            this.eval0 = args[0].createScalarEvaluator(ctx);
            this.inputArg1 = new VoidPointable();
            this.eval1 = args[1].createScalarEvaluator(ctx);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.eval.evaluate(tuple, this.inputArg);
            byte[] bytes = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            this.eval0.evaluate(tuple, this.inputArg0);
            byte[] bytes0 = this.inputArg0.getByteArray();
            int offset0 = this.inputArg0.getStartOffset();
            int len0 = this.inputArg0.getLength();
            this.eval1.evaluate(tuple, this.inputArg1);
            byte[] bytes1 = this.inputArg1.getByteArray();
            int offset1 = this.inputArg1.getStartOffset();
            int len1 = this.inputArg1.getLength();
            if (bytes[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(STRelateDescriptor.this.sourceLoc, STRelateDescriptor.this.getIdentifier(), 0, bytes[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
            if (tag != ATypeTag.GEOMETRY) {
                throw new TypeMismatchException(STRelateDescriptor.this.sourceLoc, STRelateDescriptor.this.getIdentifier(), 0, bytes0[offset0], new byte[]{ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG});
            }
            tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
            if (tag != ATypeTag.GEOMETRY) {
                throw new TypeMismatchException(STRelateDescriptor.this.sourceLoc, STRelateDescriptor.this.getIdentifier(), 0, bytes1[offset1], new byte[]{ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG});
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytes, offset + 1, len - 1);
            DataInputStream dataIn = new DataInputStream(inStream);
            String matrix = AStringSerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn).getStringValue();
            DataInputStream dataIn0 = new DataInputStream(new ByteArrayInputStream(bytes0, offset0 + 1, len0 - 1));
            OGCGeometry geometry0 = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn0).getGeometry();
            DataInputStream dataIn1 = new DataInputStream(new ByteArrayInputStream(bytes1, offset1 + 1, len1 - 1));
            OGCGeometry geometry1 = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn1).getGeometry();
            try {
                boolean val = geometry0.relate(geometry1, matrix);
                SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN).serialize((Object)(val ? ABoolean.TRUE : ABoolean.FALSE), this.out);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(STRelateDescriptor.this.sourceLoc, STRelateDescriptor.this.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
            }
            result.set((IValueReference)this.resultStorage);
        }
    }
}

