/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.AbstractTOccurrenceSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListCursorFactory;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class TOccurrenceSearcher
extends AbstractTOccurrenceSearcher {
    protected final ArrayList<IInvertedListCursor> invListCursors = new ArrayList();
    protected InvertedListCursorFactory invertedListCursorFactory;

    public TOccurrenceSearcher(IInPlaceInvertedIndex invIndex, IHyracksTaskContext ctx) throws HyracksDataException {
        super(invIndex, ctx);
        this.invertedListCursorFactory = new InvertedListCursorFactory(invIndex, ctx);
    }

    @Override
    public void search(IIndexCursor resultCursor, InvertedIndexSearchPredicate searchPred, IIndexOperationContext ictx) throws HyracksDataException {
        this.prepareSearch();
        this.tokenizeQuery(searchPred);
        int numQueryTokens = this.queryTokenAppender.getTupleCount();
        this.invListCursors.clear();
        this.invListCursorCache.reset();
        for (int i = 0; i < numQueryTokens; ++i) {
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, i);
            IInvertedListCursor invListCursor = this.invertedListCursorFactory.create();
            this.invIndex.openInvertedListCursor(invListCursor, (ITupleReference)this.searchKey, ictx);
            this.invListCursors.add(invListCursor);
        }
        IInvertedIndexSearchModifier searchModifier = searchPred.getSearchModifier();
        this.occurrenceThreshold = searchModifier.getOccurrenceThreshold(numQueryTokens);
        if (this.occurrenceThreshold <= 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.OCCURRENCE_THRESHOLD_PANIC_EXCEPTION, (Serializable[])new Serializable[0]);
        }
        int numPrefixLists = searchModifier.getNumPrefixLists(this.occurrenceThreshold, this.invListCursors.size());
        if (numQueryTokens == 1 && this.occurrenceThreshold == 1) {
            this.singleInvListCursor = this.invListCursors.get(0);
            this.singleInvListCursor.prepareLoadPages();
            this.singleInvListCursor.loadPages();
            this.isSingleInvertedList = true;
            this.isFinishedSearch = true;
        } else {
            this.finalSearchResult.reset();
            this.isFinishedSearch = this.invListMerger.merge(this.invListCursors, this.occurrenceThreshold, numPrefixLists, this.finalSearchResult);
            this.searchResultBuffer = this.finalSearchResult.getNextFrame();
            this.searchResultTupleIndex = 0;
            this.searchResultFta.reset(this.searchResultBuffer);
        }
        if (this.isFinishedSearch) {
            this.invListMerger.close();
            this.finalSearchResult.finalizeWrite();
        }
        resultCursor.open(null, (ISearchPredicate)searchPred);
    }

    @Override
    public boolean continueSearch() throws HyracksDataException {
        if (this.isFinishedSearch) {
            return true;
        }
        this.isFinishedSearch = this.invListMerger.continueMerge();
        this.searchResultBuffer = this.finalSearchResult.getNextFrame();
        this.searchResultTupleIndex = 0;
        this.searchResultFta.reset(this.searchResultBuffer);
        if (this.isFinishedSearch) {
            this.invListMerger.close();
            this.finalSearchResult.finalizeWrite();
        }
        return this.isFinishedSearch;
    }
}

