/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds;

import com.teradata.tpcds.Options;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.TpcdsException;
import java.util.Optional;

public class Session {
    private final Scaling scaling;
    private final String targetDirectory;
    private final String suffix;
    private final Optional<Table> table;
    private final String nullString;
    private final char separator;
    private final boolean doNotTerminate;
    private final boolean noSexism;
    private final int parallelism;
    private final int chunkNumber;
    private final boolean overwrite;

    public Session(double scale, String targetDirectory, String suffix, Optional<Table> table, String nullString, char separator, boolean doNotTerminate, boolean noSexism, int parallelism, boolean overwrite) {
        this(scale, targetDirectory, suffix, table, nullString, separator, doNotTerminate, noSexism, parallelism, 1, overwrite);
    }

    public Session(double scale, String targetDirectory, String suffix, Optional<Table> table, String nullString, char separator, boolean doNotTerminate, boolean noSexism, int parallelism, int chunkNumber, boolean overwrite) {
        this.scaling = new Scaling(scale);
        this.targetDirectory = targetDirectory;
        this.suffix = suffix;
        this.table = table;
        this.nullString = nullString;
        this.separator = separator;
        this.doNotTerminate = doNotTerminate;
        this.noSexism = noSexism;
        this.parallelism = parallelism;
        this.chunkNumber = chunkNumber;
        this.overwrite = overwrite;
    }

    public static Session getDefaultSession() {
        return new Options().toSession();
    }

    public Session withTable(Table table) {
        return new Session(this.scaling.getScale(), this.targetDirectory, this.suffix, Optional.of(table), this.nullString, this.separator, this.doNotTerminate, this.noSexism, this.parallelism, this.chunkNumber, this.overwrite);
    }

    public Session withScale(double scale) {
        return new Session(scale, this.targetDirectory, this.suffix, this.table, this.nullString, this.separator, this.doNotTerminate, this.noSexism, this.parallelism, this.chunkNumber, this.overwrite);
    }

    public Session withParallelism(int parallelism) {
        return new Session(this.scaling.getScale(), this.targetDirectory, this.suffix, this.table, this.nullString, this.separator, this.doNotTerminate, this.noSexism, parallelism, this.chunkNumber, this.overwrite);
    }

    public Session withChunkNumber(int chunkNumber) {
        return new Session(this.scaling.getScale(), this.targetDirectory, this.suffix, this.table, this.nullString, this.separator, this.doNotTerminate, this.noSexism, this.parallelism, chunkNumber, this.overwrite);
    }

    public Session withNoSexism(boolean noSexism) {
        return new Session(this.scaling.getScale(), this.targetDirectory, this.suffix, this.table, this.nullString, this.separator, this.doNotTerminate, noSexism, this.parallelism, this.chunkNumber, this.overwrite);
    }

    public Scaling getScaling() {
        return this.scaling;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean generateOnlyOneTable() {
        return this.table.isPresent();
    }

    public Table getOnlyTableToGenerate() {
        if (!this.table.isPresent()) {
            throw new TpcdsException("table not present");
        }
        return this.table.get();
    }

    public String getNullString() {
        return this.nullString;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean terminateRowsWithSeparator() {
        return !this.doNotTerminate;
    }

    public boolean isSexist() {
        return !this.noSexism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public boolean shouldOverwrite() {
        return this.overwrite;
    }

    public String getCommandLineArguments() {
        StringBuilder output = new StringBuilder();
        if (this.scaling.getScale() != 1.0) {
            output.append("--scale ").append(this.scaling.getScale()).append(" ");
        }
        if (!this.targetDirectory.equals(".")) {
            output.append("--directory ").append(this.targetDirectory).append(" ");
        }
        if (!this.suffix.equals(".dat")) {
            output.append("--suffix ").append(this.suffix).append(" ");
        }
        if (this.table.isPresent()) {
            output.append("--table ").append(this.table.get().getName()).append(" ");
        }
        if (!this.nullString.equals("")) {
            output.append("--null ").append(this.nullString).append(" ");
        }
        if (this.separator != '|') {
            output.append("--separator ").append(this.separator).append(" ");
        }
        if (this.doNotTerminate) {
            output.append("--do-not-terminate ");
        }
        if (this.noSexism) {
            output.append("--no-sexism ");
        }
        if (this.parallelism != 1) {
            output.append("--parallelism ").append(this.parallelism).append(" ");
        }
        if (this.overwrite) {
            output.append("--overwrite ");
        }
        if (output.length() > 0) {
            output.deleteCharAt(output.length() - 1);
        }
        return output.toString();
    }
}

