/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.prettyprint;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AbstractLogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalExpressionPrettyPrintVisitor;
import org.apache.hyracks.api.exceptions.ErrorCode;

public class LogicalOperatorPrettyPrintVisitorJson
extends AbstractLogicalOperatorPrettyPrintVisitor<Void>
implements IPlanPrettyPrinter {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final DefaultIndenter OBJECT_INDENT = new DefaultIndenter("   ", DefaultIndenter.SYS_LF);
    private static final String OPERATOR_FIELD = "operator";
    private static final String VARIABLES_FIELD = "variables";
    private static final String EXPRESSIONS_FIELD = "expressions";
    private static final String EXPRESSION_FIELD = "expression";
    private static final String CONDITION_FIELD = "condition";
    private static final String MISSING_VALUE_FIELD = "missing-value";
    private static final String OPTIMIZER_ESTIMATES = "optimizer-estimates";
    private final Map<AbstractLogicalOperator, String> operatorIdentity = new HashMap<AbstractLogicalOperator, String>();
    private final IdCounter idCounter = new IdCounter();
    private final JsonGenerator jsonGenerator;

    LogicalOperatorPrettyPrintVisitorJson() {
        super(new LogicalExpressionPrettyPrintVisitor());
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter(DefaultIndenter.SYS_LF);
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)OBJECT_INDENT);
        try {
            this.jsonGenerator = JSON_FACTORY.createGenerator((Writer)((Object)this.buffer)).setPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final IPlanPrettyPrinter reset() throws AlgebricksException {
        this.flushContentToWriter();
        this.resetState();
        this.operatorIdentity.clear();
        return this;
    }

    @Override
    public final IPlanPrettyPrinter printPlan(ILogicalPlan plan, boolean printOptimizerEstimates) throws AlgebricksException {
        this.printPlanImpl(plan, printOptimizerEstimates);
        this.flushContentToWriter();
        return this;
    }

    @Override
    public final IPlanPrettyPrinter printOperator(AbstractLogicalOperator op, boolean printInputs, boolean printOptimizerEstimates) throws AlgebricksException {
        this.printOperatorImpl(op, printInputs, printOptimizerEstimates);
        this.flushContentToWriter();
        return this;
    }

    private void printPlanImpl(ILogicalPlan plan, boolean printOptimizerEstimates) throws AlgebricksException {
        try {
            boolean writeArrayOfRoots;
            boolean bl = writeArrayOfRoots = plan.getRoots().size() > 1;
            if (writeArrayOfRoots) {
                this.jsonGenerator.writeStartArray();
            }
            for (Mutable<ILogicalOperator> root : plan.getRoots()) {
                this.printOperatorImpl((AbstractLogicalOperator)root.getValue(), true, printOptimizerEstimates);
            }
            if (writeArrayOfRoots) {
                this.jsonGenerator.writeEndArray();
            }
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void printOperatorImpl(AbstractLogicalOperator op, boolean printInputs, boolean printOptimizerEstimates) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStartObject();
            op.accept(this, null);
            this.jsonGenerator.writeStringField("operatorId", this.idCounter.printOperatorId(op));
            IPhysicalOperator pOp = op.getPhysicalOperator();
            if (pOp != null) {
                this.jsonGenerator.writeStringField("physical-operator", pOp.toString(false));
            }
            this.jsonGenerator.writeStringField("execution-mode", op.getExecutionMode().toString());
            this.generateCardCostFields(op, printOptimizerEstimates);
            List<Mutable<ILogicalOperator>> inputs = op.getInputs();
            if (printInputs && !inputs.isEmpty()) {
                this.printInputs(op, inputs, printOptimizerEstimates);
            }
            this.jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void printInputs(AbstractLogicalOperator op, List<Mutable<ILogicalOperator>> inputs, boolean printOptimizerEstimates) throws IOException, AlgebricksException {
        this.jsonGenerator.writeArrayFieldStart("inputs");
        if (LogicalOperatorPrettyPrintVisitorJson.printInputsInReverse(op)) {
            for (int i = inputs.size() - 1; i >= 0; --i) {
                Mutable<ILogicalOperator> inOp = inputs.get(i);
                this.printOperatorImpl((AbstractLogicalOperator)inOp.getValue(), true, printOptimizerEstimates);
            }
        } else {
            for (Mutable<ILogicalOperator> inOp : inputs) {
                this.printOperatorImpl((AbstractLogicalOperator)inOp.getValue(), true, printOptimizerEstimates);
            }
        }
        this.jsonGenerator.writeEndArray();
    }

    private void generateCardCostFields(AbstractLogicalOperator op, boolean printOptimizerEstimates) throws AlgebricksException {
        if (printOptimizerEstimates) {
            double opCard = this.getOpCardinality(op);
            double opLocalCost = this.getOpLocalCost(op);
            double opTotalCost = this.getOpTotalCost(op);
            try {
                this.jsonGenerator.writeObjectFieldStart(OPTIMIZER_ESTIMATES);
                this.jsonGenerator.writeNumberField("cardinality", opCard);
                this.jsonGenerator.writeNumberField("op-cost", opLocalCost);
                this.jsonGenerator.writeNumberField("total-cost", opTotalCost);
                this.jsonGenerator.writeEndObject();
            }
            catch (IOException e) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
            }
        }
    }

    @Override
    public IPlanPrettyPrinter printExpression(ILogicalExpression expression) throws AlgebricksException {
        try {
            this.jsonGenerator.writeString((String)expression.accept(this.exprVisitor, null));
            return this;
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e, ErrorCode.ERROR_PRINTING_PLAN, new Serializable[0]);
        }
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "aggregate");
            this.writeVariablesAndExpressions(op.getVariables(), op.getExpressions(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "running-aggregate");
            this.writeVariablesAndExpressions(op.getVariables(), op.getExpressions(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "empty-tuple-source");
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "group-by");
            if (op.isGroupAll()) {
                this.jsonGenerator.writeStringField("option", "all");
            }
            if (!op.getGroupByList().isEmpty()) {
                this.writeArrayFieldOfVariableExpressionPairs("group-by-list", op.getGroupByList(), indent);
            }
            if (!op.getDecorList().isEmpty()) {
                this.writeArrayFieldOfVariableExpressionPairs("decor-list", op.getDecorList(), indent);
            }
            if (!op.getNestedPlans().isEmpty()) {
                this.writeNestedPlans(op, indent);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "distinct");
            List<Mutable<ILogicalExpression>> expressions = op.getExpressions();
            if (!expressions.isEmpty()) {
                this.writeArrayFieldOfExpressions(EXPRESSIONS_FIELD, expressions, indent);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "join");
            this.writeStringFieldExpression(CONDITION_FIELD, op.getCondition(), indent);
            this.writeBuildSide(op);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "left-outer-join");
            this.writeStringFieldExpression(CONDITION_FIELD, op.getCondition(), indent);
            if (op.getMissingValue().isNull()) {
                this.writeNullField(MISSING_VALUE_FIELD);
            }
            this.writeBuildSide(op);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "nested-tuple-source");
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "order");
            int topK = op.getTopK();
            if (topK != -1) {
                this.jsonGenerator.writeStringField("topK", String.valueOf(topK));
            }
            this.writeArrayFieldOfOrderExprList("order-by-list", op.getOrderExpressions(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "assign");
            this.writeVariablesAndExpressions(op.getVariables(), op.getExpressions(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "write");
            List<Mutable<ILogicalExpression>> expressions = op.getExpressions();
            if (!expressions.isEmpty()) {
                this.writeArrayFieldOfExpressions(EXPRESSIONS_FIELD, expressions, indent);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "distribute-result");
            List<Mutable<ILogicalExpression>> expressions = op.getExpressions();
            if (!expressions.isEmpty()) {
                this.writeArrayFieldOfExpressions(EXPRESSIONS_FIELD, expressions, indent);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "load");
            this.jsonGenerator.writeStringField("data-source", String.valueOf(op.getDataSource()));
            this.writeStringFieldExpression("from", op.getPayloadExpression(), indent);
            this.writeObjectFieldWithExpressions("partitioned-by", op.getKeyExpressions(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "select");
            this.writeStringFieldExpression(CONDITION_FIELD, op.getCondition(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "project");
            List<LogicalVariable> variables = op.getVariables();
            if (!variables.isEmpty()) {
                this.writeArrayFieldOfVariables(VARIABLES_FIELD, variables);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Void indent) throws AlgebricksException {
        try {
            if (!op.getNestedPlans().isEmpty()) {
                this.jsonGenerator.writeStringField(OPERATOR_FIELD, "subplan");
                this.writeNestedPlans(op, indent);
            }
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "union");
            this.jsonGenerator.writeArrayFieldStart("values");
            for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> v : op.getVariableMappings()) {
                this.jsonGenerator.writeStartArray();
                this.jsonGenerator.writeString(String.valueOf(v.first));
                this.jsonGenerator.writeString(String.valueOf(v.second));
                this.jsonGenerator.writeString(String.valueOf(v.third));
                this.jsonGenerator.writeEndArray();
            }
            this.jsonGenerator.writeEndArray();
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "intersect");
            this.writeArrayFieldOfVariables("output-compare-variables", op.getOutputCompareVariables());
            if (op.hasExtraVariables()) {
                this.writeArrayFieldOfVariables("output-extra-variables", op.getOutputExtraVariables());
            }
            this.writeArrayFieldOfNestedVariablesList("input-compare-variables", op.getAllInputsCompareVariables());
            if (op.hasExtraVariables()) {
                this.writeArrayFieldOfNestedVariablesList("input-extra-variables", op.getAllInputsExtraVariables());
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Void indent) throws AlgebricksException {
        this.writeUnnestNonMapOperator(op, "unnest", indent);
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void indent) throws AlgebricksException {
        try {
            this.writeUnnestNonMapOperator(op, "outer-unnest", indent);
            if (op.getMissingValue().isNull()) {
                this.writeNullField(MISSING_VALUE_FIELD);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Void indent) throws AlgebricksException {
        try {
            this.writeUnnestMapOperator(op, indent, "unnest-map", null);
            this.writeSelectLimitInformation(op.getSelectCondition(), op.getOutputLimit(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void indent) throws AlgebricksException {
        this.writeUnnestMapOperator(op, indent, "left-outer-unnest-map", op.getMissingValue());
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Void indent) throws AlgebricksException {
        try {
            List<LogicalVariable> variables;
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "data-scan");
            List<LogicalVariable> projectVariables = op.getProjectVariables();
            if (!projectVariables.isEmpty()) {
                this.writeArrayFieldOfVariables("project-variables", projectVariables);
            }
            if (!(variables = op.getVariables()).isEmpty()) {
                this.writeArrayFieldOfVariables(VARIABLES_FIELD, variables);
            }
            if (op.getDataSource() != null) {
                this.jsonGenerator.writeStringField("data-source", String.valueOf(op.getDataSource()));
            }
            this.writeFilterInformation(op.getMinFilterVars(), op.getMaxFilterVars());
            this.writeSelectLimitInformation(op.getSelectCondition(), op.getOutputLimit(), indent);
            this.writeProjectInformation(op.getProjectionInfo());
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "limit");
            if (op.hasMaxObjects()) {
                this.writeStringFieldExpression("value", op.getMaxObjects(), indent);
            }
            if (op.hasOffset()) {
                this.writeStringFieldExpression("offset", (ILogicalExpression)op.getOffset().getValue(), indent);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "exchange");
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Void indent) throws AlgebricksException {
        try {
            List<LogicalVariable> outputVariables;
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "script");
            List<LogicalVariable> inputVariables = op.getInputVariables();
            if (!inputVariables.isEmpty()) {
                this.writeArrayFieldOfVariables("in", inputVariables);
            }
            if (!(outputVariables = op.getOutputVariables()).isEmpty()) {
                this.writeArrayFieldOfVariables("out", outputVariables);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "replicate");
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "split");
            this.writeStringFieldExpression(EXPRESSION_FIELD, op.getBranchingExpression(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "materialize");
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, this.getIndexOpString(op.getOperation()));
            this.jsonGenerator.writeStringField("data-source", String.valueOf(op.getDataSource()));
            this.writeStringFieldExpression("from-record", op.getPayloadExpression(), indent);
            if (op.getAdditionalNonFilteringExpressions() != null) {
                this.writeObjectFieldWithExpressions("meta", op.getAdditionalNonFilteringExpressions(), indent);
            }
            this.writeObjectFieldWithExpressions("partitioned-by", op.getPrimaryKeyExpressions(), indent);
            if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                this.jsonGenerator.writeObjectFieldStart("out");
                this.jsonGenerator.writeStringField("record-before-upsert", String.valueOf(op.getBeforeOpRecordVar()));
                if (op.getBeforeOpAdditionalNonFilteringVars() != null) {
                    this.jsonGenerator.writeStringField("additional-before-upsert", String.valueOf(op.getBeforeOpAdditionalNonFilteringVars()));
                }
                this.jsonGenerator.writeEndObject();
            }
            if (op.isBulkload()) {
                this.jsonGenerator.writeBooleanField("bulkload", true);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, this.getIndexOpString(op.getOperation()));
            this.jsonGenerator.writeStringField("index", op.getIndexName());
            this.jsonGenerator.writeStringField("on", String.valueOf(op.getDataSourceIndex().getDataSource()));
            this.jsonGenerator.writeObjectFieldStart("from");
            if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                this.writeArrayFieldOfExpressions("replace", op.getPrevSecondaryKeyExprs(), indent);
                if (op.getNestedPlans().isEmpty()) {
                    this.writeArrayFieldOfExpressions("with", op.getSecondaryKeyExpressions(), indent);
                } else {
                    this.writeNestedPlans(op, indent);
                }
            } else if (op.getNestedPlans().isEmpty()) {
                this.writeArrayFieldOfExpressions(EXPRESSIONS_FIELD, op.getSecondaryKeyExpressions(), indent);
            } else {
                this.writeNestedPlans(op, indent);
            }
            this.jsonGenerator.writeEndObject();
            if (op.isBulkload()) {
                this.jsonGenerator.writeBooleanField("bulkload", true);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "tokenize");
            this.writeVariablesAndExpressions(op.getTokenizeVars(), op.getSecondaryKeyExpressions(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "forward");
            this.writeStringFieldExpression(EXPRESSION_FIELD, op.getSideDataExpression(), indent);
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "sink");
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, Void indent) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, op.toString());
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, Void indent) throws AlgebricksException {
        try {
            List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions;
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, "window-aggregate");
            this.writeVariablesAndExpressions(op.getVariables(), op.getExpressions(), indent);
            List<Mutable<ILogicalExpression>> partitionExpressions = op.getPartitionExpressions();
            if (!partitionExpressions.isEmpty()) {
                this.writeObjectFieldWithExpressions("partition-by", partitionExpressions, indent);
            }
            if (!(orderExpressions = op.getOrderExpressions()).isEmpty()) {
                this.writeArrayFieldOfOrderExprList("order-by", orderExpressions, indent);
            }
            if (op.hasNestedPlans()) {
                int frameMaxObjects;
                Mutable<ILogicalExpression> frameOffsetExpression;
                Mutable<ILogicalExpression> frameExcludeUnaryExpression;
                List<Mutable<ILogicalExpression>> frameExcludeExpressions;
                List<Mutable<ILogicalExpression>> frameEndValidationExpressions;
                List<Mutable<ILogicalExpression>> frameEndExpressions;
                List<Mutable<ILogicalExpression>> frameStartValidationExpressions;
                List<Mutable<ILogicalExpression>> frameStartExpressions;
                List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExpressions = op.getFrameValueExpressions();
                if (!frameValueExpressions.isEmpty()) {
                    this.writeArrayFieldOfOrderExprList("frame-on", frameValueExpressions, indent);
                }
                if (!(frameStartExpressions = op.getFrameStartExpressions()).isEmpty()) {
                    this.writeObjectFieldWithExpressions("frame-start", frameStartExpressions, indent);
                }
                if (!(frameStartValidationExpressions = op.getFrameStartValidationExpressions()).isEmpty()) {
                    this.writeObjectFieldWithExpressions("frame-start-if", frameStartValidationExpressions, indent);
                }
                if (!(frameEndExpressions = op.getFrameEndExpressions()).isEmpty()) {
                    this.writeObjectFieldWithExpressions("frame-end", frameEndExpressions, indent);
                }
                if (!(frameEndValidationExpressions = op.getFrameEndValidationExpressions()).isEmpty()) {
                    this.writeObjectFieldWithExpressions("frame-end-if", frameEndValidationExpressions, indent);
                }
                if (!(frameExcludeExpressions = op.getFrameExcludeExpressions()).isEmpty()) {
                    this.writeObjectFieldWithExpressions("frame-exclude", frameExcludeExpressions, indent);
                    this.jsonGenerator.writeStringField("frame-exclude-negation-start", String.valueOf(op.getFrameExcludeNegationStartIdx()));
                }
                if ((frameExcludeUnaryExpression = op.getFrameExcludeUnaryExpression()).getValue() != null) {
                    this.writeStringFieldExpression("frame-exclude-unary", frameExcludeUnaryExpression, indent);
                }
                if ((frameOffsetExpression = op.getFrameOffsetExpression()).getValue() != null) {
                    this.writeStringFieldExpression("frame-offset", frameOffsetExpression, indent);
                }
                if ((frameMaxObjects = op.getFrameMaxObjects()) != -1) {
                    this.jsonGenerator.writeStringField("frame-max-objects", String.valueOf(frameMaxObjects));
                }
                this.writeNestedPlans(op, indent);
            }
            return null;
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void writeNestedPlans(AbstractOperatorWithNestedPlans op, Void indent) throws AlgebricksException {
        try {
            this.idCounter.nextPrefix();
            this.jsonGenerator.writeArrayFieldStart("subplan");
            List<ILogicalPlan> nestedPlans = op.getNestedPlans();
            int size = nestedPlans.size();
            for (int i = 0; i < size; ++i) {
                this.printPlanImpl(nestedPlans.get(i), false);
            }
            this.jsonGenerator.writeEndArray();
            this.idCounter.previousPrefix();
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void writeUnnestNonMapOperator(AbstractUnnestNonMapOperator op, String opName, Void indent) throws AlgebricksException {
        try {
            LogicalVariable positionalVariable;
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, opName);
            List<LogicalVariable> variables = op.getVariables();
            if (!variables.isEmpty()) {
                this.writeArrayFieldOfVariables(VARIABLES_FIELD, variables);
            }
            if ((positionalVariable = op.getPositionalVariable()) != null) {
                this.jsonGenerator.writeStringField("position", String.valueOf(positionalVariable));
            }
            this.writeArrayFieldOfExpression(EXPRESSIONS_FIELD, op.getExpressionRef(), indent);
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void writeUnnestMapOperator(AbstractUnnestMapOperator op, Void indent, String opName, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        try {
            this.jsonGenerator.writeStringField(OPERATOR_FIELD, opName);
            List<LogicalVariable> variables = op.getVariables();
            if (!variables.isEmpty()) {
                this.writeArrayFieldOfVariables(VARIABLES_FIELD, variables);
            }
            this.writeArrayFieldOfExpression(EXPRESSIONS_FIELD, op.getExpressionRef(), indent);
            this.writeFilterInformation(op.getMinFilterVars(), op.getMaxFilterVars());
            if (leftOuterMissingValue != null && leftOuterMissingValue.isNull()) {
                this.writeNullField(MISSING_VALUE_FIELD);
            }
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void writeFilterInformation(List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars) throws AlgebricksException {
        try {
            if (minFilterVars != null || maxFilterVars != null) {
                this.jsonGenerator.writeObjectFieldStart("with-filter-on");
                if (minFilterVars != null) {
                    this.writeArrayFieldOfVariables("min", minFilterVars);
                }
                if (maxFilterVars != null) {
                    this.writeArrayFieldOfVariables("max", maxFilterVars);
                }
                this.jsonGenerator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private void writeSelectLimitInformation(Mutable<ILogicalExpression> selectCondition, long outputLimit, Void i) throws AlgebricksException, IOException {
        if (selectCondition != null) {
            this.writeStringFieldExpression(CONDITION_FIELD, selectCondition, i);
        }
        if (outputLimit >= 0L) {
            this.jsonGenerator.writeStringField("limit", String.valueOf(outputLimit));
        }
    }

    private void writeProjectInformation(IProjectionInfo<?> projectionInfo) throws IOException {
        String projectedFields;
        String string = projectedFields = projectionInfo == null ? "" : projectionInfo.toString();
        if (!projectedFields.isEmpty()) {
            this.jsonGenerator.writeStringField("project", projectedFields);
        }
    }

    private void writeVariablesAndExpressions(List<LogicalVariable> variables, List<Mutable<ILogicalExpression>> expressions, Void indent) throws IOException, AlgebricksException {
        if (!variables.isEmpty()) {
            this.writeArrayFieldOfVariables(VARIABLES_FIELD, variables);
        }
        if (!expressions.isEmpty()) {
            this.writeArrayFieldOfExpressions(EXPRESSIONS_FIELD, expressions, indent);
        }
    }

    private void writeBuildSide(AbstractBinaryJoinOperator op) throws IOException {
        if (LogicalOperatorPrettyPrintVisitorJson.isHashJoin(op)) {
            this.jsonGenerator.writeNumberField("build-side", 0);
        }
    }

    private static boolean printInputsInReverse(AbstractLogicalOperator op) {
        return LogicalOperatorPrettyPrintVisitorJson.isHashJoin(op);
    }

    private static boolean isHashJoin(AbstractLogicalOperator op) {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        return pOp != null && (pOp.getOperatorTag() == PhysicalOperatorTag.IN_MEMORY_HASH_JOIN || pOp.getOperatorTag() == PhysicalOperatorTag.HYBRID_HASH_JOIN);
    }

    private String getIndexOpString(InsertDeleteUpsertOperator.Kind opKind) {
        switch (opKind) {
            case DELETE: {
                return "delete-from";
            }
            case INSERT: {
                return "insert-into";
            }
            case UPSERT: {
                return "upsert-into";
            }
        }
        throw new IllegalStateException();
    }

    private String getOrderString(OrderOperator.IOrder order, Void indent) throws AlgebricksException {
        switch (order.getKind()) {
            case ASC: {
                return "ASC";
            }
            case DESC: {
                return "DESC";
            }
        }
        return (String)((ILogicalExpression)order.getExpressionRef().getValue()).accept(this.exprVisitor, indent);
    }

    private void writeStringFieldExpression(String fieldName, Mutable<ILogicalExpression> expressionRef, Void indent) throws AlgebricksException, IOException {
        this.writeStringFieldExpression(fieldName, (ILogicalExpression)expressionRef.getValue(), indent);
    }

    private void writeStringFieldExpression(String fieldName, ILogicalExpression expression, Void indent) throws AlgebricksException, IOException {
        this.jsonGenerator.writeStringField(fieldName, (String)expression.accept(this.exprVisitor, indent));
    }

    private void writeArrayFieldOfVariables(String fieldName, List<LogicalVariable> variables) throws IOException {
        this.jsonGenerator.writeArrayFieldStart(fieldName);
        int size = variables.size();
        for (int i = 0; i < size; ++i) {
            this.jsonGenerator.writeString(String.valueOf(variables.get(i)));
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeArrayFieldOfNestedVariablesList(String fieldName, List<List<LogicalVariable>> nestedVarList) throws IOException {
        this.jsonGenerator.writeArrayFieldStart(fieldName);
        int size = nestedVarList.size();
        for (int i = 0; i < size; ++i) {
            List<LogicalVariable> nextList = nestedVarList.get(i);
            int varSize = nextList.size();
            for (int k = 0; k < varSize; ++k) {
                this.jsonGenerator.writeString(String.valueOf(nextList.get(k)));
            }
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeArrayFieldOfExpression(String fieldName, Mutable<ILogicalExpression> expr, Void indent) throws IOException, AlgebricksException {
        this.jsonGenerator.writeArrayFieldStart(fieldName);
        this.jsonGenerator.writeString((String)((ILogicalExpression)expr.getValue()).accept(this.exprVisitor, indent));
        this.jsonGenerator.writeEndArray();
    }

    private void writeArrayFieldOfExpressions(String fieldName, List<Mutable<ILogicalExpression>> exprs, Void indent) throws IOException, AlgebricksException {
        this.jsonGenerator.writeArrayFieldStart(fieldName);
        int size = exprs.size();
        for (int i = 0; i < size; ++i) {
            this.jsonGenerator.writeString((String)((ILogicalExpression)exprs.get(i).getValue()).accept(this.exprVisitor, indent));
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeArrayFieldOfVariableExpressionPairs(String fieldName, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> varExprPairs, Void indent) throws AlgebricksException, IOException {
        this.jsonGenerator.writeArrayFieldStart(fieldName);
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : varExprPairs) {
            this.jsonGenerator.writeStartObject();
            if (ve.first != null) {
                this.jsonGenerator.writeStringField("variable", ((LogicalVariable)ve.first).toString());
            }
            this.writeStringFieldExpression(EXPRESSION_FIELD, (Mutable<ILogicalExpression>)((Mutable)ve.second), indent);
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeArrayFieldOfOrderExprList(String fieldName, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderList, Void indent) throws AlgebricksException, IOException {
        this.jsonGenerator.writeArrayFieldStart(fieldName);
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : orderList) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("order", this.getOrderString((OrderOperator.IOrder)p.first, indent));
            this.writeStringFieldExpression(EXPRESSION_FIELD, (Mutable<ILogicalExpression>)((Mutable)p.second), indent);
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeObjectFieldWithExpressions(String fieldName, List<Mutable<ILogicalExpression>> exprs, Void indent) throws IOException, AlgebricksException {
        this.jsonGenerator.writeObjectFieldStart(fieldName);
        this.writeArrayFieldOfExpressions(EXPRESSIONS_FIELD, exprs, indent);
        this.jsonGenerator.writeEndObject();
    }

    private void writeNullField(String fieldName) throws IOException {
        this.jsonGenerator.writeNullField(fieldName);
    }

    private void flushContentToWriter() throws AlgebricksException {
        try {
            this.jsonGenerator.flush();
        }
        catch (IOException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ERROR_PRINTING_PLAN, (Serializable[])new Serializable[]{e, String.valueOf(e)});
        }
    }

    private class IdCounter {
        private int id;
        private final Deque<Integer> prefix = new LinkedList<Integer>();

        private IdCounter() {
            this.prefix.add(1);
            this.id = 0;
        }

        private void previousPrefix() {
            this.id = this.prefix.removeLast();
        }

        private void nextPrefix() {
            this.prefix.add(this.id);
            this.id = 0;
        }

        private String printOperatorId(AbstractLogicalOperator op) {
            Object[] values;
            String stringPrefix = "";
            for (Object val : values = this.prefix.toArray()) {
                stringPrefix = stringPrefix.isEmpty() ? val.toString() : stringPrefix + "." + val.toString();
            }
            if (!LogicalOperatorPrettyPrintVisitorJson.this.operatorIdentity.containsKey(op)) {
                String opId = stringPrefix.isEmpty() ? "" + ++this.id : stringPrefix + "." + ++this.id;
                LogicalOperatorPrettyPrintVisitorJson.this.operatorIdentity.put(op, opId);
            }
            return LogicalOperatorPrettyPrintVisitorJson.this.operatorIdentity.get(op);
        }
    }
}

