/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingTupleReference;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentReplacementContext
implements ILSMIndexOperationContext {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ILSMComponent> components;
    private final List<ILSMComponent> diskComponents;
    private final List<ILSMComponentId> replacedComponentIds;
    private final int[] swapIndexes;
    private int count = 0;
    private boolean accessingComponent = true;

    public ComponentReplacementContext(ILSMIndex lsmIndex) {
        this.components = new ArrayList<ILSMComponent>(lsmIndex.getNumberOfAllMemoryComponents());
        this.replacedComponentIds = new ArrayList<ILSMComponentId>(lsmIndex.getNumberOfAllMemoryComponents());
        this.swapIndexes = new int[lsmIndex.getNumberOfAllMemoryComponents()];
        this.diskComponents = new ArrayList<ILSMComponent>(lsmIndex.getNumberOfAllMemoryComponents());
    }

    public void setOperation(IndexOperation newOp) throws HyracksDataException {
    }

    public IndexOperation getOperation() {
        return IndexOperation.SEARCH;
    }

    public void reset() {
        this.accessingComponent = true;
        this.components.clear();
        this.diskComponents.clear();
        this.replacedComponentIds.clear();
        this.count = 0;
    }

    @Override
    public List<ILSMComponent> getComponentHolder() {
        return this.components;
    }

    @Override
    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return Collections.emptyList();
    }

    @Override
    public ISearchOperationCallback getSearchOperationCallback() {
        return null;
    }

    @Override
    public IExtendedModificationOperationCallback getModificationCallback() {
        return null;
    }

    @Override
    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISearchPredicate getSearchPredicate() {
        return null;
    }

    @Override
    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAccessingComponents() {
        return this.accessingComponent;
    }

    @Override
    public void setAccessingComponents(boolean accessingComponents) {
    }

    @Override
    public PermutingTupleReference getIndexTuple() {
        return null;
    }

    @Override
    public PermutingTupleReference getFilterTuple() {
        return null;
    }

    @Override
    public MultiComparator getFilterCmp() {
        return null;
    }

    @Override
    public void logPerformanceCounters(int tupleCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementEnterExitTime(long increment) {
    }

    public boolean proceed(List<ILSMDiskComponent> allDiskComponents) throws HyracksDataException {
        for (int i = 0; i < this.components.size(); ++i) {
            this.replacedComponentIds.add(this.components.get(i).getId());
            boolean found = false;
            ILSMComponentId replacedComponentId = this.replacedComponentIds.get(i);
            LOGGER.trace("looking for a component with the id: {}", (Object)replacedComponentId);
            for (ILSMDiskComponent dc : allDiskComponents) {
                ILSMComponentId diskComponentId = dc.getId();
                LOGGER.trace("next disk component id: {}", (Object)diskComponentId);
                if (!diskComponentId.equals(replacedComponentId)) continue;
                found = true;
                this.diskComponents.add(dc);
                break;
            }
            if (found) continue;
            LOGGER.warn("memory component {} was flushed and merged before search cursor replaces it", (Object)replacedComponentId);
            return false;
        }
        return true;
    }

    public void swapIndex(int i) {
        this.swapIndexes[this.count] = i;
        ++this.count;
    }

    public void prepareToEnter() {
        this.components.clear();
        this.components.addAll(this.diskComponents);
        this.accessingComponent = false;
    }

    public void replace(ILSMIndexOperationContext ctx) {
        try {
            for (int i = 0; i < this.count; ++i) {
                ILSMComponent removed = ctx.getComponentHolder().remove(this.swapIndexes[i]);
                if (removed.getType() != ILSMComponent.LSMComponentType.MEMORY) {
                    throw new IllegalStateException("Disk components can't be removed from the search operation");
                }
                LOGGER.info("Removed a memory component from the search operation");
                ctx.getComponentHolder().add(this.swapIndexes[i], this.diskComponents.get(i));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failure replacing memory components with disk components", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ILSMIndex getIndex() {
        return null;
    }

    @Override
    public boolean isTracingEnabled() {
        return false;
    }

    @Override
    public boolean isFilterSkipped() {
        return false;
    }

    @Override
    public void setFilterSkip(boolean skip) {
    }

    @Override
    public boolean isRecovery() {
        return false;
    }

    @Override
    public void setRecovery(boolean recovery) {
    }

    public void destroy() throws HyracksDataException {
    }

    @Override
    public ILSMIOOperation getIoOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIoOperation(ILSMIOOperation ioOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParameters(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getParameters() {
        throw new UnsupportedOperationException();
    }
}

