/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.sort.IRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ISorter;

public abstract class AbstractSortRunGenerator
implements IRunGenerator {
    private final List<GeneratedRunFileReader> generatedRunFileReaders = new LinkedList<GeneratedRunFileReader>();

    @Override
    public abstract ISorter getSorter();

    public void open() throws HyracksDataException {
        this.generatedRunFileReaders.clear();
    }

    public void close() throws HyracksDataException {
        ISorter sorter = this.getSorter();
        if (sorter != null && sorter.hasRemaining()) {
            if (this.generatedRunFileReaders.size() <= 0) {
                sorter.sort();
            } else {
                this.flushFramesToRun();
            }
        }
    }

    protected abstract RunFileWriter getRunFileWriter() throws HyracksDataException;

    protected abstract IFrameWriter getFlushableFrameWriter(RunFileWriter var1) throws HyracksDataException;

    void flushFramesToRun() throws HyracksDataException {
        ISorter sorter = this.getSorter();
        sorter.sort();
        RunFileWriter runWriter = this.getRunFileWriter();
        flushWriter.open();
        try (IFrameWriter flushWriter = this.getFlushableFrameWriter(runWriter);){
            sorter.flush(flushWriter);
        }
        this.generatedRunFileReaders.add(runWriter.createDeleteOnCloseReader());
        sorter.reset();
    }

    public void fail() throws HyracksDataException {
    }

    @Override
    public List<GeneratedRunFileReader> getRuns() {
        return this.generatedRunFileReaders;
    }
}

