/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.impl;

import com.rometools.fetcher.impl.FeedFetcherCache;
import com.rometools.fetcher.impl.SyndFeedInfo;
import com.rometools.utils.IO;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

@Deprecated
public class DiskFeedInfoCache
implements FeedFetcherCache {
    protected String cachePath = null;

    public DiskFeedInfoCache(String cachePath) {
        this.cachePath = cachePath;
    }

    @Override
    public SyndFeedInfo getFeedInfo(URL url) {
        String fileName = this.generateFilename(url);
        return this.getFeedInfo(fileName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFeedInfo(URL url, SyndFeedInfo feedInfo) {
        String fileName = this.generateFilename(url);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(fileName);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(feedInfo);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("Error while writing to cache", e);
                catch (IOException e2) {
                    throw new RuntimeException("Error while writing to cache", e2);
                }
            }
            catch (Throwable throwable) {
                IO.closeQuietly(fos);
                IO.closeQuietly(oos);
                throw throwable;
            }
        }
        IO.closeQuietly((Closeable)fos);
        IO.closeQuietly((Closeable)oos);
    }

    @Override
    public synchronized void clear() {
        File file = new File(this.cachePath);
        if (file.exists() && file.canWrite()) {
            String[] files = file.list();
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                File deleteMe = new File(this.cachePath + File.separator + files[i]);
                deleteMe.delete();
            }
        }
    }

    @Override
    public SyndFeedInfo remove(URL url) {
        File file;
        String fileName = this.generateFilename(url);
        SyndFeedInfo info = this.getFeedInfo(fileName);
        if (info != null && (file = new File(fileName)).exists()) {
            file.delete();
        }
        return info;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SyndFeedInfo getFeedInfo(String fileName) {
        SyndFeedInfo info = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(fileName);
            ois = new ObjectInputStream(fis);
            info = (SyndFeedInfo)ois.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IO.closeQuietly((Closeable)fis);
            IO.closeQuietly(ois);
            return info;
            catch (ClassNotFoundException e) {
                try {
                    throw new RuntimeException("Unable to read from cache", e);
                    catch (IOException e2) {
                        throw new RuntimeException("Unable to read from cache", e2);
                    }
                }
                catch (Throwable throwable) {
                    IO.closeQuietly(fis);
                    IO.closeQuietly(ois);
                    throw throwable;
                }
            }
        }
        IO.closeQuietly((Closeable)fis);
        IO.closeQuietly((Closeable)ois);
        return info;
    }

    private static String replaceNonAlphanumeric(String string, char character) {
        StringBuffer buffer = new StringBuffer(string.length());
        for (char singleChar : string.toCharArray()) {
            if (Character.isLetterOrDigit(singleChar)) {
                buffer.append(singleChar);
                continue;
            }
            buffer.append(character);
        }
        return buffer.toString();
    }

    private String generateFilename(URL url) {
        return this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
    }
}

