/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.providers;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

@SdkProtectedApi
public final class AwsProfileRegionProvider
implements AwsRegionProvider {
    private final String profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();

    @Override
    public Region getRegion() {
        return ProfileFile.defaultProfileFile().profile(this.profileName).map(p -> (String)p.properties().get("region")).map(Region::of).orElseThrow(() -> SdkClientException.builder().message("No region provided in profile: " + this.profileName).build());
    }
}

