/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpRequest;
import com.azure.core.util.Context;
import java.util.Objects;
import java.util.Optional;

public final class HttpPipelineCallContext {
    private HttpRequest httpRequest;
    private Context data;

    HttpPipelineCallContext(HttpRequest httpRequest) {
        this(httpRequest, Context.NONE);
    }

    HttpPipelineCallContext(HttpRequest httpRequest, Context data) {
        Objects.requireNonNull(httpRequest, "'httpRequest' cannot be null.");
        Objects.requireNonNull(data, "'data' cannot be null.");
        this.httpRequest = httpRequest;
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.data = this.data.addData(key, value);
    }

    public Optional<Object> getData(String key) {
        return this.data.getData(key);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpPipelineCallContext setHttpRequest(HttpRequest request) {
        this.httpRequest = request;
        return this;
    }
}

