/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.Collections;
import java.util.List;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.typecast.StaticTypeCastUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceEnforcedListTypeRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        List<Mutable<ILogicalExpression>> expressions;
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                AbstractAssignOperator assignOp = (AbstractAssignOperator)op;
                expressions = assignOp.getExpressions();
                break;
            }
            case UNNEST: {
                AbstractUnnestOperator unnestOp = (AbstractUnnestOperator)op;
                expressions = Collections.singletonList(unnestOp.getExpressionRef());
                break;
            }
            default: {
                return false;
            }
        }
        IVariableTypeEnvironment env = op.computeOutputTypeEnvironment((ITypingContext)context);
        return this.rewriteExpressions(expressions, env);
    }

    private boolean rewriteExpressions(List<Mutable<ILogicalExpression>> expressions, IVariableTypeEnvironment env) throws AlgebricksException {
        boolean changed = false;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            IAType exprType;
            AbstractFunctionCallExpression argFuncExpr;
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || !StaticTypeCastUtil.rewriteListExpr(argFuncExpr = (AbstractFunctionCallExpression)expr, exprType = (IAType)env.getType((ILogicalExpression)argFuncExpr), exprType, env)) continue;
            TypeCastUtils.resetRequiredAndInputTypes((AbstractFunctionCallExpression)argFuncExpr);
            changed = true;
        }
        return changed;
    }
}

