/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;

public class LSMSecondaryUpsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private final PermutingFrameTupleReference prevValueTuple = new PermutingFrameTupleReference();
    private final int numberOfFields;
    private final boolean isPrimaryKeyIndex;
    protected final int upsertIndicatorFieldIndex;
    protected final IBinaryBooleanInspector upsertIndicatorInspector;
    protected AbstractIndexModificationOperationCallback abstractModCallback;

    public LSMSecondaryUpsertOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, IModificationOperationCallbackFactory modCallbackFactory, ITupleFilterFactory tupleFilterFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, int upsertIndicatorFieldIndex, IBinaryBooleanInspectorFactory upsertIndicatorInspectorFactory, int[] prevValuePermutation) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, IndexOperation.UPSERT, modCallbackFactory, tupleFilterFactory);
        this.prevValueTuple.setFieldPermutation(prevValuePermutation);
        this.upsertIndicatorFieldIndex = upsertIndicatorFieldIndex;
        this.upsertIndicatorInspector = upsertIndicatorInspectorFactory.createBinaryBooleanInspector(ctx);
        this.numberOfFields = fieldPermutation.length;
        this.isPrimaryKeyIndex = Arrays.equals(fieldPermutation, prevValuePermutation);
    }

    public void open() throws HyracksDataException {
        super.open();
        this.frameTuple = new FrameTupleReference();
        this.abstractModCallback = (AbstractIndexModificationOperationCallback)this.modCallback;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessor;
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                boolean isUpsert = this.upsertIndicatorInspector.getBooleanValue(this.frameTuple.getFieldData(this.upsertIndicatorFieldIndex), this.frameTuple.getFieldStart(this.upsertIndicatorFieldIndex), this.frameTuple.getFieldLength(this.upsertIndicatorFieldIndex));
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                this.prevValueTuple.reset((IFrameTupleAccessor)this.accessor, i);
                boolean newTupleHasNullOrMissing = LSMSecondaryUpsertOperatorNodePushable.hasNullOrMissing((FrameTupleReference)this.tuple);
                boolean oldTupleHasNullOrMissing = LSMSecondaryUpsertOperatorNodePushable.hasNullOrMissing((FrameTupleReference)this.prevValueTuple);
                if (newTupleHasNullOrMissing && oldTupleHasNullOrMissing || !this.isPrimaryKeyIndex && TupleUtils.equalTuples((ITupleReference)this.tuple, (ITupleReference)this.prevValueTuple, (int)this.numberOfFields)) continue;
                if (!oldTupleHasNullOrMissing) {
                    this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                    lsmAccessor.forceDelete((ITupleReference)this.prevValueTuple);
                }
                if (!isUpsert || newTupleHasNullOrMissing) continue;
                this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.INSERT);
                lsmAccessor.forceInsert((ITupleReference)this.tuple);
                continue;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    private static boolean isNullOrMissing(FrameTupleReference tuple, int fieldIdx) {
        return TypeTagUtil.isType((ITupleReference)tuple, (int)fieldIdx, (byte)ATypeTag.SERIALIZED_NULL_TYPE_TAG) || TypeTagUtil.isType((ITupleReference)tuple, (int)fieldIdx, (byte)ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
    }

    protected static boolean hasNullOrMissing(FrameTupleReference tuple) {
        int fieldCount = tuple.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            if (!LSMSecondaryUpsertOperatorNodePushable.isNullOrMissing(tuple, i)) continue;
            return true;
        }
        return false;
    }
}

