/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;

public class InvertedIndexJobGenParams
extends AccessMethodJobGenParams {
    protected InvertedIndexAccessMethod.SearchModifierType searchModifierType;
    protected IAlgebricksConstantValue similarityThreshold;
    protected ATypeTag searchKeyType;
    protected List<LogicalVariable> keyVarList;
    protected List<LogicalVariable> nonKeyVarList;
    protected boolean isFullTextSearchQuery = false;
    protected static final int SEARCH_MODIFIER_INDEX = 0;
    protected static final int SIM_THRESHOLD_INDEX = 1;
    protected static final int SEARCH_KEY_TYPE_INDEX = 2;
    protected static final int IS_FULLTEXT_SEARCH_INDEX = 3;
    protected static final int KEY_VAR_INDEX = 4;

    public InvertedIndexJobGenParams() {
    }

    public InvertedIndexJobGenParams(String indexName, DatasetConfig.IndexType indexType, DataverseName dataverseName, String datasetName, boolean retainInput, boolean requiresBroadcast) {
        super(indexName, indexType, dataverseName, datasetName, retainInput, requiresBroadcast);
    }

    public void setSearchModifierType(InvertedIndexAccessMethod.SearchModifierType searchModifierType) {
        this.searchModifierType = searchModifierType;
    }

    public void setIsFullTextSearch(boolean isFullTextSearchQuery) {
        this.isFullTextSearchQuery = isFullTextSearchQuery;
    }

    public void setSimilarityThreshold(IAlgebricksConstantValue similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public void setSearchKeyType(ATypeTag searchKeyType) {
        this.searchKeyType = searchKeyType;
    }

    public void setKeyVarList(List<LogicalVariable> keyVarList) {
        this.keyVarList = keyVarList;
    }

    @Override
    public void writeToFuncArgs(List<Mutable<ILogicalExpression>> funcArgs) {
        super.writeToFuncArgs(funcArgs);
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createInt32Constant(this.searchModifierType.ordinal())));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)new ConstantExpression(this.similarityThreshold)));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createInt32Constant(this.searchKeyType.ordinal())));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createBooleanConstant(this.isFullTextSearchQuery)));
        this.writeVarList(this.keyVarList, funcArgs);
        if (this.nonKeyVarList != null) {
            this.writeVarList(this.nonKeyVarList, funcArgs);
        }
    }

    @Override
    public void readFromFuncArgs(List<Mutable<ILogicalExpression>> funcArgs) throws AlgebricksException {
        super.readFromFuncArgs(funcArgs);
        int index = super.getNumParams();
        int searchModifierOrdinal = AccessMethodUtils.getInt32Constant(funcArgs.get(index + 0));
        this.searchModifierType = InvertedIndexAccessMethod.SearchModifierType.values()[searchModifierOrdinal];
        this.similarityThreshold = ((ConstantExpression)funcArgs.get(index + 1).getValue()).getValue();
        int typeTagOrdinal = AccessMethodUtils.getInt32Constant(funcArgs.get(index + 2));
        this.searchKeyType = ATypeTag.values()[typeTagOrdinal];
        this.isFullTextSearchQuery = AccessMethodUtils.getBooleanConstant(funcArgs.get(index + 3));
        this.keyVarList = new ArrayList<LogicalVariable>();
        this.readVarList(funcArgs, index + 4, this.keyVarList);
        this.nonKeyVarList = null;
    }

    public InvertedIndexAccessMethod.SearchModifierType getSearchModifierType() {
        return this.searchModifierType;
    }

    public boolean getIsFullTextSearch() {
        return this.isFullTextSearchQuery;
    }

    public IAlgebricksConstantValue getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public ATypeTag getSearchKeyType() {
        return this.searchKeyType;
    }

    public List<LogicalVariable> getKeyVarList() {
        return this.keyVarList;
    }

    public List<LogicalVariable> getNonKeyVarList() {
        return this.nonKeyVarList;
    }
}

