/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.topology;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.topology.NetworkEndpoint;
import org.apache.hyracks.api.topology.NetworkTerminal;

public class NetworkSwitch
extends NetworkEndpoint {
    private static final long serialVersionUID = 1L;
    private final Port[] ports;
    private final Map<String, Integer> terminalNamePortIndexMap;

    public NetworkSwitch(String name, Map<String, String> properties, Port[] ports) {
        super(name, properties);
        this.ports = ports;
        this.terminalNamePortIndexMap = new HashMap<String, Integer>();
        block4: for (int i = 0; i < ports.length; ++i) {
            Port port = ports[i];
            NetworkEndpoint endpoint = port.getEndpoint();
            Integer portIndex = i;
            switch (endpoint.getType()) {
                case NETWORK_SWITCH: {
                    NetworkSwitch s = (NetworkSwitch)endpoint;
                    for (String t : s.terminalNamePortIndexMap.keySet()) {
                        this.terminalNamePortIndexMap.put(t, portIndex);
                    }
                    continue block4;
                }
                case NETWORK_TERMINAL: {
                    NetworkTerminal t = (NetworkTerminal)endpoint;
                    this.terminalNamePortIndexMap.put(t.getName(), portIndex);
                    continue block4;
                }
            }
        }
    }

    public Port[] getPorts() {
        return this.ports;
    }

    @Override
    public NetworkEndpoint.EndpointType getType() {
        return NetworkEndpoint.EndpointType.NETWORK_SWITCH;
    }

    boolean lookupNetworkTerminal(String terminalName, List<Integer> path) {
        if (this.terminalNamePortIndexMap.containsKey(terminalName)) {
            Integer portIndex = this.terminalNamePortIndexMap.get(terminalName);
            path.add(portIndex);
            NetworkEndpoint endpoint = this.ports[portIndex].getEndpoint();
            if (endpoint.getType() == NetworkEndpoint.EndpointType.NETWORK_SWITCH) {
                ((NetworkSwitch)endpoint).lookupNetworkTerminal(terminalName, path);
            }
            return true;
        }
        return false;
    }

    void getPortList(List<Integer> path, int stepIndex, List<Port> portList) {
        if (stepIndex >= path.size()) {
            return;
        }
        int portIndex = path.get(stepIndex);
        Port port = this.ports[portIndex];
        portList.add(port);
        if (++stepIndex >= path.size()) {
            return;
        }
        NetworkEndpoint endpoint = port.getEndpoint();
        if (endpoint.getType() != NetworkEndpoint.EndpointType.NETWORK_SWITCH) {
            throw new IllegalArgumentException("Path provided, " + path + ", longer than depth of topology tree");
        }
        ((NetworkSwitch)endpoint).getPortList(path, stepIndex, portList);
    }

    public static class Port
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final NetworkEndpoint endpoint;

        public Port(NetworkEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public NetworkEndpoint getEndpoint() {
            return this.endpoint;
        }
    }
}

