/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceReference {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String root;
    protected final String partition;
    protected final DataverseName dataverse;
    protected final String dataset;
    protected final String rebalance;
    protected final String index;
    protected final String name;
    private final Path relativePath;

    protected ResourceReference(String path) {
        Object[] tokens = StringUtils.split((String)path, (char)File.separatorChar);
        if (tokens.length < 6) {
            throw new IllegalStateException("Unrecognized path structure: " + path);
        }
        int offset = tokens.length;
        this.name = tokens[--offset];
        this.index = tokens[--offset];
        this.rebalance = tokens[--offset];
        this.dataset = tokens[--offset];
        ArrayList<String> dvParts = new ArrayList<String>();
        String dvPart = tokens[--offset];
        while (dvPart.codePointAt(0) == 94) {
            dvParts.add(dvPart.substring(1));
            dvPart = tokens[--offset];
        }
        String probablyPartition = tokens[--offset];
        if (dvParts.isEmpty()) {
            try {
                this.dataverse = DataverseName.createSinglePartName(dvPart);
            }
            catch (AsterixException e) {
                throw new IllegalArgumentException("unable to parse path: '" + path + "'!", (Throwable)((Object)e));
            }
            this.partition = probablyPartition;
            this.root = tokens[--offset];
        } else if (probablyPartition.startsWith("partition_")) {
            dvParts.add(dvPart);
            Collections.reverse(dvParts);
            try {
                this.dataverse = DataverseName.create(dvParts);
            }
            catch (AsterixException e) {
                throw new IllegalArgumentException("unable to parse path: '" + path + "'!", (Throwable)((Object)e));
            }
            this.partition = probablyPartition;
            this.root = tokens[--offset];
        } else if (dvPart.startsWith("partition_")) {
            if (dvParts.size() != 1) {
                throw new IllegalArgumentException("unable to parse path: '" + path + "'!");
            }
            try {
                this.dataverse = DataverseName.createSinglePartName("^" + (String)dvParts.get(0));
            }
            catch (AsterixException e) {
                throw new IllegalArgumentException("unable to parse path: '" + path + "'!", (Throwable)((Object)e));
            }
            LOGGER.info("legacy dataverse starting with ^ found: '{}'; this is not supported for new dataverses", (Object)this.dataverse);
            this.partition = dvPart;
            this.root = probablyPartition;
        } else {
            throw new IllegalArgumentException("unable to parse path: '" + path + "'!");
        }
        this.relativePath = Paths.get(this.root, (String[])ArrayUtils.subarray((Object[])tokens, (int)(offset + 1), (int)(tokens.length - 1)));
    }

    public static ResourceReference ofIndex(String indexPath) {
        return ResourceReference.of(new File(indexPath, ".metadata").toString());
    }

    public static ResourceReference of(String localResourcePath) {
        return new ResourceReference(localResourcePath);
    }

    public String getPartition() {
        return this.partition;
    }

    public DataverseName getDataverse() {
        return this.dataverse;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getRebalance() {
        return this.rebalance;
    }

    public String getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public ResourceReference getDatasetReference() {
        return ResourceReference.ofIndex(this.relativePath.getParent().resolve(this.dataset).toFile().getPath());
    }

    public Path getFileRelativePath() {
        return this.relativePath.resolve(this.name);
    }

    public int getPartitionNum() {
        return Integer.parseInt(this.partition.substring("partition_".length()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ResourceReference) {
            ResourceReference that = (ResourceReference)o;
            return this.getRelativePath().equals(that.getRelativePath());
        }
        return false;
    }

    public int hashCode() {
        return this.getRelativePath().hashCode();
    }

    public String toString() {
        return this.getRelativePath().toString();
    }

    public static String getComponentSequence(String componentFile) {
        ResourceReference ref = ResourceReference.of(componentFile);
        return IndexComponentFileReference.of((String)ref.getName()).getSequence();
    }
}

