/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.PartitionChannel;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.IOperatorEnvironment;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.common.job.profiling.StatsCollector;
import org.apache.hyracks.control.common.job.profiling.om.PartitionProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import org.apache.hyracks.control.nc.work.NotifyTaskCompleteWork;
import org.apache.hyracks.control.nc.work.NotifyTaskFailureWork;
import org.apache.hyracks.util.IThreadStats;
import org.apache.hyracks.util.IThreadStatsCollector;
import org.apache.hyracks.util.ThreadStats;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Task
implements IHyracksTaskContext,
ICounterContext,
Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Joblet joblet;
    private final TaskAttemptId taskAttemptId;
    private final String displayName;
    private final ExecutorService executorService;
    private final IWorkspaceFileFactory fileFactory;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final Map<String, Counter> counterMap;
    private final IOperatorEnvironment opEnv;
    private final Map<PartitionId, PartitionProfile> partitionSendProfile;
    private final Set<Thread> pendingThreads;
    private IPartitionCollector[] collectors;
    private IOperatorNodePushable operator;
    private final List<Exception> exceptions;
    private volatile boolean aborted;
    private final NodeControllerService ncs;
    private List<List<PartitionChannel>> inputChannelsFromConnectors;
    private Object sharedObject;
    private final Set<JobFlag> jobFlags;
    private final IStatsCollector statsCollector;
    private volatile boolean completed = false;
    private final Set<Warning> warnings;
    private final IWarningCollector warningCollector;
    private final Set<IThreadStatsCollector> threadStatsCollectors = new HashSet<IThreadStatsCollector>();
    private final Map<Long, IThreadStats> perThreadStats = new HashMap<Long, IThreadStats>();

    public Task(Joblet joblet, Set<JobFlag> jobFlags, TaskAttemptId taskId, String displayName, ExecutorService executor, NodeControllerService ncs, List<List<PartitionChannel>> inputChannelsFromConnectors) {
        this.joblet = joblet;
        this.jobFlags = jobFlags;
        this.taskAttemptId = taskId;
        this.displayName = displayName;
        this.executorService = executor;
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, joblet.getIoManager());
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.counterMap = new HashMap<String, Counter>();
        this.opEnv = joblet.getEnvironment();
        this.partitionSendProfile = new Hashtable<PartitionId, PartitionProfile>();
        this.pendingThreads = new LinkedHashSet<Thread>();
        this.exceptions = new CopyOnWriteArrayList<Exception>();
        this.ncs = ncs;
        this.inputChannelsFromConnectors = inputChannelsFromConnectors;
        this.statsCollector = new StatsCollector();
        this.warnings = ConcurrentHashMap.newKeySet();
        this.warningCollector = this.createWarningCollector(joblet.getMaxWarnings());
    }

    public void setTaskRuntime(IPartitionCollector[] collectors, IOperatorNodePushable operator) {
        this.collectors = collectors;
        this.operator = operator;
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.joblet.allocateFrame();
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        return this.joblet.allocateFrame(bytes);
    }

    public ByteBuffer reallocateFrame(ByteBuffer usedBuffer, int newSizeInBytes, boolean copyOldData) throws HyracksDataException {
        return this.joblet.reallocateFrame(usedBuffer, newSizeInBytes, copyOldData);
    }

    public void deallocateFrames(int bytes) {
        this.joblet.deallocateFrames(bytes);
    }

    public int getInitialFrameSize() {
        return this.joblet.getInitialFrameSize();
    }

    public IIOManager getIoManager() {
        return this.joblet.getIoManager();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public void registerDeallocatable(IDeallocatable deallocatable) {
        this.deallocatableRegistry.registerDeallocatable(deallocatable);
    }

    public void close() {
        this.deallocatableRegistry.close();
        this.threadStatsCollectors.forEach(IThreadStatsCollector::unsubscribe);
    }

    public IHyracksJobletContext getJobletContext() {
        return this.joblet;
    }

    public TaskAttemptId getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public ICounter getCounter(String name, boolean create) {
        Counter counter = this.counterMap.get(name);
        if (counter == null && create) {
            counter = new Counter(name);
            this.counterMap.put(name, counter);
        }
        return counter;
    }

    public ICounterContext getCounterContext() {
        return this;
    }

    public NodeControllerService getNodeControllerService() {
        return this.ncs;
    }

    public Joblet getJoblet() {
        return this.joblet;
    }

    public Map<PartitionId, PartitionProfile> getPartitionSendProfile() {
        return this.partitionSendProfile;
    }

    public synchronized void dumpProfile(TaskProfile tProfile) {
        Map dumpMap = tProfile.getCounters();
        for (Counter c : this.counterMap.values()) {
            dumpMap.put(c.getName(), c.get());
        }
    }

    public void setPartitionSendProfile(PartitionProfile profile) {
        this.partitionSendProfile.put(profile.getPartitionId(), profile);
    }

    public void start() throws HyracksException {
        this.aborted = false;
        this.executorService.execute(this);
    }

    public synchronized void abort() {
        this.aborted = true;
        for (IPartitionCollector c : this.collectors) {
            c.abort();
        }
        for (Thread t : this.pendingThreads) {
            t.interrupt();
        }
    }

    private synchronized boolean addPendingThread(Thread t) {
        if (this.aborted) {
            return false;
        }
        return this.pendingThreads.add(t);
    }

    public synchronized List<Thread> getPendingThreads() {
        return new ArrayList<Thread>(this.pendingThreads);
    }

    private synchronized void removePendingThread(Thread t) {
        this.pendingThreads.remove(t);
        if (this.pendingThreads.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        while (!this.pendingThreads.isEmpty()) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread ct = Thread.currentThread();
        if (!this.addPendingThread(ct)) {
            this.exceptions.add((Exception)((Object)HyracksDataException.create((ErrorCode)ErrorCode.TASK_ABORTED, (Serializable[])new Serializable[]{this.getTaskAttemptId()})));
            ExceptionUtils.setNodeIds(this.exceptions, (String)this.ncs.getId());
            this.ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskFailureWork(this.ncs, this, this.exceptions, this.joblet.getJobId(), this.taskAttemptId));
            return;
        }
        ct.setName(this.displayName + ":" + this.joblet.getJobId() + ":" + this.taskAttemptId + ":0");
        try {
            Throwable operatorException;
            block25: {
                operatorException = null;
                try {
                    this.operator.initialize();
                    if (this.collectors.length <= 0) break block25;
                    Semaphore sem = new Semaphore(this.collectors.length - 1);
                    int i = 1;
                    while (i < this.collectors.length) {
                        IPartitionCollector collector = this.collectors[i];
                        IFrameWriter writer = this.operator.getInputFrameWriter(i);
                        sem.acquireUninterruptibly();
                        int cIdx = i++;
                        this.executorService.execute(() -> {
                            try {
                                Thread thread = Thread.currentThread();
                                if (!this.addPendingThread(thread)) {
                                    return;
                                }
                                thread.setName(this.displayName + ":" + this.joblet.getJobId() + ":" + this.taskAttemptId + ":" + cIdx);
                                thread.setPriority(1);
                                try {
                                    this.pushFrames(collector, this.inputChannelsFromConnectors.get(cIdx), writer);
                                }
                                catch (HyracksDataException e) {
                                    Task task = this;
                                    synchronized (task) {
                                        this.exceptions.add((Exception)((Object)e));
                                    }
                                }
                                finally {
                                    this.removePendingThread(thread);
                                }
                            }
                            finally {
                                this.unsubscribeThreadFromStats();
                                sem.release();
                            }
                        });
                    }
                    try {
                        this.pushFrames(this.collectors[0], this.inputChannelsFromConnectors.get(0), this.operator.getInputFrameWriter(0));
                    }
                    finally {
                        this.unsubscribeThreadFromStats();
                        sem.acquireUninterruptibly(this.collectors.length - 1);
                    }
                }
                catch (Throwable e) {
                    operatorException = e;
                }
                finally {
                    try {
                        this.operator.deinitialize();
                    }
                    catch (Throwable e) {
                        operatorException = ExceptionUtils.suppress((Throwable)operatorException, (Throwable)e);
                    }
                }
            }
            if (operatorException != null) {
                throw operatorException;
            }
            this.ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskCompleteWork(this.ncs, this));
        }
        catch (Throwable e) {
            this.exceptions.add((Exception)((Object)HyracksDataException.create((Throwable)e)));
        }
        finally {
            this.close();
            this.removePendingThread(ct);
            this.completed = true;
        }
        if (!this.exceptions.isEmpty()) {
            if (LOGGER.isWarnEnabled()) {
                for (int i = 0; i < this.exceptions.size(); ++i) {
                    Exception e = this.exceptions.get(i);
                    LOGGER.log(ExceptionUtils.causedByInterrupt((Throwable)e) ? Level.DEBUG : Level.WARN, "Task failed with exception" + (String)(this.exceptions.size() > 1 ? "s (" + (i + 1) + "/" + this.exceptions.size() + ")" : ""), (Throwable)e);
                }
            }
            ExceptionUtils.setNodeIds(this.exceptions, (String)this.ncs.getId());
            this.ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskFailureWork(this.ncs, this, this.exceptions, this.joblet.getJobId(), this.taskAttemptId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFrames(IPartitionCollector collector, List<PartitionChannel> inputChannels, IFrameWriter writer) throws HyracksDataException {
        if (this.aborted) {
            return;
        }
        try {
            collector.open();
            try {
                if (inputChannels.isEmpty()) {
                    this.joblet.advertisePartitionRequest(this.taskAttemptId, collector.getRequiredPartitionIds(), collector, PartitionState.STARTED);
                } else {
                    collector.addPartitions(inputChannels);
                }
                reader.open();
                try (IFrameReader reader = collector.getReader();){
                    try {
                        writer.open();
                        VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)this);
                        while (true) {
                            if (reader.nextFrame((IFrame)frame)) {
                                if (this.aborted) {
                                    return;
                                }
                                ByteBuffer buffer = frame.getBuffer();
                                writer.nextFrame(buffer);
                                buffer.compact();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        try {
                            writer.fail();
                        }
                        catch (HyracksDataException e1) {
                            e.addSuppressed(e1);
                        }
                        throw e;
                    }
                    finally {
                        writer.close();
                    }
                }
            }
            finally {
                collector.close();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void setStateObject(IStateObject taskState) {
        this.opEnv.setStateObject(taskState);
    }

    public IStateObject getStateObject(Object id) {
        return this.opEnv.getStateObject(id);
    }

    public IResultPartitionManager getResultPartitionManager() {
        return this.ncs.getResultPartitionManager();
    }

    public void sendApplicationMessageToCC(byte[] message, DeploymentId deploymentId) throws Exception {
        this.ncs.sendApplicationMessageToCC(this.getJobletContext().getJobId().getCcId(), message, deploymentId);
    }

    public void sendApplicationMessageToCC(Serializable message, DeploymentId deploymentId) throws Exception {
        this.ncs.sendApplicationMessageToCC(this.getJobletContext().getJobId().getCcId(), JavaSerializationUtils.serialize((Serializable)message), deploymentId);
    }

    public void setSharedObject(Object object) {
        this.sharedObject = object;
    }

    public Object getSharedObject() {
        return this.sharedObject;
    }

    public byte[] getJobParameter(byte[] name, int start, int length) throws HyracksException {
        return this.ncs.createOrGetJobParameterByteStore(this.joblet.getJobId()).getParameterValue(name, start, length);
    }

    public Set<JobFlag> getJobFlags() {
        return this.jobFlags;
    }

    public IStatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public IWarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThreadStats getThreadStats() {
        Set<IThreadStatsCollector> set = this.threadStatsCollectors;
        synchronized (set) {
            return this.perThreadStats.computeIfAbsent(Thread.currentThread().getId(), threadId -> new ThreadStats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void subscribeThreadToStats(IThreadStatsCollector threadStatsCollector) {
        if (!this.isRuntimeProfilingEnabled()) {
            return;
        }
        Set<IThreadStatsCollector> set = this.threadStatsCollectors;
        synchronized (set) {
            this.threadStatsCollectors.add(threadStatsCollector);
            long threadId = Thread.currentThread().getId();
            IThreadStats threadStat = this.perThreadStats.computeIfAbsent(threadId, id -> new ThreadStats());
            threadStatsCollector.subscribe(threadStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribeThreadFromStats() {
        if (!this.isRuntimeProfilingEnabled()) {
            return;
        }
        Set<IThreadStatsCollector> set = this.threadStatsCollectors;
        synchronized (set) {
            this.threadStatsCollectors.forEach(IThreadStatsCollector::unsubscribe);
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Set<Warning> getWarnings() {
        return this.warnings;
    }

    private IWarningCollector createWarningCollector(final long maxWarnings) {
        return new IWarningCollector(){
            private final AtomicLong warningsCount = new AtomicLong();

            public void warn(Warning warning) {
                Task.this.warnings.add(warning);
            }

            public boolean shouldWarn() {
                long currentCount = this.warningsCount.getAndUpdate(count -> count < Long.MAX_VALUE ? count + 1L : count);
                return currentCount < maxWarnings;
            }

            public long getTotalWarningsCount() {
                return this.warningsCount.get();
            }
        };
    }

    public String toString() {
        return "{ \"class\" : \"" + this.getClass().getSimpleName() + "\", \"node\" : \"" + this.ncs.getId() + "\" \"jobId\" : \"" + this.joblet.getJobId() + "\", \"taskId\" : \"" + this.taskAttemptId + "\" }";
    }

    private boolean isRuntimeProfilingEnabled() {
        return this.getJobFlags().contains(JobFlag.PROFILE_RUNTIME);
    }
}

