/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.runningaggregates.std;

import java.io.DataOutput;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IWindowAggregateEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractRankRunningAggregateEvaluator
implements IWindowAggregateEvaluator {
    private final IScalarEvaluator[] args;
    private final ArrayBackedValueStorage[] argPrevValues;
    private final IPointable[] argCurrValues;
    private final boolean dense;
    protected final SourceLocation sourceLoc;
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private IBinaryComparator[] argComparators;
    protected boolean first;
    protected long rank;
    private long groupSize;

    AbstractRankRunningAggregateEvaluator(IScalarEvaluator[] args, boolean dense, SourceLocation sourceLoc) {
        this.args = args;
        this.dense = dense;
        this.sourceLoc = sourceLoc;
        this.argPrevValues = new ArrayBackedValueStorage[args.length];
        this.argCurrValues = new IPointable[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.argPrevValues[i] = new ArrayBackedValueStorage();
            this.argCurrValues[i] = VoidPointable.FACTORY.createPointable();
        }
    }

    public void configure(IBinaryComparator[] orderComparators) {
        this.argComparators = orderComparators;
    }

    public void init() throws HyracksDataException {
    }

    public void initPartition(long partitionLength) {
        this.first = true;
    }

    public void step(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int i;
        this.resultStorage.reset();
        for (i = 0; i < this.args.length; ++i) {
            this.args[i].evaluate(tuple, this.argCurrValues[i]);
        }
        this.computeRank();
        this.computeResult(this.resultStorage.getDataOutput());
        result.set((IValueReference)this.resultStorage);
        for (i = 0; i < this.args.length; ++i) {
            this.argPrevValues[i].assign((IValueReference)this.argCurrValues[i]);
        }
        this.first = false;
    }

    protected abstract void computeResult(DataOutput var1) throws HyracksDataException;

    private void computeRank() throws HyracksDataException {
        if (this.first) {
            this.rank = 1L;
            this.groupSize = 1L;
        } else if (this.sameGroup()) {
            ++this.groupSize;
        } else {
            this.rank += this.dense ? 1L : this.groupSize;
            this.groupSize = 1L;
        }
    }

    private boolean sameGroup() throws HyracksDataException {
        for (int i = 0; i < this.args.length; ++i) {
            ArrayBackedValueStorage v1 = this.argPrevValues[i];
            IPointable v2 = this.argCurrValues[i];
            IBinaryComparator cmp = this.argComparators[i];
            if (cmp.compare(v1.getByteArray(), v1.getStartOffset(), v1.getLength(), v2.getByteArray(), v2.getStartOffset(), v2.getLength()) == 0) continue;
            return false;
        }
        return true;
    }
}

