/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class BitValuePositionFlagEvaluator
extends AbstractScalarEval {
    private ABoolean resultBoolean;
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private boolean isStopUpdatingResultBoolean = false;
    private final IScalarEvaluator valueEvaluator;
    private final IScalarEvaluator positionEvaluator;
    private IScalarEvaluator flagEvaluator;
    private final IPointable valuePointable = new VoidPointable();
    private final IPointable positionPointable = new VoidPointable();
    private IPointable flagPointable;
    private final ListAccessor listAccessor = new ListAccessor();
    private final IPointable listItemPointable = new VoidPointable();
    private final ISerializerDeserializer aBooleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private final IEvaluatorContext context;
    private static final byte[] secondArgumentExpectedTypes = new byte[]{ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG};

    BitValuePositionFlagEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] argEvaluatorFactories, FunctionIdentifier functionIdentifier, SourceLocation sourceLocation) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.context = context;
        this.valueEvaluator = argEvaluatorFactories[0].createScalarEvaluator(context);
        this.positionEvaluator = argEvaluatorFactories[1].createScalarEvaluator(context);
        if (argEvaluatorFactories.length > 2) {
            this.flagEvaluator = argEvaluatorFactories[2].createScalarEvaluator(context);
            this.flagPointable = new VoidPointable();
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int positionStartOffset;
        int valueStartOffset;
        this.valueEvaluator.evaluate(tuple, this.valuePointable);
        this.positionEvaluator.evaluate(tuple, this.positionPointable);
        if (this.flagEvaluator != null) {
            this.flagEvaluator.evaluate(tuple, this.flagPointable);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.valuePointable, this.positionPointable, this.flagPointable)) {
            return;
        }
        byte[] valueBytes = this.valuePointable.getByteArray();
        if (!PointableHelper.isValidLongValue(valueBytes, valueStartOffset = this.valuePointable.getStartOffset(), true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)valueBytes[valueStartOffset], (int)0, (ATypeTag)ATypeTag.BIGINT);
            PointableHelper.setNull(result);
            return;
        }
        byte[] positionBytes = this.positionPointable.getByteArray();
        ATypeTag positionTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(positionBytes[positionStartOffset = this.positionPointable.getStartOffset()]);
        if (!ATypeHierarchy.canPromote((ATypeTag)positionTypeTag, (ATypeTag)ATypeTag.DOUBLE) && positionTypeTag != ATypeTag.ARRAY) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)positionBytes[positionStartOffset], (int)1, (byte[])secondArgumentExpectedTypes);
            PointableHelper.setNull(result);
            return;
        }
        boolean isAllSet = false;
        this.isStopUpdatingResultBoolean = false;
        if (this.flagEvaluator != null) {
            int flagStartOffset;
            byte[] flagBytes = this.flagPointable.getByteArray();
            ATypeTag flagTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(flagBytes[flagStartOffset = this.flagPointable.getStartOffset()]);
            if (flagTypeTag != ATypeTag.BOOLEAN) {
                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)flagBytes[flagStartOffset], (int)2, (ATypeTag)ATypeTag.BOOLEAN);
                PointableHelper.setNull(result);
                return;
            }
            isAllSet = ABooleanSerializerDeserializer.getBoolean((byte[])flagBytes, (int)(flagStartOffset + 1));
        }
        long longResult = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)0, (byte[])valueBytes, (int)valueStartOffset);
        boolean isSuccessfulOperation = positionTypeTag != ATypeTag.ARRAY ? this.applyBitWiseOperationWithNumericAsPosition(longResult, positionBytes, positionStartOffset) : this.applyBitWiseOperationWithArrayAsPosition(longResult, positionBytes, positionStartOffset, isAllSet);
        if (!isSuccessfulOperation) {
            PointableHelper.setNull(result);
            return;
        }
        this.resultStorage.reset();
        this.aBooleanSerde.serialize((Object)this.resultBoolean, this.resultStorage.getDataOutput());
        result.set((IValueReference)this.resultStorage);
    }

    private boolean applyBitWiseOperationWithArrayAsPosition(long value, byte[] bytes, int startOffset, boolean isAllSet) throws HyracksDataException {
        this.listAccessor.reset(bytes, startOffset);
        if (this.listAccessor.size() == 0) {
            return true;
        }
        try {
            for (int i = 0; i < this.listAccessor.size(); ++i) {
                this.listAccessor.getOrWriteItem(i, this.listItemPointable, this.resultStorage);
                byte[] itemBytes = this.listItemPointable.getByteArray();
                int itemStartOffset = this.listItemPointable.getStartOffset();
                if (!this.applyBitWiseOperationWithNumericAsPosition(value, itemBytes, itemStartOffset)) {
                    return false;
                }
                this.isStopUpdatingResultBoolean = !isAllSet ? this.resultBoolean == ABoolean.TRUE : this.resultBoolean == ABoolean.FALSE;
            }
            return true;
        }
        catch (IOException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    private boolean applyBitWiseOperationWithNumericAsPosition(long value, byte[] bytes, int startOffset) throws HyracksDataException {
        if (!PointableHelper.isValidLongValue(bytes, startOffset, true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)bytes[startOffset], (int)1, (ATypeTag)ATypeTag.BIGINT);
            return false;
        }
        long position = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)1, (byte[])bytes, (int)startOffset);
        if (position < 1L || position > 64L) {
            this.handleOutOfRangeInput(1, 1, 64, position);
            return false;
        }
        if (!this.isStopUpdatingResultBoolean) {
            this.resultBoolean = (value & 1L << (int)(position - 1L)) != 0L ? ABoolean.TRUE : ABoolean.FALSE;
        }
        return true;
    }

    private void handleOutOfRangeInput(int inputPosition, int startLimit, int endLimit, long actual) {
        IWarningCollector warningCollector = this.context.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(WarningUtil.forAsterix((SourceLocation)this.srcLoc, (int)43, (Serializable[])new Serializable[]{this.funID, ExceptionUtil.indexToPosition((int)inputPosition), Integer.valueOf(startLimit), Integer.valueOf(endLimit), Long.valueOf(actual)}));
        }
    }
}

