/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.RemoteCommand;
import org.apache.commons.io.IOUtils;

public class GetClusterStateCommand
extends RemoteCommand {
    public GetClusterStateCommand(Args args) {
        super(args);
    }

    private void logState(String state) {
        String hostPort = this.args.getClusterAddress() + ":" + this.args.getClusterPort();
        this.log("Cluster " + hostPort + " is " + state + ".");
    }

    @Override
    public int execute() throws IOException {
        this.log("Attempting to determine state of cluster " + this.hostPort + "...");
        try {
            HttpURLConnection conn = this.openConnection(this.args.getClusterStatePath(), RemoteCommand.Method.GET);
            if (conn.getResponseCode() == 200) {
                String result = IOUtils.toString((InputStream)conn.getInputStream(), (String)StandardCharsets.UTF_8.name());
                ObjectMapper om = new ObjectMapper();
                JsonNode json = om.readTree(result);
                String state = json.get("state").asText();
                this.logState(state);
                switch (state) {
                    case "ACTIVE": {
                        return 0;
                    }
                    case "UNUSABLE": {
                        return 2;
                    }
                }
                return 3;
            }
            this.logState("UNKNOWN (HTTP error code: " + conn.getResponseCode() + ")");
            return 3;
        }
        catch (IOException e) {
            this.logState("DOWN");
            return 1;
        }
    }
}

