/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class SqlppFunctionCallResolverVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final MetadataProvider metadataProvider;
    private final Set<FunctionSignature> declaredFunctions;
    private final BiFunction<String, Integer, FunctionSignature> builtinFunctionResolver;
    private final BiFunction<String, Integer, FunctionSignature> callExprResolver;

    public SqlppFunctionCallResolverVisitor(MetadataProvider metadataProvider, List<FunctionDecl> declaredFunctions) {
        this.metadataProvider = metadataProvider;
        this.declaredFunctions = FunctionUtil.getFunctionSignatures(declaredFunctions);
        this.builtinFunctionResolver = FunctionUtil.createBuiltinFunctionResolver((MetadataProvider)metadataProvider);
        this.callExprResolver = this::resolveCallExpr;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = FunctionUtil.resolveFunctionCall((FunctionSignature)callExpr.getFunctionSignature(), (SourceLocation)callExpr.getSourceLocation(), (MetadataProvider)this.metadataProvider, this.declaredFunctions, this.callExprResolver);
        callExpr.setFunctionSignature(fs);
        return super.visit(callExpr, arg);
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = FunctionUtil.resolveFunctionCall((FunctionSignature)winExpr.getFunctionSignature(), (SourceLocation)winExpr.getSourceLocation(), (MetadataProvider)this.metadataProvider, this.declaredFunctions, this.callExprResolver);
        winExpr.setFunctionSignature(fs);
        return super.visit(winExpr, arg);
    }

    private FunctionSignature resolveCallExpr(String name, int arity) {
        FunctionSignature fs = this.builtinFunctionResolver.apply(name, arity);
        if (fs != null) {
            return fs;
        }
        fs = new FunctionSignature(FunctionConstants.ASTERIX_DV, name, arity);
        return SqlppFunctionCallResolverVisitor.isAggregateFunction(fs) || SqlppFunctionCallResolverVisitor.isWindowFunction(fs) ? fs : null;
    }

    private static boolean isAggregateFunction(FunctionSignature fs) {
        return FunctionMapUtil.isSql92AggregateFunction(fs) || FunctionMapUtil.isCoreAggregateFunction(fs);
    }

    private static boolean isWindowFunction(FunctionSignature fs) {
        return BuiltinFunctions.getWindowFunction((FunctionIdentifier)fs.createFunctionIdentifier()) != null;
    }
}

