/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexFinalSearchResult;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchResult;
import org.apache.hyracks.storage.common.MultiComparator;

public class InvertedListMerger {
    protected final MultiComparator invListCmp;
    protected InvertedIndexSearchResult prevSearchResult;
    protected InvertedIndexSearchResult newSearchResult;
    protected InvertedIndexFinalSearchResult finalSearchResult;
    protected IInvertedListCursor finalInvListCursor;
    protected int occurrenceThreshold;
    protected int numInvertedLists;
    protected int invListIdx;
    protected int numPrevResult;
    protected int prevBufIdx;
    protected int maxPrevBufIdx;
    protected int numExpectedPages;
    protected ByteBuffer prevCurrentBuffer;
    protected IFrameTupleAccessor resultFrameTupleAcc;
    protected IInvertedListTupleReference resultTuple;
    protected boolean advanceCursor;
    protected boolean advancePrevResult;
    protected int resultTupleIdx;
    protected int invListTupleIdx;
    protected int invListTupleCount;
    protected ITupleReference invListTuple;
    protected int prevResultFrameTupleCount;
    protected boolean isProcessingFinished;
    protected boolean isProcessingFinalList;
    protected boolean isProcessingFinalPartition;
    protected boolean listVisited;
    protected processType currentProcessType = processType.NONE;

    public InvertedListMerger(IHyracksTaskContext ctx, IInvertedIndex invIndex, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this.invListCmp = MultiComparator.create((IBinaryComparatorFactory[])invIndex.getInvListCmpFactories());
        this.prevSearchResult = new InvertedIndexSearchResult(invIndex.getInvListTypeTraits(), ctx, bufferManager);
        this.newSearchResult = new InvertedIndexSearchResult(invIndex.getInvListTypeTraits(), ctx, bufferManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean merge(List<IInvertedListCursor> invListCursors, int occurrenceThreshold, int numPrefixLists, InvertedIndexFinalSearchResult finalSearchResult) throws HyracksDataException {
        Collections.sort(invListCursors);
        int numInvLists = invListCursors.size();
        InvertedIndexSearchResult result = null;
        this.prevSearchResult.reset();
        this.newSearchResult.reset();
        boolean isFinalList = false;
        boolean doneMerge = false;
        this.occurrenceThreshold = occurrenceThreshold;
        for (int i = 0; i < numInvLists; ++i) {
            InvertedIndexSearchResult swapTemp = this.prevSearchResult;
            this.prevSearchResult = this.newSearchResult;
            this.newSearchResult = swapTemp;
            this.newSearchResult.reset();
            if (i + 1 != numInvLists) {
                result = this.newSearchResult;
            } else {
                result = finalSearchResult;
                isFinalList = true;
            }
            IInvertedListCursor invListCursor = invListCursors.get(i);
            boolean finishedTryBlock = false;
            try {
                invListCursor.prepareLoadPages();
                invListCursor.loadPages();
                if (i < numPrefixLists) {
                    doneMerge = this.mergePrefixList(invListCursor, this.prevSearchResult, result, isFinalList);
                } else {
                    int numInvListElements = invListCursor.size();
                    int currentNumResults = this.prevSearchResult.getNumResults();
                    doneMerge = (double)currentNumResults * Math.log(numInvListElements) < (double)(currentNumResults + numInvListElements) ? this.mergeSuffixListProbe(invListCursor, this.prevSearchResult, result, i, numInvLists, occurrenceThreshold, isFinalList) : this.mergeSuffixListScan(invListCursor, this.prevSearchResult, result, i, numInvLists, occurrenceThreshold, isFinalList);
                }
                finishedTryBlock = true;
            }
            finally {
                if (!isFinalList || isFinalList && doneMerge || !finishedTryBlock) {
                    try {
                        invListCursor.unloadPages();
                    }
                    finally {
                        invListCursor.close();
                    }
                }
            }
            if (!isFinalList) continue;
            return doneMerge;
        }
        return true;
    }

    public boolean continueMerge() throws HyracksDataException {
        boolean doneMerge;
        switch (this.currentProcessType) {
            case PREFIX_LIST: {
                doneMerge = this.mergePrefixList(this.finalInvListCursor, this.prevSearchResult, this.finalSearchResult, this.isProcessingFinalList);
                break;
            }
            case SUFFIX_LIST_PROBE: {
                doneMerge = this.mergeSuffixListProbe(this.finalInvListCursor, this.prevSearchResult, this.finalSearchResult, this.invListIdx, this.numInvertedLists, this.occurrenceThreshold, this.isProcessingFinalList);
                break;
            }
            case SUFFIX_LIST_SCAN: {
                doneMerge = this.mergeSuffixListScan(this.finalInvListCursor, this.prevSearchResult, this.finalSearchResult, this.invListIdx, this.numInvertedLists, this.occurrenceThreshold, this.isProcessingFinalList);
                break;
            }
            default: {
                throw HyracksDataException.create((int)113, (Serializable[])new Serializable[0]);
            }
        }
        if (doneMerge) {
            try {
                this.finalInvListCursor.unloadPages();
            }
            finally {
                this.finalInvListCursor.close();
            }
        }
        return doneMerge;
    }

    protected boolean mergeSuffixListProbe(IInvertedListCursor invListCursor, InvertedIndexSearchResult prevSearchResult, InvertedIndexSearchResult newSearchResult, int invListIx, int numInvLists, int occurrenceThreshold, boolean isFinalList) throws HyracksDataException {
        if (this.isProcessingFinished) {
            return true;
        }
        this.initMergingOneList(invListCursor, prevSearchResult, newSearchResult, isFinalList, invListIx, numInvLists, occurrenceThreshold, processType.SUFFIX_LIST_PROBE);
        while (this.resultTupleIdx < this.prevResultFrameTupleCount) {
            this.resultTuple.reset(this.prevCurrentBuffer.array(), this.resultFrameTupleAcc.getTupleStartOffset(this.resultTupleIdx));
            int count = this.getCount(this.resultTuple);
            if (invListCursor.containsKey(this.resultTuple, this.invListCmp) ? !newSearchResult.append(this.resultTuple, ++count) : count + numInvLists - invListIx > occurrenceThreshold && !newSearchResult.append(this.resultTuple, count)) {
                return false;
            }
            ++this.resultTupleIdx;
            this.checkPrevResultAndFetchNextFrame(prevSearchResult);
        }
        return this.finishMergingOneList(isFinalList, prevSearchResult, newSearchResult, invListCursor);
    }

    protected boolean mergeSuffixListScan(IInvertedListCursor invListCursor, InvertedIndexSearchResult prevSearchResult, InvertedIndexSearchResult newSearchResult, int invListIx, int numInvLists, int occurrenceThreshold, boolean isFinalList) throws HyracksDataException {
        int count;
        if (this.isProcessingFinished) {
            return true;
        }
        this.initMergingOneList(invListCursor, prevSearchResult, newSearchResult, isFinalList, invListIx, numInvLists, occurrenceThreshold, processType.SUFFIX_LIST_SCAN);
        while (this.invListTupleIdx < this.invListTupleCount && this.resultTupleIdx < this.prevResultFrameTupleCount) {
            this.invListTuple = invListCursor.getTuple();
            this.resultTuple.reset(this.prevCurrentBuffer.array(), this.resultFrameTupleAcc.getTupleStartOffset(this.resultTupleIdx));
            int cmp = this.invListCmp.compare(this.invListTuple, (ITupleReference)this.resultTuple);
            if (cmp == 0) {
                count = this.getCount(this.resultTuple) + 1;
                if (!newSearchResult.append(this.resultTuple, count)) {
                    return false;
                }
                this.advanceCursor = true;
                this.advancePrevResult = true;
            } else if (cmp < 0) {
                this.advanceCursor = true;
                this.advancePrevResult = false;
            } else {
                count = this.getCount(this.resultTuple);
                if (count + numInvLists - invListIx > occurrenceThreshold && !newSearchResult.append(this.resultTuple, count)) {
                    return false;
                }
                this.advanceCursor = false;
                this.advancePrevResult = true;
            }
            this.advancePrevResultAndList(this.advancePrevResult, this.advanceCursor, prevSearchResult, invListCursor);
        }
        while (this.resultTupleIdx < this.prevResultFrameTupleCount) {
            this.resultTuple.reset(this.prevCurrentBuffer.array(), this.resultFrameTupleAcc.getTupleStartOffset(this.resultTupleIdx));
            count = this.getCount(this.resultTuple);
            if (count + numInvLists - invListIx > occurrenceThreshold && !newSearchResult.append(this.resultTuple, count)) {
                return false;
            }
            ++this.resultTupleIdx;
            this.checkPrevResultAndFetchNextFrame(prevSearchResult);
        }
        return this.finishMergingOneList(isFinalList, prevSearchResult, newSearchResult, invListCursor);
    }

    protected boolean mergePrefixList(IInvertedListCursor invListCursor, InvertedIndexSearchResult prevSearchResult, InvertedIndexSearchResult newSearchResult, boolean isFinalList) throws HyracksDataException {
        int count;
        if (this.isProcessingFinished) {
            return true;
        }
        this.initMergingOneList(invListCursor, prevSearchResult, newSearchResult, isFinalList, processType.PREFIX_LIST);
        while (this.invListTupleIdx < this.invListTupleCount && this.resultTupleIdx < this.prevResultFrameTupleCount) {
            this.invListTuple = invListCursor.getTuple();
            this.resultTuple.reset(this.prevCurrentBuffer.array(), this.resultFrameTupleAcc.getTupleStartOffset(this.resultTupleIdx));
            int cmp = this.invListCmp.compare(this.invListTuple, (ITupleReference)this.resultTuple);
            if (cmp == 0) {
                count = this.getCount(this.resultTuple) + 1;
                if (!newSearchResult.append(this.resultTuple, count)) {
                    return false;
                }
                this.advanceCursor = true;
                this.advancePrevResult = true;
            } else if (cmp < 0) {
                count = 1;
                if (!newSearchResult.append(this.invListTuple, count)) {
                    return false;
                }
                this.advanceCursor = true;
                this.advancePrevResult = false;
            } else {
                count = this.getCount(this.resultTuple);
                if (!newSearchResult.append(this.resultTuple, count)) {
                    return false;
                }
                this.advanceCursor = false;
                this.advancePrevResult = true;
            }
            this.advancePrevResultAndList(this.advancePrevResult, this.advanceCursor, prevSearchResult, invListCursor);
        }
        while (this.invListTupleIdx < this.invListTupleCount) {
            this.invListTuple = invListCursor.getTuple();
            if (!newSearchResult.append(this.invListTuple, 1)) {
                return false;
            }
            ++this.invListTupleIdx;
            if (!invListCursor.hasNext()) continue;
            invListCursor.next();
        }
        while (this.resultTupleIdx < this.prevResultFrameTupleCount) {
            this.resultTuple.reset(this.prevCurrentBuffer.array(), this.resultFrameTupleAcc.getTupleStartOffset(this.resultTupleIdx));
            count = this.getCount(this.resultTuple);
            if (!newSearchResult.append(this.resultTuple, count)) {
                return false;
            }
            ++this.resultTupleIdx;
            this.checkPrevResultAndFetchNextFrame(prevSearchResult);
        }
        return this.finishMergingOneList(isFinalList, prevSearchResult, newSearchResult, invListCursor);
    }

    protected void initMergingOneList(IInvertedListCursor invListCursor, InvertedIndexSearchResult prevSearchResult, InvertedIndexSearchResult newSearchResult, boolean isFinalList, processType mergeOpType) throws HyracksDataException {
        this.initMergingOneList(invListCursor, prevSearchResult, newSearchResult, isFinalList, 0, 0, 0, mergeOpType);
    }

    protected void initMergingOneList(IInvertedListCursor invListCursor, InvertedIndexSearchResult prevSearchResult, InvertedIndexSearchResult newSearchResult, boolean isFinalList, int invListIx, int numInvLists, int occurrenceThreshold, processType mergeOpType) throws HyracksDataException {
        if (!this.listVisited) {
            this.resetVariable();
            this.prevBufIdx = 0;
            this.maxPrevBufIdx = prevSearchResult.getCurrentBufferIndex();
            this.numPrevResult = prevSearchResult.getNumResults();
            this.invListTupleCount = invListCursor.size();
            this.numExpectedPages = newSearchResult.getExpectedNumPages(this.numPrevResult + this.invListTupleCount);
            newSearchResult.prepareWrite(this.numExpectedPages);
            prevSearchResult.prepareResultRead();
            this.prevCurrentBuffer = prevSearchResult.getNextFrame();
            this.resultFrameTupleAcc = prevSearchResult.getAccessor();
            this.resultTuple = prevSearchResult.getTuple();
            this.advanceCursor = true;
            this.advancePrevResult = false;
            this.resultTupleIdx = 0;
            this.resultFrameTupleAcc.reset(this.prevCurrentBuffer);
            this.invListTupleIdx = 0;
            this.numInvertedLists = numInvLists;
            this.invListIdx = invListIx;
            int n = this.prevResultFrameTupleCount = this.prevCurrentBuffer == null ? 0 : this.resultFrameTupleAcc.getTupleCount();
            if (isFinalList) {
                this.finalInvListCursor = invListCursor;
                this.finalSearchResult = (InvertedIndexFinalSearchResult)newSearchResult;
                this.currentProcessType = mergeOpType;
                this.occurrenceThreshold = occurrenceThreshold;
                this.isProcessingFinalList = true;
                this.listVisited = true;
            }
            if (invListCursor.hasNext()) {
                invListCursor.next();
            }
        }
    }

    protected boolean finishMergingOneList(boolean isFinalList, InvertedIndexSearchResult prevSearchResult, InvertedIndexSearchResult newSearchResult, IInvertedListCursor invListCursor) throws HyracksDataException {
        prevSearchResult.closeResultRead(false);
        invListCursor.close();
        if (!isFinalList) {
            newSearchResult.finalizeWrite();
            return false;
        }
        this.isProcessingFinished = true;
        return true;
    }

    protected void advancePrevResultAndList(boolean advancePrevResult, boolean advanceCursor, InvertedIndexSearchResult prevSearchResult, IInvertedListCursor invListCursor) throws HyracksDataException {
        if (advancePrevResult) {
            ++this.resultTupleIdx;
            this.checkPrevResultAndFetchNextFrame(prevSearchResult);
        }
        if (advanceCursor) {
            ++this.invListTupleIdx;
            if (invListCursor.hasNext()) {
                invListCursor.next();
            }
        }
    }

    protected void checkPrevResultAndFetchNextFrame(InvertedIndexSearchResult prevSearchResult) throws HyracksDataException {
        if (this.resultTupleIdx >= this.prevResultFrameTupleCount) {
            ++this.prevBufIdx;
            if (this.prevBufIdx <= this.maxPrevBufIdx) {
                this.prevCurrentBuffer = prevSearchResult.getNextFrame();
                this.resultFrameTupleAcc.reset(this.prevCurrentBuffer);
                this.prevResultFrameTupleCount = this.resultFrameTupleAcc.getTupleCount();
                this.resultTupleIdx = 0;
            }
        }
    }

    protected int getCount(IInvertedListTupleReference resultTuple) {
        return IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1));
    }

    public void reset() throws HyracksDataException {
        this.prevSearchResult.reset();
        this.newSearchResult.reset();
        this.resetVariable();
    }

    public void prepareMerge() throws HyracksDataException {
        this.prevSearchResult.prepareIOBuffer();
        this.newSearchResult.prepareIOBuffer();
        this.resetVariable();
    }

    public void close() throws HyracksDataException {
        try {
            this.prevSearchResult.close();
            this.newSearchResult.close();
        }
        finally {
            if (this.finalInvListCursor != null) {
                this.finalInvListCursor.close();
            }
        }
    }

    private void resetVariable() {
        this.prevBufIdx = 0;
        this.maxPrevBufIdx = 0;
        this.numPrevResult = 0;
        this.invListTupleCount = 0;
        this.numExpectedPages = 0;
        this.prevCurrentBuffer = null;
        this.resultFrameTupleAcc = null;
        this.resultTuple = null;
        this.advanceCursor = false;
        this.advancePrevResult = false;
        this.resultTupleIdx = 0;
        this.invListTupleIdx = 0;
        this.prevResultFrameTupleCount = 0;
        this.finalInvListCursor = null;
        this.finalSearchResult = null;
        this.currentProcessType = processType.NONE;
        this.isProcessingFinalList = false;
        this.isProcessingFinished = false;
        this.listVisited = false;
        this.occurrenceThreshold = 0;
    }

    public static enum processType {
        PREFIX_LIST,
        SUFFIX_LIST_PROBE,
        SUFFIX_LIST_SCAN,
        NONE;

    }
}

