/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.Serializable;
import org.apache.asterix.external.library.ExternalScalarJavaFunctionEvaluator;
import org.apache.asterix.external.library.ExternalScalarPythonFunctionEvaluator;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExternalScalarFunctionEvaluatorFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IExternalFunctionInfo finfo;
    private final IScalarEvaluatorFactory[] args;
    private final IAType[] argTypes;
    private final SourceLocation sourceLoc;

    public ExternalScalarFunctionEvaluatorFactory(IExternalFunctionInfo finfo, IScalarEvaluatorFactory[] args, IAType[] argTypes, SourceLocation sourceLoc) {
        this.finfo = finfo;
        this.args = args;
        this.argTypes = argTypes;
        this.sourceLoc = sourceLoc;
    }

    public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
        switch (this.finfo.getLanguage()) {
            case JAVA: {
                return new ExternalScalarJavaFunctionEvaluator(this.finfo, this.args, this.argTypes, ctx);
            }
            case PYTHON: {
                return new ExternalScalarPythonFunctionEvaluator(this.finfo, this.args, this.argTypes, ctx, this.sourceLoc);
            }
        }
        throw new HyracksDataException("ASX", 3042, new Serializable[]{this.finfo.getLanguage()});
    }
}

