/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.library.LibraryDescriptor;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.sockets.PlainSocketChannelFactory;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExternalLibraryManager
implements ILibraryManager,
ILifeCycleComponent {
    public static final String LIBRARY_MANAGER_BASE_DIR_NAME = "library";
    private static final String STORAGE_DIR_NAME = "storage";
    private static final String TRASH_DIR_NAME = "trash";
    public static final String REV_0_DIR_NAME = "rev_0";
    public static final String REV_1_DIR_NAME = "rev_1";
    public static final String STAGE_DIR_NAME = "stage";
    public static final String CONTENTS_DIR_NAME = "contents";
    public static final String DESCRIPTOR_FILE_NAME = "lib.json";
    private static final Logger LOGGER = LogManager.getLogger(ExternalLibraryManager.class);
    private final NodeControllerService ncs;
    private final IPersistedResourceRegistry reg;
    private final ObjectMapper objectMapper;
    private final FileReference baseDir;
    private final FileReference storageDir;
    private final Path storageDirPath;
    private final FileReference trashDir;
    private final Path trashDirPath;
    private final Map<Pair<DataverseName, String>, ILibrary> libraries = new HashMap<Pair<DataverseName, String>, ILibrary>();
    private IPCSystem pythonIPC;
    private final ExternalFunctionResultRouter router;

    public ExternalLibraryManager(NodeControllerService ncs, IPersistedResourceRegistry reg, FileReference appDir) {
        this.ncs = ncs;
        this.reg = reg;
        this.baseDir = appDir.getChild(LIBRARY_MANAGER_BASE_DIR_NAME);
        this.storageDir = this.baseDir.getChild(STORAGE_DIR_NAME);
        this.storageDirPath = this.storageDir.getFile().toPath();
        this.trashDir = this.baseDir.getChild(TRASH_DIR_NAME);
        this.trashDirPath = this.trashDir.getFile().toPath().normalize();
        this.objectMapper = ExternalLibraryManager.createObjectMapper();
        this.router = new ExternalFunctionResultRouter();
    }

    public void initialize(boolean resetStorageData) throws HyracksDataException {
        try {
            this.pythonIPC = new IPCSystem(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), (ISocketChannelFactory)PlainSocketChannelFactory.INSTANCE, (IIPCI)this.router, (IPayloadSerializerDeserializer)new ExternalFunctionResultRouter.NoOpNoSerJustDe());
            this.pythonIPC.start();
            Path baseDirPath = this.baseDir.getFile().toPath();
            if (Files.isDirectory(baseDirPath, new LinkOption[0])) {
                if (resetStorageData) {
                    FileUtils.cleanDirectory((File)this.baseDir.getFile());
                    Files.createDirectory(this.storageDirPath, new FileAttribute[0]);
                    Files.createDirectory(this.trashDirPath, new FileAttribute[0]);
                    IoUtil.flushDirectory((Path)baseDirPath);
                } else {
                    boolean createdDirs = false;
                    if (!Files.isDirectory(this.storageDirPath, new LinkOption[0])) {
                        Files.deleteIfExists(this.storageDirPath);
                        Files.createDirectory(this.storageDirPath, new FileAttribute[0]);
                        createdDirs = true;
                    }
                    if (Files.isDirectory(this.trashDirPath, new LinkOption[0])) {
                        FileUtils.cleanDirectory((File)this.trashDir.getFile());
                    } else {
                        Files.deleteIfExists(this.trashDirPath);
                        Files.createDirectory(this.trashDirPath, new FileAttribute[0]);
                        createdDirs = true;
                    }
                    if (createdDirs) {
                        IoUtil.flushDirectory((Path)baseDirPath);
                    }
                }
            } else {
                FileUtil.forceMkdirs((File)this.baseDir.getFile());
                Files.createDirectory(this.storageDirPath, new FileAttribute[0]);
                Files.createDirectory(this.trashDirPath, new FileAttribute[0]);
                IoUtil.flushDirectory((Path)baseDirPath.getParent().getParent());
                IoUtil.flushDirectory((Path)baseDirPath.getParent());
                IoUtil.flushDirectory((Path)baseDirPath);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean dumpState, OutputStream ouputStream) {
        ExternalLibraryManager externalLibraryManager = this;
        synchronized (externalLibraryManager) {
            for (Map.Entry<Pair<DataverseName, String>, ILibrary> p : this.libraries.entrySet()) {
                ILibrary library = p.getValue();
                try {
                    library.close();
                }
                catch (HyracksDataException e) {
                    LOGGER.warn("Error closing library " + p.getKey().first + "." + (String)p.getKey().second, (Throwable)e);
                }
            }
        }
    }

    private FileReference getDataverseDir(DataverseName dataverseName) throws HyracksDataException {
        return this.getChildFileRef(this.storageDir, dataverseName.getCanonicalForm());
    }

    public FileReference getLibraryDir(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        FileReference dataverseDir = this.getDataverseDir(dataverseName);
        return this.getChildFileRef(dataverseDir, libraryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILibrary getLibrary(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        Pair<DataverseName, String> key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        ExternalLibraryManager externalLibraryManager = this;
        synchronized (externalLibraryManager) {
            ILibrary library = this.libraries.get(key);
            if (library == null) {
                library = this.loadLibrary(dataverseName, libraryName);
                this.libraries.put(key, library);
            }
            return library;
        }
    }

    private ILibrary loadLibrary(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        FileReference libRevDir = this.findLibraryRevDir(dataverseName, libraryName);
        if (libRevDir == null) {
            throw new HyracksDataException("Cannot find library: " + dataverseName + '.' + libraryName);
        }
        FileReference libContentsDir = libRevDir.getChild(CONTENTS_DIR_NAME);
        if (!libContentsDir.getFile().isDirectory()) {
            throw new HyracksDataException("Cannot find library: " + dataverseName + '.' + libraryName);
        }
        try {
            FileReference descFile = libRevDir.getChild(DESCRIPTOR_FILE_NAME);
            byte[] descData = Files.readAllBytes(descFile.getFile().toPath());
            LibraryDescriptor desc = this.deserializeLibraryDescriptor(descData);
            ExternalFunctionLanguage libLang = desc.getLanguage();
            switch (libLang) {
                case JAVA: {
                    return new JavaLibrary(libContentsDir.getFile());
                }
                case PYTHON: {
                    return new PythonLibrary(libContentsDir.getFile());
                }
            }
            throw new HyracksDataException("Invalid language: " + libraryName);
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialize library " + dataverseName + '.' + libraryName, (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public byte[] serializeLibraryDescriptor(LibraryDescriptor libraryDescriptor) throws HyracksDataException {
        try {
            return this.objectMapper.writeValueAsBytes((Object)libraryDescriptor.toJson(this.reg));
        }
        catch (JsonProcessingException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private LibraryDescriptor deserializeLibraryDescriptor(byte[] data) throws IOException {
        JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(data, JsonNode.class);
        return (LibraryDescriptor)this.reg.deserialize(jsonNode);
    }

    private FileReference findLibraryRevDir(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        FileReference libraryBaseDir = this.getLibraryDir(dataverseName, libraryName);
        if (!libraryBaseDir.getFile().isDirectory()) {
            return null;
        }
        FileReference libDirRev1 = libraryBaseDir.getChild(REV_1_DIR_NAME);
        if (libDirRev1.getFile().isDirectory()) {
            return libDirRev1;
        }
        FileReference libDirRev0 = libraryBaseDir.getChild(REV_0_DIR_NAME);
        if (libDirRev0.getFile().isDirectory()) {
            return libDirRev0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLibrary(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        ILibrary library;
        Pair<DataverseName, String> key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        ExternalLibraryManager externalLibraryManager = this;
        synchronized (externalLibraryManager) {
            library = this.libraries.remove(key);
        }
        if (library != null) {
            library.close();
        }
    }

    public void dumpState(OutputStream os) {
    }

    private static Pair<DataverseName, String> getKey(DataverseName dataverseName, String libraryName) {
        return new Pair((Object)dataverseName, (Object)libraryName);
    }

    public void dropLibraryPath(FileReference fileRef) throws HyracksDataException {
        try {
            Path path = fileRef.getFile().toPath();
            Path trashPath = Files.createTempDirectory(this.trashDirPath, null, new FileAttribute[0]);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Drop (move) {} into {}", (Object)path, (Object)trashPath);
            }
            Files.move(path, trashPath, StandardCopyOption.ATOMIC_MOVE);
            this.ncs.getWorkQueue().schedule((AbstractWork)new DeleteDirectoryWork(trashPath));
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private FileReference getChildFileRef(FileReference dir, String fileName) throws HyracksDataException {
        Path dirPath = dir.getFile().toPath().toAbsolutePath().normalize();
        FileReference fileRef = dir.getChild(fileName);
        Path filePath = fileRef.getFile().toPath().toAbsolutePath().normalize();
        if (!filePath.startsWith(dirPath)) {
            throw new HyracksDataException("Invalid file name: " + fileName);
        }
        return fileRef;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        om.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        om.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return om;
    }

    public ExternalFunctionResultRouter getRouter() {
        return this.router;
    }

    public IPCSystem getIPCI() {
        return this.pythonIPC;
    }

    private static final class DeleteDirectoryWork
    extends AbstractWork {
        private final Path path;

        private DeleteDirectoryWork(Path path) {
            this.path = path;
        }

        public void run() {
            try {
                IoUtil.delete((Path)this.path);
            }
            catch (HyracksDataException e) {
                LOGGER.warn("Error deleting " + this.path);
            }
        }
    }
}

