/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;

public class LSMIndexPageWriteCallback
implements IPageWriteCallback {
    private final int pagesPerForce;
    private IIndexBulkLoader bulkLoader;
    private long totalWrittenPages;
    private int totalForces;

    public LSMIndexPageWriteCallback(int pagesPerForce) {
        this.pagesPerForce = pagesPerForce;
    }

    public void initialize(IIndexBulkLoader bulkLoader) {
        this.bulkLoader = bulkLoader;
    }

    public void afterWrite(ICachedPage page) throws HyracksDataException {
        ++this.totalWrittenPages;
        if (this.pagesPerForce > 0 && this.totalWrittenPages % (long)this.pagesPerForce == 0L) {
            this.bulkLoader.force();
            ++this.totalForces;
        }
    }

    public int getTotalForces() {
        return this.totalForces;
    }
}

