/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.object.base;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.ATypeTag;

public class AdmBooleanNode
implements IAdmNode {
    private static final long serialVersionUID = 1L;
    public static final AdmBooleanNode TRUE = new AdmBooleanNode(true);
    public static final AdmBooleanNode FALSE = new AdmBooleanNode(false);
    private final boolean value;

    private AdmBooleanNode(boolean value) {
        this.value = value;
    }

    @Override
    public ATypeTag getType() {
        return ATypeTag.BOOLEAN;
    }

    public boolean get() {
        return this.value;
    }

    @Override
    public void reset() {
    }

    public static AdmBooleanNode get(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static AdmBooleanNode get(Boolean value) {
        return value != false ? TRUE : FALSE;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void serializeValue(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.value);
    }
}

