/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IPassableTimer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class TimedFrameWriter
implements IFrameWriter,
IPassableTimer {
    private final IFrameWriter writer;
    private long frameStart = 0L;
    final ICounter counter;
    final IStatsCollector collector;
    final String name;

    public TimedFrameWriter(IFrameWriter writer, IStatsCollector collector, String name, ICounter counter) {
        this.writer = writer;
        this.collector = collector;
        this.name = name;
        this.counter = counter;
    }

    protected TimedFrameWriter(IFrameWriter writer, IStatsCollector collector, String name) {
        this(writer, collector, name, collector.getOrAddOperatorStats(name).getTimeCounter());
    }

    @Override
    public final void open() throws HyracksDataException {
        try {
            this.startClock();
            this.writer.open();
        }
        finally {
            this.stopClock();
        }
    }

    @Override
    public final void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        try {
            this.startClock();
            this.writer.nextFrame(buffer);
        }
        finally {
            this.stopClock();
        }
    }

    @Override
    public final void flush() throws HyracksDataException {
        try {
            this.startClock();
            this.writer.flush();
        }
        finally {
            this.stopClock();
        }
    }

    @Override
    public final void fail() throws HyracksDataException {
        this.writer.fail();
    }

    @Override
    public void close() throws HyracksDataException {
        try {
            this.startClock();
            this.writer.close();
        }
        finally {
            this.stopClock();
        }
    }

    private void stopClock() {
        this.pause();
        this.collector.giveClock(this);
    }

    private void startClock() {
        if (this.frameStart > 0L) {
            return;
        }
        this.frameStart = this.collector.takeClock(this);
    }

    @Override
    public void resume() {
        long nt;
        if (this.frameStart > 0L) {
            return;
        }
        this.frameStart = nt = System.nanoTime();
    }

    @Override
    public void pause() {
        if (this.frameStart > 1L) {
            long nt = System.nanoTime();
            long delta = nt - this.frameStart;
            this.counter.update(delta);
            this.frameStart = -1L;
        }
    }

    public static IFrameWriter time(IFrameWriter writer, IHyracksTaskContext ctx, String name) throws HyracksDataException {
        return writer instanceof TimedFrameWriter ? writer : new TimedFrameWriter(writer, ctx.getStatsCollector(), name);
    }
}

