/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.util.FileAwareArchiveStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

public class SevenZStreamFactory
implements FileAwareArchiveStreamFactory {
    @Override
    public ArchiveInputStream getArchiveStream(InputStream stream, String encoding) throws IOException {
        throw new UnsupportedOperationException("only file-based archives can be read");
    }

    @Override
    public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
        throw new UnsupportedOperationException("only file-based archives can be written");
    }

    @Override
    public ArchiveInputStream getArchiveInputStream(File file, String encoding) throws IOException {
        return new SevenZArchiveInputStream(file);
    }

    @Override
    public ArchiveOutputStream getArchiveOutputStream(File file, String encoding) throws IOException {
        return new SevenZArchiveOutputStream(file);
    }

    public static class SevenZArchiveOutputStream
    extends ArchiveOutputStream {
        private final SevenZOutputFile zipFile;

        public SevenZArchiveOutputStream(File file) throws IOException {
            this.zipFile = new SevenZOutputFile(file);
        }

        public void close() throws IOException {
            this.zipFile.close();
        }

        public void putArchiveEntry(ArchiveEntry entry) throws IOException {
            this.zipFile.putArchiveEntry(entry);
        }

        public void closeArchiveEntry() throws IOException {
            this.zipFile.closeArchiveEntry();
        }

        public void finish() throws IOException {
            this.zipFile.finish();
        }

        public ArchiveEntry createArchiveEntry(File inputFile, String entryName) throws IOException {
            return this.zipFile.createArchiveEntry(inputFile, entryName);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.zipFile.write(b, off, len);
        }

        public void setContentCompression(SevenZMethod method) {
            this.zipFile.setContentCompression(method);
        }

        public void setContentMethods(Iterable methods) {
            this.zipFile.setContentMethods(methods);
        }
    }

    private static class SevenZArchiveInputStream
    extends ArchiveInputStream {
        private final SevenZFile zipFile;

        public SevenZArchiveInputStream(File file) throws IOException {
            this.zipFile = new SevenZFile(file);
        }

        public ArchiveEntry getNextEntry() throws IOException {
            return this.zipFile.getNextEntry();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.zipFile.read(b, off, len);
        }

        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

